/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.ComputeCurvatures;
import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class TestComputeCurvatures_
implements PlugIn,
GaussianGenerationCallback {
    ImagePlus imp;

    public void run(String ignored) {
        this.imp = WindowManager.getCurrentImage();
        ComputeCurvatures c = new ComputeCurvatures(this.imp, 1.0, (GaussianGenerationCallback)this, false);
        c.run();
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int depth = this.imp.getStackSize();
        System.out.println("w: " + width + ", h: " + height + ", d:" + depth);
        ImageStack stack_0 = new ImageStack(width - 2, height - 2);
        ImageStack stack_1 = new ImageStack(width - 2, height - 2);
        ImageStack stack_2 = new ImageStack(width - 2, height - 2);
        ImageStack stack_s = new ImageStack(width - 2, height - 2);
        ImageStack stack_m = new ImageStack(width - 2, height - 2);
        ImageStack stack_d = new ImageStack(width - 2, height - 2);
        double[] evalues = new double[3];
        Calibration calibration = this.imp.getCalibration();
        float sepX = 1.0f;
        float sepY = 1.0f;
        float sepZ = 1.0f;
        if (calibration != null) {
            sepX = (float)calibration.pixelWidth;
            sepY = (float)calibration.pixelHeight;
            sepZ = (float)calibration.pixelDepth;
        }
        for (int z = 1; z < depth - 1; ++z) {
            System.out.println("Working on slice: " + z);
            float[] slice_0 = new float[(width - 2) * (height - 2)];
            float[] slice_1 = new float[(width - 2) * (height - 2)];
            float[] slice_2 = new float[(width - 2) * (height - 2)];
            float[] slice_s = new float[(width - 2) * (height - 2)];
            float[] slice_m = new float[(width - 2) * (height - 2)];
            float[] slice_d = new float[(width - 2) * (height - 2)];
            for (int y = 1; y < height - 1; ++y) {
                for (int x = 1; x < width - 1; ++x) {
                    boolean succeeded = c.hessianEigenvaluesAtPoint3D(x, y, z, true, evalues, false, false, sepX, sepY, sepZ);
                    int index = (y - 1) * (width - 2) + (x - 1);
                    slice_0[index] = (float)Math.abs(evalues[0]);
                    slice_1[index] = (float)Math.abs(evalues[1] > 0.0 ? 0.0 : evalues[1]);
                    slice_2[index] = (float)Math.abs(evalues[2] > 0.0 ? 0.0 : evalues[2]);
                    if (evalues[1] >= 0.0 || evalues[2] >= 0.0) {
                        slice_s[index] = 0.0f;
                        slice_m[index] = 0.0f;
                        slice_d[index] = 0.0f;
                        continue;
                    }
                    slice_s[index] = (float)Math.abs(evalues[2] * evalues[1]);
                    slice_m[index] = (float)Math.sqrt(Math.abs(evalues[2] * evalues[1]));
                    slice_d[index] = (float)Math.abs(evalues[2] * evalues[1] * evalues[1]);
                }
            }
            FloatProcessor fp0 = new FloatProcessor(width - 2, height - 2);
            FloatProcessor fp1 = new FloatProcessor(width - 2, height - 2);
            FloatProcessor fp2 = new FloatProcessor(width - 2, height - 2);
            FloatProcessor fps = new FloatProcessor(width - 2, height - 2);
            FloatProcessor fpm = new FloatProcessor(width - 2, height - 2);
            FloatProcessor fpd = new FloatProcessor(width - 2, height - 2);
            fp0.setPixels((Object)slice_0);
            stack_0.addSlice(null, (ImageProcessor)fp0);
            fp1.setPixels((Object)slice_1);
            stack_1.addSlice(null, (ImageProcessor)fp1);
            fp2.setPixels((Object)slice_2);
            stack_2.addSlice(null, (ImageProcessor)fp2);
            fps.setPixels((Object)slice_s);
            stack_s.addSlice(null, (ImageProcessor)fps);
            fpm.setPixels((Object)slice_m);
            stack_m.addSlice(null, (ImageProcessor)fpm);
            fpd.setPixels((Object)slice_d);
            stack_d.addSlice(null, (ImageProcessor)fpd);
            IJ.showProgress((double)((double)z / (double)(depth - 2)));
        }
        IJ.showProgress((double)1.0);
        ImagePlus imp0 = new ImagePlus("evalue 0 " + this.imp.getTitle(), stack_0);
        imp0.show();
        ImagePlus imp1 = new ImagePlus("evalue 1 (abs for > 0) " + this.imp.getTitle(), stack_1);
        imp1.show();
        ImagePlus imp2 = new ImagePlus("evalue 2 (abs for > 0) " + this.imp.getTitle(), stack_2);
        imp2.show();
        ImagePlus imps = new ImagePlus("product of e1 and e2", stack_s);
        imps.show();
        ImagePlus impm = new ImagePlus("sqrt of product of e1 and e2", stack_m);
        impm.show();
        ImagePlus impd = new ImagePlus("product of e1, e1 and e2", stack_d);
        impd.show();
    }

    public void proportionDone(double d) {
        IJ.showProgress((double)d);
    }
}

