/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FilenameFilter;
import util.BatchOpener;
import util.LabelFilenameFilter;

public class Just_Certain_Labels
implements PlugIn {
    public void run(String ignore) {
        int i;
        String macroOptions = Macro.getOptions();
        String sourceDirectory = null;
        String outputDirectory = null;
        int[] labelsToKeep = null;
        boolean[] keep = new boolean[256];
        if (macroOptions == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        sourceDirectory = Macro.getValue((String)macroOptions, (String)"source", null);
        if (sourceDirectory == null) {
            IJ.error((String)"No source directory specified. (Macro option 'source'.)");
            return;
        }
        File sourceDirectoryAsFile = new File(sourceDirectory);
        if (!sourceDirectoryAsFile.exists() || !sourceDirectoryAsFile.isDirectory()) {
            IJ.error((String)("The source (" + sourceDirectory + ") must both exist and be a directory. "));
            return;
        }
        outputDirectory = Macro.getValue((String)macroOptions, (String)"output", null);
        if (outputDirectory == null) {
            IJ.error((String)"No output directory specified. (Macro option 'output'.)");
            return;
        }
        File outputDirectoryAsFile = new File(outputDirectory);
        if (!outputDirectoryAsFile.exists() || !outputDirectoryAsFile.isDirectory()) {
            IJ.error((String)("The output (" + outputDirectory + ") must both exist and be a directory. "));
            return;
        }
        String extension = Macro.getValue((String)macroOptions, (String)"extension", null);
        String labelsToKeepString = Macro.getValue((String)macroOptions, (String)"labels", null);
        if (labelsToKeepString == null) {
            IJ.error((String)"No labels to keep specified. (Macro option 'labels'.)");
            return;
        }
        String[] labelIndicesAsStrings = labelsToKeepString.split(",");
        labelsToKeep = new int[labelIndicesAsStrings.length];
        String currentString = null;
        for (i = 0; i < labelIndicesAsStrings.length; ++i) {
            currentString = labelIndicesAsStrings[i];
            try {
                labelsToKeep[i] = Integer.parseInt(currentString);
                continue;
            }
            catch (NumberFormatException e) {
                IJ.error((String)("Couldn't parse '" + currentString + "' as a label index."));
                return;
            }
        }
        for (i = 0; i < labelsToKeep.length; ++i) {
            keep[labelsToKeep[i]] = true;
        }
        LabelFilenameFilter filter = new LabelFilenameFilter(extension);
        File[] possibleSourceFiles = sourceDirectoryAsFile.listFiles((FilenameFilter)filter);
        for (int i2 = 0; i2 < possibleSourceFiles.length; ++i2) {
            File currentFile = possibleSourceFiles[i2];
            String path = currentFile.getAbsolutePath();
            String leafName = currentFile.getName();
            System.out.println("Opening file: " + path);
            System.out.println("Leaf name is: " + leafName);
            ImagePlus[] channels = BatchOpener.open((String)path);
            if (channels == null) {
                IJ.error((String)("Opening '" + path + "' failed."));
                return;
            }
            if (channels.length != 1) {
                IJ.error((String)("The labels file must only have one channel: there are " + channels.length + " in '" + path));
                return;
            }
            ImagePlus labelsImagePlus = channels[0];
            int type = labelsImagePlus.getType();
            if (type != 0 && type != 3) {
                IJ.error((String)("Something's wrong: '" + path + "' doesn't seem to be an 8 bit file."));
                return;
            }
            if (!AmiraParameters.isAmiraLabelfield((ImagePlus)labelsImagePlus)) {
                IJ.error((String)("The file '" + path + "' isn't an Amira labelfield!"));
                return;
            }
            int width = labelsImagePlus.getWidth();
            int height = labelsImagePlus.getHeight();
            int depth = labelsImagePlus.getStackSize();
            ImageStack stack = labelsImagePlus.getStack();
            for (int z = 0; z < depth; ++z) {
                byte[] pixels = (byte[])stack.getPixels(z + 1);
                for (int p = 0; p < width * height; ++p) {
                    int value = pixels[p] & 0xFF;
                    if (keep[value]) continue;
                    pixels[p] = 0;
                }
            }
            String outputFileName = outputDirectoryAsFile.getAbsolutePath() + File.separator + leafName;
            System.out.println("Would output to: " + outputFileName);
            AmiraMeshEncoder e = new AmiraMeshEncoder(outputFileName);
            if (!e.open()) {
                IJ.error((String)("Could not write " + outputFileName));
                return;
            }
            if (!e.write(labelsImagePlus)) {
                IJ.error((String)("Error writing " + outputFileName));
                return;
            }
            labelsImagePlus.close();
        }
    }
}

