/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.StringTokenizer;
import math3d.Point3d;
import vib.ElasticTransformedImage;
import vib.InterpolatedImage;

public class ElasticTransform_
implements PlugInFilter {
    ImagePlus image;

    public void run(ImageProcessor ip) {
        GenericDialog gd = new GenericDialog("Transform Parameters");
        AmiraParameters.addAmiraMeshList((GenericDialog)gd, (String)"imageToTransform");
        gd.addStringField("origPoints", "");
        gd.addStringField("transPoints", "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ImagePlus trans = WindowManager.getImage((String)gd.getNextChoice());
        Point3d[] origPoints = this.parsePoints(gd.getNextString());
        Point3d[] transPoints = this.parsePoints(gd.getNextString());
        ElasticTransformedImage t = new ElasticTransformedImage(new InterpolatedImage(this.image), new InterpolatedImage(trans), origPoints, transPoints);
        t.getTransformed().image.show();
    }

    Point3d[] parsePoints(String s) {
        ArrayList<Point3d> array = new ArrayList<Point3d>();
        StringTokenizer t = new StringTokenizer(s);
        while (t.hasMoreTokens()) {
            array.add(new Point3d(Double.parseDouble(t.nextToken()), Double.parseDouble(t.nextToken()), Double.parseDouble(t.nextToken())));
        }
        Point3d[] res = new Point3d[array.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (Point3d)array.get(i);
        }
        return res;
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 3;
    }
}

