/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import java.awt.Color;

public class FlowJDynamicColor {
    private static final double factorization = (double)1.2f;
    private static final double epsilon = (double)1.6f;

    public static void map2D(byte[] rgb, double magnitude, double orientationxy) {
        float[] rgbd = new float[3];
        FlowJDynamicColor.map2D(rgbd, magnitude, orientationxy);
        rgb[0] = (byte)((int)((double)rgbd[0] * 255.0 + 0.5) & 0xFF);
        rgb[1] = (byte)((int)((double)rgbd[1] * 255.0 + 0.5) & 0xFF);
        rgb[2] = (byte)((int)((double)rgbd[2] * 255.0 + 0.5) & 0xFF);
    }

    public static void map(byte[] rgb, double magnitude, double orientationxy, double orientationz) {
        Color color = FlowJDynamicColor.map(magnitude, orientationxy, orientationz);
        rgb[0] = (byte)color.getRed();
        rgb[1] = (byte)color.getGreen();
        rgb[2] = (byte)color.getBlue();
    }

    public static Color map(double speed, double orientationxy, double orientationz) {
        byte[] rgb = new byte[3];
        FlowJDynamicColor.map3D(rgb, speed, orientationxy, orientationz);
        return new Color(rgb[0] & 0xFF, rgb[1] & 0xFF, rgb[2] & 0xFF);
    }

    public static void map3D(byte[] rgb, double magnitude, double orientationxy, double orientationz) {
        float[] hue = new float[3];
        float[] drgb = new float[3];
        FlowJDynamicColor.hue(hue, orientationxy);
        double intensity = (Math.sin(orientationz) + 1.0) / 2.0;
        double saturation = Math.min(magnitude, 1.0);
        drgb[0] = (float)((double)hue[0] * saturation);
        drgb[1] = (float)((double)hue[1] * saturation);
        drgb[2] = (float)((double)hue[2] * saturation);
        if (intensity >= 0.5) {
            drgb[0] = drgb[0] + (1.0f - drgb[0]) * ((float)intensity - 0.5f) * 2.0f;
            drgb[1] = drgb[1] + (1.0f - drgb[1]) * ((float)intensity - 0.5f) * 2.0f;
            drgb[2] = drgb[2] + (1.0f - drgb[2]) * ((float)intensity - 0.5f) * 2.0f;
        } else {
            drgb[0] = drgb[0] + drgb[0] * ((float)intensity - 0.5f) * 2.0f;
            drgb[1] = drgb[1] + drgb[1] * ((float)intensity - 0.5f) * 2.0f;
            drgb[2] = drgb[2] + drgb[2] * ((float)intensity - 0.5f) * 2.0f;
        }
        rgb[0] = (byte)((double)(drgb[0] * 255.0f) + 0.5);
        rgb[1] = (byte)((double)(drgb[1] * 255.0f) + 0.5);
        rgb[2] = (byte)((double)(drgb[2] * 255.0f) + 0.5);
    }

    private static void map2D(float[] rgb, double magnitude, double orientationxy) {
        float[] hue = new float[3];
        FlowJDynamicColor.hue(hue, orientationxy);
        magnitude = Math.min(magnitude, 1.0);
        double saturation = Math.pow(magnitude, 1.2f);
        rgb[0] = (float)(1.0 - (double)(1.0f - hue[0]) * saturation);
        rgb[1] = (float)(1.0 - (double)(1.0f - hue[1]) * saturation);
        rgb[2] = (float)(1.0 - (double)(1.0f - hue[2]) * saturation);
    }

    public static void hue(float[] rgb, double orientation) {
        double yc = (double)1.6f + (1.0 - Math.cos(orientation * 2.0)) / 3.0;
        double t = orientation < 1.5707963267948966 ? 0.0 : (orientation < Math.PI ? (1.0 - Math.cos(orientation * 2.0 - Math.PI)) / 2.0 : (orientation < 4.71238898038469 ? (3.0 + Math.cos(orientation * 2.0)) / 4.0 * yc : (1.0 - Math.cos(orientation * 2.0)) / 4.0 * yc));
        rgb[0] = (float)t;
        t = orientation < 1.5707963267948966 ? (1.0 - Math.cos(orientation * 2.0 - Math.PI)) / 2.0 : (orientation < Math.PI ? 0.0 : (orientation < 4.71238898038469 ? (1.0 - Math.cos(orientation * 2.0)) / 4.0 * yc : (3.0 + Math.cos(orientation * 2.0)) / 4.0 * yc));
        rgb[1] = (float)t;
        t = orientation <= Math.PI ? (1.0 - Math.cos(orientation * 2.0)) / 2.0 : 0.0;
        rgb[2] = (float)t;
        rgb[0] = Math.min(rgb[0], 1.0f);
        rgb[1] = Math.min(rgb[1], 1.0f);
        rgb[2] = Math.min(rgb[2], 1.0f);
    }
}

