/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.SVSCoreMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVSReader
extends BaseTiffReader {
    public static final String REMOVE_THUMBNAIL_KEY = "svs.remove_thumbnail";
    public static final boolean REMOVE_THUMBNAIL_DEFAULT = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(SVSReader.class);
    private static final String APERIO_IMAGE_DESCRIPTION_PREFIX = "Aperio Image";
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    private Double[] zPosition;
    private String[] comments;
    private Double emissionWavelength;
    private Double excitationWavelength;
    private Double exposureTime;
    private Double exposureScale;
    private Double magnification;
    private String date;
    private String time;
    private ArrayList<String> dyeNames = new ArrayList();
    private transient Color displayColor = null;
    private int labelIndex = -1;
    private int macroIndex = -1;
    private int extraImages = 0;
    private transient Double physicalDistanceFromLeftEdge;
    private transient Double physicalDistanceFromTopEdge;

    public SVSReader() {
        super("Aperio SVS", new String[]{"svs"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
        this.noSubresolutions = true;
        this.canSeparateSeries = false;
    }

    public SVSReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    public boolean removeThumbnail() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(REMOVE_THUMBNAIL_KEY, Boolean.valueOf(true));
        }
        return true;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (isThisType) return isThisType;
        if (!open) return isThisType;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser tiffParser = new TiffParser(stream);
            tiffParser.setDoCaching(false);
            if (!tiffParser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = tiffParser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            Object description = ifd.get((Object)270);
            if (description != null) {
                String imageDescription = null;
                if (description instanceof TiffIFDEntry) {
                    Object value = tiffParser.getIFDValue((TiffIFDEntry)description);
                    if (value != null) {
                        imageDescription = value.toString();
                    }
                } else if (description instanceof String) {
                    imageDescription = (String)description;
                }
                if (imageDescription != null && imageDescription.startsWith(APERIO_IMAGE_DESCRIPTION_PREFIX)) {
                    boolean bl = tiffParser.getIFDOffsets().length > 1;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", (Throwable)e);
            return false;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        IFD ifd = this.getIFD(no);
        this.tiffParser.getSamples(ifd, buf, x, y, (long)w, (long)h);
        return buf;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.core.size() == 1 || this.getSeries() >= this.getSeriesCount() - this.extraImages) {
            return FormatTools.openThumbBytes((IFormatReader)this, (int)no);
        }
        int smallestSeries = this.getSeriesCount() - this.extraImages - 1;
        if (smallestSeries >= 0) {
            int thisSeries = this.getSeries();
            int resolution = this.getResolution();
            this.setSeries(smallestSeries);
            if (!this.hasFlattenedResolutions()) {
                this.setResolution(1);
            }
            byte[] thumb = FormatTools.openThumbBytes((IFormatReader)this, (int)no);
            this.setSeries(thisSeries);
            this.setResolution(resolution);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.zPosition = null;
            this.comments = null;
            this.emissionWavelength = null;
            this.excitationWavelength = null;
            this.exposureTime = null;
            this.exposureScale = null;
            this.magnification = null;
            this.date = null;
            this.time = null;
            this.dyeNames.clear();
            this.displayColor = null;
            this.extraImages = 0;
            this.labelIndex = -1;
            this.macroIndex = -1;
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            IFD ifd = this.getIFD(0);
            return (int)ifd.getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            IFD ifd = this.getIFD(0);
            return (int)ifd.getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileHeight();
        }
    }

    public int getTileRows(int no) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            IFD ifd = this.getIFD(no);
            return (int)ifd.getTilesPerColumn();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not get tile row count", (Throwable)e);
            return super.getTileRows(no);
        }
    }

    public int getTileColumns(int no) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            IFD ifd = this.getIFD(no);
            return (int)ifd.getTilesPerRow();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not get tile column count", (Throwable)e);
            return super.getTileColumns(no);
        }
    }

    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        IFD ifd = this.getIFD(no);
        byte[] buf = new byte[(int)this.getCompressedByteCount(ifd, x, y)];
        return this.openCompressedBytes(no, buf, x, y);
    }

    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        IFD ifd = this.getIFD(no);
        return this.copyTile(ifd, buf, x, y);
    }

    public Codec getTileCodec(int no) throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        IFD ifd = this.getIFD(no);
        return ifd.getCompression().getCodec();
    }

    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        IFD ifd = this.getIFD(no);
        CodecOptions options = ifd.getCompression().getCompressionCodecOptions(ifd);
        options.width = (int)ifd.getTileWidth();
        options.height = (int)ifd.getTileLength();
        return options;
    }

    protected ArrayList<String> getAvailableOptions() {
        ArrayList optionsList = super.getAvailableOptions();
        optionsList.add(REMOVE_THUMBNAIL_KEY);
        return optionsList;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        IFD lastResolution;
        int s;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        int seriesCount = this.ifds.size();
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            this.core.add((Object)new SVSCoreMetadata());
        }
        this.zPosition = new Double[seriesCount];
        this.comments = new String[seriesCount];
        HashSet<Double> uniqueZ = new HashSet<Double>();
        for (int i = 0; i < seriesCount; ++i) {
            this.setSeries(i);
            int index = i;
            IFD currentIFD = (IFD)this.ifds.get(index);
            this.tiffParser.fillInIFD(currentIFD);
            String comment = currentIFD.getComment();
            int subfileType = currentIFD.getIFDIntValue(254);
            if (comment == null) {
                if (this.labelIndex == -1) {
                    this.labelIndex = i;
                    continue;
                }
                if (this.macroIndex != -1) continue;
                this.macroIndex = i;
                continue;
            }
            this.comments[i] = comment;
            String[] lines = comment.split("\n");
            boolean foundLabel = false;
            boolean foundMacro = false;
            for (String line : lines) {
                String[] tokens;
                for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf(61) >= 0) {
                        String key = t.substring(0, t.indexOf(61)).trim();
                        String value = t.substring(t.indexOf(61) + 1).trim();
                        if (key.equals("TotalDepth")) {
                            this.zPosition[index] = 0.0;
                            continue;
                        }
                        if (!key.equals("OffsetZ")) continue;
                        this.zPosition[index] = DataTools.parseDouble(value);
                        continue;
                    }
                    if (t.toLowerCase().indexOf("label") >= 0) {
                        this.labelIndex = i;
                        foundLabel = true;
                        continue;
                    }
                    if (t.toLowerCase().indexOf("macro") < 0) continue;
                    this.macroIndex = i;
                    foundMacro = true;
                }
            }
            if (this.zPosition[index] != null) {
                uniqueZ.add(this.zPosition[index]);
            }
            if (foundLabel || foundMacro || subfileType == 0) continue;
            if (this.labelIndex == -1) {
                this.labelIndex = i;
                continue;
            }
            if (this.macroIndex != -1) continue;
            this.macroIndex = i;
        }
        this.setSeries(0);
        int resolutions = this.getSeriesCount();
        if (this.labelIndex >= 0) {
            --resolutions;
        }
        if (this.macroIndex >= 0) {
            --resolutions;
        }
        this.extraImages = this.getSeriesCount() - resolutions;
        IFD firstIFD = (IFD)this.ifds.get(this.getIFDIndex(0, 0));
        for (s = 1; s < resolutions; ++s) {
            int index = this.getIFDIndex(s, 0);
            IFD ifd = (IFD)this.ifds.get(index);
            this.tiffParser.fillInIFD(ifd);
            if (ifd.getPixelType() == firstIFD.getPixelType()) continue;
            this.ifds.set(index, null);
        }
        s = 0;
        while (s < this.ifds.size()) {
            if (this.ifds.get(s) != null) {
                ++s;
                continue;
            }
            this.ifds.remove(s);
            if (s < this.labelIndex) {
                --this.labelIndex;
            }
            if (s >= this.macroIndex) continue;
            --this.macroIndex;
        }
        if (uniqueZ.size() == 0) {
            uniqueZ.add(0.0);
        }
        this.zPosition = uniqueZ.toArray(new Double[uniqueZ.size()]);
        Arrays.sort((Object[])this.zPosition);
        seriesCount = (this.ifds.size() - this.extraImages) / uniqueZ.size() + this.extraImages;
        this.core.clear();
        if (seriesCount > this.extraImages) {
            this.core.add();
            for (int r = 0; r < seriesCount - this.extraImages; ++r) {
                this.core.add(0, (CoreMetadata)new SVSCoreMetadata());
            }
            for (int extra = 0; extra < this.extraImages; ++extra) {
                this.core.add((Object)new SVSCoreMetadata());
            }
        } else {
            for (s = 0; s < seriesCount; ++s) {
                this.core.add((Object)new SVSCoreMetadata());
            }
        }
        for (s = 0; s < seriesCount; ++s) {
            String[] lines;
            String comment;
            int[] pos = this.core.flattenedIndexes(s);
            this.setCoreIndex(s);
            SVSCoreMetadata ms = (SVSCoreMetadata)((Object)this.core.get(pos[0], pos[1]));
            if (s == 0 && seriesCount > this.extraImages) {
                ms.resolutionCount = seriesCount - this.extraImages;
            }
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(s, 0));
            this.tiffParser.fillInIFD(ifd);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = s < seriesCount - this.extraImages ? uniqueZ.size() : 1;
            ms.ifdIndex = new int[ms.sizeZ];
            for (int z = 0; z < ms.sizeZ; ++z) {
                ms.ifdIndex[z] = this.getIFDIndex(s, z);
            }
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = ms.sizeZ * ms.sizeT;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            boolean bl = ms.thumbnail = s != 0;
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || (comment = ((IFD)this.ifds.get(ms.ifdIndex[0])).getComment()) == null) continue;
            for (String line : lines = comment.split("\n")) {
                String[] tokens;
                block40: for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf(61) == -1) {
                        this.addGlobalMeta("Comment", t);
                        ((SVSCoreMetadata)this.getCurrentCore()).comment = t;
                        continue;
                    }
                    String key = t.substring(0, t.indexOf(61)).trim();
                    String value = t.substring(t.indexOf(61) + 1).trim();
                    this.addSeriesMeta(key, value);
                    switch (key) {
                        case "MPP": {
                            ((SVSCoreMetadata)this.getCurrentCore()).pixelSize = FormatTools.getPhysicalSizeX((Double)DataTools.parseDouble(value));
                            continue block40;
                        }
                        case "Date": {
                            this.date = value;
                            continue block40;
                        }
                        case "Time": {
                            this.time = value;
                            continue block40;
                        }
                        case "Emission Wavelength": {
                            this.emissionWavelength = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "Excitation Wavelength": {
                            this.excitationWavelength = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "Exposure Time": {
                            this.exposureTime = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "Exposure Scale": {
                            this.exposureScale = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "AppMag": {
                            this.magnification = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "Dye": {
                            this.dyeNames.add(value);
                            continue block40;
                        }
                        case "DisplayColor": {
                            int color = Integer.parseInt(value);
                            this.displayColor = new Color(Integer.valueOf(color << 8 | 0xFF));
                            continue block40;
                        }
                        case "Left": {
                            this.physicalDistanceFromLeftEdge = DataTools.parseDouble(value);
                            continue block40;
                        }
                        case "Top": {
                            this.physicalDistanceFromTopEdge = DataTools.parseDouble(value);
                        }
                    }
                }
            }
        }
        this.setSeries(0);
        this.core.reorder();
        if (this.removeThumbnail() && (lastResolution = (IFD)this.ifds.get(this.getIFDIndex(this.core.size(0) - 1, 0))).get((Object)279) != null) {
            int index = this.core.flattenedIndex(0, this.core.size(0) - 1);
            this.core.remove(0, this.core.size(0) - 1);
            if (index < this.labelIndex) {
                --this.labelIndex;
            }
            if (index < this.macroIndex) {
                --this.macroIndex;
            }
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        boolean populatePlaneData = this.getImageCount() > 1 || this.physicalDistanceFromTopEdge != null || this.physicalDistanceFromLeftEdge != null;
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)populatePlaneData);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        String objective = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
        store.setInstrumentID(instrument, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveNominalMagnification(this.magnification, 0, 0);
        int lastImage = this.core.size() - 1;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            Length pixelSize;
            int p;
            this.setSeries(i);
            store.setImageInstrumentRef(instrument, i);
            store.setObjectiveSettingsID(objective, i);
            if (i == 0) {
                if (this.physicalDistanceFromTopEdge != null) {
                    Length yPos = FormatTools.getStagePosition((Double)this.physicalDistanceFromTopEdge, (Unit)UNITS.MILLIMETER);
                    for (p = 0; p < this.getImageCount(); ++p) {
                        store.setPlanePositionY(yPos, i, p);
                    }
                }
                if (this.physicalDistanceFromLeftEdge != null) {
                    Length xPos = FormatTools.getStagePosition((Double)this.physicalDistanceFromLeftEdge, (Unit)UNITS.MILLIMETER);
                    for (p = 0; p < this.getImageCount(); ++p) {
                        store.setPlanePositionX(xPos, i, p);
                    }
                }
            }
            if (this.hasFlattenedResolutions() || i > this.extraImages) {
                store.setImageName("Series " + (i + 1), i);
            } else if (i == 0) {
                store.setImageName("", i);
            } else if (this.core.flattenedIndex(i, 0) == this.labelIndex) {
                store.setImageName("label image", i);
            } else if (this.core.flattenedIndex(i, 0) == this.macroIndex) {
                store.setImageName("macro image", i);
            }
            String comment = ((SVSCoreMetadata)this.getCurrentCore()).comment;
            store.setImageDescription(comment, i);
            if (this.getDatestamp() != null) {
                store.setImageAcquisitionDate(this.getDatestamp(), i);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.getEmission() != null) {
                    store.setChannelEmissionWavelength(this.getEmission(), i, c);
                }
                if (this.getExcitation() != null) {
                    store.setChannelExcitationWavelength(this.getExcitation(), i, c);
                }
                if (c >= this.dyeNames.size()) continue;
                store.setChannelName(this.dyeNames.get(c), i, c);
            }
            if (this.getImageCount() > 1) {
                for (p = 0; p < this.getImageCount(); ++p) {
                    if (p >= this.zPosition.length || this.zPosition[p] == null) continue;
                    store.setPlanePositionZ(FormatTools.createLength((Double)this.zPosition[p], (Unit)UNITS.REFERENCEFRAME), i, p);
                }
            }
            if ((pixelSize = ((SVSCoreMetadata)this.getCurrentCore()).pixelSize) == null || !(pixelSize.value(UNITS.MICROMETER).doubleValue() - 1.0E-6 > 0.0)) continue;
            store.setPixelsPhysicalSizeX(pixelSize, i);
            store.setPixelsPhysicalSizeY(pixelSize, i);
        }
        this.setSeries(0);
    }

    private int getIFDIndex(int coreIndex, int no) {
        int index = coreIndex;
        int coreCount = this.core.flattenedSize() - this.extraImages;
        if (coreIndex > 0 && coreIndex < coreCount) {
            index = ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount > 1 ? ++index : coreCount - coreIndex;
        }
        if (coreIndex > 0 && coreIndex < coreCount || no > 0) {
            for (int i = 0; i < no; ++i) {
                index += coreCount;
            }
            if (coreIndex == 0) {
                ++index;
            }
        } else if (coreIndex >= coreCount) {
            if (((CoreMetadata)this.core.get((int)0, (int)0)).imageCount > 1) {
                for (int i = 0; i < coreCount; ++i) {
                    index += ((CoreMetadata)this.core.get((int)0, (int)i)).imageCount;
                }
                index -= coreCount - 1;
            } else {
                if (coreIndex == this.labelIndex) {
                    return this.labelIndex;
                }
                if (coreIndex == this.macroIndex) {
                    return this.macroIndex;
                }
            }
        }
        return index;
    }

    protected Length getEmission() {
        if (this.emissionWavelength != null && this.emissionWavelength > 0.0) {
            return FormatTools.getEmissionWavelength((Double)this.emissionWavelength);
        }
        return null;
    }

    protected Length getExcitation() {
        if (this.excitationWavelength != null && this.excitationWavelength > 0.0) {
            return FormatTools.getExcitationWavelength((Double)this.excitationWavelength);
        }
        return null;
    }

    protected Double getExposureTime() {
        if (this.exposureTime == null || this.exposureScale == null) {
            LOGGER.debug("Ignoring exposure time = {}, scale = {}", (Object)this.exposureTime, (Object)this.exposureScale);
            return null;
        }
        return this.exposureTime * this.exposureScale * 1000.0;
    }

    protected Timestamp getDatestamp() {
        if (this.date != null && this.time != null) {
            try {
                return new Timestamp(DateTools.formatDate(this.date + " " + this.time, DATE_FORMAT));
            }
            catch (Exception e) {
                LOGGER.debug("Failed to parse '" + this.date + " " + this.time + "'", (Throwable)e);
            }
        }
        return null;
    }

    protected Length[] getPhysicalSizes() {
        Length[] psizes = new Length[this.getSeriesCount()];
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int[] pos = this.core.flattenedIndexes(i);
            SVSCoreMetadata c = (SVSCoreMetadata)((Object)this.core.get(pos[0], pos[1]));
            psizes[i] = c.pixelSize;
        }
        return psizes;
    }

    protected double getMagnification() {
        return this.magnification == null ? Double.NaN : this.magnification;
    }

    protected ArrayList<String> getDyeNames() {
        return this.dyeNames;
    }

    protected Color getDisplayColor() {
        return this.displayColor;
    }

    protected IFD getIFD(int no) {
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = ((SVSCoreMetadata)this.getCurrentCore()).ifdIndex[no];
        return (IFD)this.ifds.get(ifd);
    }
}

