/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ini.trakem2.Project;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Utils;
import java.util.Set;

public class DBObject {
    protected long id;
    protected Project project;

    public DBObject(Project project) {
        this.project = project;
        this.id = project.getLoader().getNextId();
    }

    public DBObject(Project project, long id) {
        this.project = project;
        this.id = id;
    }

    public DBObject(Loader loader) {
        this.id = loader.getNextId();
    }

    public final long getId() {
        return this.id;
    }

    public String getUniqueIdentifier() {
        return Long.toString(this.id);
    }

    public final Project getProject() {
        return this.project;
    }

    public boolean addToDatabase() {
        return this.project.getLoader().addToDatabase(this);
    }

    public boolean updateInDatabase(String key) {
        return this.project.getLoader().updateInDatabase(this, key);
    }

    public boolean updateInDatabase(Set<String> keys) {
        return this.project.getLoader().updateInDatabase(this, keys);
    }

    public boolean removeFromDatabase() {
        return this.project.getLoader().removeFromDatabase(this);
    }

    public boolean remove(boolean check) {
        if (check && !Utils.check("Really remove " + this.toString() + " ?")) {
            return false;
        }
        return this.removeFromDatabase();
    }

    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        Utils.log("ERROR: exportXML not implemented for " + this.getClass().getName());
    }

    public String getTitle() {
        return this.toString();
    }

    public String getShortTitle() {
        return this.getTitle();
    }

    public String getInfo() {
        return "Class: " + this.getClass().getName() + "\nID: " + this.id + "\nFrom:\n" + this.project.getInfo();
    }
}

