/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.IntFunction;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;

public class MultiDimensionConvolution<T>
implements Convolution<T> {
    private ExecutorService executor;
    private final IntFunction<Convolution<T>> factory;
    private final HashMap<Integer, Convolution<T>> cache = new HashMap();

    @Override
    @Deprecated
    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
        this.cache.values().forEach(convolution -> convolution.setExecutor(executor));
    }

    public MultiDimensionConvolution(IntFunction<Convolution<T>> numDimensionToConvolution) {
        this.factory = numDimensionToConvolution;
    }

    private Convolution<T> getCachedConvolution(int nDimensions) {
        return this.cache.computeIfAbsent(nDimensions, n -> {
            Convolution<T> c = this.factory.apply((int)n);
            c.setExecutor(this.executor);
            return c;
        });
    }

    @Override
    public Interval requiredSourceInterval(Interval targetInterval) {
        return this.getCachedConvolution(targetInterval.numDimensions()).requiredSourceInterval(targetInterval);
    }

    @Override
    public T preferredSourceType(T targetType) {
        return this.getCachedConvolution(2).preferredSourceType(targetType);
    }

    @Override
    public void process(RandomAccessible<? extends T> source, RandomAccessibleInterval<? extends T> target) {
        this.getCachedConvolution(target.numDimensions()).process(source, target);
    }
}

