/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public abstract class AbstractDrawingEditorAction
extends AbstractAction {
    protected DrawingEditor editor;
    @Nullable
    private EventHandler eventHandler = new EventHandler();

    public AbstractDrawingEditorAction(DrawingEditor editor) {
        this.setEditor(editor);
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.eventHandler != null) {
            this.unregisterEventHandler();
        }
        this.editor = newValue;
        if (this.eventHandler != null) {
            this.registerEventHandler();
            this.updateEnabledState();
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.editor != null && this.editor.isEnabled());
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit edit) {
        this.getDrawing().fireUndoableEditHappened(edit);
    }

    public void setUpdateEnabledState(boolean newValue) {
        if (this.eventHandler != null != newValue) {
            if (newValue) {
                this.eventHandler = new EventHandler();
                this.registerEventHandler();
            } else {
                this.unregisterEventHandler();
                this.eventHandler = null;
            }
        }
        if (newValue) {
            this.updateEnabledState();
        }
    }

    public boolean isUpdatEnabledState() {
        return this.eventHandler != null;
    }

    private void unregisterEventHandler() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
    }

    private void registerEventHandler() {
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
        }
    }

    private class EventHandler
    implements PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                AbstractDrawingEditorAction.this.updateEnabledState();
            }
        }
    }
}

