/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.kdtree.KDTreeImpl;
import net.imglib2.kdtree.KDTreeUtils;

public class RadiusNeighborSearchImpl {
    private final KDTreeImpl tree;
    private final int numDimensions;
    private final int numPoints;
    private final double[] pos;
    private final double[] axisDiffs;
    private final int[] awayChilds;
    private final Neighbors neighbors;

    public RadiusNeighborSearchImpl(KDTreeImpl tree) {
        this.tree = tree;
        this.numDimensions = tree.numDimensions();
        this.numPoints = tree.size();
        this.pos = new double[this.numDimensions];
        int depth = tree.depth();
        this.axisDiffs = new double[depth + 1];
        this.awayChilds = new int[depth + 1];
        this.neighbors = new Neighbors();
    }

    public void search(RealLocalizable p, double radius, boolean sortResults) {
        assert (radius >= 0.0);
        double squRadius = radius * radius;
        p.localize(this.pos);
        this.neighbors.clear();
        int current = this.tree.root();
        int depth = 0;
        while (true) {
            int d;
            double axisDiff;
            double squDistance;
            if ((squDistance = this.tree.squDistance(current, this.pos)) < squRadius) {
                this.neighbors.add(squDistance, current);
            }
            boolean leftIsNearBranch = (axisDiff = this.pos[d = depth % this.numDimensions] - this.tree.getDoublePosition(current, d)) < 0.0;
            int nearChild = 2 * current + (leftIsNearBranch ? 1 : 2);
            int awayChild = 2 * current + (leftIsNearBranch ? 2 : 1);
            this.awayChilds[++depth] = awayChild;
            this.axisDiffs[depth] = axisDiff * axisDiff;
            if (nearChild >= this.numPoints) {
                while (this.awayChilds[depth] >= this.numPoints || this.axisDiffs[depth] > squRadius) {
                    if (--depth != 0) continue;
                    if (sortResults) {
                        this.neighbors.sort();
                    }
                    return;
                }
                current = this.awayChilds[depth];
                this.awayChilds[depth] = this.numPoints;
                continue;
            }
            current = nearChild;
        }
    }

    public int numNeighbors() {
        return this.neighbors.size;
    }

    public int bestIndex(int i) {
        return this.neighbors.indices[i];
    }

    public double bestSquDistance(int i) {
        return this.neighbors.distances[i];
    }

    public RadiusNeighborSearchImpl copy() {
        RadiusNeighborSearchImpl copy = new RadiusNeighborSearchImpl(this.tree);
        System.arraycopy(this.pos, 0, copy.pos, 0, this.pos.length);
        copy.neighbors.makeCopyOf(this.neighbors);
        return copy;
    }

    static class Neighbors {
        double[] distances;
        int[] indices;
        int size;

        Neighbors() {
            int capacity = 10;
            this.distances = new double[10];
            this.indices = new int[10];
        }

        void clear() {
            this.size = 0;
        }

        void add(double distance, int index) {
            if (this.distances.length <= this.size) {
                int newLength = this.distances.length * 2;
                this.distances = Arrays.copyOf(this.distances, newLength);
                this.indices = Arrays.copyOf(this.indices, newLength);
            }
            this.distances[this.size] = distance;
            this.indices[this.size] = index;
            ++this.size;
        }

        void sort() {
            int[] order = new int[this.size];
            Arrays.setAll(order, i -> i);
            KDTreeUtils.quicksort(0, this.size - 1, this.distances, order);
            System.arraycopy(KDTreeUtils.reorder(this.distances, order), 0, this.distances, 0, this.size);
            System.arraycopy(KDTreeUtils.reorder(this.indices, order), 0, this.indices, 0, this.size);
        }

        void makeCopyOf(Neighbors other) {
            this.distances = (double[])other.distances.clone();
            this.indices = (int[])other.indices.clone();
            this.size = other.size;
        }
    }
}

