/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.interval;

import java.util.Arrays;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.iterator.LocalizingRealIntervalIterator;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public abstract class Volume
implements IntervalSamplingMethod {
    protected abstract double[] spacing(RealInterval var1);

    @Override
    public RealInterval bounds(RealInterval interval, RealTransform transform) {
        assert (interval.numDimensions() >= transform.numSourceDimensions()) : "Interval dimensions too small for transformation.";
        int nTarget = transform.numTargetDimensions();
        double[] min = new double[nTarget];
        double[] max = new double[nTarget];
        Arrays.fill(min, Double.MAX_VALUE);
        Arrays.fill(max, Double.MIN_VALUE);
        IntervalSamplingMethod.transformedCoordinateBounds(transform, new LocalizingRealIntervalIterator(interval, this.spacing(interval)), min, max);
        return new FinalRealInterval(min, max, false);
    }
}

