/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.AbstractPNode;
import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.MutiablePolynomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class Polynomial
extends AbstractPNode {
    PNodeI[] terms;

    Polynomial(PolynomialCreator pc, PNodeI[] terms) {
        super(pc);
        this.terms = terms;
    }

    MutiablePolynomial toMutiablePolynomial() {
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            newTerms[i] = this.terms[i];
        }
        return new MutiablePolynomial(this.pc, newTerms);
    }

    @Override
    public PNodeI add(PNodeI node) throws ParseException {
        if (node instanceof Polynomial) {
            return this.add((Polynomial)node);
        }
        MutiablePolynomial mp = this.toMutiablePolynomial();
        mp.add(node);
        return mp.toPNode();
    }

    @Override
    public PNodeI sub(PNodeI node) throws ParseException {
        if (node instanceof Polynomial) {
            return this.sub((Polynomial)node);
        }
        MutiablePolynomial mp = this.toMutiablePolynomial();
        mp.add(node.negate());
        return mp.toPNode();
    }

    public PNodeI add(Polynomial p) throws ParseException {
        MutiablePolynomial mp = this.toMutiablePolynomial();
        for (int i = 0; i < p.terms.length; ++i) {
            mp.add(p.terms[i]);
        }
        return mp.toPNode();
    }

    public PNodeI sub(Polynomial p) throws ParseException {
        MutiablePolynomial mp = this.toMutiablePolynomial();
        for (int i = 0; i < p.terms.length; ++i) {
            mp.add(p.terms[i].negate());
        }
        return mp.toPNode();
    }

    @Override
    public PNodeI negate() throws ParseException {
        PNodeI[] newTerms = new PNodeI[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            newTerms[i] = this.terms[i].negate();
        }
        return new Polynomial(this.pc, newTerms);
    }

    @Override
    public PNodeI mul(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            PConstant c = (PConstant)node;
            if (c.isZero()) {
                return this.pc.zeroConstant;
            }
            if (c.isOne()) {
                return this;
            }
        }
        return super.mul(node);
    }

    @Override
    public PNodeI div(PNodeI node) throws ParseException {
        if (node instanceof PConstant) {
            PConstant c = (PConstant)node;
            if (c.isZero()) {
                return this.pc.infConstant;
            }
            if (c.isOne()) {
                return this;
            }
            PNodeI[] newTerms = new PNodeI[this.terms.length];
            for (int i = 0; i < this.terms.length; ++i) {
                newTerms[i] = this.terms[i].div(c);
            }
            return new Polynomial(this.pc, newTerms);
        }
        return super.div(node);
    }

    @Override
    public boolean equals(PNodeI node) {
        if (!(node instanceof Polynomial)) {
            return false;
        }
        Polynomial p = (Polynomial)node;
        if (this.terms.length != p.terms.length) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equals(p.terms[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(PNodeI node) {
        if (node instanceof Polynomial) {
            return this.compareTo((Polynomial)node);
        }
        int res = this.terms[0].compareTo(node);
        if (res != 0) {
            return res;
        }
        if (this.terms.length == 1) {
            return 0;
        }
        return 1;
    }

    public int compareTo(Polynomial p) {
        for (int i = 0; i < this.terms.length; ++i) {
            if (i >= p.terms.length) {
                return 1;
            }
            int res = this.terms[i].compareTo(p.terms[i]);
            if (res == 0) continue;
            return res;
        }
        if (this.terms.length < p.terms.length) {
            return -1;
        }
        return 0;
    }

    private boolean isNegative(PNodeI node) {
        if (node instanceof PConstant) {
            return ((PConstant)node).isNegative();
        }
        if (node instanceof Monomial) {
            return ((Monomial)node).negativeCoefficient();
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.terms.length == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0 && !this.isNegative(this.terms[i])) {
                sb.append('+');
            }
            sb.append(((Object)this.terms[i]).toString());
        }
        return sb.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        if (this.terms.length == 0) {
            return this.pc.nf.buildConstantNode(this.pc.zero);
        }
        Node[] args = new Node[this.terms.length];
        for (int i = 0; i < this.terms.length; ++i) {
            args[i] = this.terms[i].toNode();
        }
        if (this.terms.length == 1) {
            return args[0];
        }
        return this.pc.nf.buildOperatorNode(this.pc.os.getAdd(), args);
    }

    @Override
    public PNodeI expand() throws ParseException {
        MutiablePolynomial mp = new MutiablePolynomial(this.pc, new PNodeI[]{this.pc.zeroConstant});
        for (int i = 0; i < this.terms.length; ++i) {
            PNodeI exp = this.terms[i].expand();
            mp.add(exp);
        }
        return mp.toPNode();
    }
}

