/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import org.scijava.Cancelable;

public class ExecuteDetectionDescriptor
extends WizardPanelDescriptor {
    public static final String KEY = "ExecuteDetection";
    private final TrackMate trackmate;

    public ExecuteDetectionDescriptor(TrackMate trackmate, LogPanel logPanel) {
        super(KEY);
        this.trackmate = trackmate;
        this.targetPanel = logPanel;
    }

    @Override
    public Runnable getForwardRunnable() {
        return () -> {
            Settings settings = this.trackmate.getSettings();
            settings.setRoi(settings.imp.getRoi());
            long start = System.currentTimeMillis();
            boolean ok = this.trackmate.execDetection();
            if (!ok) {
                this.trackmate.getModel().getLogger().error(this.trackmate.getErrorMessage() + "\n");
            }
            long end = System.currentTimeMillis();
            this.trackmate.getModel().getLogger().log(String.format("Detection done in %.1f s.\n", Float.valueOf((float)(end - start) / 1000.0f)));
        };
    }

    @Override
    public Cancelable getCancelable() {
        return this.trackmate;
    }
}

