/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import fiji.plugin.trackmate.visualization.ManualEdgeColorGenerator;
import java.awt.Color;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class ManualSpotPerEdgeColorGenerator
implements FeatureColorGenerator<Spot> {
    private final Color missingValueColor;
    private final Model model;
    private final ManualEdgeColorGenerator manualEdgeColorGenerator;

    public ManualSpotPerEdgeColorGenerator(Model model, Color missingValueColor) {
        this.model = model;
        this.missingValueColor = missingValueColor;
        this.manualEdgeColorGenerator = new ManualEdgeColorGenerator(model, missingValueColor);
    }

    @Override
    public Color color(Spot spot) {
        Set<DefaultWeightedEdge> edges = this.model.getTrackModel().edgesOf(spot);
        DefaultWeightedEdge edge = null;
        for (DefaultWeightedEdge e : edges) {
            if (!this.model.getTrackModel().getEdgeTarget(e).equals(spot)) continue;
            edge = e;
            break;
        }
        if (edge == null) {
            return this.missingValueColor;
        }
        return this.manualEdgeColorGenerator.color(edge);
    }
}

