/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.iotiming;

public class IoTimeBudget {
    private long[] budget = new long[]{0L};

    public synchronized void reset(long[] partialBudget) {
        if (partialBudget == null || partialBudget.length == 0) {
            this.clear();
        } else {
            if (partialBudget.length == this.budget.length) {
                System.arraycopy(partialBudget, 0, this.budget, 0, this.budget.length);
            } else {
                this.budget = (long[])partialBudget.clone();
            }
            for (int i = 1; i < this.budget.length; ++i) {
                if (this.budget[i] <= this.budget[i - 1]) continue;
                this.budget[i] = this.budget[i - 1];
            }
        }
    }

    public synchronized void clear() {
        for (int i = 0; i < this.budget.length; ++i) {
            this.budget[i] = 0L;
        }
    }

    public synchronized long timeLeft(int level) {
        int blevel = Math.min(level, this.budget.length - 1);
        return this.budget[blevel];
    }

    public synchronized void use(long t, int level) {
        int blevel = Math.min(level, this.budget.length - 1);
        int l = 0;
        while (l <= blevel) {
            int n = l++;
            this.budget[n] = this.budget[n] - t;
        }
        while (l < this.budget.length && this.budget[l] > this.budget[l - 1]) {
            this.budget[l] = this.budget[l - 1];
            ++l;
        }
    }

    public long estimateTimeLeft(int level) {
        long[] b = this.budget;
        int blevel = Math.min(level, b.length - 1);
        return b[blevel];
    }
}

