/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ColorProcessor;
import ij.process.LUT;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;

public class IntProcessor
extends ColorProcessor {
    private byte[] pixels8;

    public IntProcessor(int width, int height) {
        this(width, height, new int[width * height]);
    }

    public IntProcessor(int width, int height, int[] pixels) {
        super(width, height, pixels);
        this.makeDefaultColorModel();
    }

    @Override
    public Image createImage() {
        block7: {
            boolean thresholding;
            if (!this.minMaxSet) {
                this.findMinAndMax();
            }
            boolean firstTime = this.pixels8 == null;
            boolean bl = thresholding = this.minThreshold != -808080.0 && this.lutUpdateMode < 2;
            if (firstTime || !this.lutAnimation) {
                this.create8BitImage(thresholding && this.lutUpdateMode == 0);
            }
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            if (!thresholding) break block7;
            int t1 = (int)this.minThreshold;
            int t2 = (int)this.maxThreshold;
            int size = this.width * this.height;
            if (this.lutUpdateMode == 1) {
                for (int i = 0; i < size; ++i) {
                    int value = this.pixels[i] & 0xFFFF;
                    this.pixels8[i] = value >= t1 && value <= t2 ? -1 : 0;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    int value = this.pixels[i] & 0xFFFF;
                    if (value < t1 || value > t2) continue;
                    this.pixels8[i] = -1;
                }
            }
        }
        return this.createBufferedImage();
    }

    private byte[] create8BitImage(boolean thresholding) {
        int size = this.width * this.height;
        if (this.pixels8 == null) {
            this.pixels8 = new byte[size];
        }
        double min2 = this.getMin();
        double max2 = this.getMax();
        double scale = 255.0 / (max2 - min2);
        int maxValue = thresholding ? 254 : 255;
        for (int i = 0; i < size; ++i) {
            int ivalue;
            double value = (double)this.pixels[i] - min2;
            if (value < 0.0) {
                value = 0.0;
            }
            if ((ivalue = (int)(value * scale + 0.5)) > maxValue) {
                ivalue = maxValue;
            }
            this.pixels8[i] = (byte)ivalue;
        }
        return this.pixels8;
    }

    @Override
    byte[] create8BitImage() {
        return this.create8BitImage(false);
    }

    @Override
    Image createBufferedImage() {
        if (this.raster == null) {
            SampleModel sm = this.getIndexSampleModel();
            DataBufferByte db = new DataBufferByte(this.pixels8, this.width * this.height, 0);
            this.raster = Raster.createWritableRaster(sm, db, null);
        }
        if (this.image == null || this.cm != this.cm2) {
            if (this.cm == null) {
                this.cm = this.getDefaultColorModel();
            }
            this.image = new BufferedImage(this.cm, this.raster, false, null);
            this.cm2 = this.cm;
        }
        this.lutAnimation = false;
        return this.image;
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.convertToByte(true).getBufferedImage();
    }

    @Override
    public void setColorModel(ColorModel cm) {
        if (cm != null && !(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("IndexColorModel required");
        }
        if (cm != null && cm instanceof LUT) {
            cm = ((LUT)cm).getColorModel();
        }
        this.cm = cm;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
        this.minThreshold = -808080.0;
    }

    @Override
    public float getPixelValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.pixels[y * this.width + x];
        }
        return Float.NaN;
    }

    @Override
    public int getNChannels() {
        return 1;
    }

    public void findMinAndMax() {
        int size = this.width * this.height;
        int min = this.pixels[0];
        int max = this.pixels[0];
        for (int i = 1; i < size; ++i) {
            int value = this.pixels[i];
            if (value < min) {
                min = value;
                continue;
            }
            if (value <= max) continue;
            max = value;
        }
        this.min = min;
        this.max = max;
        this.minMaxSet = true;
    }

    @Override
    public void resetMinAndMax() {
        this.findMinAndMax();
        this.resetThreshold();
    }

    @Override
    public void setMinAndMax(double minimum, double maximum, int channels) {
        this.min = (int)minimum;
        this.max = (int)maximum;
        this.minMaxSet = true;
        this.resetThreshold();
    }
}

