/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.localThickness;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Local_Thickness_Parallel
implements PlugInFilter {
    private ImagePlus imp;
    private ImagePlus resultImage;
    public float[][] data;
    public boolean runSilent = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 8;
    }

    public void run(ImageProcessor ip) {
        int thread;
        int ind;
        int nr;
        this.resultImage = this.imp.duplicate();
        ImageStack stack = this.resultImage.getStack();
        int w = stack.getWidth();
        int h = stack.getHeight();
        int d = this.resultImage.getStackSize();
        float[][] s = new float[d][];
        for (int k = 0; k < d; ++k) {
            s[k] = (float[])stack.getPixels(k + 1);
        }
        int[] nRidge = new int[d];
        IJ.showStatus((String)"Local Thickness: scanning stack ");
        for (int k = 0; k < d; ++k) {
            float[] sk = s[k];
            nr = 0;
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (int i = 0; i < w; ++i) {
                    ind = i + wj;
                    if (!(sk[ind] > 0.0f)) continue;
                    ++nr;
                }
            }
            nRidge[k] = nr;
        }
        int[][] iRidge = new int[d][];
        int[][] jRidge = new int[d][];
        float[][] rRidge = new float[d][];
        float sMax = 0.0f;
        for (int k = 0; k < d; ++k) {
            nr = nRidge[k];
            iRidge[k] = new int[nr];
            jRidge[k] = new int[nr];
            rRidge[k] = new float[nr];
            float[] sk = s[k];
            int[] iRidgeK = iRidge[k];
            int[] jRidgeK = jRidge[k];
            float[] rRidgeK = rRidge[k];
            int iR = 0;
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (int i = 0; i < w; ++i) {
                    ind = i + wj;
                    float skind = sk[ind];
                    if (!(skind > 0.0f)) continue;
                    iRidgeK[iR] = i;
                    jRidgeK[iR] = j;
                    rRidgeK[iR++] = skind;
                    if (skind > sMax) {
                        sMax = skind;
                    }
                    sk[ind] = 0.0f;
                }
            }
        }
        int nThreads = Runtime.getRuntime().availableProcessors();
        Object[] resources = new Object[d];
        for (int k = 0; k < d; ++k) {
            resources[k] = new Object();
        }
        LTThread[] ltt = new LTThread[nThreads];
        for (thread = 0; thread < nThreads; ++thread) {
            ltt[thread] = new LTThread(thread, nThreads, w, h, d, nRidge, s, iRidge, jRidge, rRidge, resources);
            ltt[thread].start();
        }
        try {
            for (thread = 0; thread < nThreads; ++thread) {
                ltt[thread].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted .");
        }
        IJ.showStatus((String)"Local Thickness: square root ");
        for (int k = 0; k < d; ++k) {
            float[] sk = s[k];
            for (int j = 0; j < h; ++j) {
                int wj = w * j;
                for (int i = 0; i < w; ++i) {
                    ind = i + wj;
                    sk[ind] = (float)(2.0 * Math.sqrt(sk[ind]));
                }
            }
        }
        IJ.showStatus((String)"Local Thickness complete");
        String title = this.stripExtension(this.imp.getTitle());
        this.resultImage.setTitle(title + "_LT");
        this.resultImage.getProcessor().setMinAndMax(0.0, (double)sMax);
        if (!this.runSilent) {
            this.resultImage.show();
            IJ.run((String)"Fire");
        }
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public ImagePlus getResultImage() {
        return this.resultImage;
    }

    public void purge() {
        this.data = null;
        this.resultImage = null;
        this.imp = null;
    }

    class LTThread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        int[] nRidge;
        int[][] iRidge;
        int[][] jRidge;
        float[][] rRidge;
        Object[] resources;

        public LTThread(int thread, int nThreads, int w, int h, int d, int[] nRidge, float[][] s, int[][] iRidge, int[][] jRidge, float[][] rRidge, Object[] resources) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
            this.nRidge = nRidge;
            this.iRidge = iRidge;
            this.jRidge = jRidge;
            this.rRidge = rRidge;
            this.resources = resources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                IJ.showStatus((String)("Local Thickness: processing slice " + (k + 1) + "/" + (this.d + 1)));
                int nR = this.nRidge[k];
                int[] iRidgeK = this.iRidge[k];
                int[] jRidgeK = this.jRidge[k];
                float[] rRidgeK = this.rRidge[k];
                for (int iR = 0; iR < nR; ++iR) {
                    int kStop;
                    int kStart;
                    int jStop;
                    int jStart;
                    int iStop;
                    int iStart;
                    int i = iRidgeK[iR];
                    int j = jRidgeK[iR];
                    float r = rRidgeK[iR];
                    int rSquared = (int)(r * r + 0.5f);
                    int rInt = (int)r;
                    if ((float)rInt < r) {
                        ++rInt;
                    }
                    if ((iStart = i - rInt) < 0) {
                        iStart = 0;
                    }
                    if ((iStop = i + rInt) >= this.w) {
                        iStop = this.w - 1;
                    }
                    if ((jStart = j - rInt) < 0) {
                        jStart = 0;
                    }
                    if ((jStop = j + rInt) >= this.h) {
                        jStop = this.h - 1;
                    }
                    if ((kStart = k - rInt) < 0) {
                        kStart = 0;
                    }
                    if ((kStop = k + rInt) >= this.d) {
                        kStop = this.d - 1;
                    }
                    for (int k1 = kStart; k1 <= kStop; ++k1) {
                        float r1SquaredK = (k1 - k) * (k1 - k);
                        float[] sk1 = this.s[k1];
                        for (int j1 = jStart; j1 <= jStop; ++j1) {
                            float r1SquaredJK = r1SquaredK + (float)((j1 - j) * (j1 - j));
                            int wj1 = this.w * j1;
                            if (!(r1SquaredJK <= (float)rSquared)) continue;
                            for (int i1 = iStart; i1 <= iStop; ++i1) {
                                int ind1;
                                float s1;
                                float r1Squared = r1SquaredJK + (float)((i1 - i) * (i1 - i));
                                if (!(r1Squared <= (float)rSquared) || !((float)rSquared > (s1 = sk1[ind1 = i1 + wj1]))) continue;
                                Object object = this.resources[k1];
                                synchronized (object) {
                                    s1 = sk1[ind1];
                                    if ((float)rSquared > s1) {
                                        sk1[ind1] = rSquared;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

