/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import java.util.Vector;
import view5d.APoint;

class MarkerList {
    int NumPoints = 0;
    int ActivePoint = -1;
    public Vector<APoint> MyPoints = null;
    MarkerList Parent1List = null;
    MarkerList Parent2List = null;
    MarkerList Child1List = null;
    MarkerList Child2List = null;
    int PreferredChild = 1;
    boolean toggling = false;
    static final int Attributes = 20;
    public String MyName = "Unknown";

    public MarkerList() {
        this.NewList();
    }

    void Link1To(MarkerList Parent) {
        if (Parent == null) {
            return;
        }
        this.Parent1List = Parent;
        if (this.Parent1List.Child1List == null) {
            this.Parent1List.Child1List = this;
        } else if (this.Parent1List.Child2List == null) {
            this.Parent1List.Child2List = this;
        }
        if (this.NumPoints > 0) {
            this.SetColor(Parent.GetPoint((int)0).mycolor);
        }
    }

    void Link2To(MarkerList Parent) {
        if (Parent == null) {
            return;
        }
        this.Parent2List = Parent;
        if (this.Parent2List.Child1List == null) {
            this.Parent2List.Child1List = this;
        } else if (this.Parent2List.Child2List == null) {
            this.Parent2List.Child2List = this;
        }
        if (this.NumPoints > 0) {
            this.SetColor(Parent.GetPoint((int)0).mycolor);
        }
    }

    void NewList() {
        if (this.MyPoints != null && this.NumPoints == 0) {
            return;
        }
        this.MyPoints = new Vector();
        this.NumPoints = 0;
        this.ActivePoint = -1;
    }

    void ToggleColor() {
        int color = APoint.NewColor();
        this.SetColor(color);
    }

    int GetColor() {
        APoint pt = this.GetPoint(0);
        if (pt != null) {
            return pt.mycolor;
        }
        return 0;
    }

    void SetColor(int color) {
        if (this.toggling) {
            return;
        }
        this.toggling = true;
        for (int i = 0; i < this.NumPoints; ++i) {
            this.GetPoint((int)i).mycolor = color;
        }
        if (this.Parent1List != null) {
            this.Parent1List.SetColor(color);
        }
        if (this.Parent2List != null) {
            this.Parent2List.SetColor(color);
        }
        if (this.Child1List != null && !this.Child1List.toggling) {
            this.Child1List.SetColor(color);
        }
        if (this.Child2List != null && !this.Child2List.toggling) {
            this.Child2List.SetColor(color);
        }
        this.toggling = false;
    }

    void AddPoint(APoint p) {
        if (this.NumPoints > 0) {
            p.mycolor = this.GetPoint((int)0).mycolor;
        }
        if (this.ActivePoint < 0) {
            this.ActivePoint = 0;
            this.MyPoints.addElement(p);
        } else {
            ++this.ActivePoint;
            this.MyPoints.insertElementAt(p, this.ActivePoint);
        }
        ++this.NumPoints;
    }

    boolean RemovePoint() {
        if (this.NumPoints <= 0) {
            return false;
        }
        this.MyPoints.removeElementAt(this.ActivePoint);
        --this.NumPoints;
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint = this.NumPoints - 1;
            return false;
        }
        return this.NumPoints > 0;
    }

    void RemoveTrailingPoints() {
        while (this.RemovePoint()) {
        }
    }

    void AdvancePoint(int howmany) {
        if (this.NumPoints <= 0) {
            return;
        }
        this.ActivePoint += howmany;
        if (this.ActivePoint < 0) {
            this.ActivePoint += this.NumPoints;
        }
        if (this.ActivePoint >= this.NumPoints) {
            this.ActivePoint %= this.NumPoints;
        }
    }

    int GetMarkerNr(APoint pt) {
        return this.MyPoints.indexOf(pt);
    }

    int ClosestTrackMarker(APoint other, int dir, int step) {
        int MinP = 0;
        double mindist = Math.abs(this.GetPoint(MinP).DistTo(other, dir)) - (double)step;
        for (int p = 1; p < this.NumMarkers(); ++p) {
            APoint Pt = this.GetPoint(p);
            double dist = Math.abs(Pt.DistTo(other, dir) - (double)step);
            if (dist == 0.0 && step == 1) {
                return p;
            }
            if (!(dist <= mindist)) continue;
            mindist = dist;
            MinP = p;
        }
        return MinP;
    }

    APoint MarkerFromPosition(double px, double py, int dir, double DistX, double DistY) {
        for (int p = 0; p < this.NumMarkers(); ++p) {
            APoint Pt = this.GetPoint(p);
            if (!Pt.isDisplayed || !Pt.InRange(px, py, dir, DistX, DistY)) continue;
            return Pt;
        }
        return null;
    }

    String GetMarkerListName() {
        return this.MyName;
    }

    void SetActiveMarkerClosest(APoint other, int dir, int step) {
        if (this.NumPoints <= 0) {
            return;
        }
        this.ActivePoint = other == null ? 0 : this.ClosestTrackMarker(other, dir, step);
    }

    void SetActiveMarker(int pos) {
        if (this.NumPoints <= 0) {
            return;
        }
        this.ActivePoint = pos;
    }

    APoint GetPoint(int p) {
        if (this.MyPoints == null) {
            return null;
        }
        int NPoints = this.MyPoints.size();
        if (NPoints <= 0) {
            return null;
        }
        if (p < 0) {
            p = this.ActivePoint;
        }
        if (p >= NPoints) {
            p %= NPoints;
        }
        if (p < 0) {
            p = 0;
        }
        return this.MyPoints.elementAt(p);
    }

    int NumMarkers() {
        return this.MyPoints.size();
    }

    int ActiveMarkerPos() {
        return this.ActivePoint;
    }

    double[][] ExportMarkers() {
        int listlength = this.NumMarkers();
        double[][] markers = new double[listlength][20];
        for (int i = 0; i < listlength; ++i) {
            APoint point = this.GetPoint(i);
            markers[i][0] = point.coord[0];
            markers[i][1] = point.coord[1];
            markers[i][2] = point.coord[2];
            markers[i][3] = point.coord[3];
            markers[i][4] = point.coord[4];
            markers[i][5] = point.integral;
            markers[i][6] = point.max;
            markers[i][7] = point.coord[0];
            markers[i][8] = point.coord[1];
            markers[i][9] = point.coord[2];
            markers[i][10] = point.coord[3];
            markers[i][11] = point.coord[4];
            markers[i][12] = point.integral;
            markers[i][13] = point.max;
            markers[i][14] = point.tagged ? 1.0 : 0.0;
            markers[i][15] = -1.0;
            markers[i][16] = -1.0;
            markers[i][17] = -1.0;
            markers[i][18] = -1.0;
            markers[i][19] = point.mycolor;
        }
        return markers;
    }
}

