/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractTranslator;
import io.scif.AbstractWriter;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.MetaTable;
import io.scif.MetadataLevel;
import io.scif.Plane;
import io.scif.Translator;
import io.scif.codec.CompressionType;
import io.scif.common.DateTools;
import io.scif.config.SCIFIOConfig;
import io.scif.formats.MinimalTIFFFormat;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.IFDList;
import io.scif.formats.tiff.PhotoInterp;
import io.scif.formats.tiff.TiffCompression;
import io.scif.formats.tiff.TiffParser;
import io.scif.formats.tiff.TiffRational;
import io.scif.formats.tiff.TiffSaver;
import io.scif.gui.AWTImageTools;
import io.scif.util.FormatTools;
import io.scif.xml.XMLService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Interval;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.StringUtils;

@Plugin(type=Format.class, name="Tagged Image File Format", priority=-9999.0)
public class TIFFFormat
extends AbstractFormat {
    public static final double PRIORITY = -9999.0;
    public static final String[] COMPANION_SUFFIXES = new String[]{"xml", "txt"};
    public static final String[] TIFF_SUFFIXES = new String[]{"tif", "tiff", "tf2", "tf8", "btf"};

    @Override
    protected String[] makeSuffixArray() {
        return TIFF_SUFFIXES;
    }

    @Plugin(type=Translator.class, priority=-9999.0)
    public static class TIFFTranslator
    extends AbstractTranslator<io.scif.Metadata, Metadata> {
        @Override
        public Class<? extends io.scif.Metadata> source() {
            return io.scif.Metadata.class;
        }

        @Override
        public Class<? extends io.scif.Metadata> dest() {
            return Metadata.class;
        }

        @Override
        public void translateImageMetadata(List<ImageMetadata> source, Metadata dest) {
            IFDList ifds = new IFDList();
            dest.setIfds(ifds);
            ImageMetadata m = source.get(0);
            long planeCount = m.getPlaneCount();
            if (m.getAxisIndex(Axes.CHANNEL) >= m.getPlanarAxisCount()) {
                planeCount /= m.getAxisLength(Axes.CHANNEL);
            }
            int i = 0;
            while ((long)i < planeCount) {
                ifds.add(new IFD(this.log()));
                ++i;
            }
            IFD firstIFD = (IFD)ifds.get(0);
            int sampleFormat = FormatTools.isFloatingPoint(m.getPixelType()) ? 3 : (FormatTools.isSigned(m.getPixelType()) ? 2 : 1);
            firstIFD.putIFDValue(258, new int[]{m.getBitsPerPixel()});
            firstIFD.putIFDValue(339, sampleFormat);
            firstIFD.putIFDValue(0, m.isLittleEndian());
            firstIFD.putIFDValue(256, m.getAxisLength(Axes.X));
            firstIFD.putIFDValue(257, m.getAxisLength(Axes.Y));
            firstIFD.putIFDValue(277, m.getAxisLength(Axes.CHANNEL));
            firstIFD.putIFDValue(262, PhotoInterp.BLACK_IS_ZERO);
            if (m.isMultichannel()) {
                firstIFD.putIFDValue(262, PhotoInterp.RGB);
            }
            if (m.isIndexed() && HasColorTable.class.isAssignableFrom(source.getClass())) {
                firstIFD.putIFDValue(262, PhotoInterp.RGB_PALETTE);
                ColorTable table = ((HasColorTable)((Object)source)).getColorTable(0, 0L);
                int[] flattenedTable = new int[table.getComponentCount() * table.getLength()];
                for (int i2 = 0; i2 < table.getComponentCount(); ++i2) {
                    for (int j = 0; j < table.getLength(); ++j) {
                        flattenedTable[i2 * table.getLength() + j] = table.get(i2, j);
                    }
                }
                firstIFD.putIFDValue(320, flattenedTable);
            }
        }
    }

    public static class Writer<M extends Metadata>
    extends AbstractWriter<M> {
        @Parameter
        DataHandleService dataHandleService;
        public static final String COMPRESSION_UNCOMPRESSED = CompressionType.UNCOMPRESSED.getCompression();
        public static final String COMPRESSION_LZW = CompressionType.LZW.getCompression();
        public static final String COMPRESSION_ZLIB = CompressionType.ZLIB.getCompression();
        public static final String COMPRESSION_J2K = CompressionType.J2K.getCompression();
        public static final String COMPRESSION_J2K_LOSSY = CompressionType.J2K_LOSSY.getCompression();
        public static final String COMPRESSION_JPEG = CompressionType.JPEG.getCompression();
        public static final String BIG_TIFF_KEY = "WRITE_BIG_TIFF";
        private Boolean isBigTIFF = null;
        private TiffSaver tiffSaver;
        private DataHandle<Location> in;
        private final boolean checkParams = true;

        @Override
        protected String[] makeCompressionTypes() {
            return new String[]{COMPRESSION_UNCOMPRESSED, COMPRESSION_LZW, COMPRESSION_ZLIB, COMPRESSION_J2K, COMPRESSION_J2K_LOSSY, COMPRESSION_JPEG};
        }

        public void setBigTiff(boolean bigTiff) {
            this.isBigTIFF = bigTiff;
        }

        public boolean isBigTiff() {
            return this.isBigTIFF == null ? false : this.isBigTIFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void savePlane(int imageIndex, long planeIndex, Plane plane, IFD ifd, Interval bounds) throws IOException, FormatException {
            byte[] buf = plane.getBytes();
            this.checkParams(imageIndex, planeIndex, buf, bounds);
            int xAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = ((Metadata)this.getMetadata()).get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xAxis);
            int y = (int)bounds.min(yAxis);
            int w = (int)bounds.dimension(xAxis);
            int h = (int)bounds.dimension(yAxis);
            if (ifd == null) {
                ifd = new IFD(this.log());
            }
            int type = ((Metadata)this.getMetadata()).get(imageIndex).getPixelType();
            long index = planeIndex;
            Writer writer = this;
            synchronized (writer) {
                TiffSaver tiffSaver = this.tiffSaver;
                synchronized (tiffSaver) {
                    this.prepareToWritePlane(imageIndex, planeIndex, plane, ifd, x, y, w, h);
                }
            }
            this.tiffSaver.writeImage(buf, ifd, index, type, x, y, w, h, planeIndex == ((Metadata)this.getMetadata()).get(imageIndex).getPlaneCount() - 1L && imageIndex == ((Metadata)this.getMetadata()).getImageCount() - 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void initialize(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
            Writer writer = this;
            synchronized (writer) {
                if (!(this.isInitialized(imageIndex, (int)planeIndex) || this.getHandle().length() != 0L && this.getHandle().exists())) {
                    this.getHandle().ensureWritable(0L);
                    this.tiffSaver.writeHeader();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDest(DataHandle<Location> dest, int imageIndex, SCIFIOConfig config) throws FormatException, IOException {
            super.setDest(dest, imageIndex, config);
            this.isBigTIFF = null;
            if (config.containsKey(BIG_TIFF_KEY)) {
                Object o = config.get(BIG_TIFF_KEY);
                if (o instanceof Boolean) {
                    this.isBigTIFF = (Boolean)o;
                } else {
                    String v = String.valueOf(o).toLowerCase();
                    if (v.startsWith("t")) {
                        this.isBigTIFF = true;
                    } else if (v.startsWith("f")) {
                        this.isBigTIFF = false;
                    }
                }
            }
            if (this.isBigTIFF == null && ((Metadata)this.getMetadata()).getDatasetSize() > 0x80000000L) {
                this.isBigTIFF = true;
            }
            Writer writer = this;
            synchronized (writer) {
                this.setupTiffSaver(dest, imageIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writePlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
            IFD ifd = new IFD(this.log());
            if (!this.writeSequential()) {
                TiffParser parser = new TiffParser(this.getContext(), (Location)this.getHandle().get());
                try {
                    long[] ifdOffsets = parser.getIFDOffsets();
                    if (planeIndex < (long)ifdOffsets.length) {
                        ifd = parser.getIFD(ifdOffsets[(int)planeIndex]);
                    }
                }
                finally {
                    DataHandle<Location> tiffHandle = parser.getStream();
                    if (tiffHandle != null) {
                        tiffHandle.close();
                    }
                }
            }
            if (planeIndex == 0L) {
                this.addDimensionalAxisInfo(ifd, imageIndex);
            }
            this.savePlane(imageIndex, planeIndex, plane, ifd, bounds);
        }

        @Override
        public boolean canDoStacks() {
            return true;
        }

        @Override
        public int[] getPixelTypes(String codec) {
            if (codec != null && codec.equals(COMPRESSION_JPEG)) {
                return new int[]{0, 1, 2, 3};
            }
            if (codec != null && codec.equals(COMPRESSION_J2K)) {
                return new int[]{0, 1, 2, 3, 4, 5, 6};
            }
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.in != null) {
                this.in.close();
            }
        }

        private void formatCompression(IFD ifd) {
            Object v;
            TiffCompression compressType = TiffCompression.UNCOMPRESSED;
            if (this.getCompression() != null) {
                if (this.getCompression().equals(COMPRESSION_LZW)) {
                    compressType = TiffCompression.LZW;
                } else if (this.getCompression().equals(COMPRESSION_ZLIB)) {
                    compressType = TiffCompression.DEFLATE;
                } else if (this.getCompression().equals(COMPRESSION_J2K)) {
                    compressType = TiffCompression.JPEG_2000;
                } else if (this.getCompression().equals(COMPRESSION_J2K_LOSSY)) {
                    compressType = TiffCompression.JPEG_2000_LOSSY;
                } else if (this.getCompression().equals(COMPRESSION_JPEG)) {
                    compressType = TiffCompression.JPEG;
                }
            }
            if ((v = ifd.get(259)) == null) {
                ifd.put(259, compressType.getCode());
            }
        }

        private long prepareToWritePlane(int imageIndex, long planeIndex, Plane plane, IFD ifd, int x, int y, int w, int h) throws IOException, FormatException {
            int bytesPerPixel;
            byte[] buf = plane.getBytes();
            Metadata meta = (Metadata)this.getMetadata();
            Boolean bigEndian = !meta.get(imageIndex).isLittleEndian();
            boolean littleEndian = bigEndian == false;
            boolean interleaved = meta.get(imageIndex).getInterleavedAxisCount() > 0;
            int type = meta.get(imageIndex).getPixelType();
            int c = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            int blockSize = w * h * c * (bytesPerPixel = FormatTools.getBytesPerPixel(type));
            if (blockSize > buf.length) {
                c = buf.length / (w * h * bytesPerPixel);
            }
            this.formatCompression(ifd);
            byte[][] lut = AWTImageTools.get8BitLookupTable(this.getColorModel());
            if (lut != null) {
                int[] colorMap = new int[lut.length * lut[0].length];
                for (int i = 0; i < lut.length; ++i) {
                    for (int j = 0; j < lut[0].length; ++j) {
                        colorMap[i * lut[0].length + j] = (lut[i][j] & 0xFF) << 8;
                    }
                }
                ifd.putIFDValue(320, colorMap);
            }
            int width = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int height = (int)meta.get(imageIndex).getAxisLength(Axes.Y);
            ifd.put(new Integer(256), new Long(width));
            ifd.put(new Integer(257), new Long(height));
            double avgScaleX = meta.get(0).getAxis(Axes.X).averageScale(0.0, 1.0);
            double physicalSizeX = avgScaleX == 0.0 ? 0.0 : 1.0 / avgScaleX;
            double avgScaleY = meta.get(0).getAxis(Axes.Y).averageScale(0.0, 1.0);
            double physicalSizeY = avgScaleY == 0.0 ? 0.0 : 1.0 / avgScaleY;
            ifd.put(296, 3);
            ifd.put(282, new TiffRational((long)(physicalSizeX * 1000.0 * 10000.0), 1000L));
            ifd.put(283, new TiffRational((long)(physicalSizeY * 1000.0 * 10000.0), 1000L));
            DataHandle<Location> handle = this.getHandle();
            if (!this.isBigTiff()) {
                this.isBigTIFF = handle.length() + (long)(2 * (width * height * c * bytesPerPixel)) >= 0x100000000L;
                if (this.isBigTiff()) {
                    throw new FormatException("File is too large for 32-bit TIFF but BigTIFF support was disabled. Please enable by using setBigTiff(true) or passing a SCIFIOConfig object with the appropriate BIG_TIFF_KEY,true pair.");
                }
            }
            ifd.put(0, littleEndian);
            if (!ifd.containsKey(3)) {
                ifd.put(3, handle.length());
                if (handle.length() != -1L) {
                    handle.seek(handle.length());
                }
            } else {
                handle.seek(((Long)ifd.get(3)).longValue());
            }
            ifd.putIFDValue(284, interleaved || meta.get(imageIndex).getAxisLength(Axes.CHANNEL) == 1L ? 1 : 2);
            int sampleFormat = 1;
            if (FormatTools.isSigned(type)) {
                sampleFormat = 2;
            }
            if (FormatTools.isFloatingPoint(type)) {
                sampleFormat = 3;
            }
            ifd.putIFDValue(339, sampleFormat);
            long index = planeIndex;
            int realSeries = imageIndex;
            for (int i = 0; i < realSeries; ++i) {
                index += meta.get(i).getPlaneCount();
            }
            return index;
        }

        private void setupTiffSaver(DataHandle<Location> handle, int imageIndex) {
            Metadata meta = (Metadata)this.getMetadata();
            this.tiffSaver = new TiffSaver(this.getContext(), handle);
            boolean littleEndian = meta.get(imageIndex).isLittleEndian();
            this.tiffSaver.setWritingSequentially(this.writeSequential());
            this.tiffSaver.setLittleEndian(littleEndian);
            this.tiffSaver.setBigTiff(this.isBigTiff());
            this.tiffSaver.setCodecOptions(this.getCodecOptions());
        }

        private void addDimensionalAxisInfo(IFD ifd, int imageIndex) {
            ImageMetadata imageMeta = ((Metadata)this.getMetadata()).get(imageIndex);
            CalibratedAxis cAxis = imageMeta.getAxis(Axes.CHANNEL);
            CalibratedAxis zAxis = imageMeta.getAxis(Axes.Z);
            CalibratedAxis tAxis = imageMeta.getAxis(Axes.TIME);
            List<CalibratedAxis> axes = imageMeta.getAxes();
            String types = this.list(axes, a -> a.type().toString());
            String lengths = this.list(axes, a -> "" + imageMeta.getAxisLength((CalibratedAxis)a));
            String scales = this.list(axes, a -> "" + a.averageScale(0.0, 1.0));
            String units = this.list(axes, a -> this.replaceMu(a.unit()));
            String comment = "SCIFIO=" + this.getVersion() + "\naxes=" + types + "\nlengths=" + lengths + "\nscales=" + scales + "\nunits=" + units + "\nbitsPerPixel=" + imageMeta.getBitsPerPixel() + "\nimages=" + imageMeta.getPlaneCount() + "\nchannels=" + imageMeta.getAxisLength(cAxis) + "\nslices=" + imageMeta.getAxisLength(zAxis) + "\nframes=" + imageMeta.getAxisLength(tAxis) + "\nhyperstack=true\nmode=composite\nunit=" + this.replaceMu(axes.get(0).unit()) + "\n";
            ifd.putIFDValue(270, comment);
        }

        private <T> String list(List<T> l, Function<T, String> f) {
            return String.join((CharSequence)",", l.stream().map(f).collect(Collectors.toList()));
        }

        private String replaceMu(String unit) {
            return unit != null ? unit.replace("\u00b5", "\\u00B5") : null;
        }
    }

    public static class Reader<M extends Metadata>
    extends MinimalTIFFFormat.Reader<M> {
    }

    public static abstract class BaseTIFFParser
    extends MinimalTIFFFormat.Parser<Metadata> {
        public static final String[] DATE_FORMATS = new String[]{"yyyy:MM:dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss.SS", "MM/dd/yyyy hh:mm:ss.SSS aa", "yyyyMMdd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss"};

        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            super.typedParse(stream, meta, config);
            this.initMetadata(meta, config);
        }

        protected void initMetadata(Metadata meta, SCIFIOConfig config) throws FormatException, IOException {
            IFDList exifIFDs;
            if (config.parserGetLevel() == MetadataLevel.MINIMUM) {
                return;
            }
            IFDList ifds = meta.getIfds();
            MetaTable table = meta.getTable();
            for (int i = 0; i < ifds.size(); ++i) {
                this.put(table, "PageName #" + i, (IFD)ifds.get(i), 285);
            }
            IFD firstIFD = (IFD)ifds.get(0);
            this.put(table, "ImageWidth", firstIFD, 256);
            this.put(table, "ImageLength", firstIFD, 257);
            this.put(table, "BitsPerSample", firstIFD, 258);
            if (((IFD)ifds.get(0)).containsKey(34665) && (exifIFDs = meta.getTiffParser().getExifIFDs()).size() > 0) {
                IFD exif = (IFD)exifIFDs.get(0);
                for (Integer key : exif.keySet()) {
                    int k = key;
                    table.put(BaseTIFFParser.getExifTagName(k), exif.get(key));
                }
            }
            TiffCompression comp = firstIFD.getCompression();
            table.put("Compression", comp.getCodecName());
            PhotoInterp photo = firstIFD.getPhotometricInterpretation();
            String photoInterp = photo.getName();
            String metaDataPhotoInterp = photo.getMetadataType();
            table.put("PhotometricInterpretation", photoInterp);
            table.put("MetaDataPhotometricInterpretation", metaDataPhotoInterp);
            this.putInt(table, "CellWidth", firstIFD, 264);
            this.putInt(table, "CellLength", firstIFD, 265);
            int or = firstIFD.getIFDIntValue(274);
            if (or == 8) {
                this.put(table, "ImageWidth", firstIFD, 257);
                this.put(table, "ImageLength", firstIFD, 256);
            }
            String orientation = null;
            switch (or) {
                case 1: {
                    orientation = "1st row -> top; 1st column -> left";
                    break;
                }
                case 2: {
                    orientation = "1st row -> top; 1st column -> right";
                    break;
                }
                case 3: {
                    orientation = "1st row -> bottom; 1st column -> right";
                    break;
                }
                case 4: {
                    orientation = "1st row -> bottom; 1st column -> left";
                    break;
                }
                case 5: {
                    orientation = "1st row -> left; 1st column -> top";
                    break;
                }
                case 6: {
                    orientation = "1st row -> right; 1st column -> top";
                    break;
                }
                case 7: {
                    orientation = "1st row -> right; 1st column -> bottom";
                    break;
                }
                case 8: {
                    orientation = "1st row -> left; 1st column -> bottom";
                }
            }
            table.put("Orientation", orientation);
            this.putInt(table, "SamplesPerPixel", firstIFD, 277);
            this.put(table, "Software", firstIFD, 305);
            this.put(table, "Instrument Make", firstIFD, 271);
            this.put(table, "Instrument Model", firstIFD, 272);
            this.put(table, "Document Name", firstIFD, 269);
            this.put(table, "DateTime", firstIFD, 306);
            this.put(table, "Artist", firstIFD, 315);
            this.put(table, "HostComputer", firstIFD, 316);
            this.put(table, "Copyright", firstIFD, 33432);
            this.put(table, "NewSubfileType", firstIFD, 254);
            int thresh = firstIFD.getIFDIntValue(263);
            String threshholding = null;
            switch (thresh) {
                case 1: {
                    threshholding = "No dithering or halftoning";
                    break;
                }
                case 2: {
                    threshholding = "Ordered dithering or halftoning";
                    break;
                }
                case 3: {
                    threshholding = "Randomized error diffusion";
                }
            }
            table.put("Threshholding", threshholding);
            int fill = firstIFD.getIFDIntValue(266);
            String fillOrder = null;
            switch (fill) {
                case 1: {
                    fillOrder = "Pixels with lower column values are stored in the higher order bits of a byte";
                    break;
                }
                case 2: {
                    fillOrder = "Pixels with lower column values are stored in the lower order bits of a byte";
                }
            }
            table.put("FillOrder", fillOrder);
            this.putInt(table, "Make", firstIFD, 271);
            this.putInt(table, "Model", firstIFD, 272);
            this.putInt(table, "MinSampleValue", firstIFD, 280);
            this.putInt(table, "MaxSampleValue", firstIFD, 281);
            this.putInt(table, "XResolution", firstIFD, 282);
            this.putInt(table, "YResolution", firstIFD, 283);
            int planar = firstIFD.getIFDIntValue(284);
            String planarConfig = null;
            switch (planar) {
                case 1: {
                    planarConfig = "Chunky";
                    break;
                }
                case 2: {
                    planarConfig = "Planar";
                }
            }
            table.put("PlanarConfiguration", planarConfig);
            this.putInt(table, "XPosition", firstIFD, 286);
            this.putInt(table, "YPosition", firstIFD, 287);
            this.putInt(table, "FreeOffsets", firstIFD, 288);
            this.putInt(table, "FreeByteCounts", firstIFD, 289);
            this.putInt(table, "GrayResponseUnit", firstIFD, 290);
            this.putInt(table, "GrayResponseCurve", firstIFD, 291);
            this.putInt(table, "T4Options", firstIFD, 292);
            this.putInt(table, "T6Options", firstIFD, 293);
            int res = firstIFD.getIFDIntValue(296);
            String resUnit = null;
            switch (res) {
                case 1: {
                    resUnit = "None";
                    break;
                }
                case 2: {
                    resUnit = "Inch";
                    break;
                }
                case 3: {
                    resUnit = "Centimeter";
                }
            }
            table.put("ResolutionUnit", resUnit);
            this.putInt(table, "PageNumber", firstIFD, 297);
            this.putInt(table, "TransferFunction", firstIFD, 301);
            int predict = firstIFD.getIFDIntValue(317);
            String predictor = null;
            switch (predict) {
                case 1: {
                    predictor = "No prediction scheme";
                    break;
                }
                case 2: {
                    predictor = "Horizontal differencing";
                }
            }
            table.put("Predictor", predictor);
            this.putInt(table, "WhitePoint", firstIFD, 318);
            this.putInt(table, "PrimaryChromacities", firstIFD, 319);
            this.putInt(table, "HalftoneHints", firstIFD, 321);
            this.putInt(table, "TileWidth", firstIFD, 322);
            this.putInt(table, "TileLength", firstIFD, 323);
            this.putInt(table, "TileOffsets", firstIFD, 324);
            this.putInt(table, "TileByteCounts", firstIFD, 325);
            int ink = firstIFD.getIFDIntValue(332);
            String inkSet = null;
            switch (ink) {
                case 1: {
                    inkSet = "CMYK";
                    break;
                }
                case 2: {
                    inkSet = "Other";
                }
            }
            table.put("InkSet", inkSet);
            this.putInt(table, "InkNames", firstIFD, 333);
            this.putInt(table, "NumberOfInks", firstIFD, 334);
            this.putInt(table, "DotRange", firstIFD, 336);
            this.put(table, "TargetPrinter", firstIFD, 337);
            this.putInt(table, "ExtraSamples", firstIFD, 338);
            int fmt = firstIFD.getIFDIntValue(339);
            String sampleFormat = null;
            switch (fmt) {
                case 1: {
                    sampleFormat = "unsigned integer";
                    break;
                }
                case 2: {
                    sampleFormat = "two's complement signed integer";
                    break;
                }
                case 3: {
                    sampleFormat = "IEEE floating point";
                    break;
                }
                case 4: {
                    sampleFormat = "undefined";
                }
            }
            table.put("SampleFormat", sampleFormat);
            this.putInt(table, "SMinSampleValue", firstIFD, 340);
            this.putInt(table, "SMaxSampleValue", firstIFD, 341);
            this.putInt(table, "TransferRange", firstIFD, 342);
            int jpeg = firstIFD.getIFDIntValue(512);
            String jpegProc = null;
            switch (jpeg) {
                case 1: {
                    jpegProc = "baseline sequential process";
                    break;
                }
                case 14: {
                    jpegProc = "lossless process with Huffman coding";
                }
            }
            table.put("JPEGProc", jpegProc);
            this.putInt(table, "JPEGInterchangeFormat", firstIFD, 513);
            this.putInt(table, "JPEGRestartInterval", firstIFD, 515);
            this.putInt(table, "JPEGLosslessPredictors", firstIFD, 517);
            this.putInt(table, "JPEGPointTransforms", firstIFD, 518);
            this.putInt(table, "JPEGQTables", firstIFD, 519);
            this.putInt(table, "JPEGDCTables", firstIFD, 520);
            this.putInt(table, "JPEGACTables", firstIFD, 521);
            this.putInt(table, "YCbCrCoefficients", firstIFD, 529);
            int ycbcr = firstIFD.getIFDIntValue(530);
            String subSampling = null;
            switch (ycbcr) {
                case 1: {
                    subSampling = "chroma image dimensions = luma image dimensions";
                    break;
                }
                case 2: {
                    subSampling = "chroma image dimensions are half the luma image dimensions";
                    break;
                }
                case 4: {
                    subSampling = "chroma image dimensions are 1/4 the luma image dimensions";
                }
            }
            table.put("YCbCrSubSampling", subSampling);
            this.putInt(table, "YCbCrPositioning", firstIFD, 531);
            this.putInt(table, "ReferenceBlackWhite", firstIFD, 532);
            int[] q = firstIFD.getBitsPerSample();
            int bps = q[0];
            int numC = q.length;
            if (photo == PhotoInterp.RGB_PALETTE || photo == PhotoInterp.CFA_ARRAY) {
                numC = 3;
            }
            table.put("BitsPerSample", bps);
            table.put("NumberOfChannels", numC);
            String creationDate = this.getImageCreationDate(meta);
            String date = DateTools.formatDate(creationDate, DATE_FORMATS);
            if (creationDate != null && date == null) {
                this.log().warn((Object)("unknown creation date format: " + creationDate));
            }
            meta.setCreationDate(date);
            String artist = firstIFD.getIFDTextValue(315);
            if (artist != null) {
                String firstName = null;
                String lastName = null;
                int ndx = artist.indexOf(" ");
                if (ndx < 0) {
                    lastName = artist;
                } else {
                    firstName = artist.substring(0, ndx);
                    lastName = artist.substring(ndx + 1);
                }
                String email = firstIFD.getIFDStringValue(316);
                meta.setExperimenterFirstName(firstName);
                meta.setExperimenterLastName(lastName);
                meta.setExperimenterEmail(email);
            }
            meta.setImageDescription(firstIFD.getComment());
        }

        protected String getImageCreationDate(Metadata meta) {
            Object o = ((IFD)meta.getIfds().get(0)).getIFDValue(306);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof String[]) {
                return ((String[])o)[0];
            }
            return null;
        }

        protected void put(MetaTable table, String key, IFD ifd, int tag) {
            table.put(key, ifd.getIFDValue(tag));
        }

        protected void putInt(MetaTable table, String key, IFD ifd, int tag) {
            table.put(key, ifd.getIFDIntValue(tag));
        }

        public static String getExifTagName(int tag) {
            return IFD.getIFDTagName(tag);
        }
    }

    public static class Parser
    extends BaseTIFFParser {
        public static final int IMAGEJ_TAG = 50839;
        public static final int META_DATA_BYTE_COUNTS = 50838;
        public static final int MAGIC_NUMBER = 0x494A494A;
        public static final int LUTS = 1819636851;
        public static final int LABEL = 1818321516;
        @Parameter
        private XMLService xmlService;

        @Override
        public Location[] getImageUsedFiles(int ImageIndex, boolean noPixels) {
            if (noPixels) {
                Location[] locationArray;
                if (((Metadata)this.getMetadata()).getCompanionFile() == null) {
                    locationArray = null;
                } else {
                    Location[] locationArray2 = new Location[1];
                    locationArray = locationArray2;
                    locationArray2[0] = ((Metadata)this.getMetadata()).getCompanionFile();
                }
                return locationArray;
            }
            if (((Metadata)this.getMetadata()).getCompanionFile() != null) {
                return new Location[]{((Metadata)this.getMetadata()).getCompanionFile(), (Location)this.getSource().get()};
            }
            return new Location[]{(Location)this.getSource().get()};
        }

        @Override
        protected void initMetadata(Metadata meta, SCIFIOConfig config) throws FormatException, IOException {
            boolean metamorph;
            boolean ij;
            boolean scifio;
            IFDList ifds = meta.getIfds();
            String comment = ((IFD)ifds.get(0)).getComment();
            MetaTable table = meta.getTable();
            this.log().debug((Object)"Checking comment style");
            MetadataLevel level = config.parserGetLevel();
            if (level != MetadataLevel.MINIMUM) {
                Integer[] tags;
                for (Integer tag : tags = ((IFD)ifds.get(0)).keySet().toArray(new Integer[0])) {
                    Object value;
                    if (tag < 65000 || !((value = ((IFD)ifds.get(0)).get(tag)) instanceof short[])) continue;
                    short[] s = (short[])value;
                    byte[] b = new byte[s.length];
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = (byte)s[i];
                    }
                    String metadata = StringUtils.stripNulls((String)new String(b, "UTF-8"));
                    if (metadata.contains("xml")) {
                        metadata = metadata.substring(metadata.indexOf("<"));
                        metadata = "<root>" + this.xmlService.sanitizeXML(metadata) + "</root>";
                        try {
                            Map<String, String> xmlMetadata = this.xmlService.parseXML(metadata);
                            for (String key : xmlMetadata.keySet()) {
                                table.put(key, xmlMetadata.get(key));
                            }
                            continue;
                        }
                        catch (IOException xmlMetadata) {
                            continue;
                        }
                    }
                    table.put(tag.toString(), metadata);
                }
            }
            if (scifio = this.checkCommentSCIFIO(comment)) {
                this.parseCommentSCIFIO(meta, comment);
            }
            if (ij = this.checkCommentImageJ(comment)) {
                this.parseCommentImageJ(meta, comment);
            }
            if ((metamorph = this.checkCommentMetamorph(meta, comment)) && level != MetadataLevel.MINIMUM) {
                this.parseCommentMetamorph(meta, comment);
            }
            table.put("MetaMorph", metamorph ? "yes" : "no");
            if (!ij && !metamorph && level != MetadataLevel.MINIMUM) {
                this.parseCommentGeneric(meta, comment);
            }
            if (!(scifio || ij || metamorph)) {
                meta.populateImageMetadata();
                AxisType type = Axes.unknown();
                DefaultLinearAxis axis = new DefaultLinearAxis(type);
                int axisIndex = meta.get(0).getAxisIndex(type);
                if (axisIndex < 0) {
                    meta.get(0).addAxis((CalibratedAxis)axis);
                }
                meta.get(0).setAxisLength((CalibratedAxis)axis, (long)meta.getIfds().size());
            }
            if (config.groupableIsGroupFiles()) {
                BrowsableLocation currentFile = this.asBrowsableLocation(this.getSource());
                String currentName = currentFile.getName();
                BrowsableLocation directory = currentFile.parent();
                Set files = directory.children();
                if (!files.isEmpty()) {
                    for (Location file : files) {
                        String name = file.getName();
                        if (name.contains(".")) {
                            name = name.substring(0, name.indexOf(46));
                        }
                        if (!currentName.startsWith(name) || !FormatTools.checkSuffix(file.getName(), COMPANION_SUFFIXES)) continue;
                        meta.setCompanionFile(file);
                        break;
                    }
                }
            }
            super.initMetadata(meta, config);
        }

        private boolean checkCommentSCIFIO(String comment) {
            return comment != null && comment.startsWith("SCIFIO=");
        }

        private boolean checkCommentImageJ(String comment) {
            return comment != null && comment.startsWith("ImageJ=");
        }

        private boolean checkCommentMetamorph(Metadata meta, String comment) {
            String software = ((IFD)meta.getIfds().get(0)).getIFDTextValue(305);
            return comment != null && software != null && software.contains("MetaMorph");
        }

        private void parseCommentSCIFIO(Metadata meta, String comment) {
            MetaTable table = meta.getTable();
            table.remove("Comment");
            meta.setDescription("");
            meta.populateImageMetadata();
            meta.populateImageMetadata = false;
            String[] axes = null;
            String[] lengths = null;
            String[] scales = null;
            String[] units = null;
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int eq = token.indexOf("=");
                if (eq < 0) continue;
                String value = token.substring(eq + 1);
                if (token.startsWith("axes=")) {
                    axes = value.split(",");
                    continue;
                }
                if (token.startsWith("lengths=")) {
                    lengths = value.split(",");
                    continue;
                }
                if (token.startsWith("scales=")) {
                    scales = value.split(",");
                    continue;
                }
                if (!token.startsWith("units=")) continue;
                units = value.split(",");
            }
            if (axes == null || lengths == null || scales == null || units == null) {
                return;
            }
            for (int i = 0; i < axes.length; ++i) {
                AxisType type = Axes.get((String)axes[i]);
                String unit = units[i] != null ? units[i].replace("\\u00B5", "\u00b5") : null;
                double scale = Double.parseDouble((String)scales[i]);
                DefaultLinearAxis axis = new DefaultLinearAxis(type, unit, scale);
                int axisIndex = meta.get(0).getAxisIndex(type);
                if (axisIndex < 0) {
                    meta.get(0).addAxis((CalibratedAxis)axis);
                } else {
                    meta.get(0).setAxis(axisIndex, (CalibratedAxis)axis);
                }
                long length = Long.parseLong(lengths[i]);
                meta.get(0).setAxisLength((CalibratedAxis)axis, length);
            }
        }

        private void parseCommentImageJ(Metadata meta, String comment) throws FormatException, IOException {
            meta.populateImageMetadata();
            meta.populateImageMetadata = false;
            MetaTable table = meta.getTable();
            int nl = comment.indexOf("\n");
            table.put("ImageJ", nl < 0 ? comment.substring(7) : comment.substring(7, nl));
            table.remove("Comment");
            meta.setDescription("");
            int z = 1;
            int t = 1;
            int c = (int)meta.get(0).getAxisLength(Axes.CHANNEL);
            IFDList ifds = meta.getIfds();
            if (((IFD)ifds.get(0)).containsKey(50839)) {
                comment = comment + "\n" + ((IFD)ifds.get(0)).getIFDTextValue(50839);
                this.populateIJNonTextAttributes(meta, ifds);
            }
            String unit = null;
            double spacing = 1.0;
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String value = null;
                int eq = token.indexOf("=");
                if (eq >= 0) {
                    value = token.substring(eq + 1);
                }
                if (token.startsWith("channels=")) {
                    c = this.parseInt(value);
                    continue;
                }
                if (token.startsWith("slices=")) {
                    z = this.parseInt(value);
                    continue;
                }
                if (token.startsWith("frames=")) {
                    t = this.parseInt(value);
                    continue;
                }
                if (token.startsWith("mode=")) {
                    table.put("Color mode", value);
                    continue;
                }
                if (token.startsWith("unit=")) {
                    unit = value;
                    meta.setCalibrationUnit(unit);
                    for (ImageMetadata iMeta : meta.getAll()) {
                        for (CalibratedAxis axis : iMeta.getAxes()) {
                            axis.setUnit(unit);
                        }
                    }
                    table.put("Unit", meta.getCalibrationUnit());
                    continue;
                }
                if (token.startsWith("finterval=")) {
                    meta.setTimeIncrement(this.parseDouble(value));
                    table.put("Frame Interval", meta.getTimeIncrement());
                    continue;
                }
                if (token.startsWith("spacing=")) {
                    spacing = this.parseDouble(value);
                    table.put("Spacing", spacing);
                    continue;
                }
                if (token.startsWith("xorigin=")) {
                    meta.setxOrigin(this.parseInt(value));
                    table.put("X Origin", meta.getxOrigin());
                    continue;
                }
                if (token.startsWith("yorigin=")) {
                    meta.setyOrigin(this.parseInt(value));
                    table.put("Y Origin", meta.getyOrigin());
                    continue;
                }
                if (eq <= 0) continue;
                table.put(token.substring(0, eq).trim(), value);
            }
            if (z * c * t == c && meta.get(0).isMultichannel()) {
                t = (int)meta.get(0).getPlaneCount();
            }
            ImageMetadata m = meta.get(0);
            HashSet<CalibratedAxis> predefinedAxes = new HashSet<CalibratedAxis>(m.getAxes());
            m.setAxisTypes(Axes.X, Axes.Y, Axes.CHANNEL, Axes.Z, Axes.TIME);
            if (z * t * (m.isMultichannel() ? 1 : c) == ifds.size()) {
                m.setAxisLength(Axes.Z, (long)z);
                m.setAxisLength(Axes.TIME, (long)t);
                if (!m.isMultichannel()) {
                    m.setAxisLength(Axes.CHANNEL, (long)c);
                }
            } else if (z * c * t == ifds.size() && m.isMultichannel()) {
                m.setAxisLength(Axes.Z, (long)z);
                m.setAxisLength(Axes.TIME, (long)t);
                m.setAxisLength(Axes.CHANNEL, m.getAxisLength(Axes.CHANNEL) * (long)c);
            } else if (ifds.size() == 1 && z * t > ifds.size() && ((IFD)ifds.get(0)).getCompression() == TiffCompression.UNCOMPRESSED) {
                IFD firstIFD = (IFD)ifds.get(0);
                int planeSize = (int)(m.getAxisLength(Axes.X) * m.getAxisLength(Axes.Y) * m.getAxisLength(Axes.CHANNEL) * (long)FormatTools.getBytesPerPixel(m.getPixelType()));
                long[] stripOffsets = firstIFD.getStripOffsets();
                long[] stripByteCounts = firstIFD.getStripByteCounts();
                long endOfFirstPlane = stripOffsets[stripOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
                long totalBytes = this.getSource().length() - endOfFirstPlane;
                int totalPlanes = (int)(totalBytes / (long)planeSize) + 1;
                ifds = new IFDList();
                ifds.add(firstIFD);
                for (int i = 1; i < totalPlanes; ++i) {
                    IFD ifd = new IFD(firstIFD, this.log());
                    ifds.add(ifd);
                    long[] prevOffsets = ((IFD)ifds.get(i - 1)).getStripOffsets();
                    long[] offsets = new long[stripOffsets.length];
                    offsets[0] = prevOffsets[prevOffsets.length - 1] + stripByteCounts[stripByteCounts.length - 1];
                    for (int j = 1; j < offsets.length; ++j) {
                        offsets[j] = offsets[j - 1] + stripByteCounts[j - 1];
                    }
                    ifd.putIFDValue(273, offsets);
                }
                if (z * c * t == ifds.size()) {
                    m.setAxisLength(Axes.Z, (long)z);
                    m.setAxisLength(Axes.TIME, (long)t);
                    m.setAxisLength(Axes.CHANNEL, (long)c);
                } else if (z * t == ifds.size()) {
                    m.setAxisLength(Axes.Z, (long)z);
                    m.setAxisLength(Axes.TIME, (long)t);
                } else {
                    m.setAxisLength(Axes.Z, (long)ifds.size());
                }
            } else {
                m.setAxisLength(Axes.TIME, (long)ifds.size());
            }
            ArrayList<CalibratedAxis> validAxes = new ArrayList<CalibratedAxis>();
            for (CalibratedAxis axis : m.getAxes()) {
                if (!predefinedAxes.contains(axis) && m.getAxisLength(axis) <= 1L) continue;
                validAxes.add(axis);
            }
            m.setAxes(validAxes.toArray(new CalibratedAxis[validAxes.size()]));
            CalibratedAxis zAxis = meta.get(0).getAxis(Axes.Z);
            if (zAxis != null) {
                if (unit != null) {
                    zAxis.setUnit(unit);
                }
                if (spacing >= 0.0) {
                    FormatTools.calibrate(zAxis, spacing, 0.0);
                }
            }
        }

        private String populateIJNonTextAttributes(Metadata meta, IFDList ifds) {
            int[] metaDataCounts = null;
            short[] imagejTags = null;
            boolean littleEndian = false;
            try {
                metaDataCounts = ((IFD)ifds.get(0)).getIFDIntArray(50838);
                imagejTags = ((IFD)ifds.get(0)).getIFDShortArray(50839);
                littleEndian = ((IFD)ifds.get(0)).isLittleEndian();
            }
            catch (FormatException e) {
                return null;
            }
            int hdrSize = metaDataCounts[0];
            if (hdrSize < 12 || hdrSize > 804) {
                return null;
            }
            int[] sPos = new int[1];
            int magicNum = this.getInt(sPos, imagejTags, littleEndian);
            if (magicNum != 0x494A494A) {
                return null;
            }
            int nTypes = (hdrSize - 4) / 8;
            int[] types = new int[nTypes];
            int[] counts = new int[nTypes];
            for (int i = 0; i < nTypes; ++i) {
                types[i] = this.getInt(sPos, imagejTags, littleEndian);
                counts[i] = this.getInt(sPos, imagejTags, littleEndian);
            }
            int start = 1;
            for (int i = 0; i < nTypes; ++i) {
                if (types[i] == 1819636851) {
                    byte[][] luts = this.getLUTs(start, start + counts[i] - 1, metaDataCounts, imagejTags, sPos);
                    meta.setLut(luts);
                } else if (types[i] == 1818321516) {
                    meta.get(0).getTable().put("SliceLabels", this.getSliceLabels(start, start + counts[i] - 1, metaDataCounts, imagejTags, sPos, littleEndian));
                } else {
                    this.skipUnknownType(start, start + counts[i] - 1, metaDataCounts, sPos);
                }
                start += counts[i];
            }
            return null;
        }

        private byte[][] getLUTs(int first, int last, int[] metaDataCounts, short[] imagejTags, int[] sPos) {
            byte[][] channelLuts = new byte[last - first + 1][];
            int index = 0;
            for (int i = first; i <= last; ++i) {
                int len = metaDataCounts[i];
                channelLuts[index] = new byte[len];
                for (int j = 0; j < len; ++j) {
                    int n = sPos[0];
                    sPos[0] = n + 1;
                    channelLuts[index][j] = (byte)imagejTags[n];
                }
                ++index;
            }
            return channelLuts;
        }

        private String[] getSliceLabels(int first, int last, int[] metaDataCounts, short[] imagejTags, int[] position, boolean littleEndian) {
            String[] result = new String[last - first + 1];
            for (int i = first; i <= last; ++i) {
                int len = metaDataCounts[i] / 2;
                char[] buffer = new char[len];
                for (int j = 0; j < len; ++j) {
                    buffer[j] = this.getChar(position, imagejTags, littleEndian);
                }
                result[i - first] = new String(buffer);
            }
            return result;
        }

        private void skipUnknownType(int first, int last, int[] metaDataCounts, int[] position) {
            for (int i = first; i <= last; ++i) {
                int len = metaDataCounts[i];
                position[0] = position[0] + len;
            }
        }

        private char getChar(int[] start, short[] imageJTags, boolean littleEndian) {
            int n = start[0];
            start[0] = n + 1;
            short b1 = imageJTags[n];
            int n2 = start[0];
            start[0] = n2 + 1;
            short b2 = imageJTags[n2];
            if (littleEndian) {
                return (char)(b2 << 8 | b1);
            }
            return (char)(b1 << 8 | b2);
        }

        private int getInt(int[] start, short[] imageJTags, boolean littleEndian) {
            int n = start[0];
            start[0] = n + 1;
            short b1 = imageJTags[n];
            int n2 = start[0];
            start[0] = n2 + 1;
            short b2 = imageJTags[n2];
            int n3 = start[0];
            start[0] = n3 + 1;
            short b3 = imageJTags[n3];
            int n4 = start[0];
            start[0] = n4 + 1;
            short b4 = imageJTags[n4];
            if (littleEndian) {
                return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
            }
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }

        private void parseCommentMetamorph(Metadata meta, String comment) {
            StringTokenizer st = new StringTokenizer(comment, "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int colon = line.indexOf(":");
                if (colon < 0) {
                    meta.getTable().put("Comment", line);
                    meta.setDescription(line);
                    continue;
                }
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1);
                meta.getTable().put(key, value);
            }
        }

        private void parseCommentGeneric(Metadata meta, String comment) {
            if (comment == null) {
                return;
            }
            String[] lines = comment.split("\n");
            if (lines.length > 1) {
                comment = "";
                for (String line : lines) {
                    int eq = line.indexOf("=");
                    if (eq != -1) {
                        String key = line.substring(0, eq).trim();
                        String value = line.substring(eq + 1).trim();
                        meta.getTable().put(key, value);
                        continue;
                    }
                    if (line.startsWith("[")) continue;
                    comment = comment + line + "\n";
                }
                meta.getTable().put("Comment", comment);
                meta.setDescription(comment);
            }
        }

        private int parseInt(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                this.log().debug((Object)"Failed to parse integer value", (Throwable)e);
                return 0;
            }
        }

        private double parseDouble(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                this.log().debug((Object)"Failed to parse floating point value", (Throwable)e);
                return 0.0;
            }
        }
    }

    public static class Metadata
    extends MinimalTIFFFormat.Metadata {
        private boolean populateImageMetadata = true;
        private String creationDate;
        private String experimenterFirstName;
        private String experimenterLastName;
        private String experimenterEmail;
        private String imageDescription;
        private Location companionFile;
        private String description;
        private String calibrationUnit;
        private Double timeIncrement;
        private Integer xOrigin;
        private Integer yOrigin;
        private byte[][] lut;
        private List<ColorTable> colorTable;

        public Location getCompanionFile() {
            return this.companionFile;
        }

        public void setCompanionFile(Location companionFile) {
            this.companionFile = companionFile;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCalibrationUnit() {
            return this.calibrationUnit;
        }

        public void setCalibrationUnit(String calibrationUnit) {
            this.calibrationUnit = calibrationUnit;
        }

        public Double getTimeIncrement() {
            return this.timeIncrement == null ? 1.0 : this.timeIncrement;
        }

        public void setTimeIncrement(Double timeIncrement) {
            this.timeIncrement = timeIncrement;
        }

        public Integer getxOrigin() {
            return this.xOrigin;
        }

        public void setxOrigin(Integer xOrigin) {
            this.xOrigin = xOrigin;
        }

        public Integer getyOrigin() {
            return this.yOrigin;
        }

        public void setyOrigin(Integer yOrigin) {
            this.yOrigin = yOrigin;
        }

        public String getCreationDate() {
            return this.creationDate;
        }

        public void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public String getExperimenterFirstName() {
            return this.experimenterFirstName;
        }

        public byte[][] getLut() {
            return this.lut;
        }

        public void setLut(byte[][] lut) {
            this.lut = lut;
        }

        public void setExperimenterFirstName(String experimenterFirstName) {
            this.experimenterFirstName = experimenterFirstName;
        }

        public String getExperimenterLastName() {
            return this.experimenterLastName;
        }

        public void setExperimenterLastName(String experimenterLastName) {
            this.experimenterLastName = experimenterLastName;
        }

        public String getExperimenterEmail() {
            return this.experimenterEmail;
        }

        public void setExperimenterEmail(String experimenterEmail) {
            this.experimenterEmail = experimenterEmail;
        }

        public String getImageDescription() {
            return this.imageDescription;
        }

        public void setImageDescription(String imageDescription) {
            this.imageDescription = imageDescription;
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            ColorTable ct = super.getColorTable(imageIndex, planeIndex);
            if (ct == null) {
                if (this.colorTable == null && this.getLut() != null) {
                    this.colorTable = new ArrayList<ColorTable>();
                    byte[][] ij1Lut = this.getLut();
                    for (int i = 0; i < ij1Lut.length; ++i) {
                        if (ij1Lut[i].length != 768) {
                            this.colorTable.add(null);
                            continue;
                        }
                        byte[][] currentLut = new byte[3][256];
                        for (int j = 0; j < 3; ++j) {
                            System.arraycopy(ij1Lut[i], j * 256, currentLut[j], 0, 256);
                        }
                        this.colorTable.add((ColorTable)new ColorTable8(currentLut));
                    }
                }
                if (this.colorTable != null) {
                    int ctIndex = (int)FormatTools.getNonPlanarAxisPosition(this, imageIndex, planeIndex, Axes.CHANNEL);
                    return this.colorTable.get(ctIndex);
                }
            }
            return ct;
        }

        @Override
        public void createImageMetadata(int imageCount) {
            this.populateImageMetadata = true;
            super.createImageMetadata(imageCount);
        }

        @Override
        public void populateImageMetadata() {
            if (this.populateImageMetadata) {
                super.populateImageMetadata();
            }
            ImageMetadata m = this.get(0);
            if (this.getIfds().size() > 1) {
                m.setOrderCertain(false);
            }
            try {
                Double pixX = ((IFD)this.getIfds().get(0)).getXResolution();
                Double pixY = ((IFD)this.getIfds().get(0)).getYResolution();
                if (pixX != null) {
                    if (pixX > 0.0 && pixX < Double.POSITIVE_INFINITY) {
                        FormatTools.calibrate(m.getAxis(Axes.X), pixX, 0.0);
                    } else {
                        this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + pixX));
                    }
                }
                if (pixY != null) {
                    if (pixY > 0.0 && pixY < Double.POSITIVE_INFINITY) {
                        FormatTools.calibrate(m.getAxis(Axes.Y), pixY, 0.0);
                    } else {
                        this.log().warn((Object)("Expected positive value for PhysicalSizeY; got " + pixY));
                    }
                }
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to get x, y pixel sizes", (Throwable)e);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.companionFile = null;
                this.description = null;
                this.calibrationUnit = null;
                this.timeIncrement = null;
                this.xOrigin = null;
                this.yOrigin = null;
            }
        }
    }
}

