/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils.sparse;

import java.util.stream.LongStream;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.util.Intervals;

public class IntervalIndexer2 {
    private final long[] min;
    private final long[] dimensions;
    private final long[] stepSize;

    public IntervalIndexer2(Interval interval) {
        this.min = Intervals.minAsLongArray((Interval)interval);
        this.dimensions = Intervals.dimensionsAsLongArray((Dimensions)interval);
        this.stepSize = this.initStepStepSize();
    }

    private long[] initStepStepSize() {
        long[] stepSize = new long[this.dimensions.length];
        stepSize[0] = 1L;
        for (int i = 1; i < this.dimensions.length; ++i) {
            stepSize[i] = stepSize[i - 1] * this.dimensions[i - 1];
        }
        return stepSize;
    }

    public long size() {
        return LongStream.of(this.dimensions).reduce(1L, (a, b) -> a * b);
    }

    public long positionToIndex(Localizable localizable) {
        long sum = 0L;
        for (int d = 0; d < this.dimensions.length; ++d) {
            sum += this.stepSize[d] * (localizable.getLongPosition(d) - this.min[d]);
        }
        return sum;
    }

    public void indexToPosition(long index, Positionable positionable) {
        for (int d = 0; d < this.dimensions.length; ++d) {
            positionable.setPosition(this.indexToPosition(index, d), d);
        }
    }

    public long indexToPosition(long index, int d) {
        return index / this.stepSize[d] % this.dimensions[d] + this.min[d];
    }
}

