/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.python.indexer.Indexer;
import org.python.indexer.types.NModuleType;
import org.scijava.plugins.scripteditor.jython.ClassDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class Scope {
    final Scope parent;
    final String className;
    private final List<Scope> children = new ArrayList<Scope>();
    final HashMap<String, DotAutocompletions> imports = new HashMap();
    final HashMap<String, DotAutocompletions> vars = new HashMap();
    static final Indexer indexer = new Indexer();
    private static Thread module_watcher;
    private static WatchService watcher;
    private static Hashtable<WatchKey, Path> keys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NModuleType loadPythonModule(String qname) {
        Indexer indexer = Scope.indexer;
        synchronized (indexer) {
            NModuleType mod = null;
            try {
                mod = Scope.indexer.loadModule(qname);
                if (null == mod) {
                    return null;
                }
            }
            catch (Exception e) {
                JythonDev.print("Could not load python module named " + qname, e);
                return null;
            }
            try {
                String qname_slash = qname.replace(".", "/");
                String filepath = Scope.indexer.getLoadedFiles().stream().filter(s -> s.endsWith("/" + qname_slash + ".py") || s.endsWith("/" + qname_slash + "/__init__.py")).findFirst().orElse(null);
                if (null != filepath) {
                    Path path = new File(filepath).getParentFile().toPath();
                    WatchKey key = path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    keys.put(key, path);
                } else {
                    JythonDev.print("Python module " + qname + " doesn't have an associated file path.");
                }
            }
            catch (Exception e) {
                JythonDev.print("Could not load python module named " + qname, e);
            }
            return mod;
        }
    }

    public Scope(Scope parent) {
        this(parent, null);
    }

    public Scope(Scope parent, String className) {
        this.parent = parent;
        if (null != parent) {
            parent.children.add(this);
        }
        this.className = className;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty() && this.vars.isEmpty();
    }

    public DotAutocompletions find(String name, DotAutocompletions default_value) {
        Scope scope = this;
        while (null != scope) {
            DotAutocompletions da = scope.vars.get(name);
            if (null == da) {
                da = scope.imports.get(name);
            }
            if (null != da) {
                return da;
            }
            scope = scope.parent;
        }
        String builtin_className = "__builtin__." + name + ".";
        List<CompletionText> dotAutocompletions = indexer.getBindings().keySet().stream().filter(s -> s.startsWith(builtin_className)).map(s -> new CompletionText(s.substring(builtin_className.length()))).collect(Collectors.toList());
        if (!dotAutocompletions.isEmpty()) {
            return new ClassDotAutocompletions(name, Collections.emptyList(), Collections.emptyList(), dotAutocompletions, this);
        }
        return default_value;
    }

    public List<String> findStartsWith(String name) {
        ArrayList<String> completions = new ArrayList<String>();
        Scope scope = this;
        while (null != scope) {
            for (String varName : scope.vars.keySet()) {
                if (!varName.startsWith(name)) continue;
                completions.add(varName);
            }
            for (String importName : scope.imports.keySet()) {
                if (!importName.startsWith(name)) continue;
                completions.add(importName);
            }
            for (String builtinName : indexer.getBindings().keySet()) {
                if (builtinName.startsWith("__builtin__.")) {
                    builtinName = builtinName.substring(12);
                }
                if (!builtinName.startsWith(name)) continue;
                completions.add(builtinName);
            }
            scope = scope.parent;
        }
        return completions;
    }

    public Map<String, String> findStartsWith2(String name) {
        HashMap<String, String> completions = new HashMap<String, String>();
        Scope scope = this;
        while (null != scope) {
            for (Map.Entry<String, DotAutocompletions> e : scope.vars.entrySet()) {
                if (!e.getKey().startsWith(name)) continue;
                completions.put(e.getKey(), e.getValue().getClassname());
            }
            for (Map.Entry<String, DotAutocompletions> e : scope.imports.entrySet()) {
                if (!e.getKey().startsWith(name)) continue;
                completions.put(e.getKey(), e.getValue().getClassname());
            }
            for (String builtinName : indexer.getBindings().keySet()) {
                if (builtinName.startsWith("__builtin__.")) {
                    builtinName = builtinName.substring(12);
                }
                if (!builtinName.startsWith(name)) continue;
                completions.put(builtinName, null);
            }
            scope = scope.parent;
        }
        return completions;
    }

    public Stream<String> findVarsByType(String type, Class<?> clazz) {
        Stream<String> varNames = new ArrayList().stream();
        Scope scope = this;
        JythonDev.printTrace("Scope.findVarsByType: searching for type " + type + " and class " + clazz.getCanonicalName());
        while (null != scope) {
            varNames = Stream.concat(varNames, scope.vars.entrySet().stream().filter(e -> {
                try {
                    JythonDev.printTrace("Scope.findVarsByType, testing: " + (String)e.getKey() + " :: " + e.getValue() + " with class " + ((DotAutocompletions)e.getValue()).getClassname());
                    if (((String)e.getKey()).startsWith("____")) {
                        return false;
                    }
                    String classname = ((DotAutocompletions)e.getValue()).getClassname();
                    if (null == classname) {
                        return false;
                    }
                    if (type.equals(classname)) {
                        JythonDev.printTrace("type == classname: " + type);
                        return true;
                    }
                    if (Number.class.isAssignableFrom(clazz)) {
                        if (classname.equals("float")) {
                            return true;
                        }
                        if (classname.equals("long")) {
                            return type.equals("int") || type.equals("short") || type.equals("byte") || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Byte.class);
                        }
                    }
                    Class c = null;
                    switch (classname) {
                        case "long": {
                            c = Long.class;
                            break;
                        }
                        case "float": {
                            c = Float.class;
                            break;
                        }
                        default: {
                            c = Class.forName(classname);
                        }
                    }
                    return clazz.isAssignableFrom(c);
                }
                catch (ClassNotFoundException e1) {
                    JythonDev.print("Cannot load class " + e.getValue(), e1);
                    return false;
                }
            }).map(e -> (String)e.getKey()));
            scope = scope.parent;
        }
        return varNames;
    }

    public HashMap<String, DotAutocompletions> getImports() {
        HashMap<String, DotAutocompletions> imports = new HashMap<String, DotAutocompletions>(this.imports);
        Scope parent = this.parent;
        while (parent != null) {
            imports.putAll(parent.getImports());
            parent = parent.parent;
        }
        return imports;
    }

    public HashMap<String, DotAutocompletions> getVars() {
        HashMap<String, DotAutocompletions> vars = new HashMap<String, DotAutocompletions>(this.vars);
        Scope parent = this.parent;
        while (parent != null) {
            vars.putAll(parent.getVars());
            parent = parent.parent;
        }
        return vars;
    }

    public boolean isClass() {
        return this.className != null;
    }

    public Scope getLast() {
        if (this.children.isEmpty()) {
            return this;
        }
        return this.children.get(this.children.size() - 1).getLast();
    }

    public void print(String indent) {
        if ("" == indent) {
            System.out.println("scope global:");
        }
        System.out.println(indent + "available imports: " + String.join((CharSequence)", ", this.getImports().keySet()));
        System.out.println(indent + "declared imports:");
        for (Map.Entry<String, DotAutocompletions> e : this.imports.entrySet()) {
            System.out.println(indent + "  import :: " + e.getKey() + " --> " + e.getValue());
        }
        System.out.println(indent + "available vars: " + String.join((CharSequence)", ", this.getVars().keySet()));
        System.out.println(indent + "declared vars:");
        for (Map.Entry<String, DotAutocompletions> e : this.vars.entrySet()) {
            System.out.println(indent + "  var :: " + e.getKey() + " = " + e.getValue());
        }
        int i = 0;
        for (Scope child : this.children) {
            System.out.println(indent + "scope[" + i++ + "]:");
            child.print(indent + "  ");
        }
    }

    static {
        keys = new Hashtable();
        try {
            watcher = FileSystems.getDefault().newWatchService();
            module_watcher = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!this.isInterrupted()) {
                        WatchKey key = null;
                        try {
                            key = watcher.take();
                        }
                        catch (InterruptedException x) {
                            return;
                        }
                        if (!keys.containsKey(key)) continue;
                        JythonDev.print("Python module at:\n" + keys.get(key) + "\n ... was updated. Clearing indexer cache.");
                        keys.clear();
                        Indexer indexer = Scope.indexer;
                        synchronized (indexer) {
                            Scope.indexer.clearModuleTable();
                        }
                    }
                    return;
                }
            };
            module_watcher.setPriority(5);
            module_watcher.start();
        }
        catch (Exception e) {
            JythonDev.print("Failed to start filesystem watcher service for python modules", e);
        }
    }
}

