/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.renjin.gcc.runtime.Ptr;

public class BytePtr
implements Ptr {
    public final byte[] array;
    public final int offset;

    public BytePtr(byte ... array) {
        this(array, 0);
    }

    public BytePtr(byte[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public static byte[] toArray(String constant) {
        return constant.getBytes(StandardCharsets.UTF_8);
    }

    public static BytePtr asciiString(String string) {
        return new BytePtr(string.getBytes(StandardCharsets.US_ASCII), 0);
    }

    public static BytePtr nullTerminatedString(String string, Charset charset) {
        byte[] bytes = string.getBytes(charset);
        byte[] nullTerminatedBytes = Arrays.copyOf(bytes, bytes.length + 1);
        return new BytePtr(nullTerminatedBytes, 0);
    }

    public int nullTerminatedStringLength() {
        for (int i = this.offset; i < this.array.length; ++i) {
            if (this.array[i] != 0) continue;
            return i - this.offset;
        }
        throw new IllegalStateException("String is not null-terminated.");
    }

    public String nullTerminatedString() {
        return new String(this.array, this.offset, this.nullTerminatedStringLength(), StandardCharsets.UTF_8);
    }

    public String toString(int length) {
        return new String(this.array, this.offset, length, StandardCharsets.UTF_8);
    }

    public static void memset(byte[] str, int strOffset, int c, int n) {
        Arrays.fill(str, strOffset, strOffset + c / 64, (byte)c);
    }
}

