/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public class AmazonS3Utils {
    public static final Pattern AWS_ENDPOINT_PATTERN = Pattern.compile("^(.+\\.)?(s3\\..*amazonaws\\.com)", 2);
    public static final Pattern S3_SCHEME = Pattern.compile("s3", 2);
    private static final String DISABLE_WARNING_KEY = "aws.java.v1.disableDeprecationAnnouncement";
    private static String AMZ_REQUEST_HEADER = "x-amz-request-id";

    private AmazonS3Utils() {
    }

    public static String getS3Bucket(String uri) {
        try {
            return AmazonS3Utils.getS3Bucket(N5URI.getAsUri((String)uri));
        }
        catch (N5Exception n5Exception) {
            return null;
        }
    }

    public static String getS3Bucket(URI uri) {
        try {
            return new AmazonS3URI(uri).getBucket();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String path = uri.getPath().replaceFirst("^/", "");
            return path.split("/")[0];
        }
    }

    public static String getS3Key(String uri) {
        try {
            return AmazonS3Utils.getS3Key(N5URI.getAsUri((String)uri));
        }
        catch (N5Exception n5Exception) {
            return "";
        }
    }

    public static String getS3Key(URI uri) {
        try {
            String key = new AmazonS3URI(uri).getKey();
            return key == null ? "" : key;
        }
        catch (IllegalArgumentException key) {
            StringBuilder keyBuilder = new StringBuilder();
            String[] parts = uri.getPath().replaceFirst("^/", "").split("/");
            for (int i = 1; i < parts.length; ++i) {
                keyBuilder.append(parts[i]);
                if (i == parts.length - 1 && !uri.getPath().endsWith("/")) continue;
                keyBuilder.append("/");
            }
            return keyBuilder.toString();
        }
    }

    public static boolean areAnonymous(AWSCredentialsProvider credsProvider) {
        AWSCredentials creds = credsProvider.getCredentials();
        if (creds instanceof AnonymousAWSCredentials) {
            return true;
        }
        return creds.getAWSAccessKeyId() == null && creds.getAWSSecretKey() == null;
    }

    public static Regions getS3Region(AmazonS3URI uri, @Nullable String region) {
        Regions regionFromUri = AmazonS3Utils.parseRegion(uri.getRegion());
        return regionFromUri != null ? regionFromUri : AmazonS3Utils.parseRegion(region);
    }

    private static Regions parseRegion(String stringRegionFromUri) {
        return stringRegionFromUri != null ? Regions.fromName((String)stringRegionFromUri) : null;
    }

    public static AWSCredentialsProvider getS3Credentials(AWSCredentials s3Credentials, boolean s3Anonymous) {
        String initialDisableWarningPropertyValue = System.getProperty(DISABLE_WARNING_KEY);
        if (initialDisableWarningPropertyValue == null) {
            System.setProperty(DISABLE_WARNING_KEY, "true");
        }
        if (s3Credentials != null) {
            AWSStaticCredentialsProvider provider = new AWSStaticCredentialsProvider(s3Credentials);
            AmazonS3Utils.resetDisableWarningValue(initialDisableWarningPropertyValue);
            return provider;
        }
        if (!s3Anonymous) {
            DefaultAWSCredentialsProviderChain provider = new DefaultAWSCredentialsProviderChain();
            AmazonS3Utils.resetDisableWarningValue(initialDisableWarningPropertyValue);
            return provider;
        }
        AmazonS3Utils.resetDisableWarningValue(initialDisableWarningPropertyValue);
        return null;
    }

    public static AmazonS3 createS3(String uri) {
        return AmazonS3Utils.createS3(uri, (String)null, null, null);
    }

    public static AmazonS3 createS3(String uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable String region) {
        return AmazonS3Utils.createS3(uri, s3Endpoint, s3Credentials, null, region);
    }

    public static AmazonS3 createS3(String uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable ClientConfiguration clientConfiguration, @Nullable String region) {
        try {
            AmazonS3URI s3Uri = new AmazonS3URI(uri);
            return AmazonS3Utils.createS3(s3Uri, s3Endpoint, s3Credentials, region);
        }
        catch (IllegalArgumentException e) {
            try {
                URI asURI = new URI(uri);
                URI endpointUri = new URI(asURI.getScheme(), asURI.getAuthority(), null, null, null);
                return AmazonS3Utils.createS3(AmazonS3Utils.getS3Bucket(uri), s3Credentials, new AwsClientBuilder.EndpointConfiguration(endpointUri.toString(), null), null);
            }
            catch (URISyntaxException e1) {
                throw new N5Exception("Could not create s3 client from uri: " + uri, (Throwable)e1);
            }
        }
    }

    public static AmazonS3 createS3(AmazonS3URI s3Uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable String region) {
        return AmazonS3Utils.createS3(s3Uri, s3Endpoint, s3Credentials, null, region);
    }

    public static AmazonS3 createS3(AmazonS3URI s3Uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable ClientConfiguration clientConfiguration, @Nullable String region) {
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = null;
        if (!S3_SCHEME.matcher(s3Uri.getURI().getScheme()).matches()) {
            endpointConfiguration = AmazonS3Utils.createEndpointConfiguration(s3Uri, s3Endpoint);
        }
        return AmazonS3Utils.createS3(s3Uri.getBucket(), s3Credentials, endpointConfiguration, clientConfiguration, AmazonS3Utils.getS3Region(s3Uri, region));
    }

    public static AwsClientBuilder.EndpointConfiguration createEndpointConfiguration(AmazonS3URI s3Uri, @Nullable String s3Endpoint) {
        Matcher matcher;
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = s3Endpoint != null ? new AwsClientBuilder.EndpointConfiguration(s3Endpoint, null) : ((matcher = AWS_ENDPOINT_PATTERN.matcher(s3Uri.getURI().getHost())).find() ? new AwsClientBuilder.EndpointConfiguration(matcher.group(2), s3Uri.getRegion()) : new AwsClientBuilder.EndpointConfiguration(s3Uri.getURI().getHost(), s3Uri.getRegion()));
        return endpointConfiguration;
    }

    public static AmazonS3 createS3(String bucketName, @Nullable AWSCredentialsProvider credentialsProvider, @Nullable AwsClientBuilder.EndpointConfiguration endpointConfiguration, @Nullable Regions region) {
        return AmazonS3Utils.createS3(bucketName, credentialsProvider, endpointConfiguration, null, region);
    }

    public static AmazonS3 createS3(String bucketName, @Nullable AWSCredentialsProvider credentialsProvider, @Nullable AwsClientBuilder.EndpointConfiguration endpointConfiguration, @Nullable ClientConfiguration clientConfiguration, @Nullable Regions region) {
        boolean isAmazon = endpointConfiguration == null || AWS_ENDPOINT_PATTERN.matcher(endpointConfiguration.getServiceEndpoint()).find();
        String initialDisableWarningPropertyValue = System.getProperty(DISABLE_WARNING_KEY);
        if (initialDisableWarningPropertyValue == null) {
            System.setProperty(DISABLE_WARNING_KEY, "true");
        }
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (!isAmazon) {
            builder.withPathStyleAccessEnabled(Boolean.valueOf(true));
        }
        if (credentialsProvider == null) {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()));
        } else {
            builder.withCredentials(credentialsProvider);
        }
        if (clientConfiguration != null) {
            builder.withClientConfiguration(clientConfiguration);
        }
        if (endpointConfiguration != null) {
            builder.withEndpointConfiguration(endpointConfiguration);
        } else if (region != null) {
            builder.withRegion(region);
        } else {
            builder.withRegion("us-east-1");
        }
        AmazonS3 s3 = (AmazonS3)builder.build();
        if (!(credentialsProvider != null || s3.doesBucketExistV2(bucketName) && AmazonS3Utils.canListBucket(s3, bucketName))) {
            builder.withCredentials((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            AmazonS3Utils.resetDisableWarningValue(initialDisableWarningPropertyValue);
            return (AmazonS3)builder.build();
        }
        AmazonS3Utils.resetDisableWarningValue(initialDisableWarningPropertyValue);
        return s3;
    }

    public static void requireValidS3ServerResponse(AmazonS3 s3) {
        try {
            s3.getObject(UUID.randomUUID().toString(), UUID.randomUUID().toString());
        }
        catch (AmazonS3Exception e) {
            if (e.getHttpHeaders().containsKey(AMZ_REQUEST_HEADER) || e.getErrorCode().equals("NoSuchBucket")) {
                return;
            }
            throw e;
        }
    }

    private static void resetDisableWarningValue(String initialDisableWarningPropertyValue) {
        if (initialDisableWarningPropertyValue == null) {
            System.clearProperty(DISABLE_WARNING_KEY);
        }
    }

    private static boolean canListBucket(AmazonS3 s3, String bucket) {
        ListObjectsV2Request request = new ListObjectsV2Request();
        request.setBucketName(bucket);
        request.setMaxKeys(Integer.valueOf(1));
        try {
            s3.listObjectsV2(request);
            return true;
        }
        catch (AmazonS3Exception e) {
            return false;
        }
    }
}

