/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bigwarp.BigWarp;
import bigwarp.BigWarpAutoSaver;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AutosaveOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 2449704984531905538L;
    private final BigWarp<?> bw;
    private final SpinnerNumberModel savePeriodModel;
    private final JSpinner autoSavePeriodSpinner;
    private final JCheckBox doAutoSaveBox;
    private final JTextField autoSaveFolderText;
    private int lastAutoSaveFreq = 5;
    private boolean updating = false;

    public AutosaveOptionsPanel(final BigWarp<?> bw, Container content) {
        super(new GridBagLayout());
        this.bw = bw;
        this.doAutoSaveBox = new JCheckBox("Auto-save landmarks");
        JLabel autoSavePeriodLabel = new JLabel("Frequency (minutes)");
        this.autoSavePeriodSpinner = new JSpinner();
        this.savePeriodModel = new SpinnerNumberModel(0, 0, 0, 1);
        this.getAutoSavePeriodSpinner().setModel(this.savePeriodModel);
        ((JSpinner.DefaultEditor)this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEnabled(false);
        this.getAutoSavePeriodSpinner().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AutosaveOptionsPanel.this.getDoAutoSaveBox().isSelected() && !AutosaveOptionsPanel.this.updating) {
                    long periodMillis = ((Integer)AutosaveOptionsPanel.this.savePeriodModel.getValue()).longValue() * 60000L;
                    BigWarpAutoSaver autoSaver = bw.getAutoSaver();
                    if (autoSaver != null) {
                        autoSaver.stop();
                    }
                    bw.setAutoSaver(new BigWarpAutoSaver(bw, periodMillis));
                }
            }
        });
        this.getDoAutoSaveBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                bw.stopAutosave();
                if (AutosaveOptionsPanel.this.getDoAutoSaveBox().isSelected()) {
                    AutosaveOptionsPanel.this.updating = true;
                    ((JSpinner.DefaultEditor)AutosaveOptionsPanel.this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEditable(true);
                    ((JSpinner.DefaultEditor)AutosaveOptionsPanel.this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEnabled(true);
                    AutosaveOptionsPanel.this.savePeriodModel.setMinimum(Integer.valueOf(1));
                    AutosaveOptionsPanel.this.savePeriodModel.setMaximum(Integer.valueOf(5000));
                    AutosaveOptionsPanel.this.savePeriodModel.setValue(AutosaveOptionsPanel.this.lastAutoSaveFreq);
                    long periodMillis = ((Integer)AutosaveOptionsPanel.this.savePeriodModel.getValue()).longValue() * 60000L;
                    bw.setAutoSaver(new BigWarpAutoSaver(bw, periodMillis));
                    AutosaveOptionsPanel.this.updating = false;
                } else {
                    AutosaveOptionsPanel.this.lastAutoSaveFreq = (Integer)AutosaveOptionsPanel.this.savePeriodModel.getValue();
                    AutosaveOptionsPanel.this.savePeriodModel.setMinimum(Integer.valueOf(0));
                    AutosaveOptionsPanel.this.savePeriodModel.setMaximum(Integer.valueOf(0));
                    AutosaveOptionsPanel.this.savePeriodModel.setValue(0);
                    ((JSpinner.DefaultEditor)AutosaveOptionsPanel.this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEditable(false);
                    ((JSpinner.DefaultEditor)AutosaveOptionsPanel.this.getAutoSavePeriodSpinner().getEditor()).getTextField().setEnabled(false);
                }
            }
        });
        JLabel destDirLabel = new JLabel("Directory");
        File startingFolder = bw.getBigwarpSettingsFolder();
        this.autoSaveFolderText = new JTextField();
        this.getAutoSaveFolderText().setText(startingFolder.getAbsolutePath());
        JButton browseBtn = new JButton("Browse");
        browseBtn.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setCurrentDirectory(startingFolder);
            int ret = fileChooser.showOpenDialog(content);
            if (ret == 0) {
                File folder = fileChooser.getSelectedFile();
                this.getAutoSaveFolderText().setText(folder.getAbsolutePath());
                bw.getAutoSaver().setAutosaveFolder(folder);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.getDoAutoSaveBox(), gbc);
        gbc.weightx = 1.0;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.anchor = 22;
        this.add((Component)autoSavePeriodLabel, gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.add((Component)this.getAutoSavePeriodSpinner(), gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 21;
        gbc.fill = 0;
        this.add((Component)destDirLabel, gbc);
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 21;
        gbc.fill = 2;
        this.add((Component)this.getAutoSaveFolderText(), gbc);
        gbc.gridx = 4;
        gbc.weightx = 0.0;
        gbc.anchor = 22;
        gbc.fill = 0;
        this.add((Component)browseBtn, gbc);
    }

    public JSpinner getAutoSavePeriodSpinner() {
        return this.autoSavePeriodSpinner;
    }

    public JCheckBox getDoAutoSaveBox() {
        return this.doAutoSaveBox;
    }

    public JTextField getAutoSaveFolderText() {
        return this.autoSaveFolderText;
    }
}

