/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms.metadata;

import bigwarp.transforms.metadata.N5TransformMetadata;
import java.awt.Component;
import javax.swing.JTree;
import org.janelia.saalfeldlab.n5.ui.N5DatasetTreeCellRenderer;
import org.janelia.saalfeldlab.n5.ui.N5SwingTreeNode;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;

public class N5TransformTreeCellRenderer
extends N5DatasetTreeCellRenderer {
    private static final long serialVersionUID = 9198333318002035941L;

    public N5TransformTreeCellRenderer(boolean showConversionWarning) {
        super(showConversionWarning);
    }

    public String getParameterString(N5TreeNode node) {
        N5Metadata meta = node.getMetadata();
        if (meta == null || !(meta instanceof N5TransformMetadata)) {
            return "";
        }
        CoordinateTransform<?>[] tforms = ((N5TransformMetadata)node.getMetadata()).getTransforms();
        if (tforms != null) {
            String suffix = tforms.length > 1 ? " ..." : "";
            String first = tforms.length > 0 ? String.format("\"%s\" (<i>%s</i>)", tforms[0].getName(), tforms[0].getType()) : "";
            return String.format(" (%d) [%s%s]", tforms.length, first, suffix);
        }
        return "";
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean exp, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, exp, leaf, row, hasFocus);
        if (value instanceof N5SwingTreeNode) {
            N5SwingTreeNode node = (N5SwingTreeNode)value;
            if (node.getMetadata() != null) {
                String memStr = this.memString((N5TreeNode)node);
                String memSizeString = memStr.isEmpty() ? "" : " (" + memStr + ")";
                String name = node.getParent() == null ? this.rootName : node.getNodeName();
                this.setText(String.join((CharSequence)"", "<html>", String.format("<b>%s</b>", name), this.getParameterString((N5TreeNode)node), memSizeString, "</html>"));
            } else {
                this.setText(node.getParent() == null ? this.rootName : node.getNodeName());
            }
        }
        return this;
    }
}

