/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils;

import bdv.export.ProgressWriter;
import java.util.AbstractList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.img.Img;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.TaskExecutor;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class ParallelUtils {
    public static <T> void applyOperationOnCells(RandomAccessibleInterval<T> image, int[] cellDimensions, Consumer<RandomAccessibleInterval<T>> operation, ProgressWriter progressWriter) {
        List<Interval> cells = ParallelUtils.getCells(new CellGrid(Intervals.dimensionsAsLongArray(image), cellDimensions));
        AtomicInteger numStarted = new AtomicInteger(0);
        AtomicInteger numFinished = new AtomicInteger(0);
        int n = cells.size();
        Parallelization.getTaskExecutor().forEach(cells, cell -> {
            AtomicBoolean cancelled = new AtomicBoolean(false);
            if (cancelled.get()) {
                throw new CancellationException();
            }
            try {
                progressWriter.out().println("Chunk " + numStarted.incrementAndGet() + " of " + n);
                operation.accept((RandomAccessibleInterval)Views.interval((RandomAccessible)image, (Interval)cell));
                progressWriter.setProgress((double)numFinished.incrementAndGet() / (double)n);
            }
            catch (CancellationException e) {
                cancelled.set(true);
                throw e;
            }
        });
        progressWriter.setProgress(1.0);
    }

    private static List<Interval> getCells(final CellGrid cellGrid) {
        final long numCells = Intervals.numElements((long[])cellGrid.getGridDimensions());
        return new AbstractList<Interval>(){

            @Override
            public Interval get(int i) {
                long[] min = new long[cellGrid.numDimensions()];
                int[] dim = new int[cellGrid.numDimensions()];
                cellGrid.getCellDimensions((long)i, min, dim);
                long[] max = IntStream.range(0, cellGrid.numDimensions()).mapToLong(i1 -> min[i1] + (long)dim[i1] - 1L).toArray();
                return new FinalInterval(min, max);
            }

            @Override
            public int size() {
                return (int)numCells;
            }
        };
    }

    public static void runInOtherThread(Runnable action) {
        ExecutorService executer = Executors.newSingleThreadExecutor();
        executer.submit(() -> {
            action.run();
            executer.shutdown();
        });
    }

    public static void populateCachedImg(RandomAccessibleInterval<?> img, ProgressWriter progressWriter) {
        if (img instanceof CachedCellImg) {
            Parallelization.runWithNumThreads((int)Runtime.getRuntime().availableProcessors(), () -> ParallelUtils.internPopulateCachedImg((CachedCellImg)Cast.unchecked((Object)img), progressWriter));
        }
    }

    private static void internPopulateCachedImg(CachedCellImg<?, ?> img, ProgressWriter progressWriter) {
        Img cells = (Img)img.getCells();
        long numCells = cells.size();
        AtomicLong chunk = new AtomicLong();
        ParallelUtils.forEachPixel(cells, cell -> {
            long c = chunk.incrementAndGet();
            progressWriter.out().println("Chunk " + c + " of " + numCells);
            progressWriter.setProgress((double)c / (double)numCells);
        });
        progressWriter.setProgress(1.0);
    }

    private static <T> void forEachPixel(Img<T> img, Consumer<T> action) {
        TaskExecutor te = Parallelization.getTaskExecutor();
        int numThreads = te.getParallelism();
        long size = img.size();
        AtomicLong nextIndex = new AtomicLong();
        AtomicBoolean cancelled = new AtomicBoolean(false);
        te.forEach(IntStream.range(0, numThreads).boxed().collect(Collectors.toList()), workerIndex -> {
            Cursor cursor = img.cursor();
            long iCursor = -1L;
            long i = nextIndex.getAndIncrement();
            while (i < size && !cancelled.get()) {
                if (Thread.interrupted()) {
                    cancelled.set(true);
                }
                try {
                    cursor.jumpFwd(i - iCursor);
                    action.accept(cursor.get());
                    iCursor = i;
                }
                catch (Exception e) {
                    cancelled.set(true);
                    throw e;
                }
                i = nextIndex.getAndIncrement();
            }
        });
    }
}

