/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness;

import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;

public class EstimateScalingFactors {
    public static <T extends RealType<T>, W extends RealType<W>> void estimateQuadraticFromMatrix(RandomAccessibleInterval<T> correlations, double[] scalingFactors, double[] coordinates, RandomAccessibleInterval<double[]> localFits, double regularizerWeight, int comparisonRange, int nIterations, RandomAccessibleInterval<W> pairwiseWeights) {
        double inverseRegularizerWeight = 1.0 - regularizerWeight;
        RandomAccess corrAccess = correlations.randomAccess();
        RandomAccess wAccess = pairwiseWeights.randomAccess();
        for (int iter = 0; iter < nIterations; ++iter) {
            Cursor fitCursor = Views.iterable(localFits).cursor();
            int n = 0;
            while (fitCursor.hasNext()) {
                double[] oldScalingFactors = (double[])scalingFactors.clone();
                corrAccess.setPosition(n, 0);
                wAccess.setPosition(n, 0);
                double[] lf = (double[])fitCursor.next();
                RealRandomAccessible interpolatedFit = Views.interpolate((EuclideanSpace)Views.extendValue((RandomAccessibleInterval)ArrayImgs.doubles((double[])lf, (long[])new long[]{lf.length}), (Type)new DoubleType(Double.NaN)), (InterpolatorFactory)new NLinearInterpolatorFactory());
                RealRandomAccess ra = interpolatedFit.realRandomAccess();
                double enumeratorSum = 0.0;
                double denominatorSum = 0.0;
                int minVal = Math.max(n - comparisonRange, 0);
                int maxVal = Math.min(n + comparisonRange, scalingFactors.length);
                for (int i = minVal; i < maxVal; ++i) {
                    if (i == n) continue;
                    corrAccess.setPosition(i, 1);
                    wAccess.setPosition(i, 1);
                    ra.setPosition(Math.abs(coordinates[i] - coordinates[n]), 0);
                    double fitVal = -((DoubleType)ra.get()).get();
                    double measure = ((RealType)corrAccess.get()).getRealDouble();
                    if (Double.isNaN(fitVal) || Double.isNaN(measure) || measure <= 0.0) continue;
                    double w = ((RealType)wAccess.get()).getRealDouble();
                    double prod = oldScalingFactors[i] * measure;
                    double h = w * prod;
                    enumeratorSum += h * fitVal;
                    denominatorSum += h * prod;
                }
                double result = enumeratorSum / denominatorSum * inverseRegularizerWeight + regularizerWeight * oldScalingFactors[n];
                if (!Double.isNaN(result)) {
                    scalingFactors[n] = result;
                }
                ++n;
            }
        }
    }
}

