/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold;

import java.util.Comparator;
import java.util.List;
import net.imagej.ops.AbstractNamespace;
import net.imagej.ops.Namespace;
import net.imagej.ops.OpMethod;
import net.imagej.ops.Ops;
import net.imagej.ops.threshold.ApplyThresholdMethod;
import net.imagej.ops.threshold.ApplyThresholdMethodLocal;
import net.imagej.ops.threshold.apply.ApplyConstantThreshold;
import net.imagej.ops.threshold.apply.ApplyManualThreshold;
import net.imagej.ops.threshold.apply.ApplyThresholdComparable;
import net.imagej.ops.threshold.apply.ApplyThresholdComparator;
import net.imagej.ops.threshold.huang.ComputeHuangThreshold;
import net.imagej.ops.threshold.ij1.ComputeIJ1Threshold;
import net.imagej.ops.threshold.intermodes.ComputeIntermodesThreshold;
import net.imagej.ops.threshold.isoData.ComputeIsoDataThreshold;
import net.imagej.ops.threshold.li.ComputeLiThreshold;
import net.imagej.ops.threshold.localBernsen.LocalBernsenThreshold;
import net.imagej.ops.threshold.localContrast.LocalContrastThreshold;
import net.imagej.ops.threshold.localMean.LocalMeanThreshold;
import net.imagej.ops.threshold.localMean.LocalMeanThresholdIntegral;
import net.imagej.ops.threshold.localMedian.LocalMedianThreshold;
import net.imagej.ops.threshold.localMidGrey.LocalMidGreyThreshold;
import net.imagej.ops.threshold.localNiblack.LocalNiblackThreshold;
import net.imagej.ops.threshold.localNiblack.LocalNiblackThresholdIntegral;
import net.imagej.ops.threshold.localPhansalkar.LocalPhansalkarThreshold;
import net.imagej.ops.threshold.localPhansalkar.LocalPhansalkarThresholdIntegral;
import net.imagej.ops.threshold.localSauvola.LocalSauvolaThreshold;
import net.imagej.ops.threshold.localSauvola.LocalSauvolaThresholdIntegral;
import net.imagej.ops.threshold.maxEntropy.ComputeMaxEntropyThreshold;
import net.imagej.ops.threshold.maxLikelihood.ComputeMaxLikelihoodThreshold;
import net.imagej.ops.threshold.mean.ComputeMeanThreshold;
import net.imagej.ops.threshold.minError.ComputeMinErrorThreshold;
import net.imagej.ops.threshold.minimum.ComputeMinimumThreshold;
import net.imagej.ops.threshold.moments.ComputeMomentsThreshold;
import net.imagej.ops.threshold.otsu.ComputeOtsuThreshold;
import net.imagej.ops.threshold.percentile.ComputePercentileThreshold;
import net.imagej.ops.threshold.renyiEntropy.ComputeRenyiEntropyThreshold;
import net.imagej.ops.threshold.rosin.ComputeRosinThreshold;
import net.imagej.ops.threshold.shanbhag.ComputeShanbhagThreshold;
import net.imagej.ops.threshold.triangle.ComputeTriangleThreshold;
import net.imagej.ops.threshold.yen.ComputeYenThreshold;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Namespace.class)
public class ThresholdNamespace
extends AbstractNamespace {
    @OpMethod(op=ApplyConstantThreshold.class)
    public <T extends RealType<T>> Iterable<BitType> apply(Iterable<BitType> out, Iterable<T> in, T threshold) {
        Iterable result = (Iterable)this.ops().run(Ops.Threshold.Apply.class, out, in, threshold);
        return result;
    }

    @OpMethod(op=ApplyManualThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> apply(IterableInterval<T> in, T threshold) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Apply.class, in, threshold);
        return result;
    }

    @OpMethod(op=ApplyManualThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> apply(IterableInterval<BitType> out, IterableInterval<T> in, T threshold) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Apply.class, out, in, threshold);
        return result;
    }

    @OpMethod(op=ApplyThresholdComparable.class)
    public <T> BitType apply(BitType out, Comparable<? super T> in, T threshold) {
        BitType result = (BitType)this.ops().run(Ops.Threshold.Apply.class, out, in, threshold);
        return result;
    }

    @OpMethod(op=ApplyThresholdComparator.class)
    public <T> BitType apply(BitType out, T in, T threshold, Comparator<? super T> comparator) {
        BitType result = (BitType)this.ops().run(Ops.Threshold.Apply.class, out, in, threshold, comparator);
        return result;
    }

    @OpMethod(op=ComputeHuangThreshold.class)
    public <T extends RealType<T>> T huang(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Huang.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeHuangThreshold.class)
    public <T extends RealType<T>> T huang(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Huang.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.Huang.class)
    public <T extends RealType<T>> IterableInterval<BitType> huang(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Huang.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Huang.class)
    public <T extends RealType<T>> IterableInterval<BitType> huang(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Huang.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalHuangThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> huang(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalHuangThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalHuangThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> huang(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalHuangThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeIJ1Threshold.class)
    public <T extends RealType<T>> T ij1(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.IJ1.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeIJ1Threshold.class)
    public <T extends RealType<T>> T ij1(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.IJ1.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.IJ1.class)
    public <T extends RealType<T>> IterableInterval<BitType> ij1(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.IJ1.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.IJ1.class)
    public <T extends RealType<T>> IterableInterval<BitType> ij1(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.IJ1.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIJ1Threshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> ij1(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIJ1Threshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIJ1Threshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> ij1(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIJ1Threshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeIntermodesThreshold.class)
    public <T extends RealType<T>> List<Object> intermodes(Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.Intermodes.class, in);
        return result;
    }

    @OpMethod(op=ComputeIntermodesThreshold.class)
    public <T extends RealType<T>> List<Object> intermodes(T out, Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.Intermodes.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Intermodes.class)
    public <T extends RealType<T>> IterableInterval<BitType> intermodes(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Intermodes.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Intermodes.class)
    public <T extends RealType<T>> IterableInterval<BitType> intermodes(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Intermodes.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIntermodesThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> intermodes(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIntermodesThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIntermodesThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> intermodes(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIntermodesThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.IsoData.class)
    public <T extends RealType<T>> IterableInterval<BitType> isoData(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.IsoData.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.IsoData.class)
    public <T extends RealType<T>> IterableInterval<BitType> isoData(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.IsoData.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeIsoDataThreshold.class)
    public <T extends RealType<T>> List<Object> isoData(Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.IsoData.class, in);
        return result;
    }

    @OpMethod(op=ComputeIsoDataThreshold.class)
    public <T extends RealType<T>> List<Object> isoData(T out, Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.IsoData.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIsoDataThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> isoData(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIsoDataThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalIsoDataThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> isoData(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalIsoDataThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Li.class)
    public <T extends RealType<T>> IterableInterval<BitType> li(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Li.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Li.class)
    public <T extends RealType<T>> IterableInterval<BitType> li(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Li.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeLiThreshold.class)
    public <T extends RealType<T>> T li(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Li.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeLiThreshold.class)
    public <T extends RealType<T>> T li(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Li.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalLiThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> li(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalLiThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalLiThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> li(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalLiThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=LocalContrastThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localContrastThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalContrastThreshold.class, out, in, shape, outOfBounds);
        return result;
    }

    @OpMethod(op=LocalContrastThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localContrastThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalContrastThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=LocalMeanThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMeanThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMeanThreshold.class, out, in, shape, outOfBounds, c);
        return result;
    }

    @OpMethod(op=LocalMeanThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMeanThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMeanThreshold.class, out, in, shape, c);
        return result;
    }

    @OpMethod(op=LocalMeanThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMeanThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMeanThreshold.class, out, in, shape, outOfBounds, c);
        return result;
    }

    @OpMethod(op=LocalMeanThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMeanThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMeanThreshold.class, out, in, shape, c);
        return result;
    }

    @OpMethod(op=LocalMedianThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMedianThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMedianThreshold.class, out, in, shape, outOfBounds, c);
        return result;
    }

    @OpMethod(op=LocalMedianThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMedianThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMedianThreshold.class, out, in, shape, c);
        return result;
    }

    @OpMethod(op=LocalMidGreyThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMidGreyThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMidGreyThreshold.class, out, in, shape, outOfBounds, c);
        return result;
    }

    @OpMethod(op=LocalMidGreyThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localMidGreyThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, double c) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalMidGreyThreshold.class, out, in, shape, c);
        return result;
    }

    @OpMethod(op=LocalNiblackThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localNiblackThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalNiblackThreshold.class, out, in, shape, outOfBounds, c, k);
        return result;
    }

    @OpMethod(op=LocalNiblackThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localNiblackThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, double c, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalNiblackThreshold.class, out, in, shape, c, k);
        return result;
    }

    @OpMethod(op=LocalNiblackThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localNiblackThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double c, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalNiblackThreshold.class, out, in, shape, outOfBounds, c, k);
        return result;
    }

    @OpMethod(op=LocalNiblackThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localNiblackThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, double c, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalNiblackThreshold.class, out, in, shape, c, k);
        return result;
    }

    @OpMethod(op=LocalBernsenThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localBernsenThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double contrastThreshold, double halfMaxValue) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalBernsenThreshold.class, out, in, shape, outOfBounds, contrastThreshold, halfMaxValue);
        return result;
    }

    @OpMethod(op=LocalBernsenThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localBernsenThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, double contrastThreshold, double halfMaxValue) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalBernsenThreshold.class, out, in, shape, contrastThreshold, halfMaxValue);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k, double r) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds, k, r);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds, k);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k, double r) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds, k, r);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds, k);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape, outOfBounds);
        return result;
    }

    @OpMethod(op=LocalPhansalkarThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localPhansalkarThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalPhansalkarThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=LocalSauvolaThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k, double r) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds, k, r);
        return result;
    }

    @OpMethod(op=LocalSauvolaThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds, k);
        return result;
    }

    @OpMethod(op=LocalSauvolaThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds);
        return result;
    }

    @OpMethod(op=LocalSauvolaThreshold.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=LocalSauvolaThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k, double r) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds, k, r);
        return result;
    }

    @OpMethod(op=LocalSauvolaThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds, double k) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds, k);
        return result;
    }

    @OpMethod(op=LocalSauvolaThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBounds) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape, outOfBounds);
        return result;
    }

    @OpMethod(op=LocalSauvolaThresholdIntegral.class)
    public <T extends RealType<T>> IterableInterval<BitType> localSauvolaThreshold(IterableInterval<BitType> out, RandomAccessibleInterval<T> in, RectangleShape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.LocalSauvolaThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.MaxEntropy.class)
    public <T extends RealType<T>> IterableInterval<BitType> maxEntropy(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MaxEntropy.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.MaxEntropy.class)
    public <T extends RealType<T>> IterableInterval<BitType> maxEntropy(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MaxEntropy.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeMaxEntropyThreshold.class)
    public <T extends RealType<T>> T maxEntropy(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.MaxEntropy.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeMaxEntropyThreshold.class)
    public <T extends RealType<T>> T maxEntropy(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.MaxEntropy.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMaxEntropyThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> maxEntropy(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMaxEntropyThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMaxEntropyThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> maxEntropy(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMaxEntropyThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.MaxLikelihood.class)
    public <T extends RealType<T>> IterableInterval<BitType> maxLikelihood(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MaxLikelihood.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.MaxLikelihood.class)
    public <T extends RealType<T>> IterableInterval<BitType> maxLikelihood(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MaxLikelihood.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeMaxLikelihoodThreshold.class)
    public <T extends RealType<T>> List<Object> maxLikelihood(Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.MaxLikelihood.class, in);
        return result;
    }

    @OpMethod(op=ComputeMaxLikelihoodThreshold.class)
    public <T extends RealType<T>> List<Object> maxLikelihood(T out, Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.MaxLikelihood.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMaxLikelihoodThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> maxLikelihood(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMaxLikelihoodThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMaxLikelihoodThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> maxLikelihood(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMaxLikelihoodThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Mean.class)
    public <T extends RealType<T>> IterableInterval<BitType> mean(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Mean.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Mean.class)
    public <T extends RealType<T>> IterableInterval<BitType> mean(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Mean.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeMeanThreshold.class)
    public <T extends RealType<T>> T mean(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Mean.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeMeanThreshold.class)
    public <T extends RealType<T>> T mean(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Mean.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.MinError.class)
    public <T extends RealType<T>> IterableInterval<BitType> minError(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MinError.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.MinError.class)
    public <T extends RealType<T>> IterableInterval<BitType> minError(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.MinError.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeMinErrorThreshold.class)
    public <T extends RealType<T>> List<Object> minError(Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.MinError.class, in);
        return result;
    }

    @OpMethod(op=ComputeMinErrorThreshold.class)
    public <T extends RealType<T>> List<Object> minError(T out, Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.MinError.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMinErrorThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> minError(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMinErrorThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMinErrorThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> minError(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMinErrorThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Minimum.class)
    public <T extends RealType<T>> IterableInterval<BitType> minimum(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Minimum.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Minimum.class)
    public <T extends RealType<T>> IterableInterval<BitType> minimum(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Minimum.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeMinimumThreshold.class)
    public <T extends RealType<T>> List<Object> minimum(Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.Minimum.class, in);
        return result;
    }

    @OpMethod(op=ComputeMinimumThreshold.class)
    public <T extends RealType<T>> List<Object> minimum(T out, Histogram1d<T> in) {
        List result = (List)this.ops().run(Ops.Threshold.Minimum.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMinimumThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> minimum(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMinimumThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMinimumThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> minimum(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMinimumThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeMomentsThreshold.class)
    public <T extends RealType<T>> T moments(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Moments.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeMomentsThreshold.class)
    public <T extends RealType<T>> T moments(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Moments.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.Moments.class)
    public <T extends RealType<T>> IterableInterval<BitType> moments(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Moments.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Moments.class)
    public <T extends RealType<T>> IterableInterval<BitType> moments(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Moments.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMomentsThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> moments(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMomentsThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalMomentsThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> moments(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalMomentsThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeOtsuThreshold.class)
    public <T extends RealType<T>> T otsu(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Otsu.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeOtsuThreshold.class)
    public <T extends RealType<T>> T otsu(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Otsu.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.Otsu.class)
    public <T extends RealType<T>> IterableInterval<BitType> otsu(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Otsu.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Otsu.class)
    public <T extends RealType<T>> IterableInterval<BitType> otsu(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Otsu.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalOtsuThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> otsu(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalOtsuThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalOtsuThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> otsu(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalOtsuThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Percentile.class)
    public <T extends RealType<T>> IterableInterval<BitType> percentile(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Percentile.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Percentile.class)
    public <T extends RealType<T>> IterableInterval<BitType> percentile(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Percentile.class, out, in);
        return result;
    }

    @OpMethod(op=ComputePercentileThreshold.class)
    public <T extends RealType<T>> T percentile(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Percentile.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputePercentileThreshold.class)
    public <T extends RealType<T>> T percentile(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Percentile.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalPercentileThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> percentile(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalPercentileThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalPercentileThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> percentile(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalPercentileThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.RenyiEntropy.class)
    public <T extends RealType<T>> IterableInterval<BitType> renyiEntropy(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.RenyiEntropy.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.RenyiEntropy.class)
    public <T extends RealType<T>> IterableInterval<BitType> renyiEntropy(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.RenyiEntropy.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeRenyiEntropyThreshold.class)
    public <T extends RealType<T>> T renyiEntropy(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.RenyiEntropy.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeRenyiEntropyThreshold.class)
    public <T extends RealType<T>> T renyiEntropy(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.RenyiEntropy.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalRenyiEntropyThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> renyiEntropy(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalRenyiEntropyThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalRenyiEntropyThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> renyiEntropy(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalRenyiEntropyThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Shanbhag.class)
    public <T extends RealType<T>> IterableInterval<BitType> shanbhag(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Shanbhag.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Shanbhag.class)
    public <T extends RealType<T>> IterableInterval<BitType> shanbhag(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Shanbhag.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeShanbhagThreshold.class)
    public <T extends RealType<T>> T shanbhag(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Shanbhag.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeShanbhagThreshold.class)
    public <T extends RealType<T>> T shanbhag(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Shanbhag.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalShanbhagThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> shanbhag(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalShanbhagThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalShanbhagThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> shanbhag(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalShanbhagThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Triangle.class)
    public <T extends RealType<T>> IterableInterval<BitType> triangle(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Triangle.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Triangle.class)
    public <T extends RealType<T>> IterableInterval<BitType> triangle(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Triangle.class, out, in);
        return result;
    }

    @OpMethod(op=ComputeTriangleThreshold.class)
    public <T extends RealType<T>> T triangle(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Triangle.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeTriangleThreshold.class)
    public <T extends RealType<T>> T triangle(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Triangle.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalTriangleThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> triangle(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalTriangleThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalTriangleThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> triangle(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalTriangleThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeYenThreshold.class)
    public <T extends RealType<T>> T yen(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Yen.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeYenThreshold.class)
    public <T extends RealType<T>> T yen(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Yen.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.Yen.class)
    public <T extends RealType<T>> IterableInterval<BitType> yen(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Yen.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Yen.class)
    public <T extends RealType<T>> IterableInterval<BitType> yen(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Yen.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalYenThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> yen(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalYenThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalYenThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> yen(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalYenThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    @OpMethod(op=ComputeRosinThreshold.class)
    public <T extends RealType<T>> T rosin(Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Rosin.class, in);
        return (T)result;
    }

    @OpMethod(op=ComputeRosinThreshold.class)
    public <T extends RealType<T>> T rosin(T out, Histogram1d<T> in) {
        RealType result = (RealType)this.ops().run(Ops.Threshold.Rosin.class, out, in);
        return (T)result;
    }

    @OpMethod(op=ApplyThresholdMethod.Rosin.class)
    public <T extends RealType<T>> IterableInterval<BitType> rosin(IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Rosin.class, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethod.Rosin.class)
    public <T extends RealType<T>> IterableInterval<BitType> rosin(IterableInterval<BitType> out, IterableInterval<T> in) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Threshold.Rosin.class, out, in);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalRosinThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> rosin(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalRosinThreshold.class, out, in, shape);
        return result;
    }

    @OpMethod(op=ApplyThresholdMethodLocal.LocalRosinThreshold.class)
    public <T extends RealType<T>, B extends BooleanType<B>> IterableInterval<B> rosin(IterableInterval<B> out, RandomAccessibleInterval<T> in, Shape shape, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outOfBoundsFactory) {
        IterableInterval result = (IterableInterval)this.ops().run(ApplyThresholdMethodLocal.LocalRosinThreshold.class, out, in, shape, outOfBoundsFactory);
        return result;
    }

    public String getName() {
        return "threshold";
    }
}

