/*
 * Decompiled with CFR 0.152.
 */
package anisotropic_diffusion;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Date;

public class Anisotropic_Diffusion_2D
implements PlugInFilter {
    static final String ADTDVersion = "0.3";
    static final String ADTDDate = "2010/27/05";
    int nb_iter = 20;
    static int stored_nb_iter = 20;
    int nb_smoothings = 1;
    static int stored_nb_smoothings = 1;
    double dt = 20.0;
    double stored_dt = 20.0;
    float a1 = 0.5f;
    static float stored_a1 = 0.5f;
    float a2 = 0.9f;
    static float stored_a2 = 0.9f;
    int save = 20;
    static int stored_save = 20;
    boolean sstats = false;
    static boolean stored_sstats = false;
    boolean tstats = false;
    static boolean stored_tstats = false;
    boolean add_labels = false;
    static boolean stored_add_labels = false;
    float edgeheight = 5.0f;
    static float stored_edgeheight = 5.0f;
    Color label_color;
    Font font;
    int font_size = 18;
    int scount;
    protected ImagePlus imp;
    protected ImagePlus imp2;
    protected ImageStack stack = null;
    protected ImageStack stack2;

    public void setNumOfIterations(int nb_iter) {
        this.nb_iter = nb_iter;
    }

    public void setSaveSteps(int save) {
        this.save = save;
    }

    public void setSmoothings(int nb_smoothings) {
        this.nb_smoothings = nb_smoothings;
    }

    public void setTimeSteps(int dt) {
        this.dt = dt;
    }

    public void setLimiterMinimalVariations(float a1) {
        this.a1 = a1;
    }

    public void setLimiterMaximalVariations(float a2) {
        this.a2 = a2;
    }

    public void setEdgeThreshold(float edgeThreshold) {
        this.edgeheight = edgeThreshold;
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        this.imp = imp;
        IJ.resetEscape();
        return 277;
    }

    void showAbout() {
        IJ.showMessage((String)"About 2D Anisotropic Diffusion Tschumperle-Deriche", (String)"version 0.3 (2010/27/05)\nVladimir Pilny, Jiri Janacek GPL2\nBased on CImg Library - http://cimg.sourceforge.net/\n\nThis plugin is designed to filter images\nusing 2D Tschumperle-Deriche's anisotropic diffusion.");
    }

    private boolean GUI() {
        GenericDialog gd = new GenericDialog("2D Anisotropic Diffusion Tschumperle-Deriche v0.3");
        gd.addNumericField("Number of iterations", (double)stored_nb_iter, 0);
        gd.addNumericField("Smoothings per iteration", (double)stored_nb_smoothings, 0);
        if (this.scount == 1) {
            if (this.save > this.nb_iter) {
                this.save = this.nb_iter;
            }
            gd.addNumericField("Keep each ", (double)stored_save, 0, 2, "iteration");
        }
        gd.addNumericField("a1 (Diffusion limiter along minimal variations)", (double)stored_a1, 2);
        gd.addNumericField("a2 (Diffusion limiter along maximal variations)", (double)stored_a2, 2);
        gd.addNumericField("dt (Time step)", this.stored_dt, 1);
        gd.addNumericField("edge threshold height", (double)stored_edgeheight, 1);
        String[] labels = new String[]{"Show_filter stats", "Show_time stats", "Add labels"};
        boolean[] values = new boolean[]{stored_sstats, stored_tstats, stored_add_labels};
        gd.addCheckboxGroup(2, 2, labels, values);
        gd.addMessage("Incorrect values will be replaced by defaults.\nLabels are drawn in the foreground color.\nPress Esc to stop processing.");
        return this.getUserParams(gd);
    }

    private boolean getUserParams(GenericDialog gd) {
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        stored_nb_iter = this.nb_iter = (int)gd.getNextNumber();
        if (this.nb_iter < 1) {
            this.nb_iter = 1;
        }
        stored_nb_smoothings = this.nb_smoothings = (int)gd.getNextNumber();
        if (this.nb_smoothings < 1) {
            this.nb_smoothings = 1;
        }
        if (this.scount == 1) {
            stored_save = this.save = (int)gd.getNextNumber();
            if (this.save < 1 || this.save > this.nb_iter) {
                this.save = this.nb_iter;
            }
        } else {
            this.save = 0;
        }
        stored_a1 = this.a1 = (float)gd.getNextNumber();
        stored_a2 = this.a2 = (float)gd.getNextNumber();
        this.stored_dt = this.dt = gd.getNextNumber();
        stored_edgeheight = this.edgeheight = (float)gd.getNextNumber();
        stored_sstats = this.sstats = gd.getNextBoolean();
        stored_tstats = this.tstats = gd.getNextBoolean();
        stored_add_labels = this.add_labels = gd.getNextBoolean();
        return true;
    }

    public void run(ImageProcessor ip) {
        ImagePlus result;
        this.stack = this.imp.getStack();
        this.scount = this.stack.getSize();
        if (this.GUI() && null != (result = this.runTD(ip))) {
            result.show();
        }
    }

    public ImagePlus runTD(ImageProcessor ip) {
        ImageProcessor ip2;
        Date d2;
        Date d1 = new Date();
        if (null == this.stack) {
            this.stack = this.imp.getStack();
            this.scount = this.stack.getSize();
        }
        IJ.showStatus((String)"Initializing...");
        IJ.showProgress((double)0.0);
        if (this.sstats) {
            IJ.log((String)("\n--- " + this.imp.getShortTitle() + " --- a1=" + this.a1 + ", a2 = " + this.a2 + ", dt = " + this.dt));
        }
        int channels = ip instanceof ColorProcessor ? 3 : 1;
        Rectangle r = ip.getRoi();
        int width = r.width;
        int height = r.height;
        int totalwidth = ip.getWidth();
        int totalheight = ip.getHeight();
        ImageStack stack2 = this.imp.createEmptyStack();
        float[][][][] grad = new float[2][width][height][channels];
        float[][][] G = new float[width][height][3];
        float[][][] T = new float[width][height][3];
        float[][][] veloc = new float[width][height][3];
        float[][][] ipf = new float[width][height][channels];
        float[][][] ipfo = new float[width][height][channels];
        int[] pixel = new int[channels];
        long[] time = new long[6];
        boolean breaked = false;
        int iter = 0;
        float c1 = (float)(0.25 * (2.0 - Math.sqrt(2.0)));
        float c2 = (float)(0.5 * (Math.sqrt(2.0) - 1.0));
        if (this.tstats) {
            d2 = new Date();
            time[0] = d2.getTime() - d1.getTime();
        }
        int s = 0;
        while (s++ < this.scount && !breaked) {
            int k;
            int y;
            if (this.tstats) {
                d1 = new Date();
            }
            if (this.scount > 1) {
                ip = this.stack.getProcessor(s);
                IJ.showStatus((String)("Slice " + s + "/" + this.scount + "..."));
            }
            int x = width;
            while (x-- > 0) {
                int y2 = height;
                while (y2-- > 0) {
                    pixel = ip.getPixel(x + r.x, y2 + r.y, pixel);
                    int k2 = channels;
                    while (k2-- > 0) {
                        ipf[x][y2][k2] = pixel[k2];
                    }
                }
            }
            double average = 0.0;
            float initial_max = ipf[0][0][0];
            float initial_min = ipf[0][0][0];
            int x2 = width;
            while (x2-- > 0) {
                y = height;
                while (y-- > 0) {
                    k = channels;
                    while (k-- > 0) {
                        float pix = ipf[x2][y][k];
                        if (pix > initial_max) {
                            initial_max = pix;
                        }
                        if (pix < initial_min) {
                            initial_min = pix;
                        }
                        average += (double)pix;
                    }
                }
            }
            average /= (double)(width * height * channels);
            double stddev = 0.0;
            x2 = width;
            while (x2-- > 0) {
                y = height;
                while (y-- > 0) {
                    k = channels;
                    while (k-- > 0) {
                        float pix = ipf[x2][y][k];
                        stddev += ((double)pix - average) * ((double)pix - average);
                    }
                }
            }
            stddev = Math.sqrt(stddev / (double)(width * height * channels));
            double drange = (double)this.edgeheight * stddev / 256.0;
            double drange0 = 6.0 * stddev / 256.0;
            double drange2 = drange * drange;
            if (this.tstats) {
                d2 = new Date();
                time[0] = time[0] + (d2.getTime() - d1.getTime());
            }
            for (iter = 0; iter < this.nb_iter && !breaked; ++iter) {
                int y3;
                float Icn;
                float Ipn;
                float Ipc;
                if (this.scount == 1) {
                    IJ.showStatus((String)("Iteration " + (iter + 1) + "/" + this.nb_iter + "..."));
                }
                if (this.tstats) {
                    d1 = new Date();
                }
                float Inp = 0.0f;
                float Inc = 0.0f;
                float Inn = 0.0f;
                int x3 = width;
                while (x3-- > 0) {
                    int nx;
                    int px = x3 - 1;
                    if (px < 0) {
                        px = 0;
                    }
                    if ((nx = x3 + 1) == width) {
                        --nx;
                    }
                    int y4 = height;
                    while (y4-- > 0) {
                        int ny;
                        int py = y4 - 1;
                        if (py < 0) {
                            py = 0;
                        }
                        if ((ny = y4 + 1) == height) {
                            --ny;
                        }
                        int k3 = channels;
                        while (k3-- > 0) {
                            float Ipp = ipf[px][py][k3];
                            Ipc = ipf[px][y4][k3];
                            Ipn = ipf[px][ny][k3];
                            float Icp = ipf[x3][py][k3];
                            Icn = ipf[x3][ny][k3];
                            Inp = ipf[nx][py][k3];
                            Inc = ipf[nx][y4][k3];
                            Inn = ipf[nx][ny][k3];
                            float IppInn = c1 * (Inn - Ipp);
                            float IpnInp = c1 * (Ipn - Inp);
                            grad[0][x3][y4][k3] = IppInn - IpnInp - c2 * Ipc + c2 * Inc;
                            grad[1][x3][y4][k3] = IppInn + IpnInp - c2 * Icp + c2 * Icn;
                        }
                    }
                }
                if (this.tstats) {
                    d2 = new Date();
                    time[1] = time[1] + (d2.getTime() - d1.getTime());
                    d1 = new Date();
                }
                x3 = width;
                while (x3-- > 0) {
                    y3 = height;
                    while (y3-- > 0) {
                        G[x3][y3][0] = 0.0f;
                        G[x3][y3][1] = 0.0f;
                        G[x3][y3][2] = 0.0f;
                        int k4 = channels;
                        while (k4-- > 0) {
                            float fx = grad[0][x3][y3][k4];
                            float fy = grad[1][x3][y3][k4];
                            float[] fArray = G[x3][y3];
                            fArray[0] = fArray[0] + fx * fx;
                            float[] fArray2 = G[x3][y3];
                            fArray2[1] = fArray2[1] + fx * fy;
                            float[] fArray3 = G[x3][y3];
                            fArray3[2] = fArray3[2] + fy * fy;
                        }
                    }
                }
                if (this.tstats) {
                    d2 = new Date();
                    time[2] = time[2] + (d2.getTime() - d1.getTime());
                    d1 = new Date();
                }
                x3 = width;
                while (x3-- > 0) {
                    y3 = height;
                    while (y3-- > 0) {
                        double v;
                        double u;
                        double a = G[x3][y3][0];
                        double b = G[x3][y3][1];
                        double c = G[x3][y3][1];
                        double d = G[x3][y3][2];
                        double e = a + d;
                        double f = Math.sqrt(e * e - 4.0 * (a * d - b * c));
                        double l1 = 0.5 * (e - f);
                        double l2 = 0.5 * (e + f);
                        if (e > 0.0) {
                            if (l1 != 0.0) {
                                l2 = (a * d - b * c) / l1;
                            }
                        } else if (l2 != 0.0) {
                            l1 = (a * d - b * c) / l2;
                        }
                        float val1 = (float)(l2 / drange2);
                        float val2 = (float)(l1 / drange2);
                        float f1 = (double)this.a1 == 0.5 ? (float)(1.0 / Math.sqrt(1.0f + val1 + val2)) : (float)Math.pow(1.0f + val1 + val2, -this.a1);
                        float f2 = (float)Math.pow(1.0f + val1 + val2, -this.a2);
                        if (Math.abs(b) > Math.abs(a - l1)) {
                            u = 1.0;
                            v = (l1 - a) / b;
                        } else if (a - l1 != 0.0) {
                            u = -b / (a - l1);
                            v = 1.0;
                        } else {
                            u = 1.0;
                            v = 0.0;
                        }
                        double n = Math.sqrt(u * u + v * v);
                        float vec1 = (float)(u /= n);
                        float vec2 = (float)(v /= n);
                        float vec11 = vec1 * vec1;
                        float vec12 = vec1 * vec2;
                        float vec22 = vec2 * vec2;
                        T[x3][y3][0] = f1 * vec11 + f2 * vec22;
                        T[x3][y3][1] = (f1 - f2) * vec12;
                        T[x3][y3][2] = f1 * vec22 + f2 * vec11;
                    }
                }
                if (this.tstats) {
                    d2 = new Date();
                    time[3] = time[3] + (d2.getTime() - d1.getTime());
                    d1 = new Date();
                }
                double xdt = 0.0;
                for (int sit = 0; sit < this.nb_smoothings && !breaked; ++sit) {
                    IJ.showProgress((double)(this.scount == 1 ? (double)(((float)iter + (float)sit / (float)this.nb_smoothings) / (float)this.nb_iter) : (double)((float)s / (float)this.scount)));
                    Inn = 0.0f;
                    Inc = 0.0f;
                    Inp = 0.0f;
                    int x4 = width;
                    while (x4-- > 0) {
                        int nx;
                        int px = x4 - 1;
                        if (px < 0) {
                            px = 0;
                        }
                        if ((nx = x4 + 1) == width) {
                            --nx;
                        }
                        int y5 = height;
                        while (y5-- > 0) {
                            int ny;
                            int py = y5 - 1;
                            if (py < 0) {
                                py = 0;
                            }
                            if ((ny = y5 + 1) == height) {
                                --ny;
                            }
                            int k5 = channels;
                            while (k5-- > 0) {
                                float Ipp = ipf[px][py][k5];
                                Ipc = ipf[px][y5][k5];
                                Ipn = ipf[px][ny][k5];
                                float Icp = ipf[x4][py][k5];
                                float Icc = ipf[x4][y5][k5];
                                Icn = ipf[x4][ny][k5];
                                Inp = ipf[nx][py][k5];
                                Inc = ipf[nx][y5][k5];
                                Inn = ipf[nx][ny][k5];
                                float ixx = Inc + Ipc - 2.0f * Icc;
                                float iyy = Icn + Icp - 2.0f * Icc;
                                float ixy = 0.5f * (Ipp + Inn - Ipn - Inp);
                                veloc[x4][y5][k5] = T[x4][y5][0] * ixx + T[x4][y5][1] * ixy + T[x4][y5][2] * iyy;
                            }
                        }
                    }
                    if (this.dt > 0.0) {
                        float max = veloc[0][0][0];
                        float min = veloc[0][0][0];
                        int x5 = width;
                        while (x5-- > 0) {
                            int y6 = height;
                            while (y6-- > 0) {
                                int k6 = channels;
                                while (k6-- > 0) {
                                    if (veloc[x5][y6][k6] > max) {
                                        max = veloc[x5][y6][k6];
                                    }
                                    if (!(veloc[x5][y6][k6] < min)) continue;
                                    min = veloc[x5][y6][k6];
                                }
                            }
                        }
                        xdt = this.dt / (double)Math.max(Math.abs(max), Math.abs(min)) * drange0;
                    } else {
                        xdt = -this.dt;
                    }
                    if (this.tstats) {
                        d2 = new Date();
                        time[4] = time[4] + (d2.getTime() - d1.getTime());
                        d1 = new Date();
                    }
                    x4 = width;
                    while (x4-- > 0) {
                        int y7 = height;
                        while (y7-- > 0) {
                            int k7 = channels;
                            while (k7-- > 0) {
                                double ipfnew = (double)ipf[x4][y7][k7] + (double)veloc[x4][y7][k7] * xdt;
                                ipf[x4][y7][k7] = (float)ipfnew;
                                if (ipf[x4][y7][k7] < initial_min) {
                                    ipf[x4][y7][k7] = initial_min;
                                }
                                if (!(ipf[x4][y7][k7] > initial_max)) continue;
                                ipf[x4][y7][k7] = initial_max;
                            }
                        }
                    }
                    breaked = IJ.escapePressed();
                    if (!breaked) continue;
                    IJ.beep();
                }
                if (this.scount == 1 && (this.save > 0 && (iter + 1) % this.save == 0 || breaked) || iter == this.nb_iter - 1) {
                    ip2 = ip.createProcessor(totalwidth, totalheight);
                    x3 = totalwidth;
                    while (x3-- > 0) {
                        y3 = totalheight;
                        while (y3-- > 0) {
                            int k8 = channels;
                            while (k8-- > 0) {
                                if (x3 < r.x || x3 >= r.x + width || y3 < r.y || y3 >= r.y + height) {
                                    ip2.putPixel(x3, y3, ip.getPixel(x3, y3));
                                    continue;
                                }
                                pixel[k8] = (int)ipf[x3 - r.x][y3 - r.y][k8];
                                ip2.putPixel(x3, y3, pixel);
                            }
                        }
                    }
                    if (this.scount == 1) {
                        if (this.add_labels) {
                            if (this.label_color == null) {
                                this.label_color = Toolbar.getForegroundColor();
                                this.font = new Font("SansSerif", 0, this.font_size);
                            }
                            ip2.setColor(this.label_color);
                            ip2.setFont(this.font);
                            ip2.drawString("iterations: " + (iter + 1), 5, (int)((double)this.font_size * 1.3));
                        }
                        if (this.imp2 == null) {
                            stack2 = new ImageStack(ip2.getWidth(), ip2.getHeight());
                            stack2.addSlice("iter" + (iter + 1), ip2);
                            this.imp2 = new ImagePlus(this.imp.getShortTitle() + "-iter" + (iter + 1) + (breaked ? "-interrupted" : ""), stack2);
                        } else {
                            stack2.addSlice("iter" + (iter + 1), ip2);
                            this.imp2.setStack(null, stack2);
                            this.imp2.setSlice(this.imp2.getStackSize());
                            this.imp2.setTitle(this.imp.getShortTitle() + "-iter" + (iter + 1));
                        }
                    } else {
                        stack2.addSlice(this.stack.getSliceLabel(s), ip2);
                    }
                }
                if (this.sstats) {
                    IJ.log((String)("\riter " + (iter + 1) + ", xdt = " + xdt));
                }
                if (!this.tstats) continue;
                d2 = new Date();
                time[5] = time[5] + (d2.getTime() - d1.getTime());
            }
        }
        if (this.imp2 != null && this.imp2.getStackSize() > 1) {
            ip2 = this.imp.getProcessor().duplicate();
            if (this.add_labels) {
                ip2.setColor(this.label_color);
                ip2.setFont(this.font);
                ip2.drawString("original", 5, (int)((double)this.font_size * 1.3));
            }
            stack2.addSlice("orig", ip2, 0);
            this.imp2.setStack(null, stack2);
            this.imp2.setSlice(this.imp2.getStackSize());
        }
        IJ.showProgress((double)1.0);
        if (this.tstats) {
            IJ.log((String)"\r--- time statistics ---");
            IJ.log((String)("\rinitialization = " + time[0] + " ms"));
            IJ.log((String)("\rgradients = " + time[1] + " ms"));
            IJ.log((String)("\rG tensor field = " + time[2] + " ms"));
            IJ.log((String)("\rT tensor field = " + time[3] + " ms"));
            IJ.log((String)("\rvelocity = " + time[4] + " ms"));
            IJ.log((String)("\rupdate image = " + time[5] + " ms"));
        }
        if (this.scount > 1) {
            return new ImagePlus(this.imp.getShortTitle() + "-iter" + this.nb_iter, stack2);
        }
        return this.imp2;
    }
}

