/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.SurfacenessProcessor;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;

public class Surfaceness_
implements PlugIn {
    public void run(String ignored) {
        ImagePlus original = WindowManager.getCurrentImage();
        if (original == null) {
            IJ.error((String)"No current image to calculate surfaceness of.");
            return;
        }
        if (original.getStackSize() == 1) {
            IJ.error((String)"It only makes sense to look for Sufaceness of 3D images (stacks)");
            return;
        }
        Calibration calibration = original.getCalibration();
        double minimumSeparation = 1.0;
        if (calibration != null) {
            minimumSeparation = Math.min(calibration.pixelWidth, Math.min(calibration.pixelHeight, calibration.pixelDepth));
        }
        GenericDialog gd = new GenericDialog("\"Surfaceness\" Filter");
        gd.addNumericField("Sigma: ", calibration == null ? 1.0 : minimumSeparation, 4);
        gd.addMessage("(The default value for sigma is the pixel width.)");
        gd.addCheckbox("Use calibration information", calibration != null);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double sigma = gd.getNextNumber();
        if (sigma <= 0.0) {
            IJ.error((String)"The value of sigma must be positive");
            return;
        }
        boolean useCalibration = gd.getNextBoolean();
        SurfacenessProcessor sp = new SurfacenessProcessor(sigma, useCalibration);
        ImagePlus result = sp.generateImage(original);
        result.setTitle("surfaceness of " + original.getTitle());
        result.show();
    }
}

