/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import util.ModelessQuestions;
import util.OverlayRegistered;

public class Overlay_Registered
extends OverlayRegistered
implements PlugIn {
    public void run(String ignored) {
        int i;
        int[] wList;
        String macroOptions = Macro.getOptions();
        String mustHaveSubstring = "";
        Object titleSubstring = null;
        boolean closeAllOthers = false;
        if (macroOptions != null) {
            String value = Macro.getValue((String)macroOptions, (String)"substring", null);
            if (value != null) {
                mustHaveSubstring = value;
            }
            if ((value = Macro.getValue((String)macroOptions, (String)"keep", null)) != null) {
                System.out.println("Got keep!: '" + value + "'");
            }
            if ((value = Macro.getValue((String)macroOptions, (String)"close", null)) != null) {
                System.out.println("Got close!: '" + value + "'");
            }
        }
        if ((wList = WindowManager.getIDList()) == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        if (wList.length < 2) {
            IJ.error((String)"Must have at least two images open.");
            return;
        }
        ArrayList<String> matchingTitles = new ArrayList<String>();
        ArrayList<ImagePlus> matchingImages = new ArrayList<ImagePlus>();
        ImagePlus[] matchingImagePlus = new ImagePlus[wList.length];
        ImagePlus[] allImages = new ImagePlus[wList.length];
        boolean totalMatchingTitles = false;
        for (int i2 = 0; i2 < wList.length; ++i2) {
            String title;
            ImagePlus imp = WindowManager.getImage((int)wList[i2]);
            String string = title = imp != null ? imp.getTitle() : "";
            if (title.indexOf(mustHaveSubstring) >= 0) {
                System.out.println("Yes, matched: " + title);
                matchingTitles.add(title);
                matchingImages.add(imp);
                continue;
            }
            System.out.println("No, didn't match '' in: " + title);
        }
        if (matchingTitles.size() < 2) {
            IJ.error((String)("Fewer than two images matched the substring '" + mustHaveSubstring + "'"));
            return;
        }
        GenericDialog gd = new GenericDialog("Overlay Transformed");
        gd.addChoice("A:", matchingTitles.toArray(new String[1]), (String)matchingTitles.get(0));
        gd.addChoice("B:", matchingTitles.toArray(new String[1]), (String)matchingTitles.get(1));
        gd.addCheckbox("Keep source images", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        ImagePlus[] sourceImages = new ImagePlus[]{(ImagePlus)matchingImages.get(index[0]), (ImagePlus)matchingImages.get(index[1])};
        ImagePlus rgbResult = Overlay_Registered.overlayToImagePlus((ImagePlus)sourceImages[0], (ImagePlus)sourceImages[1]);
        rgbResult.show();
        ModelessQuestions q = new ModelessQuestions("Rate This Registration", rgbResult);
        q.addTextField("I dunno", 20, "Your message:");
        q.addTextField("Well", 10, "Something");
        q.addLabel("Just a label.");
        q.addCompletingButton("ok", "Done");
        q.addCompletingButton("unhappy", "Rubbish!");
        for (i = 0; i <= 10; ++i) {
            q.addRadio("rating", "" + i);
        }
        q.waitForAnswers();
        IJ.error((String)"Finished waiting for answers!");
        if (closeAllOthers) {
            for (i = 0; i < allImages.length; ++i) {
                allImages[i].close();
            }
        }
    }
}

