/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import mpicbg.ij.integral.BlockStatistics;

public class NormalizeLocalContrast
extends BlockStatistics {
    protected final FloatProcessor fpOriginal;

    public NormalizeLocalContrast(FloatProcessor fp) {
        super(fp);
        this.fpOriginal = (FloatProcessor)fp.duplicate();
        this.fpOriginal.setMinAndMax(fp.getMin(), fp.getMax());
    }

    protected void runCenter(int blockRadiusX, int blockRadiusY) {
        this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        int width = this.fp.getWidth();
        int height = this.fp.getHeight();
        double fpMin = this.fp.getMin();
        double fpLength = this.fp.getMax() - fpMin;
        double fpMean = fpLength / 2.0 + fpMin;
        int w = width - 1;
        int h = height - 1;
        for (int y = 0; y < height; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x < width; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale = 1.0 / (double)bs;
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                int i = row + x;
                double mean = sum * scale;
                float v = this.fp.getf(i);
                this.fp.setf(i, (float)((double)v - mean + fpMean));
            }
        }
    }

    protected void runStretch(int blockRadiusX, int blockRadiusY, float meanFactor) {
        this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        int width = this.fp.getWidth();
        int height = this.fp.getHeight();
        double fpMin = this.fp.getMin();
        double fpLength = this.fp.getMax() - fpMin;
        double fpMean = fpLength / 2.0 + fpMin;
        int w = width - 1;
        int h = height - 1;
        for (int y = 0; y < height; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x < width; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                int i = row + x;
                double std = var < 0.0 ? 0.0 : Math.sqrt(var);
                float v = this.fp.getf(i);
                double d = (double)meanFactor * std;
                this.fp.setf(i, (float)(((double)v - fpMean) / 2.0 / d * fpLength + fpMean));
            }
        }
    }

    protected void runCenterStretch(int blockRadiusX, int blockRadiusY, float meanFactor) {
        this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        int width = this.fp.getWidth();
        int height = this.fp.getHeight();
        double fpMin = this.fp.getMin();
        double fpLength = this.fp.getMax() - fpMin;
        int w = width - 1;
        int h = height - 1;
        for (int y = 0; y < height; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x < width; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale = 1.0 / (double)bs;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                int i = row + x;
                double mean = sum * scale;
                double std = var < 0.0 ? 0.0 : Math.sqrt(var);
                float v = this.fp.getf(i);
                double d = (double)meanFactor * std;
                double min = mean - d;
                this.fp.setf(i, (float)(((double)v - min) / 2.0 / d * fpLength + fpMin));
            }
        }
    }

    public void run(int blockRadiusX, int blockRadiusY, float meanFactor, boolean center, boolean stretch) {
        if (center) {
            if (stretch) {
                this.runCenterStretch(blockRadiusX, blockRadiusY, meanFactor);
            } else {
                this.runCenter(blockRadiusX, blockRadiusY);
            }
        } else if (stretch) {
            this.runStretch(blockRadiusX, blockRadiusY, meanFactor);
        } else {
            this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        }
    }
}

