/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.TranslationModel2D;

public class SimilarityModel2D
extends AbstractAffineModel2D<SimilarityModel2D> {
    private static final long serialVersionUID = -2002621576568975203L;
    protected static final int MIN_NUM_MATCHES = 2;
    protected double scos = 1.0;
    protected double ssin = 0.0;
    protected double tx = 0.0;
    protected double ty = 0.0;
    private double iscos = 1.0;
    private double issin = 0.0;
    private double itx = 0.0;
    private double ity = 0.0;

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.scos, this.ssin, -this.ssin, this.scos, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.iscos, this.issin, -this.issin, this.iscos, this.itx, this.ity);
    }

    @Override
    public final double[] apply(double[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = this.scos * l0 - this.ssin * l[1] + this.tx;
        l[1] = this.ssin * l0 + this.scos * l[1] + this.ty;
    }

    @Override
    public final double[] applyInverse(double[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) {
        assert (l.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = this.iscos * l0 - this.issin * l[1] + this.itx;
        l[1] = this.issin * l0 + this.iscos * l[1] + this.ity;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double scosd = 0.0;
        double ssind = 0.0;
        ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            double x1 = pX[i] - pcx;
            double y1 = pY[i] - pcy;
            double x2 = qX[i] - qcx + dx;
            double y2 = qY[i] - qcy + dy;
            ssind += ww * (x1 * y2 - y1 * x2);
            scosd += ww * (x1 * x2 + y1 * y2);
            ws += ww * (x1 * x1 + y1 * y1);
        }
        this.scos = scosd /= ws;
        this.ssin = ssind /= ws;
        this.tx = qcx - scosd * pcx + ssind * pcy;
        this.ty = qcy - ssind * pcx - scosd * pcy;
        this.invert();
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d similarity transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double scosd = 0.0;
        double ssind = 0.0;
        ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            double x1 = (double)pX[i] - pcx;
            double y1 = (double)pY[i] - pcy;
            double x2 = (double)qX[i] - qcx + dx;
            double y2 = (double)qY[i] - qcy + dy;
            ssind += ww * (x1 * y2 - y1 * x2);
            scosd += ww * (x1 * x2 + y1 * y2);
            ws += ww * (x1 * x1 + y1 * y1);
        }
        this.scos = scosd /= ws;
        this.ssin = ssind /= ws;
        this.tx = qcx - scosd * pcx + ssind * pcy;
        this.ty = qcy - ssind * pcx - scosd * pcy;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            qcx += w * q[0];
            qcy += w * q[1];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double scosd = 0.0;
        double ssind = 0.0;
        ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double x1 = p[0] - pcx;
            double y1 = p[1] - pcy;
            double x2 = q[0] - qcx + dx;
            double y2 = q[1] - qcy + dy;
            ssind += w * (x1 * y2 - y1 * x2);
            scosd += w * (x1 * x2 + y1 * y2);
            ws += w * (x1 * x1 + y1 * y1);
        }
        this.scos = scosd /= ws;
        this.ssin = ssind /= ws;
        this.tx = qcx - scosd * pcx + ssind * pcy;
        this.ty = qcy - ssind * pcx - scosd * pcy;
        this.invert();
    }

    @Override
    public SimilarityModel2D copy() {
        SimilarityModel2D m = new SimilarityModel2D();
        m.scos = this.scos;
        m.ssin = this.ssin;
        m.tx = this.tx;
        m.ty = this.ty;
        m.iscos = this.iscos;
        m.issin = this.issin;
        m.itx = this.itx;
        m.ity = this.ity;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(SimilarityModel2D m) {
        this.scos = m.scos;
        this.ssin = m.ssin;
        this.tx = m.tx;
        this.ty = m.ty;
        this.iscos = m.iscos;
        this.issin = m.issin;
        this.itx = m.itx;
        this.ity = m.ity;
        this.cost = m.cost;
    }

    public final void reset() {
        this.scos = 1.0;
        this.ssin = 0.0;
        this.tx = 0.0;
        this.ty = 0.0;
        this.iscos = 1.0;
        this.issin = 0.0;
        this.itx = 0.0;
        this.ity = 0.0;
        this.cost = Double.MAX_VALUE;
    }

    @Override
    public final void set(TranslationModel2D m) {
        this.reset();
        this.tx = m.tx;
        this.ty = m.ty;
        this.cost = m.getCost();
        this.invert();
    }

    @Override
    public final void set(RigidModel2D m) {
        this.scos = m.cos;
        this.ssin = m.sin;
        this.tx = m.tx;
        this.ty = m.ty;
        this.cost = m.getCost();
        this.invert();
    }

    protected final void invert() {
        double det = this.scos * this.scos + this.ssin * this.ssin;
        this.iscos = this.scos / det;
        this.issin = -this.ssin / det;
        this.itx = (-this.ssin * this.ty - this.scos * this.tx) / det;
        this.ity = (this.ssin * this.tx - this.scos * this.ty) / det;
    }

    @Override
    public final void preConcatenate(SimilarityModel2D model) {
        double a = model.scos * this.scos - model.ssin * this.ssin;
        double b = model.ssin * this.scos + model.scos * this.ssin;
        double c = model.scos * this.tx - model.ssin * this.ty + model.tx;
        double d = model.ssin * this.tx + model.scos * this.ty + model.ty;
        this.scos = a;
        this.ssin = b;
        this.tx = c;
        this.ty = d;
        this.invert();
    }

    @Override
    public final void concatenate(SimilarityModel2D model) {
        double a = this.scos * model.scos - this.ssin * model.ssin;
        double b = this.ssin * model.scos + this.scos * model.ssin;
        double c = this.scos * model.tx - this.ssin * model.ty + this.tx;
        double d = this.ssin * model.tx + this.scos * model.ty + this.ty;
        this.scos = a;
        this.ssin = b;
        this.tx = c;
        this.ty = d;
        this.invert();
    }

    public final void setScaleRotationTranslation(double s, double theta, double tx, double ty) {
        this.set(s * Math.cos(theta), s * Math.sin(theta), tx, ty);
    }

    public final void set(double scos, double ssin, double tx, double ty) {
        this.scos = scos;
        this.ssin = ssin;
        this.tx = tx;
        this.ty = ty;
        this.invert();
    }

    @Override
    public SimilarityModel2D createInverse() {
        SimilarityModel2D ict = new SimilarityModel2D();
        ict.scos = this.iscos;
        ict.ssin = this.issin;
        ict.tx = this.itx;
        ict.ty = this.ity;
        ict.iscos = this.scos;
        ict.issin = this.ssin;
        ict.itx = this.tx;
        ict.ity = this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.scos;
        data[1] = this.ssin;
        data[2] = -this.ssin;
        data[3] = this.scos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.scos;
        data[0][1] = -this.ssin;
        data[0][2] = this.tx;
        data[1][0] = this.ssin;
        data[1][1] = this.scos;
        data[1][2] = this.ty;
    }
}

