/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.dsp.HilbertTransformFilter;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HilbertTransformFilterTest
extends TestCase {
    private static final int NMAX_DEFAULT = 100000;
    private static final float EMAX_DEFAULT = 0.01f;
    private static final float FMIN_DEFAULT = 0.025f;
    private static final float FMAX_DEFAULT = 0.475f;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(HilbertTransformFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void testApply() {
        int[] nmax_test = new int[]{100000, 100000, 100000, 100000, 100000};
        float[] emax_test = new float[]{0.01f, 0.01f, 0.01f, 0.001f, 0.001f};
        float[] fmin_test = new float[]{0.025f, 0.05f, 0.025f, 0.1f, 0.01f};
        float[] fmax_test = new float[]{0.475f, 0.475f, 0.45f, 0.4f, 0.49f};
        int ntest = emax_test.length;
        for (int itest = 0; itest < ntest; ++itest) {
            int lhtf;
            int nmax = nmax_test[itest];
            float emax = emax_test[itest];
            float fmin = fmin_test[itest];
            float fmax = fmax_test[itest];
            HilbertTransformFilter htf = new HilbertTransformFilter(nmax, emax, fmin, fmax);
            int nxy = lhtf = htf.length();
            float[] x = new float[nxy];
            x[(lhtf - 1) / 2] = 1.0f;
            float[] y = new float[nxy];
            htf.apply(nxy, x, y);
            int nfft = FftReal.nfftSmall(16 * nxy);
            FftReal fft = new FftReal(nfft);
            int mfft = nfft / 2 + 1;
            float[] hfft = new float[2 * mfft];
            for (int i = 0; i < nxy; ++i) {
                hfft[i] = y[i];
            }
            fft.realToComplex(1, hfft, hfft);
            int jfmin = 1 + (int)(fmin * (float)nfft);
            int jfmax = (int)(fmax * (float)nfft);
            float[] afft = ArrayMath.abs(ArrayMath.sub(ArrayMath.cabs(hfft), 1.0f));
            float error = ArrayMath.max(ArrayMath.copy(1 + jfmax - jfmin, jfmin, afft));
            HilbertTransformFilterTest.assertTrue((String)"actual error less than maximum expected error", (error <= emax ? 1 : 0) != 0);
        }
    }
}

