/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class LineSearch {
    public static final int CONVERGED = 1;
    public static final int SMIN = 2;
    public static final int SMAX = 3;
    public static final int STOL = 4;
    public static final int FAILED = 5;
    private static final double SLO_FACTOR = 1.1;
    private static final double SHI_FACTOR = 4.0;
    private final Function _func;
    private final double _stol;
    private final double _ftol;
    private final double _gtol;

    public LineSearch(Function func, double stol, double ftol, double gtol) {
        Check.argument(stol >= 0.0, "stol>=0.0");
        Check.argument(ftol >= 0.0, "ftol>=0.0");
        Check.argument(gtol >= 0.0, "gtol>=0.0");
        this._func = func;
        this._stol = stol;
        this._ftol = ftol;
        this._gtol = gtol;
    }

    public Result search(double s, double f, double g, double smin, double smax) {
        Check.argument(smin >= 0.0, "smin>=0.0");
        Check.argument(smin <= smax, "smin<=smax");
        Check.argument(smin <= s, "smin<=s");
        Check.argument(s <= smax, "s<=smax");
        Check.argument(g < 0.0, "g<0.0");
        StepInterval si = new StepInterval();
        double finit = f;
        double ginit = g;
        double gtest = this._ftol * ginit;
        double width = smax - smin;
        double widthOld = 2.0 * width;
        double fa = finit;
        double ga = ginit;
        double fb = finit;
        double gb = ginit;
        double shi = s * 5.0;
        double[] fg = this._func.evaluate(s);
        f = fg[0];
        g = fg[1];
        int neval = 1;
        int ended = 0;
        double slo = 0.0;
        double sb = 0.0;
        double sa = 0.0;
        boolean bracketed = false;
        boolean stage1 = true;
        while (ended == 0) {
            double ftest = finit + s * gtest;
            if (stage1 && f <= ftest && g >= 0.0) {
                stage1 = false;
            }
            if (bracketed && (s <= slo || s >= shi)) {
                ended = 5;
            } else if (bracketed && shi - slo <= this._stol * shi) {
                ended = 4;
            } else if (s == smax && f <= ftest && g <= gtest) {
                ended = 3;
            } else if (s == smin && (f > ftest || g >= gtest)) {
                ended = 2;
            } else if (f <= ftest && MathPlus.abs(g) <= this._gtol * -ginit) {
                ended = 1;
            } else {
                if (stage1 && f <= fa && f > ftest) {
                    double fm = f - s * gtest;
                    double fam = fa - sa * gtest;
                    double fbm = fb - sb * gtest;
                    double gm = g - gtest;
                    double gam = ga - gtest;
                    double gbm = gb - gtest;
                    si.sa = sa;
                    si.fa = fam;
                    si.ga = gam;
                    si.sb = sb;
                    si.fb = fbm;
                    si.gb = gbm;
                    si.bracketed = bracketed;
                    s = this.updateStep(s, fm, gm, slo, shi, si);
                    sa = si.sa;
                    fam = si.fa;
                    gam = si.ga;
                    sb = si.sb;
                    fbm = si.fb;
                    gbm = si.gb;
                    bracketed = si.bracketed;
                    fa = fam + sa * gtest;
                    fb = fbm + sb * gtest;
                    ga = gam + gtest;
                    gb = gbm + gtest;
                } else {
                    si.sa = sa;
                    si.fa = fa;
                    si.ga = ga;
                    si.sb = sb;
                    si.fb = fb;
                    si.gb = gb;
                    si.bracketed = bracketed;
                    s = this.updateStep(s, f, g, slo, shi, si);
                    sa = si.sa;
                    fa = si.fa;
                    ga = si.ga;
                    sb = si.sb;
                    fb = si.fb;
                    gb = si.gb;
                    bracketed = si.bracketed;
                }
                if (bracketed) {
                    if (MathPlus.abs(sb - sa) >= 0.66 * widthOld) {
                        s = sa + 0.5 * (sb - sa);
                    }
                    widthOld = width;
                    width = MathPlus.abs(sb - sa);
                }
                if (bracketed) {
                    slo = MathPlus.min(sa, sb);
                    shi = MathPlus.max(sa, sb);
                } else {
                    slo = s + 1.1 * (s - sa);
                    shi = s + 4.0 * (s - sa);
                }
                s = MathPlus.max(s, smin);
                s = MathPlus.min(s, smax);
                if (bracketed && (s <= slo || s >= shi) || bracketed && shi - slo <= this._stol * shi) {
                    s = sa;
                }
            }
            fg = this._func.evaluate(s);
            f = fg[0];
            g = fg[1];
            ++neval;
        }
        return new Result(s, f, g, ended, neval);
    }

    private double updateStep(double sp, double fp, double gp, double smin, double smax, StepInterval si) {
        double sa = si.sa;
        double fa = si.fa;
        double ga = si.ga;
        double sb = si.sb;
        double fb = si.fb;
        double gb = si.gb;
        boolean bracketed = si.bracketed;
        double sgng = gp * (ga / MathPlus.abs(ga));
        double spf = sp;
        if (fp > fa) {
            double theta = 3.0 * (fa - fp) / (sp - sa) + ga + gp;
            double s = MathPlus.max(MathPlus.abs(theta), MathPlus.abs(ga), MathPlus.abs(gp));
            double gamma = s * MathPlus.sqrt(theta / s * (theta / s) - ga / s * (gp / s));
            if (sp < sa) {
                gamma = -gamma;
            }
            double p = gamma - ga + theta;
            double q = gamma - ga + gamma + gp;
            double r = p / q;
            double spc = sa + r * (sp - sa);
            double spq = sa + ga / ((fa - fp) / (sp - sa) + ga) / 2.0 * (sp - sa);
            spf = MathPlus.abs(spc - sa) < MathPlus.abs(spq - sa) ? spc : spc + (spq - spc) / 2.0;
            bracketed = true;
        } else if (sgng < 0.0) {
            double theta = 3.0 * (fa - fp) / (sp - sa) + ga + gp;
            double s = MathPlus.max(MathPlus.abs(theta), MathPlus.abs(ga), MathPlus.abs(gp));
            double gamma = s * MathPlus.sqrt(theta / s * (theta / s) - ga / s * (gp / s));
            if (sp > sa) {
                gamma = -gamma;
            }
            double p = gamma - gp + theta;
            double q = gamma - gp + gamma + ga;
            double r = p / q;
            double spc = sp + r * (sa - sp);
            double spq = sp + gp / (gp - ga) * (sa - sp);
            spf = MathPlus.abs(spc - sp) > MathPlus.abs(spq - sp) ? spc : spq;
            bracketed = true;
        } else if (MathPlus.abs(gp) < MathPlus.abs(ga)) {
            double q;
            double p;
            double r;
            double theta = 3.0 * (fa - fp) / (sp - sa) + ga + gp;
            double s = MathPlus.max(MathPlus.abs(theta), MathPlus.abs(ga), MathPlus.abs(gp));
            double gamma = s * MathPlus.sqrt(MathPlus.max(0.0, theta / s * (theta / s) - ga / s * (gp / s)));
            if (sp > sa) {
                gamma = -gamma;
            }
            double spc = (r = (p = gamma - gp + theta) / (q = gamma + (ga - gp) + gamma)) < 0.0 && gamma != 0.0 ? sp + r * (sa - sp) : (sp > sa ? smax : smin);
            double spq = sp + gp / (gp - ga) * (sa - sp);
            if (bracketed) {
                spf = MathPlus.abs(spc - sp) < MathPlus.abs(spq - sp) ? spc : spq;
                spf = sp > sa ? MathPlus.min(sp + 0.66 * (sb - sp), spf) : MathPlus.max(sp + 0.66 * (sb - sp), spf);
            } else {
                spf = MathPlus.abs(spc - sp) > MathPlus.abs(spq - sp) ? spc : spq;
                spf = MathPlus.min(smax, spf);
                spf = MathPlus.max(smin, spf);
            }
        } else if (bracketed) {
            double spc;
            double theta = 3.0 * (fp - fb) / (sb - sp) + gb + gp;
            double s = MathPlus.max(MathPlus.abs(theta), MathPlus.abs(gb), MathPlus.abs(gp));
            double gamma = s * MathPlus.sqrt(theta / s * (theta / s) - gb / s * (gp / s));
            if (sp > sb) {
                gamma = -gamma;
            }
            double p = gamma - gp + theta;
            double q = gamma - gp + gamma + gb;
            double r = p / q;
            spf = spc = sp + r * (sb - sp);
        } else {
            spf = sp > sa ? smax : smin;
        }
        if (fp > fa) {
            si.sb = sp;
            si.fb = fp;
            si.gb = gp;
        } else {
            if (sgng < 0.0) {
                si.sb = sa;
                si.fb = fa;
                si.gb = ga;
            }
            si.sa = sp;
            si.fa = fp;
            si.ga = gp;
        }
        si.bracketed = bracketed;
        return spf;
    }

    private static class StepInterval {
        double sa = 0.0;
        double fa = 0.0;
        double ga = 0.0;
        double sb = 0.0;
        double fb = 0.0;
        double gb = 0.0;
        boolean bracketed = false;

        private StepInterval() {
        }
    }

    public static class Result {
        public final double s;
        public final double f;
        public final double g;
        public final int ended;
        public final int neval;

        public boolean converged() {
            return this.ended == 1;
        }

        private Result(double s, double f, double g, int ended, int neval) {
            this.s = s;
            this.f = f;
            this.g = g;
            this.ended = ended;
            this.neval = neval;
        }
    }

    public static interface Function {
        public double[] evaluate(double var1);
    }
}

