/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Cfloat;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayMathTest
extends TestCase {
    private static final int SAWTOOTH = 0;
    private static final int RAND = 1;
    private static final int STAGGER = 2;
    private static final int PLATEAU = 3;
    private static final int SHUFFLE = 4;
    private static final int COPY = 0;
    private static final int REV = 1;
    private static final int REVHALF1 = 2;
    private static final int REVHALF2 = 3;
    private static final int SORT = 4;
    private static final int DITHER = 5;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ArrayMathTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSort() {
        int[] ntest;
        Random r = new Random(314159L);
        for (int n : ntest = new int[]{100, 1023, 1024, 1025}) {
            float[] x = new float[n];
            for (int m = 1; m < 2 * n; m *= 2) {
                for (int dist = 0; dist < 5; ++dist) {
                    int j = 0;
                    int k = 1;
                    for (int i = 0; i < n; ++i) {
                        int ix = 0;
                        switch (dist) {
                            case 0: {
                                ix = i % m;
                                break;
                            }
                            case 1: {
                                ix = r.nextInt() % m;
                                break;
                            }
                            case 2: {
                                ix = (i * m + i) % n;
                                break;
                            }
                            case 3: {
                                ix = ArrayMath.min(i, m);
                                break;
                            }
                            case 4: {
                                ix = r.nextInt() % m != 0 ? (j += 2) : (k += 2);
                            }
                        }
                        x[i] = ix;
                    }
                    for (int order = 0; order < 6; ++order) {
                        float[] y = null;
                        switch (order) {
                            case 0: {
                                y = ArrayMath.copy(x);
                                break;
                            }
                            case 1: {
                                y = ArrayMath.reverse(x);
                                break;
                            }
                            case 2: {
                                y = ArrayMath.copy(x);
                                float[] z = ArrayMath.reverse(ArrayMath.copy(n / 2, x));
                                ArrayMath.copy(n / 2, 0, z, 0, y);
                                break;
                            }
                            case 3: {
                                y = ArrayMath.copy(x);
                                float[] z = ArrayMath.reverse(ArrayMath.copy(n / 2, n / 2, x));
                                ArrayMath.copy(n / 2, 0, z, n / 2, y);
                                break;
                            }
                            case 4: {
                                y = ArrayMath.copy(x);
                                Arrays.sort(y);
                                break;
                            }
                            case 5: {
                                y = ArrayMath.copy(x);
                                for (int i = 0; i < n; ++i) {
                                    int n2 = i;
                                    y[n2] = y[n2] + (float)(i % 5);
                                }
                                break;
                            }
                        }
                        this.sortAndCheck(y);
                    }
                }
            }
        }
    }

    private void sortAndCheck(float[] x) {
        int j;
        int i;
        int n = x.length;
        float[] x1 = ArrayMath.copy(x);
        for (int k = 0; k < n; k += n / 4) {
            ArrayMath.quickPartialSort(k, x1);
            for (i = 0; i < k; ++i) {
                ArrayMathTest.assertTrue((x1[i] <= x1[k] ? 1 : 0) != 0);
            }
            for (i = k; i < n; ++i) {
                ArrayMathTest.assertTrue((x1[k] <= x1[i] ? 1 : 0) != 0);
            }
        }
        float[] x2 = ArrayMath.copy(x);
        ArrayMath.quickSort(x2);
        for (i = 1; i < n; ++i) {
            ArrayMathTest.assertTrue((x2[i - 1] <= x2[i] ? 1 : 0) != 0);
        }
        int[] i1 = ArrayMath.rampint(0, 1, n);
        for (int k = 0; k < n; k += n / 4) {
            ArrayMath.quickPartialIndexSort(k, x, i1);
            for (j = 0; j < k; ++j) {
                ArrayMathTest.assertTrue((x[i1[j]] <= x[i1[k]] ? 1 : 0) != 0);
            }
            for (j = k + 1; j < n; ++j) {
                ArrayMathTest.assertTrue((x[i1[k]] <= x[i1[j]] ? 1 : 0) != 0);
            }
        }
        int[] i2 = ArrayMath.rampint(0, 1, n);
        ArrayMath.quickIndexSort(x, i2);
        for (j = 1; j < n; ++j) {
            ArrayMathTest.assertTrue((x[i2[j - 1]] <= x[i2[j]] ? 1 : 0) != 0);
        }
    }

    public void testFloat1() {
        int n1 = 8;
        int n2 = 6;
        int n3 = 4;
        float[] a1 = ArrayMath.rampfloat(0.0f, 1.0f, n1);
        float[][] a2 = ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, n1, n2);
        float[][][] a3 = ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1, n2, n3);
        float[] b1 = ArrayMath.copy(a1);
        float[][] b2 = ArrayMath.copy(a2);
        float[][][] b3 = ArrayMath.copy(a3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        ArrayMath.copy(a1, b1);
        ArrayMath.copy(a2, b2);
        ArrayMath.copy(a3, b3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        b1 = ArrayMath.copy(n1 - 1, a1);
        b2 = ArrayMath.copy(n1 - 1, n2 - 1, a2);
        b3 = ArrayMath.copy(n1 - 1, n2 - 1, n3 - 1, a3);
        this.assertEqual(b1, ArrayMath.rampfloat(0.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        ArrayMath.copy(n1 - 1, a1, b1);
        ArrayMath.copy(n1 - 1, n2 - 1, a2, b2);
        ArrayMath.copy(n1 - 1, n2 - 1, n3 - 1, a3, b3);
        this.assertEqual(b1, ArrayMath.rampfloat(0.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        b1 = ArrayMath.copy(n1 - 1, 1, a1);
        b2 = ArrayMath.copy(n1 - 2, n2 - 1, 2, 1, a2);
        b3 = ArrayMath.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3);
        this.assertEqual(b1, ArrayMath.rampfloat(1.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, ArrayMath.rampfloat(12.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.rampfloat(123.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        ArrayMath.copy(n1 - 1, 1, a1, 0, b1);
        ArrayMath.copy(n1 - 2, n2 - 1, 2, 1, a2, 0, 0, b2);
        ArrayMath.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 0, 0, 0, b3);
        this.assertEqual(b1, ArrayMath.rampfloat(1.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, ArrayMath.rampfloat(12.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.rampfloat(123.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        b1 = ArrayMath.copy(n1 / 2, 0, 2, a1);
        b2 = ArrayMath.copy(n1 / 2, n2 / 2, 0, 0, 2, 2, a2);
        b3 = ArrayMath.copy(n1 / 2, n2 / 2, n3 / 2, 0, 0, 0, 2, 2, 2, a3);
        this.assertEqual(b1, ArrayMath.rampfloat(0.0f, 2.0f, n1 / 2));
        this.assertEqual(b2, ArrayMath.rampfloat(0.0f, 2.0f, 20.0f, n1 / 2, n2 / 2));
        this.assertEqual(b3, ArrayMath.rampfloat(0.0f, 2.0f, 20.0f, 200.0f, n1 / 2, n2 / 2, n3 / 2));
        b1 = ArrayMath.copy(a1);
        b2 = ArrayMath.copy(a2);
        b3 = ArrayMath.copy(a3);
        ArrayMath.copy(n1 - 1, 1, a1, 1, b1);
        ArrayMath.copy(n1 - 2, n2 - 1, 2, 1, a2, 2, 1, b2);
        ArrayMath.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 3, 2, 1, b3);
        this.assertEqual(b1, ArrayMath.rampfloat(0.0f, 1.0f, n1));
        this.assertEqual(b2, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, n1, n2));
        this.assertEqual(b3, ArrayMath.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1, n2, n3));
        b1 = ArrayMath.reverse(ArrayMath.reverse(a1));
        this.assertEqual(b1, a1);
        b2 = ArrayMath.reshape(n1, n2, ArrayMath.flatten(a2));
        b3 = ArrayMath.reshape(n1, n2, n3, ArrayMath.flatten(a3));
        this.assertEqual(a2, b2);
        this.assertEqual(a3, b3);
        b2 = ArrayMath.transpose(ArrayMath.transpose(a2));
        this.assertEqual(a2, b2);
    }

    public void testFloat2() {
        int n1 = 3;
        int n2 = 4;
        int n3 = 5;
        float r0 = 0.0f;
        float ra = 2.0f;
        float rb1 = 1.0f;
        float rb2 = 2.0f;
        float rb3 = 4.0f;
        this.assertEqual(ArrayMath.zerofloat(n1, n2, n3), ArrayMath.fillfloat(r0, n1, n2, n3));
        float[][][] rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, ArrayMath.sub(ArrayMath.add(rx, rx), rx));
        this.assertEqual(rx, ArrayMath.sub(ArrayMath.add(rx, ra), ra));
        this.assertEqual(ArrayMath.fillfloat(ra, n1, n2, n3), ArrayMath.sub(ArrayMath.add(ra, rx), rx));
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, ArrayMath.div(ArrayMath.mul(rx, rx), rx));
        this.assertEqual(rx, ArrayMath.div(ArrayMath.mul(rx, ra), ra));
        this.assertEqual(ArrayMath.fillfloat(ra, n1, n2, n3), ArrayMath.div(ArrayMath.mul(ra, rx), rx));
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, ArrayMath.log(ArrayMath.exp(rx)));
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertAlmostEqual(rx, ArrayMath.mul(ArrayMath.sqrt(rx), ArrayMath.sqrt(rx)));
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertAlmostEqual(rx, ArrayMath.pow(ArrayMath.sqrt(rx), 2.0f));
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        int[] imax = new int[]{-1, -1, -1};
        float rmax = ArrayMath.max(rx, imax);
        ArrayMathTest.assertTrue((rmax == rx[n3 - 1][n2 - 1][n1 - 1] ? 1 : 0) != 0);
        ArrayMathTest.assertEquals((int)(n1 - 1), (int)imax[0]);
        ArrayMathTest.assertEquals((int)(n2 - 1), (int)imax[1]);
        ArrayMathTest.assertEquals((int)(n3 - 1), (int)imax[2]);
        rx = ArrayMath.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        int[] imin = new int[]{-1, -1, -1};
        float rmin = ArrayMath.min(rx, imin);
        ArrayMathTest.assertTrue((rmin == rx[0][0][0] ? 1 : 0) != 0);
        ArrayMathTest.assertEquals((int)0, (int)imin[0]);
        ArrayMathTest.assertEquals((int)0, (int)imin[1]);
        ArrayMathTest.assertEquals((int)0, (int)imin[2]);
    }

    private void assertEqual(float[] rx, float[] ry) {
        ArrayMathTest.assertTrue((boolean)ArrayMath.equal(rx, ry));
    }

    private void assertEqual(float[][] rx, float[][] ry) {
        ArrayMathTest.assertTrue((boolean)ArrayMath.equal(rx, ry));
    }

    private void assertEqual(float[][][] rx, float[][][] ry) {
        ArrayMathTest.assertTrue((boolean)ArrayMath.equal(rx, ry));
    }

    private void assertAlmostEqual(float[][][] rx, float[][][] ry) {
        float tolerance = 1.1920929E-5f;
        ArrayMathTest.assertTrue((boolean)ArrayMath.equal(tolerance, rx, ry));
    }

    public void testCfloat1() {
        int n1 = 8;
        int n2 = 6;
        int n3 = 4;
        Cfloat c0 = new Cfloat(0.0f, 0.0f);
        Cfloat c1 = new Cfloat(1.0f, 0.0f);
        Cfloat c2 = new Cfloat(2.0f, 0.0f);
        Cfloat c10 = new Cfloat(10.0f, 0.0f);
        Cfloat c12 = new Cfloat(12.0f, 0.0f);
        Cfloat c20 = new Cfloat(20.0f, 0.0f);
        Cfloat c100 = new Cfloat(100.0f, 0.0f);
        Cfloat c123 = new Cfloat(123.0f, 0.0f);
        Cfloat c200 = new Cfloat(200.0f, 0.0f);
        float[] a1 = ArrayMath.crampfloat(c0, c1, n1);
        float[][] a2 = ArrayMath.crampfloat(c0, c1, c10, n1, n2);
        float[][][] a3 = ArrayMath.crampfloat(c0, c1, c10, c100, n1, n2, n3);
        float[] b1 = ArrayMath.ccopy(a1);
        float[][] b2 = ArrayMath.ccopy(a2);
        float[][][] b3 = ArrayMath.ccopy(a3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        ArrayMath.ccopy(a1, b1);
        ArrayMath.ccopy(a2, b2);
        ArrayMath.ccopy(a3, b3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        b1 = ArrayMath.ccopy(n1 - 1, a1);
        b2 = ArrayMath.ccopy(n1 - 1, n2 - 1, a2);
        b3 = ArrayMath.ccopy(n1 - 1, n2 - 1, n3 - 1, a3);
        this.assertEqual(b1, ArrayMath.crampfloat(c0, c1, n1 - 1));
        this.assertEqual(b2, ArrayMath.crampfloat(c0, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.crampfloat(c0, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        ArrayMath.ccopy(n1 - 1, a1, b1);
        ArrayMath.ccopy(n1 - 1, n2 - 1, a2, b2);
        ArrayMath.ccopy(n1 - 1, n2 - 1, n3 - 1, a3, b3);
        this.assertEqual(b1, ArrayMath.crampfloat(c0, c1, n1 - 1));
        this.assertEqual(b2, ArrayMath.crampfloat(c0, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.crampfloat(c0, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        b1 = ArrayMath.ccopy(n1 - 1, 1, a1);
        b2 = ArrayMath.ccopy(n1 - 2, n2 - 1, 2, 1, a2);
        b3 = ArrayMath.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3);
        this.assertEqual(b1, ArrayMath.crampfloat(c1, c1, n1 - 1));
        this.assertEqual(b2, ArrayMath.crampfloat(c12, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.crampfloat(c123, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        ArrayMath.ccopy(n1 - 1, 1, a1, 0, b1);
        ArrayMath.ccopy(n1 - 2, n2 - 1, 2, 1, a2, 0, 0, b2);
        ArrayMath.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 0, 0, 0, b3);
        this.assertEqual(b1, ArrayMath.crampfloat(c1, c1, n1 - 1));
        this.assertEqual(b2, ArrayMath.crampfloat(c12, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, ArrayMath.crampfloat(c123, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        b1 = ArrayMath.ccopy(n1 / 2, 0, 2, a1);
        b2 = ArrayMath.ccopy(n1 / 2, n2 / 2, 0, 0, 2, 2, a2);
        b3 = ArrayMath.ccopy(n1 / 2, n2 / 2, n3 / 2, 0, 0, 0, 2, 2, 2, a3);
        this.assertEqual(b1, ArrayMath.crampfloat(c0, c2, n1 / 2));
        this.assertEqual(b2, ArrayMath.crampfloat(c0, c2, c20, n1 / 2, n2 / 2));
        this.assertEqual(b3, ArrayMath.crampfloat(c0, c2, c20, c200, n1 / 2, n2 / 2, n3 / 2));
        b1 = ArrayMath.ccopy(a1);
        b2 = ArrayMath.ccopy(a2);
        b3 = ArrayMath.ccopy(a3);
        ArrayMath.ccopy(n1 - 1, 1, a1, 1, b1);
        ArrayMath.ccopy(n1 - 2, n2 - 1, 2, 1, a2, 2, 1, b2);
        ArrayMath.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 3, 2, 1, b3);
        this.assertEqual(b1, ArrayMath.crampfloat(c0, c1, n1));
        this.assertEqual(b2, ArrayMath.crampfloat(c0, c1, c10, n1, n2));
        this.assertEqual(b3, ArrayMath.crampfloat(c0, c1, c10, c100, n1, n2, n3));
        b1 = ArrayMath.creverse(ArrayMath.creverse(a1));
        this.assertEqual(b1, a1);
        b2 = ArrayMath.creshape(n1, n2, ArrayMath.cflatten(a2));
        b3 = ArrayMath.creshape(n1, n2, n3, ArrayMath.cflatten(a3));
        this.assertEqual(a2, b2);
        this.assertEqual(a3, b3);
        b2 = ArrayMath.ctranspose(ArrayMath.ctranspose(a2));
        this.assertEqual(a2, b2);
    }

    public void testCfloat2() {
        int n1 = 3;
        int n2 = 4;
        int n3 = 5;
        Cfloat c0 = new Cfloat();
        Cfloat ca = new Cfloat(1.0f, 2.0f);
        Cfloat cb1 = new Cfloat(2.0f, 3.0f);
        Cfloat cb2 = new Cfloat(3.0f, 4.0f);
        Cfloat cb3 = new Cfloat(4.0f, 5.0f);
        this.assertEqual(ArrayMath.czerofloat(n1, n2, n3), ArrayMath.cfillfloat(c0, n1, n2, n3));
        float[][][] cx = ArrayMath.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(cx, ArrayMath.csub(ArrayMath.cadd(cx, cx), cx));
        this.assertEqual(cx, ArrayMath.csub(ArrayMath.cadd(cx, ca), ca));
        this.assertEqual(ArrayMath.cfillfloat(ca, n1, n2, n3), ArrayMath.csub(ArrayMath.cadd(ca, cx), cx));
        cx = ArrayMath.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(cx, ArrayMath.cdiv(ArrayMath.cmul(cx, cx), cx));
        this.assertEqual(cx, ArrayMath.cdiv(ArrayMath.cmul(cx, ca), ca));
        this.assertEqual(ArrayMath.cfillfloat(ca, n1, n2, n3), ArrayMath.cdiv(ArrayMath.cmul(ca, cx), cx));
        cx = ArrayMath.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(ArrayMath.cnorm(cx), ArrayMath.cabs(ArrayMath.cmul(cx, ArrayMath.cconj(cx))));
        float[][][] rr = ArrayMath.fillfloat(1.0f, n1, n2, n3);
        float[][][] ra = ArrayMath.rampfloat(0.0f, 1.0f, 1.0f, 1.0f, n1, n2, n3);
        cx = ArrayMath.polar(rr, ra);
        float[][][] rx = ArrayMath.cos(ra);
        float[][][] ry = ArrayMath.sin(ra);
        float[][][] cy = ArrayMath.cmplx(rx, ry);
        this.assertEqual(cx, cy);
        Cfloat ci = new Cfloat(0.0f, 1.0f);
        float[][][] ciw = ArrayMath.crampfloat(c0, ci, ci, ci, n1, n2, n3);
        float[][][] cz = ArrayMath.cexp(ciw);
        this.assertEqual(cx, cz);
    }

    public void testMonotonic() {
        double[] a = new double[]{};
        ArrayMathTest.assertTrue((boolean)ArrayMath.isMonotonic(a));
        ArrayMathTest.assertTrue((boolean)ArrayMath.isIncreasing(a));
        ArrayMathTest.assertTrue((boolean)ArrayMath.isDecreasing(a));
        double[] a0 = new double[]{0.0};
        ArrayMathTest.assertTrue((boolean)ArrayMath.isMonotonic(a0));
        ArrayMathTest.assertTrue((boolean)ArrayMath.isIncreasing(a0));
        ArrayMathTest.assertTrue((boolean)ArrayMath.isDecreasing(a0));
        double[] a01 = new double[]{0.0, 1.0};
        ArrayMathTest.assertTrue((boolean)ArrayMath.isMonotonic(a01));
        ArrayMathTest.assertTrue((boolean)ArrayMath.isIncreasing(a01));
        ArrayMathTest.assertTrue((!ArrayMath.isDecreasing(a01) ? 1 : 0) != 0);
        double[] a10 = new double[]{1.0, 0.0};
        ArrayMathTest.assertTrue((boolean)ArrayMath.isMonotonic(a10));
        ArrayMathTest.assertTrue((!ArrayMath.isIncreasing(a10) ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((boolean)ArrayMath.isDecreasing(a10));
        double[] a101 = new double[]{1.0, 0.0, 1.0};
        ArrayMathTest.assertTrue((!ArrayMath.isMonotonic(a101) ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((!ArrayMath.isIncreasing(a101) ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((!ArrayMath.isDecreasing(a101) ? 1 : 0) != 0);
        double[] a010 = new double[]{0.0, 1.0, 0.0};
        ArrayMathTest.assertTrue((!ArrayMath.isMonotonic(a010) ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((!ArrayMath.isIncreasing(a010) ? 1 : 0) != 0);
        ArrayMathTest.assertTrue((!ArrayMath.isDecreasing(a010) ? 1 : 0) != 0);
    }

    public void testBinarySearch() {
        double[] a = new double[]{};
        this.checkSearch(a, 1.0);
        double[] a0 = new double[]{2.0};
        this.checkSearch(a0, 1.0);
        this.checkSearch(a0, 2.0);
        this.checkSearch(a0, 3.0);
        double[] a13 = new double[]{1.0, 3.0};
        this.checkSearch(a13, 0.0);
        this.checkSearch(a13, 1.0);
        this.checkSearch(a13, 2.0);
        this.checkSearch(a13, 3.0);
        this.checkSearch(a13, 4.0);
        double[] a31 = new double[]{3.0, 1.0};
        this.checkSearch(a31, 0.0);
        this.checkSearch(a31, 1.0);
        this.checkSearch(a31, 2.0);
        this.checkSearch(a31, 3.0);
        this.checkSearch(a31, 4.0);
        double[] a135 = new double[]{1.0, 3.0, 5.0};
        this.checkSearch(a135, 0.0);
        this.checkSearch(a135, 1.0);
        this.checkSearch(a135, 2.0);
        this.checkSearch(a135, 3.0);
        this.checkSearch(a135, 4.0);
        this.checkSearch(a135, 5.0);
        this.checkSearch(a135, 6.0);
        double[] a531 = new double[]{5.0, 3.0, 1.0};
        this.checkSearch(a531, 0.0);
        this.checkSearch(a531, 1.0);
        this.checkSearch(a531, 2.0);
        this.checkSearch(a531, 3.0);
        this.checkSearch(a531, 4.0);
        this.checkSearch(a531, 5.0);
        this.checkSearch(a531, 6.0);
    }

    private void checkSearch(double[] a, double x) {
        int n = a.length;
        int i = ArrayMath.binarySearch(a, x);
        this.validateSearch(a, x, i);
        for (int is = -2; is < n + 2; ++is) {
            i = ArrayMath.binarySearch(a, x, is);
            this.validateSearch(a, x, i);
        }
    }

    private void validateSearch(double[] a, double x, int i) {
        int n = a.length;
        if (i >= 0) {
            ArrayMathTest.assertTrue((a[i] == x ? 1 : 0) != 0);
        } else {
            i = -(i + 1);
            if (n == 0) {
                ArrayMathTest.assertTrue((i == 0 ? 1 : 0) != 0);
            } else if (n < 2 || a[0] < a[n - 1]) {
                if (i == 0) {
                    ArrayMathTest.assertTrue((x < a[i] ? 1 : 0) != 0);
                } else if (i == n) {
                    ArrayMathTest.assertTrue((a[i - 1] < x ? 1 : 0) != 0);
                } else {
                    ArrayMathTest.assertTrue((a[i - 1] < x && x < a[i] ? 1 : 0) != 0);
                }
            } else if (i == 0) {
                ArrayMathTest.assertTrue((x > a[i] ? 1 : 0) != 0);
            } else if (i == n) {
                ArrayMathTest.assertTrue((a[i - 1] > x ? 1 : 0) != 0);
            } else {
                ArrayMathTest.assertTrue((a[i - 1] > x && x > a[i] ? 1 : 0) != 0);
            }
        }
    }

    public void testMath() {
        this.assertEquals(0.0f, ArrayMath.sin((float)Math.PI));
        this.assertEquals(0.0, ArrayMath.sin(Math.PI));
        this.assertEquals(1.0f, ArrayMath.cos((float)Math.PI * 2));
        this.assertEquals(1.0, ArrayMath.cos(Math.PI * 2));
        this.assertEquals(1.0f, ArrayMath.tan(0.7853982f));
        this.assertEquals(1.0, ArrayMath.tan(0.7853981633974483));
        this.assertEquals(1.5707964f, ArrayMath.asin(1.0f));
        this.assertEquals(1.5707963267948966, ArrayMath.asin(1.0));
        this.assertEquals(1.5707964f, ArrayMath.acos(0.0f));
        this.assertEquals(1.5707963267948966, ArrayMath.acos(0.0));
        this.assertEquals(0.7853982f, ArrayMath.atan(1.0f));
        this.assertEquals(0.7853981633974483, ArrayMath.atan(1.0));
        this.assertEquals(1.5707964f, ArrayMath.atan2(1.0f, 0.0f));
        this.assertEquals(1.5707963267948966, ArrayMath.atan2(1.0, 0.0));
        this.assertEquals(-2.3561945f, ArrayMath.atan2(-1.0f, -1.0f));
        this.assertEquals(-2.356194490192345, ArrayMath.atan2(-1.0, -1.0));
        this.assertEquals((float)Math.PI, ArrayMath.toRadians(180.0f));
        this.assertEquals(Math.PI, ArrayMath.toRadians(180.0));
        this.assertEquals(180.0f, ArrayMath.toDegrees((float)Math.PI));
        this.assertEquals(180.0, ArrayMath.toDegrees(Math.PI));
        this.assertEquals(1.0f, ArrayMath.log(ArrayMath.exp(1.0f)));
        this.assertEquals(1.0, ArrayMath.log(ArrayMath.exp(1.0)));
        this.assertEquals(3.0f, ArrayMath.sqrt(ArrayMath.pow(3.0f, 2.0f)));
        this.assertEquals(3.0, ArrayMath.sqrt(ArrayMath.pow(3.0, 2.0)));
        this.assertEquals(ArrayMath.tanh(1.0f), ArrayMath.sinh(1.0f) / ArrayMath.cosh(1.0f));
        this.assertEquals(ArrayMath.tanh(1.0), ArrayMath.sinh(1.0) / ArrayMath.cosh(1.0));
        this.assertEquals(4.0f, ArrayMath.ceil((float)Math.PI));
        this.assertEquals(4.0, ArrayMath.ceil(Math.PI));
        this.assertEquals(-3.0f, ArrayMath.ceil((float)(-Math.PI)));
        this.assertEquals(-3.0, ArrayMath.ceil(-Math.PI));
        this.assertEquals(3.0f, ArrayMath.floor((float)Math.PI));
        this.assertEquals(3.0, ArrayMath.floor(Math.PI));
        this.assertEquals(-4.0f, ArrayMath.floor((float)(-Math.PI)));
        this.assertEquals(-4.0, ArrayMath.floor(-Math.PI));
        this.assertEquals(3.0f, ArrayMath.rint((float)Math.PI));
        this.assertEquals(3.0, ArrayMath.rint(Math.PI));
        this.assertEquals(-3.0f, ArrayMath.rint((float)(-Math.PI)));
        this.assertEquals(-3.0, ArrayMath.rint(-Math.PI));
        ArrayMathTest.assertEquals((int)3, (int)ArrayMath.round((float)Math.PI));
        ArrayMathTest.assertEquals((long)3L, (long)ArrayMath.round(Math.PI));
        ArrayMathTest.assertEquals((int)-3, (int)ArrayMath.round((float)(-Math.PI)));
        ArrayMathTest.assertEquals((long)-3L, (long)ArrayMath.round(-Math.PI));
        ArrayMathTest.assertEquals((int)3, (int)ArrayMath.round((float)Math.E));
        ArrayMathTest.assertEquals((long)3L, (long)ArrayMath.round(Math.E));
        ArrayMathTest.assertEquals((int)-3, (int)ArrayMath.round(-2.7182817f));
        ArrayMathTest.assertEquals((long)-3L, (long)ArrayMath.round(-2.718281828459045));
        this.assertEquals(1.0f, ArrayMath.signum((float)Math.PI));
        this.assertEquals(1.0, ArrayMath.signum(Math.PI));
        this.assertEquals(-1.0f, ArrayMath.signum((float)(-Math.PI)));
        this.assertEquals(-1.0, ArrayMath.signum(-Math.PI));
        this.assertEquals(0.0f, ArrayMath.signum(0.0f));
        this.assertEquals(0.0, ArrayMath.signum(0.0));
        ArrayMathTest.assertEquals((int)2, (int)ArrayMath.abs(2));
        ArrayMathTest.assertEquals((long)2L, (long)ArrayMath.abs(2L));
        this.assertEquals(2.0f, ArrayMath.abs(2.0f));
        this.assertEquals(2.0, ArrayMath.abs(2.0));
        ArrayMathTest.assertEquals((int)2, (int)ArrayMath.abs(-2));
        ArrayMathTest.assertEquals((long)2L, (long)ArrayMath.abs(-2L));
        this.assertEquals(2.0f, ArrayMath.abs(-2.0f));
        this.assertEquals(2.0, ArrayMath.abs(-2.0));
        ArrayMathTest.assertEquals((String)"abs(float) changed sign of 0", (int)0, (int)Float.floatToIntBits(ArrayMath.abs(0.0f)));
        ArrayMathTest.assertEquals((String)"abs(double) changed sign of 0", (long)0L, (long)Double.doubleToLongBits(ArrayMath.abs(0.0)));
        ArrayMathTest.assertEquals((int)4, (int)ArrayMath.max(1, 3, 4, 2));
        ArrayMathTest.assertEquals((long)4L, (long)ArrayMath.max(1L, 3L, 4L, 2L));
        this.assertEquals(4.0f, ArrayMath.max(1.0f, 3.0f, 4.0f, 2.0f));
        this.assertEquals(4.0, ArrayMath.max(1.0, 3.0, 4.0, 2.0));
        ArrayMathTest.assertEquals((int)1, (int)ArrayMath.min(3, 1, 4, 2));
        ArrayMathTest.assertEquals((long)1L, (long)ArrayMath.min(3L, 1L, 4L, 2L));
        this.assertEquals(1.0f, ArrayMath.min(3.0f, 1.0f, 4.0f, 2.0f));
        this.assertEquals(1.0, ArrayMath.min(3.0, 1.0, 4.0, 2.0));
    }

    private void assertEquals(float expected, float actual) {
        float small = 1.0E-6f * ArrayMath.max(ArrayMath.abs(expected), ArrayMath.abs(actual), 1.0f);
        ArrayMathTest.assertEquals((float)expected, (float)actual, (float)small);
    }

    private void assertEquals(double expected, double actual) {
        double small = (double)1.0E-12f * ArrayMath.max(ArrayMath.abs(expected), ArrayMath.abs(actual), 1.0);
        ArrayMathTest.assertEquals((double)expected, (double)actual, (double)small);
    }
}

