/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.MedianFinder;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MedianFinderTest
extends TestCase {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            MedianFinderTest.bench();
        }
        TestSuite suite = new TestSuite(MedianFinderTest.class);
        TestRunner.run((Test)suite);
    }

    public void testUnweighted() {
        Random r = new Random();
        int ntest = 100;
        for (int itest = 0; itest < ntest; ++itest) {
            float eu;
            MedianFinder mf;
            float ew;
            int n = 1 + (r.nextBoolean() ? r.nextInt(100) : r.nextInt(10));
            float[] f = ArrayMath.randfloat(n);
            float[] w = ArrayMath.fillfloat(1.0f, n);
            if (r.nextBoolean()) {
                for (int i = n / 4; i < 3 * n / 4; ++i) {
                    f[i] = f[0];
                }
            }
            MedianFinderTest.assertTrue(((ew = (mf = new MedianFinder(n)).findMedian(w, f)) == (eu = mf.findMedian(f)) ? 1 : 0) != 0);
        }
    }

    public void testWeighted() {
        Random r = new Random();
        int ntest = 100;
        for (int itest = 0; itest < ntest; ++itest) {
            int i;
            int n = 1 + (r.nextBoolean() ? r.nextInt(100) : r.nextInt(10));
            float[] w = ArrayMath.randfloat(n);
            float[] f = ArrayMath.randfloat(n);
            int[] k = ArrayMath.rampint(0, 1, n);
            ArrayMath.quickIndexSort(f, k);
            float wsum = 0.0f;
            float wtotal = ArrayMath.sum(w);
            for (i = 0; i < n && wsum < 0.5f * wtotal; wsum += w[k[i]], ++i) {
            }
            float qslow = f[k[i - 1]];
            MedianFinder mf = new MedianFinder(n);
            float qfast = mf.findMedian(w, f);
            MedianFinderTest.assertTrue((qslow == qfast ? 1 : 0) != 0);
        }
    }

    public static void bench() {
        double maxtime = 2.0;
        Stopwatch sw = new Stopwatch();
        for (int n = 10; n < 10000; n *= 10) {
            System.out.println("n=" + n);
            MedianFinder mf = new MedianFinder(n);
            for (int ntrial = 0; ntrial < 3; ++ntrial) {
                float[] w = ArrayMath.fillfloat(1.0f, n);
                float[] f = ArrayMath.randfloat(n);
                float q1 = 0.0f;
                sw.restart();
                int nq = 0;
                while (sw.time() < maxtime) {
                    q1 = mf.findMedian(w, f);
                    ++nq;
                }
                sw.stop();
                int rate = (int)(1.0E-6 * (double)nq * (double)n / sw.time());
                System.out.println("  weighted: median=" + q1 + " rate=" + rate);
                float q2 = 0.0f;
                sw.restart();
                nq = 0;
                while (sw.time() < maxtime) {
                    q2 = mf.findMedian(f);
                    ++nq;
                }
                sw.stop();
                rate = (int)(1.0E-6 * (double)nq * (double)n / sw.time());
                System.out.println("unweighted: median=" + q2 + " rate=" + rate);
                float q3 = 0.0f;
                sw.restart();
                nq = 0;
                while (sw.time() < maxtime) {
                    q3 = ArrayMath.sum(f) / (float)n;
                    ++nq;
                }
                sw.stop();
                rate = (int)(1.0E-6 * (double)nq * (double)n / sw.time());
                System.out.println("   average: mean=" + q3 + " rate=" + rate);
            }
        }
    }
}

