/*
 * Decompiled with CFR 0.152.
 */
package ij3d.shapes;

import java.text.DecimalFormat;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.LineArray;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.OrientedShape3D;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Text2D;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class BoundingBox
extends BranchGroup {
    private final Point3f min;
    private final Point3f max;

    public BoundingBox(Point3d min, Point3d max) {
        this(new Point3f(min), new Point3f(max));
    }

    public BoundingBox(Point3f min, Point3f max) {
        this(min, max, new Color3f(1.0f, 0.0f, 0.0f));
    }

    public BoundingBox(Point3d minp, Point3d maxp, Color3f color) {
        this(new Point3f(minp), new Point3f(maxp), color);
    }

    public BoundingBox(Point3f minp, Point3f maxp, Color3f color) {
        this.setCapability(17);
        this.min = minp;
        this.max = maxp;
        this.min.x -= 0.0f;
        this.min.y -= 0.0f;
        this.min.z -= 0.0f;
        this.max.x += 0.0f;
        this.max.y += 0.0f;
        this.max.z += 0.0f;
        Point3f[] p = new Point3f[]{new Point3f(this.min.x, this.min.y, this.max.z), new Point3f(this.max.x, this.min.y, this.max.z), new Point3f(this.max.x, this.max.y, this.max.z), new Point3f(this.min.x, this.max.y, this.max.z), new Point3f(this.min.x, this.min.y, this.min.z), new Point3f(this.max.x, this.min.y, this.min.z), new Point3f(this.max.x, this.max.y, this.min.z), new Point3f(this.min.x, this.max.y, this.min.z)};
        Shape3D shape = new Shape3D();
        shape.setName("BB");
        float lx = this.max.x - this.min.x;
        float ly = this.max.y - this.min.y;
        float lz = this.max.z - this.min.z;
        float max = Math.max(lx, Math.max(ly, lz));
        float min = Math.min(lx, Math.min(ly, lz));
        if (min == 0.0f || max / min > 100.0f) {
            min = max;
        }
        double tmp = 1.0E-5f;
        while ((double)min / tmp > 5.0) {
            tmp *= 10.0;
        }
        if ((double)min / tmp < 2.0) {
            tmp /= 2.0;
        }
        float tickDistance = (float)tmp;
        float tickSize = max / 50.0f;
        Color3f c = color;
        float td = tickDistance;
        float ts = tickSize;
        float fx = tickDistance - this.min.x % tickDistance;
        float fy = tickDistance - this.min.y % tickDistance;
        float fz = tickDistance - this.min.z % tickDistance;
        shape.addGeometry(this.makeLine(p[0], p[1], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[1], p[2], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[2], p[3], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[3], p[0], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[4], p[5], c, td, fx, ts, false));
        shape.addGeometry(this.makeLine(p[5], p[6], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[6], p[7], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[4], p[7], c, td, fy, ts, false));
        shape.addGeometry(this.makeLine(p[4], p[0], c, td, fz, ts, false));
        shape.addGeometry(this.makeLine(p[1], p[5], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[2], p[6], c, td, 0.0f, ts, true));
        shape.addGeometry(this.makeLine(p[3], p[7], c, td, 0.0f, ts, true));
        shape.setAppearance(this.createAppearance(color));
        this.addChild((Node)shape);
        float fontsize = 2.0f * tickSize;
        DecimalFormat df = new DecimalFormat("#.##");
        float v = this.min.x + fx;
        Point3f pos = new Point3f(v, this.min.y - 1.5f * tickSize, this.min.z - 1.5f * tickSize);
        this.addText(df.format(v), pos, fontsize, color);
        v = this.min.x + fx + tickDistance;
        pos = new Point3f(v, this.min.y - 1.5f * tickSize, this.min.z - 1.5f * tickSize);
        this.addText(df.format(v), pos, fontsize, color);
        v = this.min.y + fy;
        pos = new Point3f(this.min.x - 1.5f * tickSize, v, this.min.z - 1.5f * tickSize);
        this.addText(df.format(v), pos, fontsize, color);
        v = this.min.y + fy + tickDistance;
        pos = new Point3f(this.min.x - 1.5f * tickSize, v, this.min.z - 1.5f * tickSize);
        this.addText(df.format(v), pos, fontsize, color);
        v = this.min.z + fz;
        pos = new Point3f(this.min.x - 1.5f * tickSize, this.min.y - 1.5f * tickSize, v);
        this.addText(df.format(v), pos, fontsize, color);
        v = this.min.z + fz + tickDistance;
        pos = new Point3f(this.min.x - 1.5f * tickSize, this.min.y - 1.5f * tickSize, v);
        this.addText(df.format(v), pos, fontsize, color);
    }

    private void addText(String s, Point3f pos, float fontsize, Color3f c) {
        Transform3D translation = new Transform3D();
        translation.rotX(Math.PI);
        translation.setTranslation(new Vector3f((Tuple3f)pos));
        TransformGroup tg = new TransformGroup(translation);
        OrientedShape3D textShape = new OrientedShape3D();
        textShape.setAlignmentMode(1);
        textShape.setAlignmentAxis(0.0f, 1.0f, 0.0f);
        textShape.setRotationPoint(new Point3f(0.0f, 0.0f, 0.0f));
        textShape.setConstantScaleEnable(true);
        Text2D t2d = new Text2D(s, c, "Helvetica", 24, 0);
        t2d.setRectangleScaleFactor(0.03f);
        textShape.setGeometry(t2d.getGeometry());
        textShape.setAppearance(t2d.getAppearance());
        tg.addChild((Node)textShape);
        this.addChild((Node)tg);
    }

    private Appearance createAppearance(Color3f color) {
        Appearance a = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setPolygonMode(2);
        pa.setCullFace(0);
        a.setPolygonAttributes(pa);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(color);
        a.setColoringAttributes(ca);
        return a;
    }

    private Geometry makeLine(Point3f start, Point3f end, Color3f color, float tickDistance, float first, float tickSize, boolean noTicks) {
        float lineLength = start.distance(end);
        int nTicks = (int)Math.floor((lineLength - first) / tickDistance) + 1;
        if (nTicks < 1) {
            noTicks = true;
        }
        int n = noTicks ? 2 : nTicks * 6 + 2;
        Point3f[] coords = new Point3f[n];
        int i = 0;
        coords[i++] = start;
        coords[i++] = end;
        if (!noTicks) {
            Point3f p = new Point3f();
            Vector3f dir = new Vector3f();
            dir.sub((Tuple3f)end, (Tuple3f)start);
            dir.normalize();
            float fx = first * dir.x;
            float fy = first * dir.y;
            float fz = first * dir.z;
            dir.scale(tickDistance);
            for (int t = 0; t < nTicks; ++t) {
                p.x = start.x + fx + (float)t * dir.x;
                p.y = start.y + fy + (float)t * dir.y;
                p.z = start.z + fz + (float)t * dir.z;
                coords[i++] = new Point3f(p.x - tickSize, p.y, p.z);
                coords[i++] = new Point3f(p.x + tickSize, p.y, p.z);
                coords[i++] = new Point3f(p.x, p.y - tickSize, p.z);
                coords[i++] = new Point3f(p.x, p.y + tickSize, p.z);
                coords[i++] = new Point3f(p.x, p.y, p.z - tickSize);
                coords[i++] = new Point3f(p.x, p.y, p.z + tickSize);
            }
        }
        LineArray ga = new LineArray(coords.length, 5);
        ga.setCoordinates(0, coords);
        Color3f[] col = new Color3f[coords.length];
        for (i = 0; i < col.length; ++i) {
            col[i] = color;
        }
        ga.setColors(0, col);
        return ga;
    }

    public String toString() {
        return "[BoundingBox (" + this.min.x + ", " + this.min.y + ", " + this.min.z + ") - (" + this.max.x + ", " + this.max.y + ", " + this.max.z + ")]";
    }
}

