/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.hdf5;

import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.jdom2.Content;
import org.jdom2.Element;

@ImgLoaderIo(format="bdv.hdf5", type=Hdf5ImageLoader.class)
public class XmlIoHdf5ImageLoader
implements XmlIoBasicImgLoader<Hdf5ImageLoader> {
    public Element toXml(Hdf5ImageLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", "bdv.hdf5");
        elem.addContent((Content)XmlHelpers.pathElement((String)"hdf5", (File)imgLoader.getHdf5File(), (File)basePath));
        for (Partition partition : imgLoader.getPartitions()) {
            elem.addContent((Content)this.partitionToXml(partition, basePath));
        }
        return elem;
    }

    public Hdf5ImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        String path = XmlHelpers.loadPath((Element)elem, (String)"hdf5", (File)basePath).toString();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (Element p : elem.getChildren("partition")) {
            partitions.add(this.partitionFromXml(p, basePath));
        }
        return new Hdf5ImageLoader(new File(path), partitions, sequenceDescription);
    }

    private Element partitionToXml(Partition partition, File basePath) {
        Element elem = new Element("partition");
        elem.addContent((Content)XmlHelpers.pathElement((String)"path", (File)new File(partition.getPath()), (File)basePath));
        Pair<int[], int[]> timepointIdVecs = XmlIoHdf5ImageLoader.idMapToVectors(partition.getTimepointIdSequenceToPartition());
        int[] timepointIds = timepointIdVecs.getA();
        int[] timepointIdsPartition = timepointIdVecs.getB();
        elem.addContent((Content)XmlHelpers.intArrayElement((String)"timepoints", (int[])timepointIds));
        if (!Arrays.equals(timepointIds, timepointIdsPartition)) {
            elem.addContent((Content)XmlHelpers.intArrayElement((String)"timepointsMapped", (int[])timepointIdsPartition));
        }
        Pair<int[], int[]> setupIdVecs = XmlIoHdf5ImageLoader.idMapToVectors(partition.getSetupIdSequenceToPartition());
        int[] setupIds = setupIdVecs.getA();
        int[] setupIdsPartition = setupIdVecs.getB();
        elem.addContent((Content)XmlHelpers.intArrayElement((String)"setups", (int[])setupIds));
        if (!Arrays.equals(setupIds, setupIdsPartition)) {
            elem.addContent((Content)XmlHelpers.intArrayElement((String)"setupsMapped", (int[])setupIdsPartition));
        }
        return elem;
    }

    private static Pair<int[], int[]> idMapToVectors(Map<Integer, Integer> setupIdMap) {
        ArrayList<Integer> seqIdList = new ArrayList<Integer>(setupIdMap.keySet());
        Collections.sort(seqIdList);
        int[] seqIds = new int[seqIdList.size()];
        int[] parIds = new int[seqIdList.size()];
        int i = 0;
        for (Integer seqId : seqIdList) {
            seqIds[i] = seqId;
            parIds[i] = setupIdMap.get(seqId);
            ++i;
        }
        return new ValuePair<int[], int[]>(seqIds, parIds);
    }

    private Partition partitionFromXml(Element elem, File basePath) {
        String path;
        try {
            path = XmlHelpers.loadPath((Element)elem, (String)"path", (File)basePath).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int[] timepointIds = XmlHelpers.getIntArray((Element)elem, (String)"timepoints");
        int[] timepointIdsPartition = XmlHelpers.getIntArray((Element)elem, (String)"timepointsMapped", (int[])timepointIds);
        int[] setupIds = XmlHelpers.getIntArray((Element)elem, (String)"setups");
        int[] setupIdsPartition = XmlHelpers.getIntArray((Element)elem, (String)"setupsMapped", (int[])setupIds);
        return new Partition(path, timepointIds, setupIds, timepointIdsPartition, setupIdsPartition);
    }
}

