/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.crop;

import bdv.util.IntervalBoundingBox;
import bdv.viewer.Source;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.ViewId;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class CropImgLoader
implements BasicImgLoader {
    private final AffineTransform3D globalToCropTransform;
    private final RealInterval cropInterval;
    private final Map<Integer, Integer> timepointIdToTimepointIndex;
    private final Map<Integer, SetupImgLoader<?>> setupImgLoaders;

    public CropImgLoader(ArrayList<Source<?>> sources, AffineTransform3D globalToCropTransform, RealInterval cropInterval, Map<Integer, Integer> timepointIdToTimepointIndex, Map<Integer, Integer> setupIdToSourceIndex) {
        this.globalToCropTransform = globalToCropTransform;
        this.cropInterval = cropInterval;
        this.timepointIdToTimepointIndex = timepointIdToTimepointIndex;
        this.setupImgLoaders = new HashMap();
        for (Map.Entry<Integer, Integer> entry : setupIdToSourceIndex.entrySet()) {
            this.setupImgLoaders.put(entry.getKey(), this.createSetupImgLoader(sources.get(entry.getValue())));
        }
    }

    public AffineTransform3D getCroppedTransform(ViewId view) {
        Pair pair = ((SetupImgLoader)this.getSetupImgLoader(view.getViewSetupId())).cropView(view.getTimePointId());
        return (AffineTransform3D)pair.getB();
    }

    public SetupImgLoader<?> getSetupImgLoader(int setupId) {
        return this.setupImgLoaders.get(setupId);
    }

    public static <T> Pair<RandomAccessibleInterval<T>, AffineTransform3D> crop(AffineTransform3D globalToCropTransform, RealInterval interval, Source<T> source, int timepoint) {
        int n = interval.numDimensions();
        AffineTransform3D cropToGlobal = globalToCropTransform.inverse();
        AffineTransform3D sourceToGlobal = new AffineTransform3D();
        source.getSourceTransform(timepoint, 0, sourceToGlobal);
        AffineTransform3D globalToSource = sourceToGlobal.inverse();
        AffineTransform3D cropToSource = globalToSource.copy();
        cropToSource.concatenate(cropToGlobal);
        ArrayList<RealPoint> sourceCorners = new ArrayList<RealPoint>();
        for (RealLocalizable corner : IntervalBoundingBox.getCorners(interval)) {
            RealPoint sourceCorner = new RealPoint(n);
            cropToSource.apply(corner, (RealPositionable)sourceCorner);
            sourceCorners.add(sourceCorner);
        }
        RandomAccessibleInterval<T> sourceImg = source.getSource(timepoint, 0);
        Interval cropBoundingBox = Intervals.smallestContainingInterval(IntervalBoundingBox.getBoundingBox(sourceCorners));
        FinalInterval sourceInterval = Intervals.intersect(cropBoundingBox, sourceImg);
        AffineTransform3D croppedSourceTransform = new AffineTransform3D();
        if (Intervals.isEmpty(sourceInterval)) {
            long[] minsize = new long[n * 2];
            for (int d = 0; d < n; ++d) {
                minsize[d] = cropBoundingBox.min(d) + cropBoundingBox.dimension(d) / 2L;
            }
            Arrays.fill(minsize, n, n * 2, 1L);
            sourceInterval = Intervals.createMinSize(minsize);
        }
        IntervalView croppedSourceImg = Views.zeroMin(Views.interval(Views.extendBorder(sourceImg), sourceInterval));
        croppedSourceTransform.set(1.0, 0.0, 0.0, (double)sourceInterval.min(0), 0.0, 1.0, 0.0, (double)sourceInterval.min(1), 0.0, 0.0, 1.0, (double)sourceInterval.min(2));
        croppedSourceTransform.preConcatenate(sourceToGlobal);
        return new ValuePair<RandomAccessibleInterval<T>, AffineTransform3D>(croppedSourceImg, croppedSourceTransform);
    }

    private <T> SetupImgLoader<T> createSetupImgLoader(Source<T> source) {
        return new SetupImgLoader<T>(source);
    }

    public class SetupImgLoader<T>
    implements BasicSetupImgLoader<T> {
        private final Source<T> source;

        protected SetupImgLoader(Source<T> source) {
            this.source = source;
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
            return this.cropView(timepointId).getA();
        }

        public T getImageType() {
            return this.source.getType();
        }

        private Pair<RandomAccessibleInterval<T>, AffineTransform3D> cropView(int timepointId) {
            int timepointIndex = (Integer)CropImgLoader.this.timepointIdToTimepointIndex.get(timepointId);
            return CropImgLoader.crop(CropImgLoader.this.globalToCropTransform, CropImgLoader.this.cropInterval, this.source, timepointIndex);
        }
    }
}

