/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui;

import bdv.ui.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class CardPanel {
    private static final String HEADER_BACKGROUND = "CheckBox.background";
    private static final String HEADER_FOREGROUND = "CheckBox.foreground";
    private final Map<Object, Card> cards = new HashMap<Object, Card>();
    private final List<Card> cardList = new ArrayList<Card>();
    private final Container container = new Container((LayoutManager)new MigLayout("fillx, ins 0", "[grow]", "[]0[]"));
    private static final Icon collapsedIcon = new CardCollapseIcon(10, 10, true, false);
    private static final Icon collapsedMouseOverIcon = new CardCollapseIcon(10, 10, true, true);
    private static final Icon expandedIcon = new CardCollapseIcon(10, 10, false, false);
    private static final Icon expandedMouseOverIcon = new CardCollapseIcon(10, 10, false, true);
    private static final int RESIZE_HANDLE_HEIGHT = 10;

    public JComponent getComponent() {
        return this.container;
    }

    public boolean addCard(String title, JComponent component, boolean expanded, Insets insets) {
        return this.addCard(title, title, component, expanded, insets);
    }

    public synchronized boolean addCard(Object key, String title, JComponent component, boolean expanded, Insets insets) {
        if (key == null || title == null || component == null) {
            throw new NullPointerException();
        }
        if (this.cards.containsKey(key)) {
            return false;
        }
        Card card = new Card(key, title, component, expanded, insets);
        this.cards.put(key, card);
        if (!this.cardList.isEmpty()) {
            this.cardList.get(this.cardList.size() - 1).setIsLastCard(false);
        }
        this.cardList.add(card);
        this.container.add((Component)card, "growx, wrap");
        this.container.revalidate();
        return true;
    }

    public boolean addCard(String title, JComponent component, boolean expanded) {
        return this.addCard(title, title, component, expanded, null);
    }

    public boolean addCard(Object key, String title, JComponent component, boolean expanded) {
        return this.addCard(key, title, component, expanded, null);
    }

    public synchronized void removeCard(Object key) {
        Card card = this.cards.remove(key);
        if (card != null) {
            this.cardList.remove(card);
            Card lastCard = this.cardList.get(this.cardList.size() - 1);
            lastCard.setIsLastCard(true);
            this.container.remove(card);
            this.container.revalidate();
        }
    }

    public synchronized int indexOf(Object key) {
        if (this.cards.containsKey(key)) {
            for (int i = 0; i < this.cardList.size(); ++i) {
                if (!this.cardList.get(i).getKey().equals(key)) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized boolean isCardExpanded(Object key) {
        Card card = this.cards.get(key);
        return card != null && card.isExpanded();
    }

    public synchronized void setCardExpanded(Object key, boolean expanded) {
        Card card = this.cards.get(key);
        if (card != null && card.isExpanded() != expanded) {
            card.setExpanded(expanded);
        }
    }

    private static class CardCollapseIcon
    implements Icon {
        private static final Color mouseOverColor = new Color(0x606060);
        private static final Color color = new Color(0x808080);
        private final int width;
        private final int height;
        private final boolean collapsed;
        private final boolean mouseOver;

        public CardCollapseIcon(int width, int height, boolean collapsed, boolean mouseOver) {
            this.width = width;
            this.height = height;
            this.collapsed = collapsed;
            this.mouseOver = mouseOver;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Path2D.Double path = new Path2D.Double();
            if (this.collapsed) {
                path.moveTo(0.05, 0.05);
                path.lineTo(0.85, 0.5);
                path.lineTo(0.05, 0.95);
            } else {
                path.moveTo(0.05, 0.05);
                path.lineTo(0.5, 0.85);
                path.lineTo(0.95, 0.05);
            }
            path.transform(AffineTransform.getScaleInstance(this.width, this.height));
            path.transform(AffineTransform.getTranslateInstance(x, y));
            g2d.setColor(this.mouseOver ? mouseOverColor : color);
            g2d.fill(path);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    private static class Container
    extends JPanel
    implements Scrollable {
        public Container(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class ResizeMouseHandler
    extends MouseAdapter {
        private final JComponent attachedComponent;
        private final Resizable resizable;
        private int oy;
        private int oheight;
        private int minheight;
        private int maxheight;
        private JComponent resizeComponent;

        public ResizeMouseHandler(JComponent attachedComponent, Resizable resizable) {
            this.attachedComponent = attachedComponent;
            this.resizable = resizable;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.resizeComponent = e.getY() < 10 ? this.resizable.getComponent() : null;
            if (this.resizeComponent != null) {
                this.oheight = this.resizeComponent.getHeight();
                this.minheight = this.resizeComponent.getMinimumSize().height;
                this.maxheight = this.resizeComponent.getMaximumSize().height;
                UIUtils.setPreferredHeight(this.resizeComponent, this.oheight);
                this.oy = e.getYOnScreen();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getY() < 10 && this.resizable.showResizeHandle()) {
                this.attachedComponent.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.attachedComponent.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.attachedComponent.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.resizeComponent != null) {
                int height = this.oheight + e.getYOnScreen() - this.oy;
                UIUtils.setPreferredHeight(this.resizeComponent, Math.min(this.maxheight, Math.max(this.minheight, height)));
                this.resizeComponent.revalidate();
            }
        }
    }

    private static interface Resizable {
        public boolean showResizeHandle();

        public JComponent getComponent();
    }

    private class Card
    extends JPanel {
        private final JPanel componentPanel;
        private final HeaderPanel headerPanel;
        private final TerminalResizePanel terminalResizePanel;
        private final Object key;
        private boolean isLastCard = true;
        private Color borderColor;

        public Card(Object key, String title, JComponent component, boolean open, Insets insets) {
            this.key = key;
            this.setLayout((LayoutManager)new MigLayout("fillx, ins 0, hidemode 3", "[grow]", "[]0lp![]"));
            String ins = insets == null ? "ins 4 4 4 0" : String.format("ins %d %d %d %d", insets.top, insets.left, insets.bottom, insets.right);
            this.componentPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3, " + ins, "[grow]", "[grow]0lp![]"));
            this.componentPanel.add((Component)component, "grow, wrap");
            this.headerPanel = new HeaderPanel(title);
            this.terminalResizePanel = new TerminalResizePanel();
            this.add((Component)this.headerPanel, "growx, wrap");
            this.add((Component)this.componentPanel, "growx, wrap");
            this.add((Component)this.terminalResizePanel, "growx");
            this.setExpanded(open);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Color bg = UIManager.getColor(CardPanel.HEADER_BACKGROUND);
            Color fg = UIManager.getColor(CardPanel.HEADER_FOREGROUND);
            this.borderColor = UIUtils.mix(bg, fg, 0.8);
            if (this.headerPanel != null) {
                this.headerPanel.setBackground(bg);
                this.headerPanel.label.setForeground(fg);
            }
        }

        public Object getKey() {
            return this.key;
        }

        public boolean isExpanded() {
            return this.componentPanel.isVisible();
        }

        public void setExpanded(boolean open) {
            this.componentPanel.setVisible(open);
            this.terminalResizePanel.setVisible(open && this.isLastCard);
            this.componentPanel.revalidate();
        }

        public void setIsLastCard(boolean isLastCard) {
            this.isLastCard = isLastCard;
            this.terminalResizePanel.setVisible(this.componentPanel.isVisible() && isLastCard);
            this.terminalResizePanel.revalidate();
        }

        public boolean equals(Object obj) {
            return obj instanceof Card && this.key.equals(((Card)obj).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JComponent getContentOfCardAbove() {
            CardPanel cardPanel = CardPanel.this;
            synchronized (cardPanel) {
                int i = CardPanel.this.cardList.indexOf(this);
                if (i <= 0) {
                    return null;
                }
                JPanel component = ((Card)((CardPanel)CardPanel.this).cardList.get((int)(i - 1))).componentPanel;
                JPanel jPanel = component.isVisible() ? component : null;
                return jPanel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCardAboveExpanded() {
            CardPanel cardPanel = CardPanel.this;
            synchronized (cardPanel) {
                int i = CardPanel.this.cardList.indexOf(this);
                if (i <= 0) {
                    return false;
                }
                return ((Card)CardPanel.this.cardList.get(i - 1)).isExpanded();
            }
        }

        private class TerminalResizePanel
        extends JPanel {
            public TerminalResizePanel() {
                UIUtils.setMinimumHeight(this, 5);
                UIUtils.setPreferredHeight(this, 5);
                this.setOpaque(false);
                ResizeMouseHandler resizeHandler = new ResizeMouseHandler(this, new Resizable(){

                    @Override
                    public boolean showResizeHandle() {
                        return true;
                    }

                    @Override
                    public JComponent getComponent() {
                        return Card.this.componentPanel;
                    }
                });
                this.addMouseListener(resizeHandler);
                this.addMouseMotionListener(resizeHandler);
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(Card.this.borderColor);
                g.fillRect(0, 0, this.getWidth(), 1);
            }
        }

        private class HeaderPanel
        extends JPanel {
            private final JPanel labelPanel;
            private final JLabel label;

            public HeaderPanel(String title) {
                super((LayoutManager)new MigLayout("fillx, aligny center, ins 0 0 0 0, gapx 0", "[][grow]", ""));
                UIUtils.setPreferredWidth(this, 100);
                this.setOpaque(false);
                this.setBorder(new EmptyBorder(1, 0, 1, 0));
                this.labelPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 0 0 0 4", "[grow]", ""));
                this.labelPanel.setOpaque(false);
                this.label = new JLabel(title);
                this.labelPanel.add(this.label);
                final JToggleButton collapseButton = new JToggleButton();
                collapseButton.setIcon(expandedIcon);
                collapseButton.setRolloverIcon(expandedMouseOverIcon);
                collapseButton.setSelectedIcon(collapsedIcon);
                collapseButton.setRolloverSelectedIcon(collapsedMouseOverIcon);
                collapseButton.setFocusable(false);
                collapseButton.setBorder(new EmptyBorder(5, 5, 5, 5));
                collapseButton.setBorderPainted(false);
                collapseButton.setFocusPainted(false);
                collapseButton.setContentAreaFilled(false);
                collapseButton.addActionListener(e -> Card.this.setExpanded(!collapseButton.isSelected()));
                Card.this.componentPanel.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        collapseButton.setSelected(false);
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        collapseButton.setSelected(true);
                    }
                });
                ResizeMouseHandler resizeHandler = new ResizeMouseHandler(this, new Resizable(){

                    @Override
                    public boolean showResizeHandle() {
                        return Card.this.isCardAboveExpanded();
                    }

                    @Override
                    public JComponent getComponent() {
                        return Card.this.getContentOfCardAbove();
                    }
                });
                this.addMouseListener(resizeHandler);
                this.addMouseMotionListener(resizeHandler);
                this.add(collapseButton);
                this.add((Component)this.labelPanel, "growx");
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
            }

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Card.this.borderColor);
                if (Card.this.isCardAboveExpanded()) {
                    g.fillRect(0, 0, this.getWidth(), 1);
                }
                if (Card.this.isExpanded()) {
                    g.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
                }
                g.setColor(this.getForeground());
                super.paintComponent(g);
            }
        }
    }
}

