/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import java.util.Collection;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class Process
implements IFunction {
    private final Cursor<? extends RealType<?>> c;

    public Process(OutputAlgorithm<? extends RealType<?>> algorithm) throws Exception {
        this.execute(algorithm);
        this.c = algorithm.getResult().createCursor();
    }

    public Process(Class<Algorithm> algorithmClass, IFunction fn, Object ... parameters) throws Exception {
        this(algorithmClass, Compute.inDoubles(fn), parameters);
    }

    public Process(Class<Algorithm> algorithmClass, Image<? extends RealType<?>> img, Object ... parameters) throws Exception {
        Class[] cargs = new Class[1 + parameters.length];
        Object[] args = new Object[cargs.length];
        cargs[0] = Image.class;
        args[0] = img;
        for (int i = 1; i < cargs.length; ++i) {
            cargs[i] = parameters[i - 1].getClass();
            args[i] = parameters[i - 1];
        }
        Algorithm a = algorithmClass.getConstructor(cargs).newInstance(args);
        this.execute(a);
        this.c = (a instanceof OutputAlgorithm ? ((OutputAlgorithm)a).getResult() : img).createCursor();
    }

    private final void execute(Algorithm algorithm) throws Exception {
        if (!algorithm.checkInput() || !algorithm.process()) {
            throw new Exception("Algorithm " + algorithm.getClass().getSimpleName() + " failed: " + algorithm.getErrorMessage());
        }
    }

    private Process(Cursor<? extends RealType<?>> c) {
        this.c = c;
    }

    public Image<? extends RealType<?>> getResult() {
        return this.c.getImage();
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new Process(this.c.getImage().createCursor());
    }

    @Override
    public final double eval() {
        this.c.fwd();
        return this.c.getType().getRealDouble();
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> cursors) {
        cursors.add(this.c);
    }
}

