/*
 * Decompiled with CFR 0.152.
 */
package vib.app.gui;

import ij.ImagePlus;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.io.File;
import vib.app.Options;
import vib.app.module.AverageBrain;
import vib.app.module.Label;
import vib.app.module.Module;
import vib.app.module.ModuleListener;
import vib.app.module.Resample;
import vib.app.module.SplitChannels;
import vib.app.module.TissueStatistics;
import vib.app.module.TransformImages;

public class ProgressIndicator
implements ModuleListener {
    private String[] modules = new String[]{new SplitChannels().getName(), new Label().getName(), new Resample().getName(), new TissueStatistics().getName(), new TransformImages().getName(), new AverageBrain().getName()};
    private String[] files;
    private int[][] done;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final int EXCEPTION = 2;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 500;
    private Garten garten;

    public ProgressIndicator(Options options) {
        this.done = new int[options.fileGroup.size() + 1][this.modules.length];
        this.files = new String[options.fileGroup.size()];
        for (int i = 0; i < options.fileGroup.size(); ++i) {
            this.files[i] = ((File)options.fileGroup.get(i)).getName();
        }
        this.showDialog();
    }

    public static void main(String[] args) {
        Options op = new Options();
        op.loadFrom("/home/bene/PhD/brains/VIB_Protocol/options.config");
        new ProgressIndicator(op);
    }

    @Override
    public void moduleFinished(Module m, int index) {
        if (index < 0) {
            return;
        }
        int modIndex = this.getModuleIndex(m.getName());
        if (modIndex != -1 && this.done[index][modIndex] != 1) {
            this.done[index][modIndex] = 1;
            this.garten.draw();
        }
    }

    @Override
    public void exceptionOccurred(Module m, int index) {
        if (index < 0) {
            return;
        }
        int modIndex = this.getModuleIndex(m.getName());
        if (modIndex != -1) {
            this.done[index][modIndex] = 2;
            this.garten.draw();
        }
    }

    private int getModuleIndex(String name) {
        for (int i = 0; i < this.modules.length; ++i) {
            if (!this.modules[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void showDialog() {
        this.garten = new Garten();
        this.garten.image.show();
        this.garten.draw();
    }

    class Garten {
        Font f = new Font("Verdana", 1, 12);
        int colW = this.calculateColWidth();
        int rowH = this.calculateRowHeight();
        int cols = ProgressIndicator.access$000(ProgressIndicator.this).length;
        int rows = ProgressIndicator.access$100(ProgressIndicator.this).length;
        final int xIndent = 10;
        final int yIndent = 10;
        final int strIndent = 5;
        ImagePlus image;
        ImageProcessor ip;
        final float SIN45 = (float)(0.5 * Math.sqrt(2.0));

        Garten() {
            this.ip = new ColorProcessor(this.colW * (this.cols + 1) + 20, this.rowH * (this.rows + 1) + 20);
            this.ip.setBackgroundValue(0.0);
            this.image = new ImagePlus("Progress", this.ip);
        }

        public void draw() {
            int i;
            this.ip.setFont(this.f);
            this.ip.setColor(Color.WHITE);
            for (i = 0; i < this.rows; ++i) {
                this.ip.drawLine(10, 15 + (i + 1) * this.rowH, (this.cols + 1) * this.colW, 15 + (i + 1) * this.rowH);
            }
            for (i = 0; i < this.cols; ++i) {
                this.ip.drawLine(10 + (i + 1) * this.colW, 10, 10 + (i + 1) * this.colW, 15 + (this.rows + 1) * this.rowH);
            }
            for (i = 0; i < ProgressIndicator.this.modules.length; ++i) {
                this.ip.drawString(ProgressIndicator.this.modules[i], (i + 1) * this.colW + 10 + 5, this.rowH + 10);
            }
            for (i = 0; i < ProgressIndicator.this.files.length; ++i) {
                this.ip.drawString(ProgressIndicator.this.files[i], 15, 10 + (i + 2) * this.rowH);
            }
            for (i = 0; i < ProgressIndicator.this.files.length; ++i) {
                block10: for (int j = 0; j < ProgressIndicator.this.modules.length; ++j) {
                    switch (ProgressIndicator.this.done[i][j]) {
                        case 1: {
                            this.drawOK(i, j);
                            continue block10;
                        }
                        case 0: {
                            this.drawNY(i, j);
                            continue block10;
                        }
                        case 2: {
                            this.drawEX(i, j);
                        }
                    }
                }
            }
            this.image.updateAndDraw();
        }

        public void drawNY(int file, int mod) {
            int xOffs = 10 + (mod + 1) * this.colW;
            int yOffs = 15 + (file + 1) * this.rowH;
            int r = (this.rowH - 5) / 2;
            int cx = xOffs + this.colW / 2;
            int cy = yOffs + this.rowH / 2;
            this.ip.setColor(Color.GRAY);
            this.ip.fillOval(cx - r, cy - r, 2 * r, 2 * r);
            this.ip.setColor(Color.BLACK);
            this.ip.drawOval(cx - r, cy - r, 2 * r, 2 * r);
        }

        public void drawOK(int file, int mod) {
            int xOffs = 10 + (mod + 1) * this.colW;
            int yOffs = 15 + (file + 1) * this.rowH;
            int r = (this.rowH - 5) / 2;
            int cx = xOffs + this.colW / 2;
            int cy = yOffs + this.rowH / 2;
            this.ip.setColor(Color.GREEN);
            this.ip.fillOval(cx - r, cy - r, 2 * r, 2 * r);
            this.ip.setColor(Color.BLACK);
            int cross = (int)((float)r * this.SIN45);
            this.ip.drawLine(cx - cross, cy, cx, cy + cross);
            this.ip.drawLine(cx, cy + cross, cx + cross, cy - cross);
            this.ip.setColor(Color.WHITE);
            this.ip.drawLine(cx + cross, cy - cross, cx + r, cy - r);
        }

        public void drawEX(int file, int mod) {
            int xOffs = 10 + (mod + 1) * this.colW;
            int yOffs = 15 + (file + 1) * this.rowH;
            int r = (this.rowH - 5) / 2;
            int cx = xOffs + this.colW / 2;
            int cy = yOffs + this.rowH / 2;
            this.ip.setColor(Color.RED);
            this.ip.fillOval(cx - r, cy - r, 2 * r, 2 * r);
            this.ip.setColor(Color.BLACK);
            this.ip.drawOval(cx - r, cy - r, 2 * r, 2 * r);
            int cross = (int)((float)r * this.SIN45);
            this.ip.drawLine(cx - cross, cy - cross, cx + cross, cy + cross);
            this.ip.drawLine(cx - cross, cy + cross, cx + cross, cy - cross);
        }

        public int calculateColWidth() {
            int c;
            int i;
            int w = 0;
            FontMetrics fm = new Frame().getFontMetrics(this.f);
            for (i = 0; i < ProgressIndicator.this.modules.length; ++i) {
                c = fm.stringWidth(ProgressIndicator.this.modules[i]);
                if (w >= c) continue;
                w = c;
            }
            for (i = 0; i < ProgressIndicator.this.files.length; ++i) {
                c = fm.stringWidth(ProgressIndicator.this.files[i]);
                if (w >= c) continue;
                w = c;
            }
            return w + 10;
        }

        public int calculateRowHeight() {
            return new Frame().getFontMetrics(this.f).getHeight() + 10;
        }
    }
}

