/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;

public class FinalizerRegistry {
    private final ReferenceQueue<Environment> queue = new ReferenceQueue();
    private final Set<Finalizer> finalizers = new HashSet<Finalizer>();

    public void register(Environment environment2, Closure closure, boolean onExit) {
        this.finalizers.add(new Finalizer(environment2, closure, onExit));
    }

    public void finalizeDisposedEnvironments(Context context) {
        Reference<Environment> ref;
        while ((ref = this.queue.poll()) != null) {
            Finalizer finalizer2 = (Finalizer)ref;
            this.finalizers.remove(finalizer2);
            finalizer2.invoke(context);
        }
    }

    public void finalizeOnExit(Context context) {
        ArrayList<Finalizer> toInvoke = new ArrayList<Finalizer>(this.finalizers);
        this.finalizers.clear();
        for (Finalizer finalizer2 : toInvoke) {
            if (!finalizer2.isOnExit()) continue;
            finalizer2.invoke(context);
        }
    }

    private class Finalizer
    extends WeakReference<Environment> {
        private final Closure function;
        private boolean onExit;

        public Finalizer(Environment environment2, Closure function2, boolean onExit) {
            super(environment2, FinalizerRegistry.this.queue);
            this.function = function2;
            this.onExit = onExit;
        }

        private void invoke(Context context) {
            context.evaluate(new FunctionCall(this.function, PairList.Node.singleton(this.getEnvironment())));
        }

        public Environment getEnvironment() {
            Environment e = (Environment)this.get();
            if (e == null) {
                throw new IllegalStateException("Environment has already been garbage collected!");
            }
            return e;
        }

        public boolean isOnExit() {
            return this.onExit;
        }
    }
}

