/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import com.google.common.base.Strings;
import org.renjin.primitives.combine.CombinedBuilder;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class MaterializedBuilder
implements CombinedBuilder {
    private Vector.Builder vector;
    private StringVector.Builder names = new StringVector.Builder();
    private boolean haveNames = false;
    private boolean useNames = false;

    MaterializedBuilder(Vector.Type resultType) {
        this.vector = resultType.newBuilder();
    }

    @Override
    public CombinedBuilder useNames(boolean useNames) {
        this.useNames = useNames;
        return this;
    }

    @Override
    public void add(String prefix, SEXP sexp) {
        this.vector.add(sexp);
        this.addName(prefix);
    }

    @Override
    public void addElements(String prefix, Vector value) {
        for (int i = 0; i != value.length(); ++i) {
            this.vector.addFrom(value, i);
            if (!this.useNames) continue;
            this.addNameFrom(prefix, value, i);
        }
    }

    @Override
    public Vector build() {
        if (this.haveNames) {
            this.vector.setAttribute(Symbols.NAMES, (SEXP)this.names.build());
        }
        return this.vector.build();
    }

    private void addNameFrom(String prefix, SEXP vector2, int index) {
        StringBuilder name = new StringBuilder(prefix);
        String elementName = vector2.getName(index);
        if (!Strings.isNullOrEmpty((String)elementName)) {
            if (name.length() > 0) {
                name.append('.');
            }
            name.append(elementName);
        } else if (name.length() > 0 && vector2.length() > 1) {
            name.append(index + 1);
        }
        this.addName(name.toString());
    }

    private void addName(String name) {
        if (name.length() > 0) {
            this.haveNames = true;
        }
        this.names.add(name);
    }
}

