/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class HashFrame
implements Frame {
    private IdentityHashMap<Symbol, SEXP> values = new IdentityHashMap();
    private int functionFilter = 0;

    @Override
    public Set<Symbol> getSymbols() {
        return this.values.keySet();
    }

    @Override
    public SEXP getVariable(Symbol name) {
        SEXP value = this.values.get(name);
        return value == null ? Symbol.UNBOUND_VALUE : value;
    }

    @Override
    public Function getFunction(Context context, Symbol name) {
        SEXP value;
        if (this.functionFilter != 0 && (this.functionFilter & name.hashBit()) != 0 && (value = this.values.get(name)) != null) {
            if ((value = value.force(context)) == Symbol.MISSING_ARG) {
                throw new EvalException("argument '%s' is missing with no default", name.toString());
            }
            if (value instanceof Function) {
                return (Function)value;
            }
        }
        return null;
    }

    @Override
    public boolean isMissingArgument(Symbol name) {
        if (this.functionFilter != 0 && (this.functionFilter & name.hashBit()) != 0) {
            return this.values.get(name) == Symbol.MISSING_ARG;
        }
        return false;
    }

    @Override
    public void setVariable(Symbol name, SEXP value) {
        this.values.put(name, value);
        if (value instanceof Function || value instanceof Promise || value == Symbol.MISSING_ARG) {
            this.functionFilter |= name.hashBit();
        }
    }

    @Override
    public void remove(Symbol name) {
        this.values.remove(name);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Symbol, SEXP> entry : this.values.entrySet()) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }
}

