/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealArithmeticMeanFunction;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.function.real.RealMaxFunction;
import net.imglib2.ops.function.real.RealMedianFunction;
import net.imglib2.ops.function.real.RealMinFunction;
import net.imglib2.ops.function.real.RealSumFunction;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", headless=true, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Bin...", mnemonic=98)}, attrs={@Attr(name="no-legacy")})
public class Binner<T extends RealType<T>>
extends ContextCommand {
    private static final String AVERAGE = "Average";
    private static final String SUM = "Sum";
    private static final String MIN = "Min";
    private static final String MAX = "Max";
    private static final String MEDIAN = "Median";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Dimension reduction factors", persist=false)
    private String dimFactors;
    @Parameter(label="Value method", choices={"Average", "Sum", "Min", "Max", "Median"})
    private String method = "Average";
    @Parameter
    private DatasetService datasetService;
    private String err = null;
    private List<Integer> factors = new ArrayList<Integer>();

    public void setDataset(Dataset ds) {
        this.dataset = ds;
        this.init();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setFactor(int d, int factor) {
        if (d < 0 || d >= this.factors.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.factors.size() - 1) + ")");
        }
        this.factors.set(d, factor);
        this.dimFactors = this.factorsString();
    }

    public int getFactor(int d) {
        if (d < 0 || d >= this.factors.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.factors.size() - 1) + ")");
        }
        return this.factors.get(d);
    }

    public void setValueMethod(String str) {
        if (str.equals(AVERAGE)) {
            this.method = AVERAGE;
        } else if (str.equals(MAX)) {
            this.method = MAX;
        } else if (str.equals(MEDIAN)) {
            this.method = MEDIAN;
        } else if (str.equals(MIN)) {
            this.method = MIN;
        } else if (str.equals(SUM)) {
            this.method = SUM;
        } else {
            throw new IllegalArgumentException("Unknown value method: " + str);
        }
    }

    public String getValueMethod() {
        return this.method;
    }

    public String getError() {
        return this.err;
    }

    public void run() {
        List<Integer> reductions = this.parseReductions(this.dataset, this.dimFactors);
        if (reductions == null) {
            this.cancel(this.err);
            return;
        }
        this.reduceData(this.dataset, reductions);
    }

    protected void init() {
        this.factors.clear();
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            this.factors.add(1);
        }
        this.dimFactors = this.factorsString();
    }

    private List<Integer> parseReductions(Dataset ds, String spec) {
        int i;
        if (spec == null) {
            this.err = "Dimension reduction specification string is null.";
            return null;
        }
        String[] terms = spec.split(",");
        if (terms.length == 0) {
            this.err = "Dimension reduction specification string is empty.";
            return null;
        }
        ArrayList<Integer> reductions = new ArrayList<Integer>();
        for (i = 0; i < ds.numDimensions(); ++i) {
            reductions.add(1);
        }
        for (i = 0; i < terms.length; ++i) {
            int factor;
            int axisIndex;
            String term = terms[i].trim();
            String[] parts = term.split("=");
            if (parts.length != 2) {
                this.err = "Err in dimension reduction specification string: each dimension must be two numbers separated by an '=' sign.";
                return null;
            }
            try {
                axisIndex = Integer.parseInt(parts[0].trim());
                factor = Integer.parseInt(parts[1].trim());
            }
            catch (NumberFormatException e) {
                this.err = "Err in dimension reduction specification string: each dimension must be two numbers separated by an '=' sign.";
                return null;
            }
            if (axisIndex < 0 || axisIndex >= ds.numDimensions()) {
                this.err = "An axis index is outside dimensionality of input dataset.";
                return null;
            }
            if (factor < 1 || (long)factor > ds.dimension(axisIndex)) {
                this.err = "Reduction factor " + i + " must be between 1 and " + ds.dimension(axisIndex) + ".";
                return null;
            }
            reductions.set(axisIndex, factor);
        }
        return reductions;
    }

    private void reduceData(Dataset ds, List<Integer> reductionFactors) {
        Function<PointSet, T> func = this.function(ds);
        PointSet neigh = this.neighborhood(reductionFactors);
        Dataset newDs = this.newData(ds, reductionFactors);
        long[] currPos = new long[newDs.numDimensions()];
        long[] lastPos = new long[newDs.numDimensions()];
        long[] translation = new long[ds.numDimensions()];
        Cursor cursor = newDs.getImgPlus().localizingCursor();
        RealType var = (RealType)((RealType)cursor.get()).createVariable();
        while (cursor.hasNext()) {
            cursor.next();
            cursor.localize(currPos);
            this.findTranslation(lastPos, currPos, reductionFactors, translation);
            for (int i = 0; i < lastPos.length; ++i) {
                lastPos[i] = currPos[i];
            }
            neigh.translate(translation);
            func.compute((Object)neigh, (Object)var);
            ((RealType)cursor.get()).set((Type)var);
        }
        ds.setImgPlus(newDs.getImgPlus());
    }

    private String factorsString() {
        String str = "";
        for (int i = 0; i < this.factors.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + i + "=" + this.factors.get(i);
        }
        return str;
    }

    private Function<PointSet, T> function(Dataset ds) {
        ImgPlus img = ds.getImgPlus();
        OutOfBoundsMirrorFactory oobFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE);
        RealType var = (RealType)img.firstElement();
        RealImageFunction imgFunc = new RealImageFunction((RandomAccessibleInterval)img, (OutOfBoundsFactory)oobFactory, var);
        if (this.method == AVERAGE) {
            return new RealArithmeticMeanFunction((Function)imgFunc);
        }
        if (this.method == MAX) {
            return new RealMaxFunction((Function)imgFunc);
        }
        if (this.method == MEDIAN) {
            return new RealMedianFunction((Function)imgFunc);
        }
        if (this.method == MIN) {
            return new RealMinFunction((Function)imgFunc);
        }
        if (this.method == SUM) {
            return new RealSumFunction((Function)imgFunc);
        }
        throw new IllegalArgumentException("unknown method: " + this.method);
    }

    private PointSet neighborhood(List<Integer> reductionFactors) {
        long[] dims = this.neighSize(reductionFactors);
        return new HyperVolumePointSet(dims);
    }

    private Dataset newData(Dataset origDs, List<Integer> reductionFactors) {
        long[] newDims = this.newDims(origDs, reductionFactors);
        String name = origDs.getName();
        AxisType[] axisTypes = new AxisType[origDs.numDimensions()];
        for (int i = 0; i < axisTypes.length; ++i) {
            axisTypes[i] = ((CalibratedAxis)origDs.axis(i)).type();
        }
        int bitsPerPixel = ((RealType)origDs.getImgPlus().firstElement()).getBitsPerPixel();
        boolean signed = origDs.isSigned();
        boolean floating = !origDs.isInteger();
        boolean virtual = AbstractCellImg.class.isAssignableFrom(origDs.getImgPlus().getImg().getClass());
        return this.datasetService.create(newDims, name, axisTypes, bitsPerPixel, signed, floating, virtual);
    }

    private void findTranslation(long[] newDsLastPos, long[] newDsCurrPos, List<Integer> reductionFactors, long[] origDsTranslation) {
        for (int i = 0; i < origDsTranslation.length; ++i) {
            origDsTranslation[i] = newDsCurrPos[i] - newDsLastPos[i];
            int n = i;
            origDsTranslation[n] = origDsTranslation[n] * (long)reductionFactors.get(i).intValue();
        }
    }

    private long[] neighSize(List<Integer> reductionFactors) {
        long[] neighSize = new long[reductionFactors.size()];
        for (int i = 0; i < neighSize.length; ++i) {
            neighSize[i] = reductionFactors.get(i).intValue();
        }
        return neighSize;
    }

    private long[] newDims(Dataset ds, List<Integer> reductionFactors) {
        long[] dims = new long[ds.numDimensions()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = ds.dimension(i) / (long)reductionFactors.get(i).intValue();
            if (ds.dimension(i) % (long)reductionFactors.get(i).intValue() == 0L) continue;
            int n = i;
            dims[n] = dims[n] + 1L;
        }
        return dims;
    }
}

