/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.DisplayablePanel;
import ini.trakem2.display.ZDisplayable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class RollingPanel
extends JPanel
implements ComponentListener,
AdjustmentListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private final Display display;
    private final Class<?> clazz;
    private final Map<Displayable, DisplayablePanel> current;
    private final JPanel inner;
    private final JPanel filler;
    private final JScrollBar scrollBar;
    private final GridBagLayout gbInner;
    private final GridBagConstraints cInner;

    protected RollingPanel(Display display, Class<?> clazz) {
        this.display = display;
        this.clazz = clazz;
        this.current = new HashMap<Displayable, DisplayablePanel>();
        this.inner = new JPanel();
        this.filler = new JPanel();
        this.gbInner = new GridBagLayout();
        this.cInner = new GridBagConstraints();
        this.inner.setLayout(this.gbInner);
        this.inner.setBackground(Color.white);
        this.scrollBar = new JScrollBar();
        this.scrollBar.setUnitIncrement(1);
        this.scrollBar.setBlockIncrement(1);
        this.scrollBar.setMaximum(this.getList().size());
        this.setBackground(Color.white);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gb);
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gb.setConstraints(this.inner, c);
        this.add(this.inner);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 3;
        gb.setConstraints(this.scrollBar, c);
        this.add(this.scrollBar);
        this.addComponentListener(this);
        this.scrollBar.addAdjustmentListener(this);
        this.addMouseWheelListener(this);
        this.scrollBar.addMouseWheelListener(this);
    }

    public final void updateList() {
        try {
            this.updateList2();
        }
        catch (Exception e) {
            try {
                Thread.sleep(1000L);
                this.updateList2();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private final synchronized void updateList2() {
        int i;
        DisplayablePanel[] toReuse;
        boolean notReusing;
        int last;
        List<? extends Displayable> list = this.getList();
        int count = this.getList().size();
        if (list.isEmpty()) {
            this.current.clear();
            if (this.inner.getComponentCount() > 0) {
                this.inner.removeAll();
                this.scrollBar.setMaximum(0);
                this.revalidate();
            }
            return;
        }
        int numCanFit = (int)Math.floor((float)this.inner.getBounds().height / 52.0f);
        if (this.scrollBar.getMaximum() != count || this.scrollBar.getVisibleAmount() != numCanFit) {
            this.scrollBar.getModel().setRangeProperties(Math.max(0, this.scrollBar.getValue()), numCanFit, 0, count, false);
        }
        this.current.clear();
        int first = this.scrollBar.getValue();
        if (-1 == first) {
            this.scrollBar.setValue(0);
            first = 0;
        }
        if ((last = (first = list.size() - first - 1) - numCanFit + 1) < 0) {
            first = Math.min(numCanFit, count) - 1;
            last = 0;
        }
        if (first - last + 1 != this.inner.getComponentCount() - 1) {
            this.inner.removeAll();
            notReusing = true;
            toReuse = null;
        } else {
            notReusing = false;
            toReuse = new DisplayablePanel[first - last + 1];
            i = 0;
            for (Component c : this.inner.getComponents()) {
                if (DisplayablePanel.class != c.getClass()) continue;
                toReuse[i++] = (DisplayablePanel)c;
            }
        }
        this.cInner.anchor = 18;
        this.cInner.fill = 2;
        this.cInner.weightx = 0.0;
        this.cInner.weighty = 0.0;
        this.cInner.gridy = 0;
        i = first;
        int k = 0;
        while (i >= last) {
            DisplayablePanel dp;
            Displayable d = list.get(i);
            if (notReusing) {
                dp = new DisplayablePanel(this.display, d);
                this.gbInner.setConstraints(dp, this.cInner);
                this.inner.add(dp);
                ++this.cInner.gridy;
            } else {
                dp = toReuse[k];
                dp.set(d);
            }
            this.current.put(d, dp);
            --i;
            ++k;
        }
        if (notReusing) {
            this.cInner.fill = 1;
            this.cInner.weightx = 1.0;
            this.cInner.weighty = 1.0;
            this.gbInner.setConstraints(this.filler, this.cInner);
            this.inner.add(this.filler);
            this.inner.validate();
        }
    }

    private final List<? extends Displayable> getList() {
        if (ZDisplayable.class == this.clazz) {
            return this.display.getLayerSet().getDisplayableList();
        }
        return this.display.getLayer().getDisplayables(this.clazz);
    }

    protected boolean isShowing(Displayable d) {
        return this.current.containsKey(d);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateList();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (0 == this.inner.getComponentCount()) {
            this.updateList();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateList();
    }

    public void scrollToShow(Displayable d) {
        DisplayablePanel dp = this.current.get(d);
        if (null == dp) {
            List<? extends Displayable> list = this.getList();
            this.scrollBar.setValue(list.size() - list.indexOf(d) - 1);
        } else {
            dp.repaint();
        }
    }

    @Override
    public void update(Graphics g) {
        if (0 == this.inner.getComponentCount()) {
            this.updateList();
        }
        super.update(g);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int newVal = this.scrollBar.getValue() + (e.getWheelRotation() > 0 ? 1 : -1);
        if (newVal >= 0 && newVal <= this.scrollBar.getMaximum()) {
            this.scrollBar.setValue(newVal);
        }
    }
}

