/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.ResultsTable;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class Selection {
    public static int PADDING = 31;
    private Display display;
    private final LinkedList<Displayable> queue = new LinkedList();
    private final LinkedList<Displayable> queue_prev = new LinkedList();
    private final Object queue_lock = new Object();
    private final HashSet<Displayable> hs = new HashSet();
    private Displayable active = null;
    private Rectangle box = null;

    public Selection(Display display) {
        this.display = display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Displayable d) {
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                if (!this.queue.contains(d)) {
                    Utils.log2("Selection.setActive warning: " + d + " is not part of the selection");
                    return;
                }
                this.active = d;
                if (null != this.display && this.active instanceof ZDisplayable) {
                    this.active.setLayer(this.display.getLayer());
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        this.display.setActive(d);
    }

    public Displayable getActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Displayable d) {
        if (null == d) {
            Utils.log2("Selection.add warning: skipping null ob");
            return;
        }
        try {
            Object object = this.queue_lock;
            synchronized (object) {
                block18: {
                    this.active = d;
                    if (!this.queue.contains(d)) break block18;
                    if (null != this.display && d instanceof ZDisplayable) {
                        d.setLayer(this.display.getLayer());
                    }
                    Utils.log2("Selection.add warning: already have " + d + " selected.");
                    return;
                }
                this.setPrev(this.queue);
                this.queue.add(d);
                Rectangle b = d.getBoundingBox(new Rectangle());
                if (null == this.box) {
                    this.box = b;
                } else {
                    this.box.add(b);
                }
                if (!this.hs.contains(d)) {
                    this.hs.add(d);
                    HashSet<Displayable> hsl = d.getLinkedGroup(new HashSet<Displayable>());
                    if (null != hsl) {
                        for (Displayable displ : hsl) {
                            if (this.hs.contains(displ)) continue;
                            this.hs.add(displ);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (null != this.display) {
                this.display.setActive(d);
            }
        }
    }

    public void selectAll() {
        if (null == this.display) {
            return;
        }
        ArrayList<Displayable> al = this.display.getLayer().getDisplayables();
        al.addAll(this.display.getLayer().getParent().getZDisplayables());
        this.selectAll(al);
    }

    public void selectAllVisible() {
        if (null == this.display) {
            return;
        }
        ArrayList<Displayable> al = this.display.getLayer().getDisplayables();
        al.addAll(this.display.getLayer().getParent().getZDisplayables());
        Rectangle tmp = new Rectangle();
        Iterator<Displayable> it = al.iterator();
        while (it.hasNext()) {
            Displayable d = it.next();
            if (!d.isVisible() || 0.0f == d.getAlpha()) {
                it.remove();
                continue;
            }
            Rectangle box = d.getBounds(tmp, this.display.getLayer());
            if (0 != box.width && 0 != box.height) continue;
            it.remove();
        }
        if (al.size() > 0) {
            this.selectAll(al);
        }
    }

    public void selectAll(Layer layer) {
        this.selectAll(layer.getDisplayables());
    }

    public void selectAll(Roi roi, boolean visible_only) {
        if (null == this.display) {
            return;
        }
        if (null == roi) {
            if (visible_only) {
                this.selectAllVisible();
                return;
            }
            roi = new ShapeRoi((Shape)this.display.getLayerSet().get2DBounds());
        }
        ShapeRoi shroi = roi instanceof ShapeRoi ? (ShapeRoi)roi : new ShapeRoi(roi);
        Area aroi = new Area(shroi.getShape());
        AffineTransform affine = new AffineTransform();
        Rectangle bounds = shroi.getBounds();
        affine.translate(bounds.x, bounds.y);
        aroi = aroi.createTransformedArea(affine);
        ArrayList<Displayable> al = new ArrayList<Displayable>(this.display.getLayer().getDisplayables(Displayable.class, aroi, visible_only, true));
        al.addAll(this.display.getLayer().getParent().findZDisplayables(ZDisplayable.class, this.display.getLayer(), aroi, visible_only, true));
        Rectangle tmp = new Rectangle();
        if (visible_only) {
            Iterator it = al.iterator();
            while (it.hasNext()) {
                Displayable d = (Displayable)it.next();
                if (!d.isVisible() || 0.0f == d.getAlpha()) {
                    it.remove();
                    continue;
                }
                Rectangle box = d.getBounds(tmp, this.display.getLayer());
                if (0 != box.width && 0 != box.height) continue;
                it.remove();
            }
        }
        if (al.size() > 0) {
            this.selectAll(al);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll(Collection<? extends Displayable> al) {
        block14: {
            if (al.isEmpty()) {
                return;
            }
            Displayable the_active = null;
            try {
                Object object = this.queue_lock;
                synchronized (object) {
                    this.setPrev(this.queue);
                    for (Displayable displayable : al) {
                        if (this.queue.contains(displayable)) continue;
                        this.queue.add(displayable);
                        if (this.hs.contains(displayable)) continue;
                        this.hs.add(displayable);
                        HashSet<Displayable> hsl = displayable.getLinkedGroup(new HashSet<Displayable>());
                        if (null == hsl) continue;
                        for (Displayable displ : hsl) {
                            if (this.hs.contains(displ)) continue;
                            this.hs.add(displ);
                        }
                    }
                    this.resetBox();
                    if (null != this.display) {
                        if (null == this.active) {
                            this.active = the_active = this.queue.getLast();
                        } else {
                            the_active = this.active;
                        }
                    }
                }
                this.display.setActive(the_active);
            }
            catch (Exception e) {
                IJError.print(e);
                break block14;
            }
            finally {
                this.display.setActive(the_active);
                Display.update(this.display.getLayer());
            }
            Display.update(this.display.getLayer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAll() {
        int size = 0;
        Object object = this.queue_lock;
        synchronized (object) {
            size = this.queue.size();
            if (0 == size) {
                return false;
            }
        }
        if (!Utils.check("Remove " + size + " selected object" + (1 == size ? "?" : "s?"))) {
            return false;
        }
        HashSet<Displayable> set = new HashSet<Displayable>();
        Object object2 = this.queue_lock;
        synchronized (object2) {
            if (size != this.queue.size()) {
                Utils.log("Number of selected objects has changed!");
                return false;
            }
            try {
                this.setPrev(this.queue);
                this.active = null;
                set.addAll(this.queue);
                this.queue.clear();
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        if (null != this.display) {
            this.display.setActive(null);
            this.display.getLayerSet().addChangeTreesStep();
        }
        ((Displayable)set.iterator().next()).getProject().removeAll(set);
        Display.updateSelection();
        if (null != this.display) {
            this.display.getLayerSet().addChangeTreesStep();
        }
        return true;
    }

    private void setPrev(LinkedList<Displayable> q) {
        if (0 == q.size()) {
            return;
        }
        this.queue_prev.clear();
        this.queue_prev.addAll(q);
    }

    public void removeAll(Collection<Displayable> col) {
        for (Displayable d : col) {
            this.remove(d);
        }
    }

    /*
     * Exception decompiling
     */
    public void remove(Displayable d) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int size = 0;
        Object object = this.queue_lock;
        synchronized (object) {
            size = this.queue.size();
        }
        if (null != this.display && size > 0) {
            this.display.setActive(null);
            Display.repaint(this.display.getLayer(), 5, this.box, false);
        }
        Rectangle bb = null;
        try {
            Object object2 = this.queue_lock;
            synchronized (object2) {
                if (size != this.queue.size()) {
                    Utils.log("Interrupted clearing selection: number of selected items changed!");
                    return;
                }
                this.setPrev(this.queue);
                this.queue.clear();
                this.hs.clear();
                this.active = null;
                bb = this.box;
                this.box = null;
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        if (null != this.display) {
            Display.repaint(this.display.getLayer(), 5, bb, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getLinkedBox() {
        if (null == this.active) {
            return null;
        }
        Rectangle b = this.active.getBoundingBox();
        Layer layer = this.display.getLayer();
        Rectangle r = new Rectangle();
        Object object = this.queue_lock;
        synchronized (object) {
            for (Displayable d : this.hs) {
                if (d.equals(this.active) || !d.getLayer().equals(layer)) continue;
                b.add(d.getBoundingBox(r));
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        Object object = this.queue_lock;
        synchronized (object) {
            if (null == this.active || null == this.hs || this.hs.isEmpty()) {
                return false;
            }
            for (Displayable d : this.hs) {
                if (!d.isLocked2()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocked(final boolean b) {
        HashSet<Displayable> hs;
        Object object = this.queue_lock;
        synchronized (object) {
            hs = new HashSet<Displayable>(this.hs);
        }
        this.apply("locked", new Action(){

            @Override
            void exec(Displayable d) {
                d.setLocked(b);
            }

            @Override
            void post(Collection<Displayable> queue_copy, HashSet<Displayable> hs_copy) {
                Display.updateCheckboxes(hs, 1, b);
            }
        });
    }

    final void addDataEditStep(String[] fields) {
        if (null != this.display) {
            this.display.getLayerSet().addDataEditStep(new HashSet<Displayable>(this.queue), fields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(String field, Action task) {
        HashSet<Displayable> hs_copy;
        LayerSet ls;
        if (null == this.active) {
            return;
        }
        HashSet<Displayable> sel = new HashSet<Displayable>();
        Iterator iterator = this.queue_lock;
        synchronized (iterator) {
            sel.addAll(this.queue);
            ls = this.active.getLayer().getParent();
            hs_copy = new HashSet<Displayable>(this.hs);
        }
        ls.addDataEditStep(sel, new String[]{field});
        try {
            for (Displayable d : sel) {
                task.exec(d);
            }
            task.post(sel, hs_copy);
            ls.addDataEditStep(sel, new String[]{field});
        }
        catch (Exception e) {
            IJError.print(e);
            ls.undoOneStep();
        }
    }

    public void setColor(final Color c) {
        this.apply("color", new Action(){

            @Override
            void exec(Displayable d) {
                d.setColor(c);
            }
        });
    }

    public void setAlpha(final float alpha) {
        this.apply("alpha", new Action(){

            @Override
            void exec(Displayable d) {
                d.setAlpha(alpha);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.queue_lock;
        synchronized (object) {
            return 0 == this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Displayable d) {
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                return this.queue.contains(d);
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Class<?> c) {
        if (null == c) {
            return false;
        }
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                if (c.equals(Displayable.class) && this.queue.size() > 0) {
                    return true;
                }
                for (Displayable d : this.queue) {
                    if (!c.isInstance(d)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return false;
    }

    protected void debug(String msg) {
        Utils.log2(msg + ": queue size = " + this.queue.size() + "  hs size: " + this.hs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        Object object = this.queue_lock;
        synchronized (object) {
            if (null != this.display && this.display.getCanvas().isTransforming()) {
                Utils.log2("Selection.update warning: shouldn't be doing this while transforming!");
                return;
            }
        }
        HashSet<Displayable> hsl = new HashSet<Displayable>();
        try {
            Object object2 = this.queue_lock;
            synchronized (object2) {
                block16: {
                    Utils.log2("updating selection");
                    this.hs.clear();
                    for (Displayable d : this.queue) {
                        hsl = d.getLinkedGroup(hsl);
                    }
                    if (0 != hsl.size()) break block16;
                    this.active = null;
                    return;
                }
                this.hs.addAll(hsl);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        finally {
            if (0 == hsl.size() && null != this.display) {
                this.display.setActive(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTransform(Displayable d) {
        if (null == d) {
            Utils.log2("Selection.updateTransform warning: null Displayable");
            return;
        }
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                if (!this.hs.contains(d)) {
                    Utils.log2("Selection.updateTransform warning: " + d + " not selected or among the linked");
                    return;
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNSelected() {
        Object object = this.queue_lock;
        synchronized (object) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNLinked() {
        Object object = this.queue_lock;
        synchronized (object) {
            return this.hs.size();
        }
    }

    public void rotate(double angle, double xo, double yo) {
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(angle), xo, yo);
        Displayable.preConcatenate(at, this.getAffected());
    }

    public void translate(double dx, double dy) {
        AffineTransform at = new AffineTransform();
        at.translate(dx, dy);
        Displayable.preConcatenate(at, this.getAffected());
    }

    public void scale(double sx, double sy, double x_o, double y_o) {
        if (0.0 == sx || 0.0 == sy) {
            Utils.showMessage("Cannot scale to 0.");
            return;
        }
        AffineTransform at = new AffineTransform();
        at.translate(x_o, y_o);
        at.scale(sx, sy);
        at.translate(-x_o, -y_o);
        Displayable.preConcatenate(at, this.getAffected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Displayable> getSelected() {
        Object object = this.queue_lock;
        synchronized (object) {
            return new ArrayList<Displayable>(this.queue);
        }
    }

    public ArrayList<Displayable> getSelected(Class<?> c) {
        if (null == c || c == Displayable.class) {
            return this.getSelected();
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Displayable d : this.getSelected()) {
            if (!c.isInstance(d)) continue;
            al.add(d);
        }
        return al;
    }

    public <T extends Displayable> List<T> get(Class<T> c) {
        if (Displayable.class == c) {
            return this.getSelected();
        }
        ArrayList<Displayable> a = new ArrayList<Displayable>();
        for (Displayable d : this.getSelected()) {
            if (!c.isInstance(d)) continue;
            a.add(d);
        }
        return a;
    }

    public List<Displayable> getSelectedSorted(Class<? extends Displayable> c) {
        if (Displayable.class == c) {
            return null;
        }
        ArrayList<Displayable> al = this.getSelected(c);
        TreeMap<Integer, Displayable> tm = new TreeMap<Integer, Displayable>();
        if (ZDisplayable.class.isAssignableFrom(c)) {
            for (Displayable d : al) {
                tm.put(d.getLayerSet().indexOf((ZDisplayable)d), d);
            }
        } else {
            for (Displayable d : al) {
                tm.put(d.getLayer().indexOf(d), d);
            }
        }
        return new ArrayList<Displayable>(tm.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Displayable> getAffected() {
        Object object = this.queue_lock;
        synchronized (object) {
            return new HashSet<Displayable>(this.hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Displayable> getAffected(Class<?> c) {
        HashSet<Displayable> copy = new HashSet<Displayable>();
        Object object = this.queue_lock;
        synchronized (object) {
            if (Displayable.class.equals(c)) {
                copy.addAll(this.hs);
                return copy;
            }
            for (Displayable d : this.hs) {
                if (!c.isInstance(d)) continue;
                copy.add(d);
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAffected(Class<?> c) {
        Object object = this.queue_lock;
        synchronized (object) {
            if (Displayable.class.equals(c) && this.hs.size() > 0) {
                return true;
            }
            for (Displayable d : this.hs) {
                if (!c.isInstance(d)) continue;
                return true;
            }
        }
        return false;
    }

    public void moveUp() {
        if (null == this.display) {
            return;
        }
        Layer la = this.display.getLayer();
        for (Displayable d : this.getSelected()) {
            la.getParent().moveUp(la, d);
        }
        this.clear();
    }

    public void moveDown() {
        if (null == this.display) {
            return;
        }
        Layer la = this.display.getLayer();
        for (Displayable d : this.getSelected()) {
            la.getParent().moveDown(la, d);
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Displayable> setVisible(final boolean b) {
        final HashSet<Displayable> changing = new HashSet<Displayable>();
        Object object = this.queue_lock;
        synchronized (object) {
            for (Displayable d : this.queue) {
                if (b == d.isVisible()) continue;
                changing.add(d);
            }
        }
        this.apply("visible", new Action(){

            @Override
            void exec(Displayable d) {
                if (changing.contains(d)) {
                    d.setVisible(b);
                }
            }
        });
        if (null != this.display) {
            Display.updateCheckboxes(changing, 2, b);
            Display.repaint(this.display.getLayer(), this.box, 10);
        }
        return changing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPrev(Displayable d) {
        if (null == d) {
            return;
        }
        Object object = this.queue_lock;
        synchronized (object) {
            this.queue_prev.remove(d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        Object object = this.queue_lock;
        synchronized (object) {
            LinkedList<Displayable> q = new LinkedList<Displayable>(this.queue);
            ArrayList<Displayable> al = new ArrayList<Displayable>();
            al.addAll(this.queue_prev);
            this.clear();
            if (al.size() > 0) {
                this.selectAll(al);
            }
            this.setPrev(q);
        }
    }

    public void specify() {
        if (null == this.display || null == this.display.getActive()) {
            return;
        }
        GenericDialog gd = new GenericDialog("Specify");
        gd.addMessage("Relative to the floater's position:");
        gd.addNumericField("origin X: ", (double)(this.box.x + this.box.width / 2), 2);
        gd.addNumericField("origin Y: ", (double)(this.box.y + this.box.height / 2), 2);
        gd.addMessage("Transforms applied in the same order as listed below:");
        gd.addNumericField("rotate : ", 0.0, 2);
        gd.addNumericField("translate in X: ", 0.0, 2);
        gd.addNumericField("translate in Y: ", 0.0, 2);
        gd.addNumericField("scale in X: ", 1.0, 2);
        gd.addNumericField("scale in Y: ", 1.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.display.getLayerSet().addTransformStep(this.active.getLinkedGroup(null));
        Rectangle sel_box = this.getLinkedBox();
        double x_o = gd.getNextNumber();
        double y_o = gd.getNextNumber();
        double rot = gd.getNextNumber();
        double dx = gd.getNextNumber();
        double dy = gd.getNextNumber();
        double sx = gd.getNextNumber();
        double sy = gd.getNextNumber();
        if (0.0 != dx || 0.0 != dy) {
            this.translate(dx, dy);
        }
        if (0.0 != rot) {
            this.rotate(rot, x_o, y_o);
        }
        if (0.0 != sx && 0.0 != sy) {
            this.scale(sx, sy, x_o, y_o);
        } else {
            Utils.showMessage("Cannot scale to zero.");
        }
        sel_box.add(this.getLinkedBox());
        Display.repaint(this.display.getLayer(), sel_box, PADDING);
    }

    protected void apply(int what, double[] params) {
        if (null == this.active) {
            return;
        }
        LayerSet ls = this.active.getLayerSet();
        Set<Displayable> affected = this.getAffected();
        try {
            ls.addTransformStep(affected);
            Rectangle sel_box = this.getLinkedBox();
            switch (what) {
                case 0: {
                    this.translate(params[0], params[1]);
                    break;
                }
                case 1: {
                    this.rotate(params[0], this.box.x + this.box.width / 2, this.box.y + this.box.height / 2);
                    break;
                }
                case 2: {
                    this.scale(params[0], params[1], this.box.x + this.box.width / 2, this.box.y + this.box.height / 2);
                }
            }
            sel_box.add(this.getLinkedBox());
            ls.addTransformStep(affected);
            Display.repaint(this.display.getLayer(), sel_box, PADDING);
        }
        catch (Exception e) {
            IJError.print(e);
            ls.undoOneStep();
        }
    }

    public void setLut(ColorModel cm) {
        ArrayList<Patch> al = new ArrayList<Patch>();
        for (Displayable d : this.getSelected(Patch.class)) {
            al.add((Patch)d);
        }
        if (0 == al.size()) {
            return;
        }
        if (!Utils.check("Really change LUT for " + al.size() + " images?")) {
            return;
        }
        Utils.log("Selection.setLut: not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject() {
        if (null != this.display) {
            return this.display.getProject();
        }
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                if (this.queue.size() > 0) {
                    return this.queue.get(0).getProject();
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Layer getLayer() {
        if (null != this.display) {
            return this.display.getLayer();
        }
        Object object = this.queue_lock;
        synchronized (object) {
            try {
                if (this.queue.size() > 0) {
                    return this.queue.get(0).getLayer();
                }
            }
            catch (Exception e) {
                IJError.print(e);
            }
        }
        return null;
    }

    public Rectangle getBox() {
        if (null == this.box) {
            return null;
        }
        return (Rectangle)this.box.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBox() {
        Object object = this.queue_lock;
        synchronized (object) {
            this.box = null;
            Rectangle b = new Rectangle();
            for (Displayable d : this.queue) {
                b = d.getBoundingBox(b);
                if (null == this.box) {
                    this.box = (Rectangle)b.clone();
                }
                this.box.add(b);
            }
        }
    }

    public void measure() {
        Utils.log2("Selection.measure");
        HashMap rts = new HashMap();
        for (Displayable d : this.getSelected()) {
            Utils.log2("measured " + d);
            ResultsTable rt1 = rts.get(d.getClass());
            ResultsTable rt2 = d.measure(rt1);
            if (null != rt1 || null == rt2) continue;
            rts.put(d.getClass(), rt2);
        }
        Utils.showAllTables(rts);
    }

    private static abstract class Action {
        private Action() {
        }

        abstract void exec(Displayable var1);

        void post(Collection<Displayable> queue_copy, HashSet<Displayable> hs_copy) {
        }
    }
}

