/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import mpicbg.util.Util;

public class DifferenceARGBComposite
implements Composite {
    private static DifferenceARGBComposite instance = new DifferenceARGBComposite();
    private final float alpha;

    public static DifferenceARGBComposite getInstance(float alpha) {
        if (alpha == 1.0f) {
            return instance;
        }
        return new DifferenceARGBComposite(alpha);
    }

    private DifferenceARGBComposite() {
        this.alpha = 1.0f;
    }

    private DifferenceARGBComposite(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        final Composer c = srcColorModel.getNumColorComponents() > 1 ? (srcColorModel.hasAlpha() ? new ARGB2ARGB() : new RGB2ARGB()) : new Gray2ARGB();
        return new CompositeContext(){
            private Composer composer;
            {
                this.composer = c;
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int[] srcPixel = new int[4];
                int[] dstInPixel = new int[4];
                for (int x = 0; x < dstOut.getWidth(); ++x) {
                    for (int y = 0; y < dstOut.getHeight(); ++y) {
                        src.getPixel(x, y, srcPixel);
                        dstIn.getPixel(x, y, dstInPixel);
                        this.composer.compose(srcPixel, dstInPixel, DifferenceARGBComposite.this.alpha);
                        dstOut.setPixel(x, y, dstInPixel);
                    }
                }
            }

            @Override
            public void dispose() {
            }
        };
    }

    private static final class Gray2ARGB
    implements Composer {
        private Gray2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            dst[0] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[0] - (float)src[0] * alpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[1] - (float)src[0] * alpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[2] - (float)src[0] * alpha))));
            dst[3] = 255;
        }
    }

    private static final class RGB2ARGB
    implements Composer {
        private RGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            dst[0] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[0] - (float)src[0] * alpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[1] - (float)src[1] * alpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[2] - (float)src[2] * alpha))));
            dst[3] = 255;
        }
    }

    private static final class ARGB2ARGB
    implements Composer {
        private ARGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            float srcAlpha = (float)src[3] / 255.0f * alpha;
            dst[0] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[0] - (float)src[0] * srcAlpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[1] - (float)src[1] * srcAlpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)Math.abs((float)dst[2] - (float)src[2] * srcAlpha))));
            dst[3] = 255;
        }
    }

    private static interface Composer {
        public void compose(int[] var1, int[] var2, float var3);
    }
}

