/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.Ball;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Profile;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.Loader;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.tree.TrakEM2MLParser;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;

public class DBLoader
extends Loader {
    private String db_host = "127.0.0.1";
    private String db_port = "5432";
    private String db_name = null;
    private String db_user = null;
    private String db_pw = null;
    private Connection connection = null;
    private static boolean driver_loaded = false;
    private Connection preloader_connection = null;
    private PreparedStatement stmt_add_patch = null;
    private PreparedStatement stmt_update_snap = null;
    private PreparedStatement stmt_add_displayable = null;

    public boolean isReady() {
        return null != this.db_host && null != this.db_port && null != this.db_name && null != this.db_user && null != this.db_pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBLoader() {
        Object object = this.db_lock;
        synchronized (object) {
            if (null == this.db_host || null == this.db_port || null == this.db_name || null == this.db_user || null == this.db_pw) {
                GenericDialog gd = new GenericDialog("Login");
                gd.addStringField("host: ", this.db_host);
                gd.addStringField("port: ", this.db_port);
                gd.addStringField("database name: ", this.db_name);
                gd.addStringField("user name: ", this.db_user);
                gd.addStringField("password: ", this.db_pw);
                Vector v = gd.getStringFields();
                TextField tf = (TextField)v.get(v.size() - 1);
                tf.setEchoChar('*');
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                this.db_host = gd.getNextString();
                this.db_port = gd.getNextString();
                this.db_name = gd.getNextString();
                this.db_user = gd.getNextString();
                this.db_pw = gd.getNextString();
            }
            if (!driver_loaded) {
                try {
                    Class.forName("org.postgresql.Driver");
                    driver_loaded = true;
                }
                catch (ClassNotFoundException cnfe) {
                    driver_loaded = false;
                    Utils.log("Loader: could not load " + Driver.class.getName() + ": " + cnfe);
                    return;
                }
            }
            if (!this.connectToDatabase()) {
                return;
            }
            try {
                String query0 = "SELECT relname FROM pg_class WHERE relname LIKE 'ab\\_%'";
                ResultSet result0 = this.connection.prepareStatement(query0).executeQuery();
                boolean table_projects_exists = false;
                boolean table_layers_exists = false;
                boolean table_layer_sets_exists = false;
                boolean table_displayables_exists = false;
                boolean table_patches_exists = false;
                boolean table_profiles_exists = false;
                boolean sequence_ids_exists = false;
                boolean table_displays_exists = false;
                boolean table_links_exists = false;
                boolean table_things_exists = false;
                boolean table_attributes_exists = false;
                boolean table_zdisplayables_exists = false;
                boolean table_pipe_points_exists = false;
                boolean table_labels_exists = false;
                boolean table_ball_points_exists = false;
                boolean table_area_paths_exists = false;
                while (result0.next()) {
                    String relname = result0.getString("relname");
                    if (relname.equals("ab_projects")) {
                        table_projects_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_layers")) {
                        table_layers_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_layer_sets")) {
                        table_layer_sets_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_displayables")) {
                        table_displayables_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_patches")) {
                        table_patches_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_profiles")) {
                        table_profiles_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_ids")) {
                        sequence_ids_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_displays")) {
                        table_displays_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_links")) {
                        table_links_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_things")) {
                        table_things_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_attributes")) {
                        table_attributes_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_zdisplayables")) {
                        table_zdisplayables_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_pipe_points")) {
                        table_pipe_points_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_labels")) {
                        table_labels_exists = true;
                        continue;
                    }
                    if (relname.equals("ab_ball_points")) {
                        table_ball_points_exists = true;
                        continue;
                    }
                    if (!relname.equals("ab_area_paths")) continue;
                    table_area_paths_exists = true;
                }
                result0.close();
                if (!table_projects_exists) {
                    String query_projects = "CREATE TABLE ab_projects (id BIGINT NOT NULL, title TEXT NULL, trakem2_version TEXT NOT NULL, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_projects).execute();
                    Utils.log("Created table ab_projects in database " + this.db_name);
                } else if (!this.upgradeProjectsTable()) {
                    Utils.showMessage("Can't proceed without an upgraded 'ab_projects' table");
                    return;
                }
                if (!table_layers_exists) {
                    String query_layers = "CREATE TABLE ab_layers (id BIGINT NOT NULL, project_id BIGINT NOT NULL, layer_set_id BIGINT, z DOUBLE PRECISION NOT NULL, thickness DOUBLE PRECISION NOT NULL, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_layers).execute();
                    Utils.log("Created table ab_layers in database " + this.db_name);
                }
                if (!table_layer_sets_exists) {
                    String query_layer_sets = "CREATE TABLE ab_layer_sets (id BIGINT NOT NULL, project_id BIGINT NOT NULL, parent_layer_id BIGINT NOT NULL, active_layer_id BIGINT NOT NULL, layer_width DOUBLE PRECISION NOT NULL, layer_height DOUBLE PRECISION NOT NULL, rot_x DOUBLE PRECISION NOT NULL, rot_y DOUBLE PRECISION NOT NULL, rot_z DOUBLE PRECISION NOT NULL, snapshots_mode INT DEFAULT 0, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_layer_sets).execute();
                    Utils.log("Created table ab_layer_sets in database " + this.db_name);
                } else if (!this.upgradeLayerSetTable()) {
                    Utils.showMessage("Can't proceed without an upgraded 'ab_layer_sets' table.");
                    return;
                }
                if (!table_displayables_exists) {
                    String query_displayables = "CREATE TABLE ab_displayables (id BIGINT NOT NULL, layer_id BIGINT DEFAULT -1, title TEXT NOT NULL, width DOUBLE PRECISION NOT NULL, height DOUBLE PRECISION NOT NULL, alpha DOUBLE PRECISION DEFAULT 1.0, visible BOOLEAN DEFAULT TRUE, color_red INT DEFAULT 255, color_green INT DEFAULT 255, color_blue INT DEFAULT 0, stack_index INT DEFAULT -1, annotation TEXT NULL, locked BOOLEAN DEFAULT FALSE, m00 DOUBLE PRECISION DEFAULT 0.0, m10 DOUBLE PRECISION DEFAULT 0.0, m01 DOUBLE PRECISION DEFAULT 0.0, m11 DOUBLE PRECISION DEFAULT 0.0, m02 DOUBLE PRECISION DEFAULT 0.0, m12 DOUBLE PRECISION DEFAULT 0.0, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_displayables).execute();
                    Utils.log("Created table ab_displayables in database " + this.db_name);
                } else if (!this.upgradeDisplayablesTable()) {
                    Utils.showMessage("Can't proceed without an upgraded 'ab_displayables' table");
                    return;
                }
                if (!table_patches_exists) {
                    String query_patches = "CREATE TABLE ab_patches (id BIGINT NOT NULL, imp_type INT NOT NULL, tiff_original BYTEA, tiff_working BYTEA, tiff_snapshot BYTEA, min DOUBLE PRECISION DEFAULT -1, max DOUBLE PRECISION DEFAULT -1, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_patches).execute();
                    Utils.log("Created table ab_patches in database " + this.db_name);
                } else if (!this.upgradePatchesTable()) {
                    Utils.showMessage("Can't proceed without an upgraded 'ab_patches' table");
                    return;
                }
                if (!table_profiles_exists) {
                    String query_profiles = "CREATE TABLE ab_profiles (id BIGINT NOT NULL, polygon POLYGON NULL, closed BOOLEAN DEFAULT FALSE, PRIMARY KEY(id))";
                    this.connection.prepareStatement(query_profiles).execute();
                    Utils.log("Created table ab_profiles in database " + this.db_name);
                }
                if (!sequence_ids_exists) {
                    String query_ids = "CREATE SEQUENCE ab_ids INCREMENT BY 1 NO CYCLE";
                    this.connection.prepareStatement(query_ids).execute();
                    Utils.log("Created sequence ab_ids in database " + this.db_name);
                }
                if (!table_displays_exists) {
                    String query_displays = "CREATE TABLE ab_displays (id BIGINT NOT NULL, layer_id BIGINT NOT NULL, active_displayable_id BIGINT DEFAULT -1, window_x INT DEFAULT 0, window_y INT DEFAULT 0, magnification DOUBLE PRECISION DEFAULT 1.0, srcrect_x INT NULL, srcrect_y INT NULL, srcrect_width INT NULL, srcrect_height INT NULL, c_alphas INT DEFAULT -1, c_alphas_state INT DEFAULT -1, scroll_step INT DEFAULT 1, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_displays).execute();
                    Utils.log("Created table ab_displays in database " + this.db_name);
                } else if (!this.upgradeDisplaysTable()) {
                    Utils.showMessage("Can't proceed without an upgraded 'ab_displays' table");
                    return;
                }
                if (!table_links_exists) {
                    String query_links = "CREATE TABLE ab_links (project_id BIGINT NOT NULL, id1 BIGINT NOT NULL, id2 BIGINT NOT NULL)";
                    this.connection.prepareStatement(query_links).execute();
                    Utils.log("Created table ab_links in database " + this.db_name);
                }
                if (!table_things_exists) {
                    String query_things = "CREATE TABLE ab_things (id BIGINT NOT NULL, project_id BIGINT NOT NULL, type TEXT NOT NULL, title TEXT NULL, parent_id BIGINT NOT NULL, object_id BIGINT NOT NULL, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_things).execute();
                    Utils.log("Created table ab_things in database " + this.db_name);
                } else if (!this.upgradeThingsTable()) {
                    Utils.showMessage("Can't proceed without updating template types for layer and layer_set.");
                    return;
                }
                if (!table_attributes_exists) {
                    String query_attributes = "CREATE TABLE ab_attributes (id BIGINT NOT NULL, thing_id BIGINT NOT NULL, name TEXT NOT NULL, value TEXT NULL, PRIMARY KEY (id))";
                    this.connection.prepareStatement(query_attributes).execute();
                    Utils.log("Created table ab_attributes in database " + this.db_name);
                }
                if (!table_zdisplayables_exists) {
                    this.connection.prepareStatement("CREATE TABLE ab_zdisplayables (id BIGINT, project_id BIGINT NOT NULL, layer_set_id BIGINT, PRIMARY KEY(id))").execute();
                    Utils.log("Created table ab_zdisplayables in database " + this.db_name);
                }
                if (!table_pipe_points_exists) {
                    this.connection.prepareStatement("CREATE TABLE ab_pipe_points (pipe_id BIGINT NOT NULL, index INT NOT NULL, x DOUBLE PRECISION NOT NULL, y DOUBLE PRECISION NOT NULL, x_r DOUBLE PRECISION NOT NULL, y_r DOUBLE PRECISION NOT NULL, x_l DOUBLE PRECISION NOT NULL, y_l DOUBLE PRECISION NOT NULL, width DOUBLE PRECISION NOT NULL, layer_id BIGINT NOT NULL)").execute();
                    Utils.log("Created table ab_pipe_points in database " + this.db_name);
                }
                if (!table_labels_exists) {
                    this.connection.prepareStatement("CREATE TABLE ab_labels (id BIGINT NOT NULL, type TEXT, font_name TEXT, font_style INT, font_size INT, PRIMARY KEY (id))").execute();
                    Utils.log("Created table ab_labels in database " + this.db_name);
                }
                if (!table_ball_points_exists) {
                    this.connection.prepareStatement("CREATE TABLE ab_ball_points (ball_id BIGINT NOT NULL, x DOUBLE PRECISION NOT NULL, y DOUBLE PRECISION NOT NULL, width DOUBLE PRECISION NOT NULL, layer_id BIGINT NOT NULL)").execute();
                    Utils.log("Created table ab_ball_points in database " + this.db_name);
                }
                if (!table_area_paths_exists) {
                    this.connection.createStatement().execute("CREATE TABLE ab_area_paths (area_list_id BIGINT NOT NULL, layer_id BIGINT NOT NULL, polygon POLYGON NULL, fill_paint BOOLEAN DEFAULT false)");
                } else if (!this.upgradeAreaListTable()) {
                    Utils.showMessage("Can't continue without upgrading the ab_area_paths table");
                    return;
                }
            }
            catch (SQLException sqle) {
                Utils.log("Loader: Database problems, can't check and/or create tables.");
                this.disconnect();
                IJError.print(sqle);
                return;
            }
            catch (Exception e) {
                Utils.log("Loader: Database problems, can't check tables!");
                this.disconnect();
                IJError.print(e);
                return;
            }
        }
    }

    @Override
    public void destroy() {
        if (IJ.getInstance().quitting()) {
            if (this.isConnected()) {
                this.disconnect();
            }
            return;
        }
        super.destroy();
        if (this.isConnected()) {
            this.disconnect();
        }
        System.gc();
        Utils.showStatus("");
    }

    private boolean connectToDatabase() {
        try {
            if (null == this.connection || this.connection.isClosed()) {
                Utils.showStatus("Connecting...", false);
                this.connection = DriverManager.getConnection("jdbc:postgresql:" + (this.db_host.equals("") || this.db_host.equals("localhost") ? "" : "//" + this.db_host + (this.db_port.equals("") ? "" : ":" + this.db_port + "/")) + this.db_name, this.db_user, this.db_pw);
                this.prepareStatements();
                if (null != this.connection) {
                    // empty if block
                }
                Utils.showStatus("", false);
            }
        }
        catch (SQLException sqle) {
            Utils.showStatus("");
            Utils.log("Loader: can't connect to database: " + sqle);
            Utils.showMessage("Database connection failed.");
            return false;
        }
        return true;
    }

    private Connection getPreloaderConnection() {
        try {
            if (null == this.preloader_connection || this.preloader_connection.isClosed()) {
                this.preloader_connection = DriverManager.getConnection("jdbc:postgresql:" + (this.db_host.equals("") || this.db_host.equals("localhost") ? "" : "//" + this.db_host + (this.db_port.equals("") ? "" : ":" + this.db_port + "/")) + this.db_name, this.db_user, this.db_pw);
            }
        }
        catch (SQLException e) {
            IJError.print(e);
            return null;
        }
        return this.preloader_connection;
    }

    @Override
    public void startLargeUpdate() {
        super.startLargeUpdate();
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            IJError.print(e);
        }
    }

    @Override
    public void commitLargeUpdate() {
        super.commitLargeUpdate();
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            IJError.print(e);
        }
    }

    @Override
    public void rollback() {
        super.rollback();
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            IJError.print(e);
        }
    }

    private void prepareStatements() {
        try {
            this.stmt_add_patch = this.connection.prepareStatement("INSERT INTO ab_patches (id, imp_type, tiff_original, min, max) VALUES (?,?,?,?,?)");
            this.stmt_add_displayable = this.connection.prepareStatement("INSERT INTO ab_displayables (id, title, x, y, width, height) VALUES (?,?,?,?,?,?)");
            this.stmt_update_snap = this.connection.prepareStatement("UPDATE ab_patches SET tiff_snapshot=? WHERE id=?");
        }
        catch (SQLException e) {
            IJError.print(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                if (null != this.connection && this.connection.isClosed()) {
                    this.connection = null;
                    return false;
                }
                if (null == this.connection) {
                    return false;
                }
            }
            catch (SQLException sqle) {
                IJError.print(sqle);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.db_lock;
        synchronized (object) {
            try {
                if (null != this.connection) {
                    this.connection.close();
                }
            }
            catch (SQLException sqle) {
                Utils.log("Loader: Can't close connection to database:\n " + sqle);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextId() {
        if (!this.connectToDatabase()) {
            Utils.log("Not connected and can't connect to database.");
            return -System.currentTimeMillis();
        }
        Object object = this.db_lock;
        synchronized (object) {
            long id = Long.MIN_VALUE;
            try {
                String query = "SELECT nextval('ab_ids')";
                ResultSet result = this.connection.prepareStatement(query).executeQuery();
                if (result.next()) {
                    id = result.getLong(1);
                }
                result.close();
            }
            catch (SQLException sqle) {
                IJError.print(sqle);
            }
            return id;
        }
    }

    private boolean upgradeProjectsTable() throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT column_name FROM information_schema.columns WHERE table_name='ab_projects' AND column_name='xml_template'").executeQuery();
        if (r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table projects.\nNo data will be lost, but reorganized.\nProceed?");
            if (!yn.yesPressed()) {
                return false;
            }
            ResultSet r1 = this.connection.prepareStatement("SELECT * FROM ab_projects").executeQuery();
            while (r1.next()) {
                long project_id = r1.getLong("id");
                InputStream xml_stream = null;
                try {
                    String query = "SELECT xml_template FROM ab_projects WHERE id=" + project_id;
                    ResultSet result = this.connection.prepareStatement(query).executeQuery();
                    if (result.next()) {
                        xml_stream = result.getBinaryStream("xml_template");
                    }
                    result.close();
                }
                catch (Exception e) {
                    IJError.print(e);
                    return false;
                }
                if (null == xml_stream) {
                    Utils.showMessage("Failed to upgrade the database schema: XML template stream is null.");
                    return false;
                }
                TemplateThing template_root = new TrakEM2MLParser(xml_stream).getTemplateRoot();
                if (null == template_root) {
                    Utils.showMessage("Failed to upgrade the database schema: root TemplateThing is null.");
                    return false;
                }
                Project project = new Project(project_id, r1.getString("title"));
                project.setTempLoader(this);
                template_root.addToDatabase(project);
            }
            r1.close();
            this.connection.prepareStatement("ALTER TABLE ab_projects DROP xml_template").execute();
            this.connection.prepareStatement("ALTER TABLE ab_projects ADD version TEXT").execute();
            this.connection.prepareStatement("ALTER TABLE ab_projects ALTER COLUMN version SET DEFAULT '" + Utils.version + "'").execute();
        }
        r.close();
        return true;
    }

    private boolean upgradeDisplayablesTable() throws Exception {
        Statement st = this.connection.createStatement();
        try {
            ResultSet r = st.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='ab_displayables' AND column_name='locked'");
            if (!r.next()) {
                YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_displayables.\nThe column 'locked' will be added.\nProceed?");
                if (!yn.yesPressed()) {
                    r.close();
                    return false;
                }
                st.execute("ALTER TABLE ab_displayables ADD locked BOOLEAN");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN locked SET DEFAULT false");
            }
            r.close();
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        try {
            ResultSet r2 = st.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='ab_displayables' AND column_name='m00'");
            if (!r2.next()) {
                st.execute("ALTER TABLE ab_displayables ADD m00 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m00 SET DEFAULT 0.0");
                st.execute("ALTER TABLE ab_displayables ADD m10 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m10 SET DEFAULT 0.0");
                st.execute("ALTER TABLE ab_displayables ADD m01 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m01 SET DEFAULT 0.0");
                st.execute("ALTER TABLE ab_displayables ADD m11 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m11 SET DEFAULT 0.0");
                st.execute("ALTER TABLE ab_displayables ADD m02 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m02 SET DEFAULT 0.0");
                st.execute("ALTER TABLE ab_displayables ADD m12 DOUBLE PRECISION");
                st.execute("ALTER TABLE ab_displayables ALTER COLUMN m12 SET DEFAULT 0.0");
                ResultSet r3 = st.executeQuery("SELECT id,x,y,rot FROM ab_displayables");
                AffineTransform at = new AffineTransform();
                double[] m = new double[6];
                while (r3.next()) {
                    at.setToIdentity();
                    at.rotate(r3.getDouble("rot"));
                    at.translate(r3.getDouble("x"), r3.getDouble("y"));
                    at.getMatrix(m);
                    st.execute(new StringBuffer("UPDATE ab_displayables SET m00=").append(m[0]).append(",m10=").append(m[1]).append(",m01=").append(m[2]).append(",m11=").append(m[3]).append(",m02=").append(m[4]).append(",m12=").append(m[5]).append(" WHERE id='" + r3.getLong("id")).toString());
                }
                r3.close();
                Utils.showMessage("Database update completed successfully.\nColumns x,y,rot have NOT been deleted\nfor data safety.\nYou can delete them manually when happy with the update.");
            }
            r2.close();
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    private boolean upgradeThingsTable() throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT type FROM ab_things WHERE type='Layer' or type='Layer Set'").executeQuery();
        if (r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_things.\nWill replace 'Layer Set' by 'layer_set'\nand 'Layer' by 'layer'.\nProceed?");
            if (!yn.yesPressed()) {
                r.close();
                return false;
            }
            this.connection.prepareStatement("UPDATE ab_things SET type='layer' WHERE type='Layer'").executeUpdate();
            this.connection.prepareStatement("UPDATE ab_things SET type='layer_set' WHERE type='Layer Set'").executeUpdate();
        }
        r.close();
        ResultSet r2 = this.connection.prepareStatement("SELECT column_name FROM information_schema.columns WHERE table_name='ab_things' AND column_name='expanded'").executeQuery();
        if (!r2.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_things.\nThe column 'expanded' will be added.\nProceed?");
            if (!yn.yesPressed()) {
                r2.close();
                return false;
            }
            this.connection.prepareStatement("ALTER TABLE ab_things ADD expanded BOOLEAN").execute();
            this.connection.prepareStatement("ALTER TABLE ab_things ALTER COLUMN expanded SET DEFAULT true").execute();
        }
        r2.close();
        return true;
    }

    private boolean upgradeLayerSetTable() throws Exception {
        Statement st = this.connection.createStatement();
        ResultSet r = st.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='ab_layer_sets' AND column_name='snapshots_enabled'");
        if (!r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_layer_sets.\nThe column 'snapshots_enabled' will be added.\nProceed?");
            if (!yn.yesPressed()) {
                r.close();
                return false;
            }
            st.execute("ALTER TABLE ab_layer_sets ADD snapshots_enabled BOOLEAN");
            st.execute("ALTER TABLE ab_layer_sets ALTER COLUMN snapshots_enabled SET DEFAULT true");
        }
        r.close();
        return true;
    }

    private boolean upgradeDisplaysTable() throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT column_name FROM information_schema.columns WHERE table_name='ab_displays' AND column_name='scroll_step'").executeQuery();
        if (!r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_displays.\nThe column 'scroll_step' will be added.\nProceed?");
            if (!yn.yesPressed()) {
                r.close();
                return false;
            }
            this.connection.prepareStatement("ALTER TABLE ab_displays ADD scroll_step INT").execute();
            this.connection.prepareStatement("ALTER TABLE ab_displays ALTER COLUMN scroll_step SET DEFAULT 1").execute();
        }
        r.close();
        return true;
    }

    private boolean upgradeAreaListTable() throws Exception {
        ResultSet r = this.connection.createStatement().executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='ab_area_paths' AND column_name='fill_paint'");
        if (!r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade table ab_area_paths.\nThe column 'fill_paint' will be added.\nProceed?");
            if (!yn.yesPressed()) {
                r.close();
                return false;
            }
            this.connection.createStatement().executeUpdate("ALTER TABLE ab_area_paths ADD fill_paint BOOLEAN");
            this.connection.createStatement().executeUpdate("ALTER TABLE ab_area_paths ALTER COLUMN fill_paint SET DEFAULT TRUE");
        }
        r.close();
        return true;
    }

    private boolean upgradePatchesTable() throws Exception {
        Statement st = this.connection.createStatement();
        ResultSet r = st.executeQuery("SELECT column_name FROM information_schema.columns WHERE table_name='ab_patches' AND column_name='min'");
        if (!r.next()) {
            YesNoCancelDialog yn = new YesNoCancelDialog((Frame)IJ.getInstance(), "Upgrade", "Need to upgrade the table ab_patches.\nThe columns 'min' and 'max' will be added.\nProceed?");
            if (!yn.yesPressed()) {
                r.close();
                return false;
            }
            st.executeUpdate("ALTER TABLE ab_patches ADD min DOUBLE PRECISION");
            st.executeUpdate("ALTER TABLE ab_patches ALTER COLUMN min SET DEFAULT -1");
            st.executeUpdate("ALTER TABLE ab_patches ADD max DOUBLE PRECISION");
            st.executeUpdate("ALTER TABLE ab_patches ALTER COLUMN max SET DEFAULT -1");
        }
        r.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateThing getTemplateRoot(Project project) {
        if (!this.connectToDatabase()) {
            return null;
        }
        TemplateThing root = null;
        Object object = this.db_lock;
        synchronized (object) {
            try {
                ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_things WHERE project_id=" + project.getId() + " AND parent_id=-1 AND object_id=-1").executeQuery();
                if (r.next()) {
                    long id = r.getLong("id");
                    String type = r.getString("type");
                    root = new TemplateThing(type, project, id);
                    root.setup(this.getChildrenTemplateThings(project, id));
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
        }
        return root;
    }

    private ArrayList getChildrenTemplateThings(Project project, long parent_id) throws Exception {
        ArrayList<TemplateThing> al = new ArrayList<TemplateThing>();
        ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_things WHERE parent_id=" + parent_id).executeQuery();
        while (r.next()) {
            long id = r.getLong("id");
            String type = r.getString("type");
            TemplateThing tt = new TemplateThing(type, project, id);
            tt.setup(this.getChildrenTemplateThings(project, id));
            al.add(tt);
        }
        r.close();
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project[] getProjects() {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            Project[] projects = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT title, id FROM ab_projects ORDER BY id").executeQuery();
                ArrayList<Project> al_projects = new ArrayList<Project>();
                while (r.next()) {
                    al_projects.add(new Project(r.getLong("id"), r.getString("title")));
                }
                r.close();
                projects = new Project[al_projects.size()];
                al_projects.toArray(projects);
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return projects;
        }
    }

    private void unpack(TemplateThing root, HashMap<String, TemplateThing> hs_tt) {
        String type = root.getType();
        if (null != hs_tt.get(type)) {
            return;
        }
        hs_tt.put(type, root);
        if (null == root.getChildren()) {
            return;
        }
        for (TemplateThing tt : root.getChildren()) {
            this.unpack(tt, hs_tt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectThing getRootProjectThing(Project project, TemplateThing root_tt, TemplateThing project_tt, HashMap<Long, Displayable> hs_d) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            HashMap<String, TemplateThing> hs_tt = new HashMap<String, TemplateThing>();
            this.unpack(root_tt, hs_tt);
            ProjectThing root = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_things WHERE project_id=" + project.getId() + " AND type='project' AND parent_id=-1").executeQuery();
                if (r.next()) {
                    long id = r.getLong("id");
                    root = new ProjectThing(project_tt, project, id, project, this.getChildrenProjectThings(project, id, project_tt.getType(), hs_tt, hs_d));
                }
                r.close();
                if (null == root) {
                    Utils.log("Loader.getRootProjectThing: can't find it for project id=" + project.getId());
                    return null;
                }
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return root;
        }
    }

    private ProjectThing getProjectThing(ResultSet r, Project project, HashMap<String, TemplateThing> hs_tt, HashMap<Long, Displayable> hs_d) throws Exception {
        long id = r.getLong("id");
        String type = r.getString("type");
        TemplateThing tt = hs_tt.get(type);
        if (null == tt) {
            Utils.log("Loader.getProjectThing: can not find a proper TemplateThing of type " + type + " for the ProjectThing of id=" + id);
            return null;
        }
        long object_id = r.getLong("object_id");
        Object ob = r.getString("title");
        if (-1L != object_id) {
            ob = this.getProjectObject(project, object_id);
            if (ob instanceof Displayable) {
                hs_d.put(new Long(((Displayable)ob).getId()), (Displayable)ob);
            } else {
                Utils.log("Loader.getProjectThing: not adding to hs_d: " + ob);
            }
        }
        return new ProjectThing(tt, project, id, ob, this.getChildrenProjectThings(project, id, type, hs_tt, hs_d));
    }

    private ArrayList<ProjectThing> getChildrenProjectThings(Project project, long parent_id, String parent_type, HashMap<String, TemplateThing> hs_tt, HashMap<Long, Displayable> hs_d) throws Exception {
        ArrayList<ProjectThing> al_children = new ArrayList<ProjectThing>();
        ResultSet r = null;
        if (-1L == parent_id) {
            Utils.log("parent_id = -1 for parent_type=" + parent_type);
        }
        r = parent_type.equals("profile_list") ? this.connection.prepareStatement("SELECT ab_things.* FROM ab_things,ab_displayables,ab_layers WHERE ab_things.parent_id=" + parent_id + " AND ab_things.object_id=ab_displayables.id AND ab_displayables.layer_id=ab_layers.id ORDER BY ab_layers.z,ab_things.id ASC").executeQuery() : this.connection.prepareStatement("SELECT * FROM ab_things WHERE parent_id=" + parent_id + " ORDER BY id").executeQuery();
        while (r.next()) {
            ProjectThing thing = this.getProjectThing(r, project, hs_tt, hs_d);
            if (null == thing) continue;
            al_children.add(thing);
        }
        r.close();
        return al_children;
    }

    private Object getProjectObject(Project project, long id) throws Exception {
        if (-1L == id) {
            return null;
        }
        Displayable object = null;
        object = this.fetchProfile(project, id);
        if (null != object) {
            return object;
        }
        object = this.fetchPipe(project, id);
        if (null != object) {
            return object;
        }
        object = this.fetchBall(project, id);
        if (null != object) {
            return object;
        }
        object = this.fetchAreaList(project, id);
        if (null != object) {
            return object;
        }
        if (null == object) {
            Utils.log("Loader.makeObject: don't know what to do with object of id=" + id);
        }
        return object;
    }

    private Profile fetchProfile(Project project, long id) throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT ab_profiles.id, ab_displayables.id, title, width, height, alpha, visible, color_red, color_green, color_blue, closed, locked, m00, m10, m01, m11, m02, m12 FROM ab_profiles, ab_displayables WHERE ab_profiles.id=ab_displayables.id AND ab_profiles.id=" + id).executeQuery();
        Profile p = null;
        if (r.next()) {
            p = new Profile(project, id, r.getString("title"), (float)r.getDouble("width"), (float)r.getDouble("height"), (float)r.getDouble("alpha"), r.getBoolean("visible"), new Color(r.getInt("color_red"), r.getInt("color_green"), r.getInt("color_blue")), r.getBoolean("closed"), r.getBoolean("locked"), new AffineTransform(r.getDouble("m00"), r.getDouble("m10"), r.getDouble("m01"), r.getDouble("m11"), r.getDouble("m02"), r.getDouble("m12")));
        }
        r.close();
        return p;
    }

    private Pipe fetchPipe(Project project, long id) throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT ab_displayables.id, title, ab_displayables.width, height, alpha, visible, color_red, color_green, color_blue, ab_zdisplayables.id, ab_pipe_points.pipe_id, ab_displayables.locked, m00, m10, m01, m11, m02, m12 FROM ab_zdisplayables, ab_displayables, ab_pipe_points WHERE ab_zdisplayables.id=ab_displayables.id AND ab_zdisplayables.id=ab_pipe_points.pipe_id AND ab_zdisplayables.id=" + id).executeQuery();
        Pipe p = null;
        if (r.next()) {
            p = new Pipe(project, id, r.getString("title"), (float)r.getDouble("width"), (float)r.getDouble("height"), r.getFloat("alpha"), r.getBoolean("visible"), new Color(r.getInt("color_red"), r.getInt("color_green"), r.getInt("color_blue")), r.getBoolean("locked"), new AffineTransform(r.getDouble("m00"), r.getDouble("m10"), r.getDouble("m01"), r.getDouble("m11"), r.getDouble("m02"), r.getDouble("m12")));
        }
        r.close();
        return p;
    }

    private Ball fetchBall(Project project, long id) throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT ab_displayables.id, title, ab_displayables.width, height, alpha, visible, color_red, color_green, color_blue, ab_zdisplayables.id, ab_ball_points.ball_id, ab_displayables.locked, m00, m10, m01, m11, m02, m12 FROM ab_zdisplayables, ab_displayables, ab_ball_points WHERE ab_zdisplayables.id=ab_displayables.id AND ab_zdisplayables.id=ab_ball_points.ball_id AND ab_zdisplayables.id=" + id).executeQuery();
        Ball b = null;
        if (r.next()) {
            b = new Ball(project, id, r.getString("title"), (float)r.getDouble("width"), (float)r.getDouble("height"), r.getFloat("alpha"), r.getBoolean("visible"), new Color(r.getInt("color_red"), r.getInt("color_green"), r.getInt("color_blue")), r.getBoolean("locked"), new AffineTransform(r.getDouble("m00"), r.getDouble("m10"), r.getDouble("m01"), r.getDouble("m11"), r.getDouble("m02"), r.getDouble("m12")));
        }
        r.close();
        return b;
    }

    private AreaList fetchAreaList(Project project, long id) throws Exception {
        ResultSet r = this.connection.createStatement().executeQuery("SELECT area_list_id, layer_id FROM ab_area_paths WHERE area_list_id=" + id);
        ArrayList<Long> al_ul = new ArrayList<Long>();
        while (r.next()) {
            al_ul.add(new Long(r.getLong(2)));
        }
        r.close();
        r = this.connection.prepareStatement("SELECT ab_displayables.id, title, ab_displayables.width, height, alpha, visible, color_red, color_green, color_blue, locked, m00, m10, m01, m11, m02, m12, ab_zdisplayables.id FROM ab_zdisplayables, ab_displayables WHERE ab_zdisplayables.id=ab_displayables.id AND ab_zdisplayables.id=" + id).executeQuery();
        AreaList area_list = null;
        if (r.next()) {
            area_list = new AreaList(project, id, r.getString("title"), (float)r.getDouble("width"), (float)r.getDouble("height"), r.getFloat("alpha"), r.getBoolean("visible"), new Color(r.getInt("color_red"), r.getInt("color_green"), r.getInt("color_blue")), r.getBoolean("locked"), al_ul, new AffineTransform(r.getDouble("m00"), r.getDouble("m10"), r.getDouble("m01"), r.getDouble("m11"), r.getDouble("m02"), r.getDouble("m12")));
        }
        r.close();
        return area_list;
    }

    private void unpack(ProjectThing root, HashMap hs) {
        Object ob = root.getObject();
        if (null != ob && ob instanceof DBObject) {
            DBObject dbo = (DBObject)ob;
            hs.put(new Long(dbo.getId()), dbo);
        }
        if (null == root.getChildren()) {
            return;
        }
        for (ProjectThing pt : root.getChildren()) {
            this.unpack(pt, hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayerThing getRootLayerThing(Project project, ProjectThing project_thing, TemplateThing layer_set_tt, TemplateThing layer_tt) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            HashMap hs_pt = new HashMap();
            this.unpack(project_thing, hs_pt);
            LayerThing root = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_things WHERE project_id=" + project.getId() + " AND type='layer_set' AND parent_id=-1").executeQuery();
                if (r.next()) {
                    root = this.getLayerThing(r, project, hs_pt, layer_set_tt, layer_tt);
                }
                r.close();
                if (null == root) {
                    Utils.log("Loader.getRootLayerThing: can't find it for project id=" + project.getId());
                    return null;
                }
                ResultSet rl = this.connection.prepareStatement("SELECT * FROM ab_links WHERE project_id=" + project.getId()).executeQuery();
                while (rl.next()) {
                    Long id1 = new Long(rl.getLong("id1"));
                    Long id2 = new Long(rl.getLong("id2"));
                    Object ob1 = hs_pt.get(id1);
                    Object ob2 = hs_pt.get(id2);
                    if (null != ob1 && null != ob2) {
                        Displayable d = (Displayable)ob1;
                        d.link((Displayable)ob2, false);
                        continue;
                    }
                    Utils.log("Loader: broken link between " + id1 + " and " + id2);
                }
                rl.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return root;
        }
    }

    private LayerThing getLayerThing(ResultSet r, Project project, HashMap hs_pt, TemplateThing layer_set_tt, TemplateThing layer_tt) throws Exception {
        long id = r.getLong("id");
        String type = r.getString("type");
        TemplateThing template = type.equals("layer_set") ? layer_set_tt : layer_tt;
        return new LayerThing(template, project, id, r.getString("title"), this.getLayerThingObject(project, r.getLong("object_id"), template, hs_pt), this.getChildrenLayerThing(project, id, hs_pt, layer_set_tt, layer_tt));
    }

    private ArrayList getChildrenLayerThing(Project project, long parent_id, HashMap hs_pt, TemplateThing layer_set_tt, TemplateThing layer_tt) throws Exception {
        ArrayList<LayerThing> al_children = new ArrayList<LayerThing>();
        ResultSet r = this.connection.prepareStatement("SELECT ab_things.id AS id, ab_layers.id AS layer_id, ab_layers.project_id AS l_project_id, ab_things.project_id AS project_id, type, title, parent_id, object_id, z FROM ab_things, ab_layers WHERE ab_things.project_id=ab_layers.project_id AND ab_things.object_id=ab_layers.id AND ab_things.parent_id=" + parent_id + " ORDER BY z ASC").executeQuery();
        while (r.next()) {
            al_children.add(this.getLayerThing(r, project, hs_pt, layer_set_tt, layer_tt));
        }
        r.close();
        return al_children;
    }

    private Object getLayerThingObject(Project project, long id, TemplateThing template, HashMap hs_pt) throws Exception {
        if (template.getType().equals("layer")) {
            return this.fetchLayer(project, id, hs_pt);
        }
        if (template.getType().equals("layer_set")) {
            Object ob = hs_pt.get(new Long(id));
            if (ob != null) {
                return ob;
            }
            ResultSet rls = this.connection.prepareStatement("SELECT * FROM ab_layer_sets, ab_displayables WHERE ab_layer_sets.id=ab_displayables.id AND ab_layer_sets.id=" + id).executeQuery();
            LayerSet layer_set = null;
            if (rls.next()) {
                long ls_id = rls.getLong("id");
                layer_set = new LayerSet(project, ls_id, rls.getString("title"), (float)rls.getDouble("width"), (float)rls.getDouble("height"), rls.getDouble("rot_x"), rls.getDouble("rot_y"), rls.getDouble("rot_z"), (float)rls.getDouble("layer_width"), (float)rls.getDouble("layer_height"), rls.getBoolean("locked"), rls.getInt("snapshots_mode"), new AffineTransform(rls.getDouble("m00"), rls.getDouble("m10"), rls.getDouble("m01"), rls.getDouble("m11"), rls.getDouble("m02"), rls.getDouble("m12")));
                hs_pt.put(new Long(ls_id), layer_set);
                ResultSet rpi = this.connection.prepareStatement("SELECT ab_displayables.id, ab_zdisplayables.id, layer_id, layer_set_id, stack_index FROM ab_displayables,ab_zdisplayables WHERE ab_displayables.id=ab_zdisplayables.id AND layer_set_id=" + ls_id + " ORDER BY stack_index ASC").executeQuery();
                while (rpi.next()) {
                    Long idd = new Long(rpi.getLong("id"));
                    Object obb = hs_pt.get(idd);
                    if (null != obb && obb instanceof ZDisplayable) {
                        layer_set.addSilently((ZDisplayable)obb);
                        continue;
                    }
                    Utils.log("getLayerThingObject: failed to add a ZDisplayable to the root layer_set: zdispl id = " + idd);
                }
                rpi.close();
            }
            rls.close();
            return layer_set;
        }
        Utils.log("Loader.getLayerThingObject: don't know what to do with a template of type " + template.getType());
        return null;
    }

    private Layer fetchLayer(Project project, long id, HashMap hs_pt) throws Exception {
        ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_layers WHERE id=" + id).executeQuery();
        Layer layer = null;
        if (r.next()) {
            long layer_id = r.getLong("id");
            layer = new Layer(project, layer_id, r.getDouble("z"), r.getDouble("thickness"));
            long parent_id = r.getLong("layer_set_id");
            Object set = hs_pt.get(new Long(parent_id));
            if (null != set) {
                ((LayerSet)set).addSilently(layer);
            } else {
                Utils.log("Loader.fetchLayer: WARNING no parent for layer " + layer);
            }
            HashMap hs_d = new HashMap();
            ResultSet rd = this.connection.prepareStatement("SELECT ab_displayables.id, ab_profiles.id, layer_id, stack_index FROM ab_displayables,ab_profiles WHERE ab_displayables.id=ab_profiles.id AND layer_id=" + layer_id).executeQuery();
            while (rd.next()) {
                Long idd = new Long(rd.getLong("id"));
                Object ob = hs_pt.get(idd);
                if (null == ob) continue;
                hs_d.put(new Integer(rd.getInt("stack_index")), ob);
            }
            rd.close();
            ResultSet rls = this.connection.prepareStatement("SELECT * FROM ab_layer_sets, ab_displayables WHERE ab_layer_sets.id=ab_displayables.id AND ab_layer_sets.parent_layer_id=" + id).executeQuery();
            while (rls.next()) {
                long ls_id = rls.getLong("id");
                LayerSet layer_set = new LayerSet(project, ls_id, rls.getString("title"), (float)rls.getDouble("width"), (float)rls.getDouble("height"), rls.getDouble("rot_x"), rls.getDouble("rot_y"), rls.getDouble("rot_z"), (float)rls.getDouble("layer_width"), (float)rls.getDouble("layer_height"), rls.getBoolean("locked"), rls.getInt("snapshots_mode"), new AffineTransform(rls.getDouble("m00"), rls.getDouble("m10"), rls.getDouble("m01"), rls.getDouble("m11"), rls.getDouble("m02"), rls.getDouble("m12")));
                hs_pt.put(new Long(ls_id), layer_set);
                hs_d.put(new Integer(rls.getInt("stack_index")), layer_set);
                layer_set.setLayer(layer, false);
                ResultSet rpi = this.connection.prepareStatement("SELECT ab_displayables.id, ab_zdisplayables.id, layer_id, layer_set_id, stack_index FROM ab_displayables,ab_zdisplayables WHERE ab_displayables.id=ab_zdisplayables.id AND layer_set_id=" + ls_id + " ORDER BY stack_index ASC").executeQuery();
                while (rpi.next()) {
                    Long idd = new Long(rpi.getLong("id"));
                    Object ob = hs_pt.get(idd);
                    if (null != ob && ob instanceof ZDisplayable) {
                        layer_set.addSilently((ZDisplayable)ob);
                        continue;
                    }
                    Utils.log("fetchLayer: failed to add a ZDisplayable to the layer_set. zdispl id = " + idd);
                }
                rpi.close();
            }
            rls.close();
            ResultSet rp = this.connection.prepareStatement("SELECT ab_patches.id, ab_displayables.id, layer_id, title, width, height, stack_index, imp_type, locked, min, max, m00, m10, m01, m11, m02, m12 FROM ab_patches,ab_displayables WHERE ab_patches.id=ab_displayables.id AND ab_displayables.layer_id=" + layer_id).executeQuery();
            while (rp.next()) {
                long patch_id = rp.getLong("id");
                Patch patch = new Patch(project, patch_id, rp.getString("title"), (float)rp.getDouble("width"), (float)rp.getDouble("height"), rp.getInt("o_width"), rp.getInt("o_height"), rp.getInt("imp_type"), rp.getBoolean("locked"), rp.getDouble("min"), rp.getDouble("max"), new AffineTransform(rp.getDouble("m00"), rp.getDouble("m10"), rp.getDouble("m01"), rp.getDouble("m11"), rp.getDouble("m02"), rp.getDouble("m12")));
                hs_pt.put(new Long(patch_id), patch);
                hs_d.put(new Integer(rp.getInt("stack_index")), patch);
            }
            rp.close();
            ResultSet rl = this.connection.prepareStatement("SELECT ab_labels.id, ab_displayables.id, layer_id, title, width, height, m00, m10, m01, m11, m02, m12, stack_index, font_name, font_style, font_size, ab_labels.type, locked FROM ab_labels,ab_displayables WHERE ab_labels.id=ab_displayables.id AND ab_displayables.layer_id=" + layer_id).executeQuery();
            while (rl.next()) {
                long label_id = rl.getLong("id");
                DLabel label = new DLabel(project, label_id, rl.getString("title"), (float)rl.getDouble("width"), (float)rl.getDouble("height"), rl.getInt("type"), rl.getString("font_name"), rl.getInt("font_style"), rl.getInt("font_size"), rl.getBoolean("locked"), new AffineTransform(rl.getDouble("m00"), rl.getDouble("m10"), rl.getDouble("m01"), rl.getDouble("m11"), rl.getDouble("m02"), rl.getDouble("m12")));
                hs_pt.put(new Long(label_id), label);
                hs_d.put(new Integer(rl.getInt("stack_index")), label);
            }
            rl.close();
            Set e = hs_d.keySet();
            Object[] si = new Object[hs_d.size()];
            si = e.toArray(si);
            Arrays.sort(si);
            for (int i = 0; i < si.length; ++i) {
                layer.addSilently((DBObject)hs_d.get(si[i]));
            }
            ResultSet rdi = this.connection.prepareStatement("SELECT * FROM ab_displays WHERE layer_id=" + layer.getId()).executeQuery();
            while (rdi.next()) {
                this.fetchDisplay(rdi, layer);
            }
            rdi.close();
        }
        r.close();
        return layer;
    }

    private HashMap getLayerAttributes(Project project, long thing_id) throws Exception {
        HashMap hs = new HashMap();
        return hs;
    }

    private void fetchDisplay(ResultSet r, Layer layer) throws Exception {
        Object[] props = new Object[]{new Point(r.getInt("window_x"), r.getInt("window_y")), new Double(r.getDouble("magnification")), new Rectangle(r.getInt("srcrect_x"), r.getInt("srcrect_y"), r.getInt("srcrect_width"), r.getInt("srcrect_height")), new Long(r.getLong("active_displayable_id")), new Integer(r.getInt("c_alphas")), new Integer(r.getInt("c_alphas_state"))};
        new Display(layer.getProject(), r.getLong("id"), layer, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][][] fetchBezierArrays(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            this.releaseMemory2();
            PGpolygon p = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT id, polygon FROM ab_profiles WHERE id=" + id).executeQuery();
                if (r.next()) {
                    p = (PGpolygon)r.getObject("polygon");
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return this.toBezierArrays(p);
        }
    }

    private double[][][] toBezierArrays(PGpolygon polygon) {
        if (null == polygon) {
            return null;
        }
        int n_points = polygon.points.length / 3;
        double[][][] b = new double[3][][];
        double[][] p = new double[2][n_points];
        double[][] p_l = new double[2][n_points];
        double[][] p_r = new double[2][n_points];
        int i = 0;
        int j = 0;
        while (i < n_points) {
            p_l[0][i] = polygon.points[j].x;
            p_l[1][i] = polygon.points[j].y;
            p[0][i] = polygon.points[j + 1].x;
            p[1][i] = polygon.points[j + 1].y;
            p_r[0][i] = polygon.points[j + 2].x;
            p_r[1][i] = polygon.points[j + 2].y;
            ++i;
            j += 3;
        }
        b[0] = p_l;
        b[1] = p;
        b[2] = p_r;
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Area fetchArea(long area_list_id, long layer_id) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            this.releaseMemory2();
            Area area = new Area();
            try {
                ResultSet r = this.connection.createStatement().executeQuery(new StringBuffer("SELECT * from ab_area_paths WHERE area_list_id=").append(area_list_id).append(" AND layer_id=").append(layer_id).toString());
                while (r.next()) {
                    PGpolygon pol = (PGpolygon)r.getObject("polygon");
                    area.add(new Area(this.makePolygon(pol)));
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return area;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList fetchPipePoints(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            this.releaseMemory2();
            ArrayList<Object[]> al = new ArrayList<Object[]>();
            try {
                ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_pipe_points WHERE pipe_id=" + id + " ORDER BY index ASC").executeQuery();
                while (r.next()) {
                    al.add(new Object[]{r.getObject("x"), r.getObject("y"), r.getObject("x_r"), r.getObject("y_r"), r.getObject("x_l"), r.getObject("y_l"), r.getObject("width"), r.getObject("layer_id")});
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return al;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList fetchBallPoints(long id) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            this.releaseMemory2();
            ArrayList<Object[]> al = new ArrayList<Object[]>();
            try {
                ResultSet r = this.connection.prepareStatement("SELECT * FROM ab_ball_points WHERE ball_id=" + id + " ORDER BY layer_id ASC").executeQuery();
                while (r.next()) {
                    al.add(new Object[]{r.getObject("x"), r.getObject("y"), r.getObject("width"), r.getObject("layer_id")});
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return al;
        }
    }

    private void unpackLayers(LayerThing root, HashMap hs) {
        Object ob = root.getObject();
        if (ob instanceof Layer) {
            hs.put(new Long(((DBObject)ob).getId()), ob);
        }
        if (null == root.getChildren()) {
            return;
        }
        for (LayerThing child : root.getChildren()) {
            this.unpackLayers(child, hs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addToDatabase(DBObject ob) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return false;
            }
            try {
                Method method = this.getClass().getDeclaredMethod("addToDatabase", ob.getClass());
                method.invoke((Object)this, ob);
            }
            catch (NoSuchMethodException nsme) {
                Class<?>[] interfaces = ob.getClass().getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        Method method = this.getClass().getDeclaredMethod("addToDatabase", interfaces[i]);
                        method.invoke((Object)this, ob);
                        return true;
                    }
                    catch (Exception e) {
                        Utils.log("Loader: Not for " + interfaces[i] + " : " + e);
                        IJError.print(e);
                        continue;
                    }
                }
                Utils.log("Loader: no method for addToDatabase(" + ob.getClass().getName() + ")");
                return false;
            }
            catch (Exception e) {
                SQLException next;
                IJError.print(e);
                if (e instanceof SQLException && null != (next = ((SQLException)e).getNextException())) {
                    IJError.print(next);
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateInDatabase(DBObject ob, String key) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return false;
            }
            try {
                Method method = this.getClass().getDeclaredMethod("updateInDatabase", ob.getClass(), key.getClass());
                method.invoke((Object)this, ob, key);
            }
            catch (NoSuchMethodException nsme) {
                Class<?>[] interfaces = ob.getClass().getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        Method method = this.getClass().getDeclaredMethod("updateInDatabase", interfaces[i], key.getClass());
                        method.invoke((Object)this, ob, key);
                        return true;
                    }
                    catch (Exception e) {
                        Utils.debug("Loader: Not for " + interfaces[i]);
                        IJError.print(e);
                        continue;
                    }
                }
                Utils.log("Loader: no method for updateInDatabase(" + ob.getClass().getName() + ")");
                return false;
            }
            catch (Exception e) {
                SQLException next;
                IJError.print(e);
                if (e instanceof SQLException && null != (next = ((SQLException)e).getNextException())) {
                    IJError.print(next);
                }
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean updateInDatabase(DBObject ob, Set<String> keys) {
        Utils.log2("updateInDatabase(DBObject, Set<String>) NOT IMPLEMENTED");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFromDatabase(DBObject ob) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return false;
            }
            try {
                Method method = this.getClass().getDeclaredMethod("removeFromDatabase", ob.getClass());
                method.invoke((Object)this, ob);
            }
            catch (NoSuchMethodException nsme) {
                Class<?>[] interfaces = ob.getClass().getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    try {
                        Method method = this.getClass().getDeclaredMethod("removeFromDatabase", interfaces[i]);
                        method.invoke((Object)this, ob);
                        return true;
                    }
                    catch (Exception e) {
                        Utils.log("Loader: Not for " + interfaces[i]);
                        continue;
                    }
                }
                Utils.log("Loader: no method for removeFromDatabase(" + ob.getClass().getName() + ")");
                return false;
            }
            catch (Exception e) {
                SQLException next;
                IJError.print(e);
                if (e instanceof SQLException && null != (next = ((SQLException)e).getNextException())) {
                    IJError.print(next);
                }
                return false;
            }
            return true;
        }
    }

    private void addToDatabase(Project project) throws Exception {
        Utils.debug("Adding project to database.");
        this.connection.prepareStatement("INSERT INTO ab_projects (id, title, trakem2_version) VALUES (" + project.getId() + ",'" + project.toString() + "','" + Utils.version + "')").executeUpdate();
    }

    private void updateInDatabase(Project project, String key) throws Exception {
        StringBuffer sb_query = new StringBuffer("UPDATE ab_projects SET ");
        if (!key.equals("title")) {
            Utils.log("Loader.updateInDatabase(Project, String): don't know what to do with key = " + key);
            return;
        }
        sb_query.append(key).append("='").append(project.toString()).append("'");
        sb_query.append(" WHERE id=").append(project.getId());
        this.connection.prepareStatement(sb_query.toString()).executeUpdate();
    }

    private void removeFromDatabase(Project project) throws Exception {
        boolean autocommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        Statement st = this.connection.createStatement();
        long project_id = project.getId();
        try {
            st.addBatch("DELETE FROM ab_attributes WHERE thing_id IN (SELECT thing_id FROM ab_things WHERE ab_things.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_things WHERE project_id=" + project_id);
            st.addBatch("DELETE FROM ab_displays WHERE layer_id IN (SELECT id as layer_id FROM ab_layers WHERE ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_links WHERE project_id=" + project_id);
            st.addBatch("DELETE FROM ab_patches WHERE id IN (SELECT ab_displayables.id as id FROM ab_displayables,ab_layers WHERE ab_displayables.layer_id=ab_layers.id AND ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_profiles WHERE id IN (SELECT ab_displayables.id as id FROM ab_displayables,ab_layers WHERE ab_displayables.layer_id=ab_layers.id AND ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_pipe_points WHERE pipe_id IN (SELECT id as pipe_id FROM ab_zdisplayables WHERE ab_zdisplayables.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_zdisplayables WHERE id IN (SELECT ab_displayables.id as id FROM ab_displayables,ab_layers WHERE ab_displayables.layer_id=ab_layers.id AND ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_displayables WHERE id IN (SELECT id FROM ab_layer_sets WHERE ab_layer_sets.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_layer_sets WHERE project_id=" + project_id);
            st.addBatch("DELETE FROM ab_labels WHERE id IN (SELECT ab_displayables.id as id FROM ab_displayables, ab_layers WHERE ab_displayables.layer_id=ab_layers.id AND ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_displayables WHERE layer_id IN (SELECT id as layer_id FROM ab_layers WHERE ab_layers.project_id=" + project_id + ")");
            st.addBatch("DELETE FROM ab_layers WHERE project_id=" + project_id);
            st.addBatch("DELETE FROM ab_projects WHERE id=" + project_id);
            st.executeBatch();
            this.connection.commit();
        }
        catch (SQLException sqle) {
            SQLException next = sqle.getNextException();
            if (null != next) {
                IJError.print(next);
            }
            this.connection.setAutoCommit(autocommit);
            return;
        }
        catch (Exception e) {
            IJError.print(e);
            this.connection.setAutoCommit(autocommit);
            return;
        }
        Utils.log("Project " + project_id + " successfully deleted.");
        this.connection.setAutoCommit(autocommit);
    }

    private void addToDatabase(Thing thing) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_things (id, project_id, type, parent_id, object_id) VALUES (").append(((DBObject)((Object)thing)).getId()).append(',').append(((DBObject)((Object)thing)).getProject().getId()).append(",'").append(thing.getType()).append("',").append(null == thing.getParent() ? -1L : ((DBObject)((Object)thing.getParent())).getId()).append(',').append(thing.getObject() instanceof DBObject ? ((DBObject)thing.getObject()).getId() : -1L).append(')').toString()).executeUpdate();
    }

    private void updateInDatabase(Thing thing, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_things SET ");
        if (key.equals("title")) {
            sb.append("title='").append(thing.getTitle()).append("'");
        } else if (key.equals("parent_id")) {
            sb.append("parent_id=").append(null == thing.getParent() ? -1L : ((DBObject)((Object)thing.getParent())).getId());
        } else if (key.equals("type")) {
            sb.append("type='").append(thing.getType()).append("'");
        } else {
            Utils.log("Loader.updateInDatabase(Thing): don't know what to do with key: " + key);
            return;
        }
        sb.append(" WHERE id=").append(((DBObject)((Object)thing)).getId());
        this.connection.prepareStatement(sb.toString()).executeUpdate();
    }

    private void removeFromDatabase(Thing thing) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_things WHERE id=" + ((DBObject)((Object)thing)).getId()).execute();
    }

    private void addToDatabase(ProjectThing pt) throws Exception {
        this.addToDatabase((Thing)pt);
    }

    private void updateInDatabase(ProjectThing pt, String key) throws Exception {
        if (key.startsWith("expanded")) {
            StringBuffer sb = new StringBuffer("UPDATE ab_things SET ");
            if (-1 != key.indexOf(61)) {
                sb.append(key);
            } else {
                sb.append("expanded='").append(pt.getProject().getProjectTree().isExpanded(pt)).append('\'');
            }
            sb.append(" WHERE id=").append(pt.getId());
            this.connection.prepareStatement(sb.toString()).executeUpdate();
        } else {
            this.updateInDatabase((Thing)pt, key);
        }
    }

    private void removeFromDatabase(ProjectThing pt) throws Exception {
        this.removeFromDatabase((Thing)pt);
    }

    private void addToDatabase(TemplateThing tt) throws Exception {
        this.addToDatabase((Thing)tt);
    }

    private void updateInDatabase(TemplateThing tt, String key) throws Exception {
        StringBuffer sb = new StringBuffer();
        if (key.equals("type")) {
            sb.append("UPDATE ab_things SET type='").append(tt.getType()).append("' WHERE id=").append(tt.getId());
            Utils.log("Renaming type for tt.id=" + tt.getId() + " to type=" + tt.getType());
        } else if (key.startsWith("add_child")) {
            long l = Long.parseLong(key.substring(10));
        } else if (key.startsWith("remove_child")) {
            long l = Long.parseLong(key.substring(13));
        } else if (!key.startsWith("expanded")) {
            Utils.log("Loader.updateInDatabase(TemplateThing): don't know what to do with key: " + key);
            return;
        }
        this.connection.prepareStatement(sb.toString()).executeUpdate();
    }

    private void removeFromDatabase(TemplateThing tt) throws Exception {
        this.removeFromDatabase((Thing)tt);
    }

    private void addToDatabase(Displayable displ) throws Exception {
        this.stmt_add_displayable.setLong(1, displ.getId());
        this.stmt_add_displayable.setString(2, displ.getTitle());
        this.stmt_add_displayable.setDouble(3, displ.getX());
        this.stmt_add_displayable.setDouble(4, displ.getY());
        this.stmt_add_displayable.setDouble(5, displ.getWidth());
        this.stmt_add_displayable.setDouble(6, displ.getHeight());
        this.stmt_add_displayable.executeUpdate();
    }

    private void updateInDatabase(Displayable displ, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_displayables SET ");
        if (key.equals("transform")) {
            double[] m = new double[6];
            displ.getAffineTransform().getMatrix(m);
            sb.append(",m00=").append(m[0]).append(",m10=").append(m[1]).append(",m01=").append(m[2]).append(",m11=").append(m[3]).append(",m02=").append(m[4]).append(",m12=").append(m[5]);
        } else if (key.equals("dimensions")) {
            sb.append("width=").append(displ.getWidth()).append(",height=").append(displ.getHeight());
        } else if (key.equals("transform+dimensions")) {
            double[] m = new double[6];
            displ.getAffineTransform().getMatrix(m);
            sb.append(",width=").append(displ.getWidth()).append(",height=").append(displ.getHeight()).append(",m00=").append(m[0]).append(",m10=").append(m[1]).append(",m01=").append(m[2]).append(",m11=").append(m[3]).append(",m02=").append(m[4]).append(",m12=").append(m[5]);
        } else if (key.equals("alpha")) {
            sb.append("alpha=").append(displ.getAlpha());
        } else if (key.equals("title")) {
            sb.append("title='").append(displ.getTitle()).append("'");
        } else if (key.equals("color")) {
            Color color = displ.getColor();
            sb.append("color_red=").append(color.getRed()).append(",color_green=").append(color.getGreen()).append(",color_blue=").append(color.getBlue());
        } else if (key.equals("visible")) {
            sb.append("visible=").append(displ.isVisible());
        } else if (key.equals("layer_id")) {
            sb.append("layer_id=").append(displ.getLayer().getId());
        } else if (key.equals("all")) {
            double[] m = new double[6];
            displ.getAffineTransform().getMatrix(m);
            sb.append("layer_id=").append(null == displ.getLayer() ? -1L : displ.getLayer().getId()).append(",title='").append(displ.getTitle()).append(",width=").append(displ.getWidth()).append(",height=").append(displ.getHeight()).append(",alpha=").append(displ.getAlpha()).append(",visible=").append(displ.isVisible());
            Color color = displ.getColor();
            sb.append(",color_red=").append(color.getRed()).append(",color_green=").append(color.getGreen()).append(",color_blue=").append(color.getBlue()).append(",locked=").append(displ.isLocked2()).append(",m00=").append(m[0]).append(",m10=").append(m[1]).append(",m01=").append(m[2]).append(",m11=").append(m[3]).append(",m02=").append(m[4]).append(",m12=").append(m[5]);
        } else if (key.equals("locked")) {
            sb.append("locked=").append(displ.isLocked());
        } else {
            Utils.log("Loader.updateInDatabase(Displayable): don't know what to do with key: " + key);
            return;
        }
        sb.append(" WHERE id=").append(displ.getId());
        this.connection.prepareStatement(sb.toString()).executeUpdate();
    }

    private void removeFromDatabase(Displayable displ) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_displayables WHERE id=" + displ.getId()).execute();
    }

    private void addToDatabase(Patch patch) throws Exception {
        InputStream i_stream = null;
        try {
            ImagePlus imp = this.mawts.get(patch.getId());
            this.stmt_add_patch.setLong(1, patch.getId());
            this.stmt_add_patch.setInt(2, imp.getType());
            i_stream = this.createZippedStream(imp);
            if (null == i_stream) {
                Utils.log("Loader.addToDatabase(Patch): null stream.");
                return;
            }
            this.stmt_add_patch.setBinaryStream(3, i_stream, i_stream.available());
            this.stmt_add_patch.setDouble(4, patch.getMin());
            this.stmt_add_patch.setDouble(5, patch.getMax());
            this.stmt_add_patch.executeUpdate();
            i_stream.close();
        }
        catch (Exception e) {
            if (null != i_stream) {
                try {
                    i_stream.close();
                }
                catch (Exception ie) {
                    IJError.print(ie);
                }
            }
            Utils.showMessage("Could not add Patch image.");
            IJError.print(e);
            return;
        }
        this.addToDatabase((Displayable)patch);
    }

    private void updateInDatabase(Patch patch, String key) throws Exception {
        block13: {
            if (key.equals("tiff_snapshot")) {
                return;
            }
            StringBuffer sb = new StringBuffer("UPDATE ab_patches SET ");
            boolean update_imp = false;
            if (key.equals("tiff_working")) {
                sb.append("imp_type=").append(patch.getType()).append(", tiff_working=?");
                update_imp = true;
            } else if (key.equals("remove_tiff_working")) {
                sb.append("tiff_working=NULL");
            } else if (key.equals("min_and_max")) {
                sb.append("min=").append(patch.getMin()).append(", max=").append(patch.getMax());
            } else {
                this.updateInDatabase((Displayable)patch, key);
                return;
            }
            PreparedStatement st = this.connection.prepareStatement(sb.append(" WHERE id=").append(patch.getId()).toString());
            int i = 1;
            InputStream i_stream2 = null;
            try {
                if (update_imp) {
                    ImagePlus imp = this.mawts.get(patch.getId());
                    i_stream2 = this.createZippedStream(imp);
                    st.setBinaryStream(i, i_stream2, i_stream2.available());
                    ++i;
                }
                st.executeUpdate();
                if (null != i_stream2) {
                    i_stream2.close();
                }
            }
            catch (Exception e) {
                IJError.print(e);
                if (null == i_stream2) break block13;
                try {
                    i_stream2.close();
                }
                catch (Exception e2) {
                    IJError.print(e2);
                }
            }
        }
    }

    private void removeFromDatabase(Patch patch) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_patches WHERE id=" + patch.getId()).execute();
        this.removeFromDatabase((Displayable)patch);
        this.mawts.remove(patch.getId());
    }

    private void addToDatabase(Layer layer) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_layers (id, project_id, layer_set_id, z, thickness) VALUES (").append(layer.getId()).append(',').append(layer.getProject().getId()).append(',').append(layer.getParent().getId()).append(',').append(layer.getZ()).append(',').append(layer.getThickness()).append(')').toString()).executeUpdate();
    }

    private void updateInDatabase(Layer layer, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_layers SET ");
        if (key.equals("stack_index")) {
            boolean autocommit = this.connection.getAutoCommit();
            try {
                Iterator<Displayable> it = layer.getDisplayables().iterator();
                this.connection.setAutoCommit(false);
                Statement st = this.connection.createStatement();
                int i = 0;
                while (it.hasNext()) {
                    DBObject dBObject = it.next();
                    st.addBatch("UPDATE ab_displayables SET stack_index=" + i + " WHERE id=" + dBObject.getId());
                    ++i;
                }
                for (DBObject dBObject : layer.getParent().getZDisplayables()) {
                    st.addBatch("UPDATE ab_displayables SET stack_index=" + i + " WHERE id=" + dBObject.getId());
                    ++i;
                }
                st.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(autocommit);
            }
            catch (SQLException sqle) {
                IJError.print(sqle);
                SQLException next = sqle.getNextException();
                if (null != next) {
                    IJError.print(next);
                }
                try {
                    this.connection.rollback();
                    this.connection.setAutoCommit(autocommit);
                }
                catch (SQLException sqle2) {
                    IJError.print(sqle2);
                }
            }
            return;
        }
        if (key.equals("z")) {
            sb.append("z=").append(layer.getZ());
        } else if (key.equals("thickness")) {
            sb.append("thickness=").append(layer.getThickness());
        } else if (key.equals("layer_set_id")) {
            sb.append("layer_set_id=").append(layer.getParent().getId());
        } else {
            Utils.log("Loader.updateInDatabase(Layer): don't know what to do with key: " + key);
            return;
        }
        sb.append(" WHERE id=").append(layer.getId());
        this.connection.prepareStatement(sb.toString()).executeUpdate();
    }

    private void removeFromDatabase(Layer layer) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_layers WHERE id=" + layer.getId()).execute();
    }

    private void addToDatabase(LayerSet layer_set) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_layer_sets (id, project_id, parent_layer_id, layer_width, layer_height, rot_x, rot_y, rot_z) VALUES (").append(layer_set.getId()).append(',').append(layer_set.getProject().getId()).append(',').append(null == layer_set.getParent() ? -1L : layer_set.getParent().getId()).append(',').append(layer_set.getLayerWidth()).append(',').append(layer_set.getLayerHeight()).append(',').append(layer_set.getRotX()).append(',').append(layer_set.getRotY()).append(',').append(layer_set.getRotZ()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)layer_set);
    }

    private void updateInDatabase(LayerSet layer_set, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_layer_sets SET ");
        if (key.equals("parent_id")) {
            sb.append("parent_id=").append(layer_set.getParent().getId());
        } else if (key.startsWith("rot")) {
            sb.append("rot_x=").append(layer_set.getRotX()).append(", rot_y=").append(layer_set.getRotY()).append(", rot_z=").append(layer_set.getRotZ());
        } else if (key.equals("layer_dimensions")) {
            sb.append("layer_width=").append(layer_set.getLayerWidth()).append(",layer_height=").append(layer_set.getLayerHeight());
        } else if (key.equals("snapshots_mode")) {
            sb.append("snapshots_mode=").append(layer_set.getSnapshotsMode());
        } else {
            this.updateInDatabase((Displayable)layer_set, key);
            return;
        }
        sb.append(" WHERE id=").append(layer_set.getId());
        this.connection.prepareStatement(sb.toString()).executeUpdate();
    }

    private void removeFromDatabase(LayerSet layer_set) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_layer_sets WHERE id=" + layer_set.getId()).execute();
        this.removeFromDatabase((Displayable)layer_set);
    }

    private void addToDatabase(Profile profile) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_profiles (id) VALUES (").append(profile.getId()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)profile);
    }

    private void updateInDatabase(Profile profile, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_profiles SET ");
        boolean update_points = false;
        if (key.equals("points")) {
            sb.append("polygon=?");
            update_points = true;
        } else if (key.equals("closed")) {
            sb.append("closed=").append(profile.isClosed());
        } else if (key.equals("all")) {
            sb.append("closed=").append(profile.isClosed()).append(",polygon=?");
            this.updateInDatabase((Displayable)profile, key);
            update_points = true;
        } else {
            this.updateInDatabase((Displayable)profile, key);
            return;
        }
        sb.append(" WHERE id=").append(profile.getId());
        PreparedStatement statement = this.connection.prepareStatement(sb.toString());
        if (update_points) {
            statement.setObject(1, this.makePGpolygon(profile.getBezierArrays()));
        }
        statement.executeUpdate();
    }

    private PGpolygon makePGpolygon(double[][][] bezarr) {
        PGpoint[] points = new PGpoint[bezarr[0][0].length * 3];
        double[][] p_l = bezarr[0];
        double[][] p = bezarr[1];
        double[][] p_r = bezarr[2];
        int i = 0;
        int j = 0;
        while (i < points.length) {
            points[i] = new PGpoint(p_l[0][j], p_l[1][j]);
            points[i + 1] = new PGpoint(p[0][j], p[1][j]);
            points[i + 2] = new PGpoint(p_r[0][j], p_r[1][j]);
            i += 3;
            ++j;
        }
        return new PGpolygon(points);
    }

    private Polygon makePolygon(PGpolygon pg) {
        Polygon pol = new Polygon();
        for (int i = 0; i < pg.points.length; ++i) {
            pol.addPoint((int)pg.points[i].x, (int)pg.points[i].y);
        }
        return pol;
    }

    private void removeFromDatabase(Profile profile) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_profiles WHERE id=" + profile.getId()).execute();
        this.removeFromDatabase((Displayable)profile);
    }

    private void addToDatabase(Display display) throws Exception {
        StringBuffer sb = new StringBuffer("INSERT INTO ab_displays (id, layer_id, window_x, window_y, magnification, srcrect_x, srcrect_y, srcrect_width, srcrect_height) VALUES (");
        sb.append(display.getId()).append(',');
        sb.append(display.getLayer().getId()).append(',');
        Rectangle r = display.getBounds();
        sb.append(r.x).append(',').append(r.y).append(',').append(display.getCanvas().getMagnification()).append(',');
        r = display.getCanvas().getSrcRect();
        sb.append(r.x).append(',').append(r.y).append(',').append(r.width).append(',').append(r.height);
        this.connection.prepareStatement(sb.append(')').toString()).executeUpdate();
    }

    private void updateInDatabase(Display display, String key) throws Exception {
        StringBuffer sb = new StringBuffer("UPDATE ab_displays SET ");
        if (key.equals("active_displayable_id")) {
            sb.append(key).append("=").append(null == display.getActive() ? -1L : display.getActive().getId());
        } else if (key.equals("position")) {
            Rectangle r = display.getBounds();
            sb.append("window_x=").append(r.x).append(",window_y=").append(r.y);
        } else if (key.equals("srcRect")) {
            Rectangle r = display.getCanvas().getSrcRect();
            sb.append("magnification=").append(display.getCanvas().getMagnification()).append(",srcrect_x=").append(r.x).append(",srcrect_y=").append(r.y).append(",srcrect_width=").append(r.width).append(",srcrect_height=").append(r.height);
        } else if (key.equals("layer_id")) {
            sb.append("layer_id=").append(display.getLayer().getId());
        } else if (key.equals("c_alphas")) {
            sb.append("c_alphas=").append(display.getChannelAlphas());
            sb.append(", c_alphas_state=").append(display.getChannelAlphasState());
        } else if (key.equals("scroll_step")) {
            sb.append("scroll_step=").append(display.getScrollStep());
        } else {
            Utils.log("Loader.updateInDatabase(Display): don't know what to do with key: " + key);
            return;
        }
        this.connection.prepareStatement(sb.append(" WHERE id=").append(display.getId()).toString()).executeUpdate();
    }

    private void removeFromDatabase(Display display) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_displays WHERE id=" + display.getId()).execute();
    }

    private void addToDatabase(Ball ball) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_zdisplayables (id, project_id) VALUES (").append(ball.getId()).append(',').append(ball.getProject().getId()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)ball);
    }

    private void updateInDatabase(Ball ball, String key) throws Exception {
        if (!this.connectToDatabase()) {
            Utils.log("Not connected and can't connect to database.");
            return;
        }
        try {
            boolean autocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            Statement st = this.connection.createStatement();
            StringBuffer sb_query = new StringBuffer("UPDATE ab_zdisplayables SET ");
            boolean update_all_points = false;
            if (key.startsWith("INSERT INTO ab_ball_points ")) {
                this.connection.prepareStatement(key).executeUpdate();
                this.connection.commit();
                this.connection.setAutoCommit(autocommit);
                return;
            }
            if (key.equals("points")) {
                update_all_points = true;
            } else {
                if (key.startsWith("UPDATE ab_ball_points")) {
                    this.connection.prepareStatement(key).executeUpdate();
                    this.connection.commit();
                    this.connection.setAutoCommit(autocommit);
                    return;
                }
                if (key.equals("layer_set_id")) {
                    sb_query.append("layer_set_id=").append(ball.getLayerSet().getId());
                } else {
                    this.connection.setAutoCommit(autocommit);
                    this.updateInDatabase((Displayable)ball, key);
                    return;
                }
            }
            if (sb_query.length() > 28) {
                st.addBatch(sb_query.toString());
            }
            if (update_all_points) {
                st.addBatch("DELETE FROM ab_ball_points WHERE ball_id=" + ball.getId());
                String[] s_points = ball.getPointsForSQL();
                for (int i = 0; i < s_points.length; ++i) {
                    st.addBatch(s_points[i]);
                }
            }
            sb_query.append(" WHERE pipe_id=").append(ball.getId());
            st.executeBatch();
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            SQLException next = sqle.getNextException();
            if (null != next) {
                IJError.print(next);
            }
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private void removeFromDatabase(Ball ball) throws Exception {
        boolean autocommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            Statement st = this.connection.createStatement();
            st.addBatch("DELETE FROM ab_ball_points WHERE ball_id=" + ball.getId());
            st.addBatch("DELETE FROM ab_zdisplayables WHERE id=" + ball.getId());
            st.addBatch("DELETE FROM ab_displayables WHERE id=" + ball.getId());
            st.executeBatch();
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(autocommit);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private void addToDatabase(Pipe pipe) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_zdisplayables (id, project_id) VALUES (").append(pipe.getId()).append(',').append(pipe.getProject().getId()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)pipe);
    }

    private void updateInDatabase(Pipe pipe, String key) throws Exception {
        if (!this.connectToDatabase()) {
            Utils.log("Not connected and can't connect to database.");
            return;
        }
        try {
            boolean autocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            Statement st = this.connection.createStatement();
            StringBuffer sb_query = new StringBuffer("UPDATE ab_zdisplayables SET ");
            boolean update_all_points = false;
            if (key.equals("points")) {
                update_all_points = true;
            } else {
                if (key.startsWith("UPDATE ab_pipe_points")) {
                    this.connection.prepareStatement(key).executeUpdate();
                    this.connection.commit();
                    this.connection.setAutoCommit(autocommit);
                    return;
                }
                if (key.equals("layer_set_id")) {
                    sb_query.append("layer_set_id=").append(pipe.getLayerSet().getId());
                } else {
                    this.connection.setAutoCommit(autocommit);
                    this.updateInDatabase((Displayable)pipe, key);
                    return;
                }
            }
            if (sb_query.length() > 28) {
                st.addBatch(sb_query.toString());
            }
            if (update_all_points) {
                st.addBatch("DELETE FROM ab_pipe_points WHERE pipe_id=" + pipe.getId());
                String[] s_points = pipe.getPointsForSQL();
                for (int i = 0; i < s_points.length; ++i) {
                    st.addBatch(s_points[i]);
                }
            }
            sb_query.append(" WHERE pipe_id=").append(pipe.getId());
            st.executeBatch();
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            SQLException next = sqle.getNextException();
            if (null != next) {
                IJError.print(next);
            }
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private void removeFromDatabase(Pipe pipe) throws Exception {
        boolean autocommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        try {
            Statement st = this.connection.createStatement();
            st.addBatch("DELETE FROM ab_pipe_points WHERE pipe_id=" + pipe.getId());
            st.addBatch("DELETE FROM ab_zdisplayables WHERE id=" + pipe.getId());
            st.addBatch("DELETE FROM ab_displayables WHERE id=" + pipe.getId());
            st.executeBatch();
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(autocommit);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private void addToDatabase(DLabel label) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_labels (id, type, font_name, font_style, font_size) VALUES (").append(label.getId()).append(',').append(label.getType()).append(",'").append(label.getFont().getName()).append("',").append(label.getFont().getStyle()).append(',').append(label.getFont().getSize()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)label);
    }

    private void updateInDatabase(DLabel label, String key) throws Exception {
        if (key.equals("font")) {
            this.connection.createStatement().executeQuery(new StringBuffer("UPDATE ab_labels SET font_name='").append(label.getFont().getName()).append("', font_style=").append(label.getFont().getStyle()).append(", font_size=").append(label.getFont().getSize()).append(" WHERE id=").append(label.getId()).toString());
        } else {
            this.updateInDatabase((Displayable)label, key);
        }
    }

    private void removeFromDatabase(DLabel label) throws Exception {
        this.connection.prepareStatement("DELETE FROM ab_labels WHERe id=" + label.getId()).execute();
        this.removeFromDatabase((Displayable)label);
    }

    private void addToDatabase(AreaList arealist) throws Exception {
        this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_zdisplayables (id, project_id) VALUES (").append(arealist.getId()).append(',').append(arealist.getProject().getId()).append(')').toString()).executeUpdate();
        this.addToDatabase((Displayable)arealist);
    }

    private void updateInDatabase(AreaList arealist, String key) throws Exception {
        if (!this.connectToDatabase()) {
            Utils.log("Not connected and can't connect to database.");
            return;
        }
        try {
            boolean autocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            StringBuffer sb_query = new StringBuffer("UPDATE ");
            if (key.equals("layer_set_id")) {
                Statement st = this.connection.createStatement();
                st.executeUpdate(sb_query.append(" ab_zdisplayables SET layer_set_id=").append(arealist.getLayerSet().getId()).append(" WHERE id=").append(arealist.getId()).toString());
            } else if (key.startsWith("points=")) {
                long layer_id = Long.parseLong(key.substring(7));
                this.connection.createStatement().executeUpdate(new StringBuffer("DELETE FROM ab_area_paths WHERE area_list_id=").append(arealist.getId()).append(" AND layer_id=").append(layer_id).toString());
                ArrayList<ArrayList<Point>> al_paths = arealist.getPaths(layer_id);
                Iterator<ArrayList<Point>> it = al_paths.iterator();
                while (it.hasNext()) {
                    PreparedStatement ps = this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_area_paths (area_list_id, layer_id, polygon) VALUES (").append(arealist.getId()).append(',').append(layer_id).append(",?)").toString());
                    ps.setObject(1, this.makePGpolygon(it.next()));
                    ps.executeUpdate();
                }
            } else if (key.equals("all_points")) {
                this.connection.createStatement().executeUpdate(new StringBuffer("DELETE FROM ab_area_paths WHERE area_list_id=").append(arealist.getId()).toString());
                HashMap<Long, ArrayList<ArrayList<Point>>> ht = arealist.getAllPaths();
                for (Map.Entry<Long, ArrayList<ArrayList<Point>>> entry : ht.entrySet()) {
                    long layer_id = entry.getKey();
                    ArrayList<ArrayList<Point>> al_paths = entry.getValue();
                    Iterator<ArrayList<Point>> it = al_paths.iterator();
                    while (it.hasNext()) {
                        PreparedStatement ps = this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_area_paths (area_list_id, layer_id, polygon) VALUES (").append(arealist.getId()).append(',').append(layer_id).append(",?)").toString());
                        ps.setObject(1, this.makePGpolygon(it.next()));
                        ps.executeUpdate();
                    }
                }
            } else if (key.equals("fill_paint")) {
                this.connection.createStatement().executeUpdate(new StringBuffer("UPDATE ab_area_paths SET fill_paint=").append(arealist.isFillPaint()).append(" WHERE area_list_id=").append(arealist.getId()).toString());
            }
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            SQLException next = sqle.getNextException();
            if (null != next) {
                IJError.print(next);
            }
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private void removeFromDatabase(AreaList arealist) throws Exception {
        if (!this.connectToDatabase()) {
            Utils.log("Not connected and can't connect to database.");
            return;
        }
        try {
            boolean autocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            Statement st = this.connection.createStatement();
            st.addBatch("DELETE FROM ab_zdisplayables WHERE id=" + arealist.getId());
            st.addBatch("DELETE FROM ab_area_paths WHERE area_list_id=" + arealist.getId());
            st.executeBatch();
            this.connection.commit();
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException sqle) {
            IJError.print(sqle);
            SQLException next = sqle.getNextException();
            if (null != next) {
                IJError.print(next);
            }
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sqle2) {
                IJError.print(sqle2);
            }
        }
    }

    private PGpolygon makePGpolygon(ArrayList al_points) {
        PGpoint[] pol = new PGpoint[al_points.size()];
        for (int i = 0; i < pol.length; ++i) {
            Point p = (Point)al_points.get(i);
            pol[i] = new PGpoint((double)p.x, (double)p.y);
        }
        return new PGpolygon(pol);
    }

    @Override
    public synchronized void addCrossLink(long project_id, long id1, long id2) {
        if (!this.connectToDatabase()) {
            return;
        }
        try {
            this.connection.prepareStatement(new StringBuffer("INSERT INTO ab_links (project_id, id1, id2) VALUES (").append(project_id).append(',').append(id1).append(',').append(id2).append(')').toString()).executeUpdate();
        }
        catch (Exception e) {
            IJError.print(e);
            return;
        }
    }

    @Override
    public synchronized boolean removeCrossLink(long id1, long id2) {
        if (!this.connectToDatabase()) {
            return false;
        }
        try {
            this.connection.prepareStatement(new StringBuffer("DELETE FROM ab_links WHERE (id1=").append(id1).append(" AND id2=").append(id2).append(") OR (id1=").append(id2).append(" AND id2=").append(id1).append(')').toString()).executeUpdate();
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImagePlus fetchImagePlus(Patch p) {
        Object object = this.db_lock;
        synchronized (object) {
            long id = p.getId();
            ImagePlus imp = this.mawts.get(id);
            if (null != imp) {
                if (null != imp.getProcessor() && null != imp.getProcessor().getPixels()) {
                    return imp;
                }
                DBLoader.flush(imp);
            }
            if (!this.connectToDatabase()) {
                return null;
            }
            this.releaseMemory2();
            InputStream i_stream = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT tiff_working FROM ab_patches WHERE tiff_working IS NOT NULL AND id=" + id).executeQuery();
                boolean found = false;
                if (r.next()) {
                    found = true;
                    i_stream = r.getBinaryStream("tiff_working");
                    imp = this.unzipTiff(i_stream, p.getTitle());
                    i_stream.close();
                    this.mawts.put(id, imp, (int)Math.max(p.getWidth(), p.getHeight()));
                }
                r.close();
                if (!found) {
                    r = this.connection.prepareStatement("SELECT tiff_original FROM ab_patches WHERE id=" + id).executeQuery();
                    if (r.next()) {
                        i_stream = r.getBinaryStream("tiff_original");
                        imp = this.unzipTiff(i_stream, p.getTitle());
                        i_stream.close();
                        this.mawts.put(id, imp, (int)Math.max(p.getWidth(), p.getHeight()));
                    }
                    r.close();
                }
                if (null == imp) {
                    // empty if block
                }
            }
            catch (Exception e) {
                IJError.print(e);
                if (null != i_stream) {
                    try {
                        i_stream.close();
                    }
                    catch (Exception ie) {
                        IJError.print(ie);
                    }
                }
                return null;
            }
            return imp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] fetchLabel(DLabel label) {
        Object object = this.db_lock;
        synchronized (object) {
            if (!this.connectToDatabase()) {
                return null;
            }
            Object[] ob = null;
            try {
                ResultSet r = this.connection.prepareStatement("SELECT ab_labels.id, ab_displayables.id, title, ab_labels.type, font_name, font_style, font_size FROM ab_labels,ab_displayables WHERE ab_labels.id=ab_displayables.id AND id=" + label.getId()).executeQuery();
                if (r.next()) {
                    ob = new Object[]{r.getString("title"), r.getString("font_name"), new Integer(r.getInt("font_style")), new Integer(r.getInt("font_size")), new Integer(r.getInt("type"))};
                }
                r.close();
            }
            catch (Exception e) {
                IJError.print(e);
                return null;
            }
            return ob;
        }
    }

    @Override
    public synchronized ImagePlus fetchOriginal(Patch patch) {
        if (!this.connectToDatabase()) {
            return null;
        }
        long imp_size = (long)(patch.getWidth() * patch.getHeight() * 4.0f);
        this.releaseToFit(MIN_FREE_BYTES > imp_size ? MIN_FREE_BYTES : imp_size);
        ImagePlus imp = null;
        InputStream i_stream = null;
        try {
            ResultSet r = this.connection.prepareStatement("SELECT id, tiff_original FROM ab_patches WHERE id=" + patch.getId()).executeQuery();
            if (r.next()) {
                i_stream = r.getBinaryStream("tiff_original");
                imp = this.unzipTiff(i_stream, patch.getTitle());
                i_stream.close();
            }
            r.close();
        }
        catch (Exception e) {
            Utils.log("Loader.fetchOriginal: ERROR fetching original ImagePlus for Patch id=" + patch.getId());
            IJError.print(e);
            if (null != i_stream) {
                try {
                    i_stream.close();
                }
                catch (Exception ee) {
                    Utils.log("Loader.fetchOriginal: could not close stream.");
                }
            }
            return null;
        }
        if (null == imp) {
            Utils.log("WARNING fetching a null original");
        }
        return imp;
    }

    @Override
    public boolean hasChanges() {
        return false;
    }

    public boolean isIdenticalProjectSource(Loader loader) {
        if (loader instanceof DBLoader) {
            DBLoader dbl = (DBLoader)loader;
            if (this.db_host.equals(dbl.db_host) && this.db_port.equals(dbl.db_port)) {
                return true;
            }
        }
        return false;
    }

    public void restoreNodesExpandedState(Project project) {
        if (!this.connectToDatabase()) {
            return;
        }
        try {
            ProjectTree ptree = project.getProjectTree();
            ResultSet r = this.connection.prepareStatement("SELECT id,expanded from ab_things where project_id=" + project.getId()).executeQuery();
            while (r.next()) {
                ProjectThing thing;
                boolean expanded = r.getBoolean(2);
                if (!expanded || null == (thing = project.find(r.getLong(1)))) continue;
                ptree.setExpandedSilently(thing, true);
            }
            ptree.updateUILater();
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    @Override
    protected Patch importStackAsPatches(Project project, Layer first_layer, double x, double y, ImagePlus imp_stack, boolean as_copy, String filepath) {
        double pos_x = Double.MAX_VALUE != x ? x : (double)(first_layer.getLayerWidth() / 2.0f - (float)(imp_stack.getWidth() / 2));
        double pos_y = Double.MAX_VALUE != y ? y : (double)(first_layer.getLayerHeight() / 2.0f - (float)(imp_stack.getHeight() / 2));
        double thickness = first_layer.getThickness();
        String title = Utils.removeExtension(imp_stack.getTitle()).replace(' ', '_');
        Utils.showProgress(0.0);
        Patch previous_patch = null;
        int n = imp_stack.getStackSize();
        for (int i = 1; i <= n; ++i) {
            Layer layer = first_layer;
            double z = first_layer.getZ() + (double)(i - 1) * thickness;
            if (i > 1) {
                layer = first_layer.getParent().getLayer(z, thickness, true);
            }
            if (null == layer) {
                Utils.log("Display.importStack: could not create new layers.");
                return null;
            }
            ImageProcessor ip = imp_stack.getStack().getProcessor(i);
            if (as_copy) {
                ip = ip.duplicate();
            }
            ImagePlus imp_patch_i = new ImagePlus(title + "__slice=" + i, ip);
            String label = imp_stack.getStack().getSliceLabel(i);
            if (null == label) {
                label = "";
            }
            Patch patch = new Patch(project, label + " " + title + " " + i, pos_x, pos_y, imp_patch_i);
            layer.add(patch);
            if (null != previous_patch) {
                patch.link(previous_patch);
            }
            previous_patch = patch;
            Utils.showProgress((double)i * (1.0 / (double)n));
        }
        Utils.showProgress(1.0);
        return previous_patch;
    }
}

